/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
// $Id: QTAtom_mvhd.h,v 1.3 1999/04/15 22:36:11 lecroy Exp $
//
// QTAtom_mvhd:
//   The 'mvhd' QTAtom class.

#ifndef QTAtom_mvhd_H
#define QTAtom_mvhd_H


//
// Includes
#include "QTFile.h"
#include "QTAtom.h"


//
// QTAtom class
class QTAtom_mvhd : public QTAtom {

public:
	//
	// Constructors and destructor.
						QTAtom_mvhd(QTFile * File, QTFile::AtomTOCEntry * Atom,
							   bool Debug = false, bool DeepDebug = false);
	virtual				~QTAtom_mvhd(void);


	//
	// Initialization functions.
	virtual	bool		Initialize(void);
	
	//
	// Accessors.
	inline	Float64		GetTimeScale(void) { return (Float64)fTimeScale; }
	inline	Float64		GetDurationInSeconds(void) { return fDuration / (Float64)fTimeScale; }


	//
	// Debugging functions.
	virtual	void		DumpAtom(void);


protected:
	//
	// Protected member variables.
	UInt8		fVersion;
	UInt32		fFlags; // 24 bits in the low 3 bytes
	UInt32		fCreationTime, fModificationTime;
	UInt32		fTimeScale, fDuration;
	UInt32		fPreferredRate;
	UInt16		fPreferredVolume;
	UInt32		fa, fb, fu, fc, fd, fv, fx, fy, fw;
	UInt32		fPreviewTime, fPreviewDuration, fPosterTime;
	UInt32		fSelectionTime, fSelectionDuration;
	UInt32		fCurrentTime;
	UInt32		fNextTrackID;
};

#endif // QTAtom_mvhd_H
