/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPSvrControlModule.h

	Contains:	A module that supports the MacOSX Server / ASIP Server Control interface.
				Even though this module bears the RTSP label, it requires & depends on
				the RTP server.

	$Log: RTSPSvrControlModule.h,v $
	Revision 1.2  1999/02/19 23:08:40  ds
	Created
	
	
*/

#ifndef _RTSPSERVERCONTROLMODULE_H_
#define _RTSPSERVERCONTROLMODULE_H_

#include <stdio.h>
#include "RTSPModule.h"
#include "ServerControlAPI.h"

class RTSPSvrControlThread;
class RTSPSvrControlModule;

class	RTSPSvrControlModule : public RTSPModule
{
	public:

		RTSPSvrControlModule();
		virtual ~RTSPSvrControlModule() {}
		
		virtual bool	Initialize();
		virtual void	Shutdown();
		
		//These methods execute the server control calls
		kern_return_t 	StopServer(int inMinutes);
		kern_return_t 	CancelStopServer();
		kern_return_t	GetServerAttribute(AttributeType attrib, UInt32 tagSize, void* tags,
											unsigned int bufSize, unsigned int* attribSize,
											void** buffer);
		kern_return_t	SetServerAttribute(AttributeType attrib, UInt32 tagSize, void* tags,
											unsigned int bufSize, void* buffer);
											
		//Static Methods
		static RTSPSvrControlModule* GetModule()	{ return sModule; }

	private:
	
		enum
		{
			//number of times the thread samples per entry to come up with
			//an average 
			kNumSamplesPerEntry = 30
		};
		
		//Functions that get and set specific attributes
		kern_return_t 	GetServerName(QTSServerDNSName* outServerName);
		kern_return_t 	GetServerStatusRec(QTSServerStatusRec* outServerStatus);
		kern_return_t 	GetRefuseConnections(QTSRefuseConnectionsRec* outRefuseConnections);
		kern_return_t 	SetRefuseConnections(QTSRefuseConnectionsRec* inRefuseConnections);
		kern_return_t 	GetHistory(QTSServerHistoryRec* outHistory);
		kern_return_t 	RereadPreferences();
		kern_return_t 	RollLogNow(QTSLogRollRec* theRollLogRec);
		kern_return_t	GetProcessInfo(QTSProcessInfoRec* inProcessInfo);
		kern_return_t 	GetServerVersion(QTSServerVersionRec* outServerVersion);
	
		void			UpdateHistoryArray();
		void 			AddHistorySample();
		void			CheckShutdown();
	
		OSMutex			fHistoryMutex;
		RTSPSvrControlThread *fThread;
		UInt32 fCursor;//where do we write next into the history array?
		static RTSPSvrControlModule*	sModule;
		
		//for Server History stuff.
		long		fBandwidthLo;
		long		fBandwidthHi;
		long		fBandwidthAvg;
		long		fConnectionLo;
		long		fConnectionHi;
		long		fConnectionAvg;
		long 		fSampleIndex;
		QTSServerHistoryRec fHistoryArray;
		
		time_t		fStartupTime;
		char*		fDNSName;
		bool		fGracefulShutdownInProgress;
		UInt32		fHistoryIntervalInSeconds;
		
		char*		fAttributeBuffer;
		
		friend class RTSPSvrControlThread;
};

class RTSPSvrControlThread
{
	private:

		RTSPSvrControlThread();
		virtual ~RTSPSvrControlThread();
		
		//This thread can encounter errors as it starts up.
		//Check this after calling the constructor
		bool	HasErrorOccurred() { return fErrorOccurred; }
	
	private:
	
		void Entry();
		void HistoryEntry();
		static void _Entry(RTSPSvrControlThread *thread);
		static void _HistoryEntry(RTSPSvrControlThread *thread);
		
		port_t fMessagePort;
		
		//thread related
		cthread_t 		fThreadID;
		cthread_t 		fHistoryThreadID;
		bool			fDone;
		bool			fErrorOccurred;
		bool			fDoneStartingUp;
		bool			fThreadsAllocated;
		
		friend class RTSPSvrControlModule;
};

#endif //_RTSPSERVERCONTROLMODULE_H_
