# DEXPIRE.CTL
#
# Information from all matching entries are merged, taking
# the lowest equivalent expire time.  So, for example,
# a * entry with a maximum file size of 2m covers ALL
# articles, but a later :m400k match will reduce that.
#
# Expiration is in percentage of best-case and values may
# be between 1 and 100.  At least one entry should have
# an expiration of 100 :-). Most people specify 100 for
# local groups and lesser values for other groups.
#
# You can revert to the old FIFO spool storage mechanism
# simply by specifying a 100 expiration for all groups
# in this file.
#
# NOTE!!! NEW DIRECTIVE!  'a' see below.
#
# directives:
#
#	mSIZE[k,m,g]	specify maximum article size
#
#	sFLOAT		DEPRECIATED, no longer supported.
#
#	bLINES		Article size expiration factor (for dexpire, on the
#			diablo feeder side).  The expiration percentage is
#			reduced by half for every N lines in the article,
#			as determined by the Lines: header.
#
#	cFLOAT		exponential cross posting factor, reduce expire
#			based on number of cross posts.  1.0 == no effect.
#			Specify a number 0.01 to 1.0 inclusive.  Numbers
#			less then 0.50 are typically not specified.
#
#			actual = pow(factor, numgroups)
#
#	xFLOAT		(dreaderd/dexpireover only) overview expiration, in 
#			days.  This is multiplied by an appropriate factor by
#			dexpireover to maintain the FreeSpaceTarget.  However,
#			the factor never goes above 1.0 so you can treat this 
#			as the maximum expiration period for the article.
#
#			If no expiration is specified, the expiration 
#			percentage is multiplied by 1000000 days which 
#			essentially means that dexpireover bases overview
#			expiration entirely on available overview space
#			and/or any dsyncgroups runs you make.
#
#	aSTARTARTS	Specify the initial size of the overview index file.
#			The default is 512 articles.  This only applies to
#			the initial creation of over.* files.  Ongoing
#			management of the size of the index files is handled
#			dynamically by dexpireover (w/ -a, -s, or -R options).
#
# An expiration of 0 rejects the article entirely.
#
# NOTE! expirations are set for an article when it is
# received, not when dexpire runs.

*:100:c0.95:m2m:b1000:x14
alt.*:80
*.advocacy:30
*.test:10

# example of more restrictive additions, note the
# small expiration percentages.  This may not work
# for you.
#
#alt.binaries.*:10:m400k
#alt.binaries.warez*:1
#alt.binaries.mac.games:1
#alt.binaries.misc*:2
#alt.binaries.games*:1
#alt.cracks*:1:m400k
#alt.sex*:1:m400k
#alt.sex.pictures*:1:m400k
#
# control.  Don't bother to keep cancel messages
# for very long.  Even though they are small there
# are still a huge number of them and they do eat
# space.  But keep other controls for a while.
#
control.*:80
control.cancel:20

# permanent, semi-permanent, local groups
#
#best.*:100

