%{
/*
**  GAG
**
**  Mail/news gateway alias generator.
*/
/* SUPPRESS 530 in yyparse *//* Empty body for statement */
/* SUPPRESS 593 on yyerrlab *//* Label was not used */
/* SUPPRESS 593 on yynewstate *//* Label was not used */
/* SUPPRESS 595 on yypvt *//* Automatic variable may be used before set */

#define MAINLINE
#include "gate.h"
#if	defined(RCSID)
static char RCS[] =
	"$Header: /nfs/papaya/u2/rsalz/src/newsgate/RCS/gag.y,v 1.8 91/07/18 11:04:03 rsalz Exp Locker: rsalz $";
#endif	/* defined(RCSID) */

#define EMPTY(p)		((p) == NULL || (p)[0] == '\0')

char		*Pname;			/* Program name			*/

int		Errors;			/* Did user screw up?		*/
STATIC int	NoGroupCheck;		/* Don't check if valid group?	*/
STATIC int	PostViaMail;		/* Make post-news-group alias?	*/
STATIC int	NewsStyle;		/* B or C news format?		*/
STATIC char	*OutDir;		/* Directory for BBN scripts	*/
STATIC FILE	*bbn;			/* File for BBN-style aliases	*/
STATIC FILE	*ppuser;		/* File for PP user aliases	*/
STATIC FILE	*ppshell;		/* File for PP shell aliases	*/
STATIC FILE	*mmdf;			/* File for MMDF aliases	*/
STATIC FILE	*sendmail;		/* File for Sendmail aliases	*/
STATIC FILE	*news;			/* File for sys file entries	*/

STATIC char	*CurDirectory,		*DefDirectory;
STATIC char	**CurDistribs,		**DefDistribs;
STATIC int	CurDoMailinglist,	DefDoMailinglist;
STATIC char	*CurFlags,		*DefFlags;
STATIC char	*CurMail2news,		*DefMail2news;
STATIC char	*CurMailcontact,	*DefMailcontact;
STATIC char	*CurMailhost,		*DefMailhost;
STATIC char	*CurModerator,		*DefModerator;
STATIC char	*CurNews2mail,		*DefNews2mail;
STATIC char	*CurOrganization,	*DefOrganization;
STATIC char	*CurOwner,		*DefOwner;
STATIC char	*CurRequestAddr,	*DefRequestAddr;
STATIC char	*CurSite,		*DefSite;
STATIC char	*CurUser,		*DefUser;

extern time_t	time();
%}

%union {
    char	*String;
    int		Bool;
}

%token	tDEFAULT tDIRECTORY tDISTRIBUTIONS tDOTIFY tFALSE tGATEWAY tFLAGS
%token	tID tINEWS tMAIL2NEWS tMAILCONTACT tMAILHOST tMAILINGLIST
%token	tMAILPOST tMODERATOR tNEWS2MAIL tORGANIZATION tOWNER tREQUESTADDR
%token	tSITE tTRUE tUSER

%type	<String>	tID value
%type	<Bool>		boolean

%%

file	: /* NULL */
	| file block ';'
	| file default ';'
	| file mpost ';'
	| file error ';'
	;

default	: tDEFAULT tDIRECTORY value	{ DefDirectory = $3; }
	| tDEFAULT tDISTRIBUTIONS value	{ (void)Split($3, &DefDistribs, '\0'); }
	| tDEFAULT tINEWS tFLAGS value	{ DefFlags = $4; }
	| tDEFAULT tMAIL2NEWS value	{ DefMail2news = $3; }
	| tDEFAULT tMAILCONTACT value	{ DefMailcontact = $3; }
	| tDEFAULT tMAILHOST value	{ DefMailhost = $3; }
	| tDEFAULT tMAILINGLIST boolean	{ DefDoMailinglist = $3; }
	| tDEFAULT tMODERATOR value	{ DefModerator = $3; }
	| tDEFAULT tNEWS2MAIL value	{ DefNews2mail = $3; }
	| tDEFAULT tORGANIZATION value	{ DefOrganization = $3; }
	| tDEFAULT tOWNER value		{ DefOwner = $3; }
	| tDEFAULT tREQUESTADDR value	{ DefRequestAddr = $3; }
	| tDEFAULT tSITE value		{ DefSite = $3; }
	| tDEFAULT tUSER value		{ DefUser = $3; }
	;

block	: op_init tGATEWAY tID tID op_set {
	    if (!Errors && ValidNewsgroup($3))
		WriteOne($3, $4);
	}
	;

mpost	: op_init tMAILPOST tID op_set {
	    char	*GroupasMail;

	    if (!Errors && ValidNewsgroup($3)) {
		GroupasMail = Dot2Dash($3);
		if (bbn)
		    BBNpostviamail($3, GroupasMail);
		if (sendmail)
		    Fprintf(sendmail, "%s: \"|%s -n %s\"\n",
			GroupasMail, CurMail2news, $3);
		if (mmdf)
		    Fprintf(mmdf, "%s: \"%s|%s -n %s\"\n",
			GroupasMail, CurUser, CurMail2news, $3);
		if (ppuser)
		    Fprintf(ppuser, "%s:shell\n", GroupasMail);
		if (ppshell)
		    Fprintf(ppshell, "%s:%s,,%s -n %s\n",
			GroupasMail, CurUser, CurMail2news, $3);
	    }
	}
	;

op_init	: /* NULL */ {
	    CurDoMailinglist = DefDoMailinglist;
	    CurDistribs = DefDistribs;
	    CurDirectory = DefDirectory;
	    CurFlags = DefFlags;
	    CurMail2news = DefMail2news;
	    CurMailhost = DefMailhost;
	    CurMailcontact = DefMailcontact;
	    CurModerator = DefModerator;
	    CurNews2mail = DefNews2mail;
	    CurOrganization = DefOrganization;
	    CurOwner = DefOwner;
	    CurRequestAddr = DefRequestAddr;
	    CurSite = DefSite;
	    CurUser = DefUser;
	}
	;

op_set	: /* NULL */
	| an_opt op_set
	;

an_opt	: tDIRECTORY value	{ CurDirectory = $2; }
	| tDISTRIBUTIONS value	{ (void)Split($2, &CurDistribs, '\0'); }
	| tINEWS tFLAGS value	{ CurFlags = $3; }
	| tMAIL2NEWS value	{ CurMail2news = $2; }
	| tMAILCONTACT value	{ CurMailcontact = $2; }
	| tMAILHOST value	{ CurMailhost = $2; }
	| tMAILINGLIST boolean	{ CurDoMailinglist = $2; }
	| tMODERATOR value	{ CurModerator = $2; }
	| tNEWS2MAIL value	{ CurNews2mail = $2; }
	| tORGANIZATION value	{ CurOrganization = $2; }
	| tOWNER value		{ CurOwner = $2; }
	| tREQUESTADDR value	{ CurRequestAddr = $2; }
	| tSITE value		{ CurSite = $2; }
	| tUSER value		{ CurUser = $2; }
	;

value	: '=' tID {
	    $$ = $2;
	}
	| '=' tDOTIFY '(' tID ')' {
	    $$ = Dotify($4);
	}
	;

boolean	: '=' tTRUE {
	    $$ = TRUE;
	}
	| '=' tFALSE {
	    $$ = FALSE;
	}
	;
%%


/*
**  Copy the string s turning all '.' into '-'.
*/
STATIC char *
Dot2Dash(s)
    register char	*s;
{
    register char	*p;
    char		*save;

    for (save = p = COPY(s); *s; s++)
	*p++ = *s == '.' ? '-' : *s;
    *p = '\0';
    return save;
}


/*
**  Copy the string s putting a '.' before all uppercase letters and '.'.
*/
STATIC char *
Dotify(s)
    register char	*s;
{
    register char	*p;
    char		*save;

    for (save = p = NEW(char, strlen(s) * 2 + 1); *s; *p++ = *s++)
	if (*s == '.' || isupper(*s))
	    *p++ = '.';
    *p = '\0';
    return save;
}


/*
**  Check if the newsgroup exists in the ACTIVE file.
*/
STATIC int
ValidNewsgroup(Group)
    register char	*Group;
{
    static char		**File;
    register char	**p;
    register char	*q;

    if (NoGroupCheck)
	return TRUE;

    if (File == NULL)
	/* Read in active file, trim to just the newsgroup names. */
	for (p = File = ReadFile(ACTIVE); *p; p++)
	    if ((q = IDX(*p, ' ')) != NULL)
		*q = '\0';

    for (p = File; *p; p++)
	if (EQ(*p, Group))
	    return TRUE;

    Fprintf(stderr, "%s: ignoring invalid newsgroup \"%s\".\n", Pname, Group);
    return FALSE;
}


/*
**  Create a BBN alias set so that users can mail into a newsgroup
**  as if it were a mailing list.
*/
STATIC void
BBNpostviamail(Ngroup, GroupasMail)
    char		*Ngroup;
    char		*GroupasMail;
{
    register FILE	*F;
    char		buff[SM_SIZE];

    /* Create a post-news-group alias which pipes into
     * the /bin/dir/post-news-group script. */
    Fprintf(bbn, "post-%s: @%s { \"%s|%s/post-%s\" }\n",
	GroupasMail, CurMailhost, CurUser, CurDirectory, GroupasMail);
    Fprintf(bbn, "\tpost-%s@%s\n", GroupasMail, CurMailhost);

    /* Write a post-news-script which calls mail2news. */
    if (OutDir) {

	/* Open the file. */
	(void)sprintf(buff, "%s/post-%s", OutDir, GroupasMail);
	(void)unlink(buff);
	if ((F = fopen(buff, "w")) == NULL) {
	    Fprintf(stderr, "%s:  Can't open \"%s\" for output, %s.\n",
		Pname, buff, strerror(errno));
	    exit(1);
	}

	/* Write the script. */
	Fprintf(F, "#! /bin/sh\n");
	Fprintf(F, "## This script forwards into the \"%s\" newsgroup.\n",
	    Ngroup);
	Fprintf(F, "exec %s -n %s\n", CurMail2news, Ngroup);

	/* Close the file. */
	(void)fclose(F);
	(void)chmod(buff, 0755);
    }
}


/*
**  Write out one newsgroup/mailing list gatewaying entry.  This is where
**  the real work is done.  We do BBN, MMDF, Sendmail, and news/sys file
**  entries here.
*/
STATIC void
WriteOne(Ngroup, Mlist)
    register char	*Ngroup;
    register char	*Mlist;
{
    register char	**p;
    register FILE	*F;
    register char	*GroupasMail;
    char		buff[SM_SIZE];

    GroupasMail = Dot2Dash(Ngroup);

    if (bbn) {
	/* Create an alias that forwards to the script. */
	Fprintf(bbn, "\n##  Add this to the \"%s\" mailing list.\n", Mlist);
	Fprintf(bbn, "%s-gate: @%s { \"%s|%s/gate-%s\" }\n",
	    Mlist, CurMailhost, CurUser, CurDirectory, Mlist);
	Fprintf(bbn, "\t%s-gate@%s\n", Mlist, CurMailhost);

	/* Write the script. */
	if (OutDir) {
	    if (IDX(CurOrganization, '"')) {
		yyerror("Can't have \" in organization name");
		free(GroupasMail);
		return;
	    }

	    /* Open the file. */
	    (void)sprintf(buff, "%s/gate-%s", OutDir, Mlist);
	    (void)unlink(buff);
	    if ((F = fopen(buff, "w")) == NULL) {
		Fprintf(stderr, "%s:  Can't open \"%s\" for output, %s.\n",
		    Pname, buff, strerror(errno));
		exit(1);
	    }

	    /* Write it. */
	    Fprintf(F, "#! /bin/sh\n");
	    Fprintf(F, "## This script is on the \"%s\" mailing list.\n",
		Mlist);
	    Fprintf(F, "exec %s -n %s", CurMail2news, Ngroup);
	    if (!EMPTY(CurOrganization))
		fprintf(F, "\\\n\t-o \"%s\"", CurOrganization);
	    if (!EMPTY(CurModerator))
		Fprintf(F, "\\\n\t-a %s", CurModerator);
	    if (!EMPTY(CurFlags))
		Fprintf(F, " \\\n\t%s", CurFlags);
	    Fprintf(F, "\n");

	    /* Close it. */
	    (void)fclose(F);
	    (void)chmod(buff, 0755);
	}

	if (PostViaMail)
	    BBNpostviamail(Ngroup, GroupasMail);
    }

    if (sendmail || mmdf || ppshell || ppuser) {
	if (IDX(CurOrganization, '\'')) {
	    yyerror("Can't have ' in organization name");
	    free(GroupasMail);
	    return;
	}
	/* Does it make sense to do this? */
	if (!EMPTY(CurModerator) && CurDoMailinglist)
	    Fprintf(stderr, "Warning:  group %s is moderated and mailable.\n",
		Ngroup);
    }

    if (sendmail) {
	Fprintf(sendmail, "\n## %s <==> %s gateway\n", Ngroup, Mlist);
	Fprintf(sendmail, "%s%s: %s@%s\n",
	    CurDoMailinglist ? "" : "#", Mlist, Mlist, CurMailhost);
	if (!EMPTY(CurOwner))
	    Fprintf(sendmail, "%sowner-%s: %s\n",
		CurDoMailinglist ? "" : "#", Mlist, CurOwner);
	Fprintf(sendmail, "post-%s: \"|%s -n %s", Mlist, CurMail2news, Ngroup);
	if (!EMPTY(CurOrganization))
	    Fprintf(sendmail, " -o '%s'", CurOrganization);
	if (!EMPTY(CurFlags))
	    Fprintf(sendmail, " %s", CurFlags);
	if (!EMPTY(CurModerator))
	    Fprintf(sendmail, " -a %s", CurModerator);
	Fprintf(sendmail, "\"\n");
	if (!EMPTY(CurOwner))
	    Fprintf(sendmail, "owner-post-%s: %s\n", Mlist, CurOwner);

	if (PostViaMail) {
	    Fprintf(sendmail, "%s: \"|%s -n %s\"\n",
		GroupasMail, CurMail2news, Ngroup);
	    if (!EMPTY(CurOwner))
		Fprintf(sendmail, "owner-%s: %s\n", GroupasMail, CurOwner);
	}
    }

    if (mmdf) {
	Fprintf(mmdf, "\n## %s <==> %s gateway\n", Ngroup, Mlist);
	Fprintf(mmdf, "%s%s: %s@%s\n",
		CurDoMailinglist ? "" : "#", Mlist, Mlist, CurMailhost);
	Fprintf(mmdf, "post-%s: \"%s|%s -n %s",
	    Mlist, CurUser, CurMail2news, Ngroup);
	if (!EMPTY(CurOrganization))
	    Fprintf(mmdf, " -o '%s'", CurOrganization);
	if (!EMPTY(CurFlags))
	    Fprintf(mmdf, " %s", CurFlags);
	if (!EMPTY(CurModerator))
	    Fprintf(mmdf, " -a %s", CurModerator);
	Fprintf(mmdf, "\"\n");

	if (PostViaMail)
	    Fprintf(mmdf, "%s: \"%s|%s -n %s\"\n",
		GroupasMail, CurUser, CurMail2news, Ngroup);
    }

    if (ppuser) {
	Fprintf(ppuser, "\n## %s <==> %s gateway\n", Ngroup, Mlist);
	Fprintf(ppuser, "%s%s:822 %s@%s\n",
	    CurDoMailinglist ? "" : "#", Mlist, Mlist, CurMailhost);
	Fprintf(ppuser, "post-%s: shell\n", Mlist);
	if (PostViaMail)
	    Fprintf(ppuser, "%s:shell\n", GroupasMail);
	}  

    if (ppshell) {
	Fprintf(ppshell, "\n## %s <==> %s gateway\n", Ngroup, Mlist);
	Fprintf(ppshell, "post-%s:%s,,%s -n %s",
	    Mlist, CurUser, CurMail2news, Ngroup);
	if (!EMPTY(CurOrganization))
	    Fprintf(ppshell, " -o '%s'", CurOrganization);
	if (!EMPTY(CurFlags))
	    Fprintf(ppshell, " %s", CurFlags);
	if (!EMPTY(CurModerator))
	    Fprintf(ppshell, " -a %s", CurModerator);
	Fprintf(ppshell, "\n");
	if (PostViaMail)
	    Fprintf(ppshell, "%s:%s,,%s -n %s\n",
		GroupasMail, CurUser, CurMail2news, Ngroup);
    }  

    if (news == NULL) {
	/* Clean up. */
	free(GroupasMail);
	return;
    }

    if (CurSite == NULL) {
	Fprintf(stderr, "No site for newsgroup %s\n", Ngroup);
	return;
    }

    switch (NewsStyle) {

    case 'c':			/* C News	*/
	/* Psuedo-site name and distributions. */
	Fprintf(news, "%s\\\n  :%s,!%s.all", CurSite, Ngroup, Ngroup);
	if (CurDistribs) {
	    Fprintf(news, "/");
	    for (p = CurDistribs; *p; p++)
		Fprintf(news, "%s%s", p == CurDistribs ? "" : ",", *p);
	}
	Fprintf(news, "\\\n");

	/* Command invocation. */
	if (CurRequestAddr)
	    Fprintf(news, "  ::%s %s %s %s %s\n",
		    CurNews2mail, Mlist, CurMailcontact,
		    CurRequestAddr, CurMailhost);
	else
	    Fprintf(news, "  ::%s %s %s %s-request %s\n",
		    CurNews2mail, Mlist, CurMailcontact,
		    CurMailcontact, CurMailhost);
	break;

    case 'i':			/* InterNetNews	*/
	/* Psuedo-site name and distributions. */
	Fprintf(news, "%s\\\n  :%s", CurSite, Ngroup);
	if (CurDistribs) {
	    Fprintf(news, "/");
	    for (p = CurDistribs; *p; p++)
		Fprintf(news, "%s%s", p == CurDistribs ? "" : ",", *p);
	}
	Fprintf(news, "\\\n");

	/* Command invocation. */
	if (CurRequestAddr)
	    Fprintf(news, "  :Tp:%s %s %s %s %s %%s\n",
		    CurNews2mail, Mlist, CurMailcontact,
		    CurRequestAddr, CurMailhost);
	else
	    Fprintf(news, "  :Tp:%s %s %s %s-request %s %%s\n",
		    CurNews2mail, Mlist, CurMailcontact,
		    CurMailcontact, CurMailhost);
	break;

    case 'n':			/* B News	*/
	/* Psuedo-site name and distributions. */
	Fprintf(news, "%s\\\n  :", CurSite);
	if (CurDistribs) {
	    for (p = CurDistribs; *p; p++)
		Fprintf(news, "%s,!%s.all,", *p, *p);
	}
	Fprintf(news, "%s,!%s.all\\\n ", Ngroup, Ngroup);

	/* Command invocation. */
	if (CurRequestAddr)
	    Fprintf(news, "  ::%s %s %s %s %s %%s\n",
		    CurNews2mail, Mlist, CurMailcontact,
		    CurRequestAddr, CurMailhost);
	else
	    Fprintf(news, "  ::%s %s %s %s-request %s %%s\n",
		    CurNews2mail, Mlist, CurMailcontact,
		    CurMailcontact, CurMailhost);
	break;
    }

    /* Clean up. */
    free(GroupasMail);
}


/*
**  Open a file, or use - for standard output.  Write the prolog.
*/
STATIC FILE *
openfile(name, timestring)
    char	*name;
    char	*timestring;
{
    FILE	*F;

    if (EQ(name, "-"))
	F = stdout;
    else if ((F = fopen(name, "w")) == NULL) {
	Fprintf(stderr, "%s:  Can't open \"%s\" for output, %s.\n",
		Pname, name, strerror(errno));
	exit(1);
    }

    /* Write prolog. */
    Fprintf(F, "##  %s\n", "--START-OF-GATEWAY-OUTPUT-");
    Fprintf(F, "##  Created at %s", timestring);
    Fprintf(F, "##  %s\n",
	"This section of the file has been built automatically.");
    Fprintf(F, "##  %s\n",
	"If you make any changes here they will be lost when it is rebuilt.");

    return F;
}


/*
**  Close a file, write the epilog.
*/
STATIC void
closefile(F)
    FILE	*F;
{
    if (F) {
	Fprintf(F, "##  %s\n", "--END-OF-GATEWAY-OUTPUT-");
	if (F != stdout)
	    (void)fclose(F);
    }
}


STATIC void
Usage()
{
    Fprintf(stderr, "Usage:\n\t%s %s\n\t\t%s input\n",
	    Pname,
	    "[-b] [-p] [-c cnews] [-n news] [-i inn_news] [-d dir]",
	    "[-b bbn] [-m mmdf] [-s sendmail] [-t PP_shell] [-u PP_user]");
    Fprintf(stderr, "Only one of -c or -n may be used.\n");
    exit(1);
}


int
main(ac, av)
    int		ac;
    char	*av[];
{
    int		c;
    time_t	now;
    char	*timestring;

    /* Set defaults. */
    if ((Pname = RDX(av[0], '/')) == NULL)
	Pname = av[0];
    else
	Pname++;
    now = time((time_t *)NULL);
    timestring = ctime(&now);

    /* Parse JCL. */
    while ((c = getopt(ac, av, "ab:c:i:m:n:ps:t:u:")) != EOF)
	switch (c) {
	default:
	    Usage();
	    /* NOTREACHED */
	case 'a':
	    NoGroupCheck = TRUE;
	    break;
	case 'b':
	    bbn = openfile(optarg, timestring);
	    break;
	case 'c':
	case 'i':
	case 'n':
	    if (NewsStyle)
		Usage();
	    NewsStyle = c;
	    news = openfile(optarg, timestring);
	    break;
	case 'd':
	    OutDir = optarg;
	    break;
	case 'm':
	    mmdf = openfile(optarg, timestring);
	    break;
	case 'p':
	    PostViaMail++;
	    break;
	case 's':
	    sendmail = openfile(optarg, timestring);
	    break;
	case 't':
	    ppshell = openfile(optarg, timestring);
	    break;
	case 'u':
	    ppuser = openfile(optarg, timestring);
	    break;
	}

    /* Get input. */
    ac -= optind;
    av += optind;
    if (ac != 0 && ac != 1)
	Usage();
    yyopen(av[0]);


    /* Do the work. */
    (void)yyparse();

    /* Close files. */
    closefile(bbn);
    closefile(mmdf);
    closefile(news);
    closefile(sendmail);
    closefile(ppuser);
    closefile(ppshell);

    /* That's all she wrote... */
    exit(Errors == 0 ? 0 : 1);
    return Errors == 0 ? 0 : 1;
}
