;
; Test orchestra for the control opcode
;
; WARNING: this is totally provisional and unofficial, since no precise
; specs for the control and cdisplay module have been released - so these
; may change in the future
;
; What I can gather from reading the source code, as of release 3.49.3.2a
; of the unofficial sources the control opcodes work like this:
;
; 	cdisplay	kcommand, kslider, kval
;
; allows to send a control command to the display - commands are:
;
;	kcommand == 0 ==> set kslider slider to value kval
;	kcommand == 1 ==> set kslider minimum value to value kval
;	kcommand == 2 ==> set kslider maximum value to value kval
;
; ==========
;
;	kvalue	control	kslider
;
;	reads value from slider kslider into kvalue
;
; =========
;
; it looks like that the first time one of these opcodes are called, the
; mechanism allocates n sliders, where n is the highest slider mentioned
; so far; if another call mentions slider m > n, m sliders get allocated
; (so the idea is that you better call for the highest slider first to
; set your sliders, you will spend less time fragmenting your memory)
;
;
	sr=44100
	kr=441
	ksmps=100
	nchnls=1

	instr 1
	cdisplay 2, 4, 1024		; setting slider 4 max to 1024
	cdisplay 1, 4, 70		; setting slider 4 min to 70
	cdisplay 0, 4, 440		; setting slider 4 to 440
	endin

	instr 2
kfrq	control	4			; reading from slider 4
aout	oscil 	10000, kfrq, 1		; and controlling frequency
aref	oscil	10000, 440, 1		; reference oscillator
	out	aout+aref
	endin

