#include "cs.h"			/*				FGENS.C		*/
#include <stdlib.h>
#include "soundio.h"
#include "window.h"
#include <math.h>
#include "cmath.h"
#include "ftgen.h"

#define GENMAX  28
extern float curr_func_sr; /* gab A1 */
extern OPARMS  O;
extern float curr_func_sr;

typedef void    (*GEN)(void);

static void   gen01(void), gen01raw(void), gen02(void), gen03(void), gen04(void),
              gen05(void);
static void   gen06(void), gen07(void), gen08(void), gen09(void), gen10(void);
static void   gen11(void), gen12(void), gen13(void), gen14(void), gen15(void);
static void   gn1314(void), gen17(void), gen19(void), gen20(void), gen21(void);
static void   gen22(void), gen22raw(void), gen23(void),	gen24(void); /* gab-A1 */
static void   gen25(void), gen27(void), gen28(void);

static void   GENUL(void);

FUNC	**flist /*[MAXFNUM+1]*/;
static	FUNC	*ftp;
static  int	maxfnum = 0;
static	GEN	gensub[GENMAX+1] = { GENUL,
				     gen01, gen02, gen03, gen04, gen05,
				     gen06, gen07, gen08, gen09, gen10,
				     gen11, gen12, gen13, gen14, gen15,
				     GENUL, gen17, GENUL, gen19, gen20,
	  			     gen21, gen22,gen23,  gen24, gen25, /* gab-A1 (22-23-24) */
				     GENUL,  gen27, gen28};
static	EVTBLK	*e;

static	double	tpdlen, tpd360 = 0.017453293;
static	int	fno, guardreq, nargs, fterrcnt;
static	long	flen, flenp1, lenmask;
static  void    fterror(char *), ftresdisp(void), ftalloc(void);
static  int     displayed;	/* Set when graph drawn to stop redrawing */
static  void	ftalloc2(void); /* gab-A1 */

#define	FTERR(s)	{fterror(s);  return;}

#ifdef RESET
void ftreset(void)
{
    int i;
    mfree(flist);
    flist = NULL;
    maxfnum = 0;
    ftp= e = NULL;
}
#endif

static void   GENUL(void)
{
    FTERR("Unknown GEN number");
}

void fgens(EVTBLK *evtblkp)	/* create ftable using evtblk data */
{
    long	ltest, lobits, lomod, genum;

    e = evtblkp;
    fterrcnt = 0; displayed = 0;
    if ((fno = (int)e->p[1]) < 0) {			/* fno < 0: remove */
      if ((fno = -fno) > maxfnum)
	FTERR("illegal ftable number")
	  if ((ftp = flist[fno]) == NULL)
	    FTERR("ftable does not exist")
	      flist[fno] = NULL;
      mfree((char *)ftp);
      printf("ftable %d now deleted\n",fno);
      return;
    }
    if (!fno)				/* fno = 0, return	*/
      return;
    if (fno > maxfnum) {
      int size = maxfnum;
      FUNC **nn;
      int i;
      while (fno >= size) size += MAXFNUM;
      size++;
      if (maxfnum!=0)
	printf("Increasing number of tables from %d to %d\n", maxfnum, size-1);
      nn = (FUNC**)mrealloc(flist, size*sizeof(FUNC*));
      flist = nn;
      for (i=maxfnum+1; i<size; i++) flist[i] = NULL; /* Clear new section */
      maxfnum = size-1;
/*           FTERR("illegal ftable number") */
    }
    if ((nargs = e->pcnt - 4) <= 0)		/* chk minimum arg count */
      FTERR("insufficient gen arguments")
      if ((genum = (long)e->p[4]) < 0)
	genum = -genum;
    if (!genum || genum > GENMAX)		/*   & legal gen number */
      FTERR("illegal gen number")
    if ((flen = (long)e->p[3])) {		/* if user flen	given       */
      guardreq = flen & 01;			/*   set guard request flg  */
      flen &= -2;				/*   flen now w/o guardpt   */
      flenp1 = flen + 1;			/*   & flenp1 with guardpt  */
      if (flen <= 0 || flen > MAXLEN)
	FTERR("illegal table length")
      for (ltest=flen,lobits=0; (ltest & MAXLEN)==0; lobits++,ltest<<=1);
      if (ltest != MAXLEN)		/*   flen must be power-of-2 */
	FTERR("illegal table length")
      lenmask = flen-1;
   		if (genum == 22 || genum == -22) /* gab-A1 */
			ftalloc2();
		else /* end gab-A1 */
      ftalloc();				/*   alloc ftable space now */
      ftp->flen = flen;
      ftp->lenmask = lenmask;  		/*   init hdr w powof2 data */
      ftp->lobits = lobits;
      lomod = MAXLEN / flen;
      ftp->lomask = lomod - 1;
      ftp->lodiv = 1.0f/((float)lomod);	/*    & other useful vals    */
      tpdlen = TWOPI_F / flen;
      ftp->nchnls = 1;                    /*    presume mono for now   */
      ftp->flenfrms = flen;
    }
	else if (genum != 1 && genum != 28 && genum != 22) /* else defer alloc to gen01|gen28 */ /* gab-A1 (gen22) */
	    FTERR("deferred size for GEN01,GEN22 and GEN28 only")
    printf("ftable %d:\n", fno);
    (*gensub[genum])();			/* call gen subroutine	*/
	if (!fterrcnt && genum != 22)	/* gab-A1 (genum != 22) */
      ftresdisp();			/* rescale and display */
}

static void needsiz(long maxend)
{
    long nxtpow;
    maxend -= 1; nxtpow = 2;
    while (maxend >>= 1)
      nxtpow <<= 1;
    printf("non-deferred ftable %d needs size %ld\n", (int)fno, nxtpow);
}

static void gen01(void)         /* read ftable values from a sound file */
{				/* stops reading when table is full	*/
    if (nargs < 4)
      FTERR("insufficient args")
    if (O.gen01defer) {
      /* We're deferring the soundfile load until performance time,
	 so allocate the function table descriptor, save the arguments,
	 and get out */
      ftalloc();
      ftp->gen01args.gen01 = e->p[4];
      ftp->gen01args.ifilno = e->p[5];
      ftp->gen01args.iskptim = e->p[6];
      ftp->gen01args.iformat = e->p[7];
      ftp->gen01args.channel = e->p[8];
      strcpy(ftp->gen01args.strarg,e->strarg);
      ftp->flen = flen;
      return;
    }
    gen01raw();
}

static void gen01raw()             /* read ftable values from a sound file */
{				/* stops reading when table is full	*/
        extern  int	close(int);
	static	ARGOFFS	argoffs = {0};	/* OUTOCOUNT-not applicable yet */
	static	OPTXT	optxt;		/* create dummy optext	*/
        SOUNDIN *p;			/*   for sndgetset	*/
        AIFFDAT *adp;
        extern  int     sndgetset(SOUNDIN *);
        extern  long    getsndin(int, float *, long, SOUNDIN *);
	SOUNDIN	tmpspace;		/* create temporary opds */
        int     fd, truncmsg = 0;
        long    inlocs = 0;

	optxt.t.outoffs = &argoffs;      /* point to dummy OUTOCOUNT */
	p = &tmpspace;
	p->h.optext = &optxt;
	p->ifilno = &e->p[5];
	p->iskptim = &e->p[6];
	p->iformat = &e->p[7];
        p->channel = (short)e->p[8];
        p->bytrev = 0;
	if (p->channel < 0 || p->channel > ALLCHNLS-1) {
	    sprintf(errmsg,"channel %d illegal",(int)p->channel);
	    FTERR(errmsg);
	}
	if (p->channel == 0)                    /* snd is chan 1,2,..8 or all */
	    p->channel = ALLCHNLS;
	p->analonly = 0;
	p->STRARG = e->strarg;
	if (!flen)
		printf("deferred alloc\n");
	if ((fd = sndgetset(p))<0) 		/* sndinset to open the file */
		FTERR (errmsg)
	if (p->endfile) {
	        printf("GEN1 early end-of-file\n");
		goto gn1rtn;
	}
	if (!flen) {                            /* deferred ftalloc requestd: */
	    if ((flen = p->framesrem) <= 0)       /*   get minsize from soundin */
		FTERR ("deferred size, but filesize unknown")
	    if (p->channel == ALLCHNLS)
	        flen *= p->nchnls;
	    guardreq = 1;
	    flenp1 = flen;                      /* presum this includes guard */
	    flen -= 1;
	    ftalloc();                          /*   alloc now, and           */
	    ftp->flen = flen;
	    ftp->lenmask = 0;                   /*   mark hdr partly filled   */
	    ftp->nchnls = p->nchnls;
	    ftp->flenfrms = flen / p->nchnls;  /* ?????????? */
	}
 	ftp->gen01args.sample_rate = curr_func_sr;
	ftp->cvtbas = LOFACT * p->sr / esr;
        if ((adp = p->aiffdata) != NULL) {            /* if file was aiff,    */
	    /* set up some necessary header stuff if not in aiff file */
	    if (adp->natcps == 0)                      /* from Jeff Fried */
    		adp->natcps = ftp->cvtbas;
	    if (adp->gainfac == 0)
    		adp->gainfac = 1.0f;
	    ftp->cpscvt = ftp->cvtbas / adp->natcps;  /*    copy data to FUNC */
	    ftp->loopmode1 = adp->loopmode1;          /* (getsndin does gain) */
	    ftp->loopmode2 = adp->loopmode2;
	    ftp->begin1 = adp->begin1;
	    ftp->begin2 = adp->begin2;
	    if (ftp->loopmode1)	/* Greg Sullivan */
	      ftp->end1 = adp->end1;
	    else
	      ftp->end1 = ftp->flenfrms;
	    ftp->end1 = adp->end1;
	    ftp->end2 = adp->end2;
	    if (ftp->end1 > flen || ftp->end2 > flen) {
	        long maxend;
	        warning("GEN1: input file truncated by ftable size");
		if ((maxend = ftp->end1) < ftp->end2)
		    maxend = ftp->end2;
		printf("\tlooping endpoint %ld exceeds ftsize %ld\n",maxend,flen);
		needsiz(maxend);
		truncmsg = 1;
	    }
	}
	else {
	    ftp->cpscvt = 0.0f;	/* else no looping possible   */
	    ftp->loopmode1 = 0;
	    ftp->loopmode2 = 0;
	    ftp->end1 = ftp->flenfrms; /* Greg Sullivan */
	}
	if ((inlocs = getsndin(fd, ftp->ftable, flenp1, p)) < 0)  /* read sound */
	    fterror("GEN1 read error");                       /* with opt gain */
gn1rtn: if (p->audrem > 0 && !truncmsg && p->framesrem > flen) { /* Reduce msg */
	    warning("GEN1: aiff file truncated by ftable size");
	    printf("\taudio samps %ld exceeds ftsize %ld\n", p->framesrem, flen);
            needsiz(p->framesrem);     /* ????????????  */
	}
        ftp->soundend = inlocs / ftp->nchnls;   /* record end of sound samps */
        ftresdisp();
        close(fd);
}

static void gen02(void)             /* read ftable values directly from p-args */
{
	float	*fp = ftp->ftable, *pp = &e->p[5];
        int	nvals = nargs;

	if (nvals > flenp1)
		nvals = flenp1;			/* for all vals up to flen+1 */
	do  *fp++ = *pp++;			/*   copy into ftable	*/
	while (--nvals);
}

static void gen03(void)
{
	int	ncoefs;
	float	xintvl, xscale;
        int	xloc, nlocs;
        float	*fp = ftp->ftable, x, sum, *coefp, *coef0, *coeflim;

	if ((ncoefs = nargs - 2) <= 0)
		FTERR("no coefs present")
	coef0 = &e->p[7];
	coeflim = coef0 + ncoefs;
	if ((xintvl = e->p[6] - e->p[5]) <= 0)
		FTERR("illegal x interval")
	xscale = xintvl / (float)flen;
	xloc = (int)(e->p[5] / xscale);		/* initial xloc	*/
	nlocs = flenp1;
	do {					/* for each loc:	*/
		x = xloc++ * xscale;
		coefp = coeflim;
		sum = *--coefp;			/* init sum to coef(n)	*/
		while (coefp > coef0) {
			sum *= x;		/*  & accum by Horner's rule */
			sum += *--coefp;
		}
		*fp++ = sum;
	} while (--nlocs);
}

static void gen04(void)
{
	float	*valp, *rvalp, *fp = ftp->ftable;
        int	n, r;
        FUNC	*srcftp;
	float	val, max, maxinv;
	int	srcno, srcpts, ptratio;

	if (nargs < 2)
		FTERR("insufficient args")
	if ((srcno = (int)e->p[5]) <= 0 || srcno > maxfnum
	  || (srcftp = flist[srcno]) == NULL)
	  	FTERR("unknown srctable number")
	if (!e->p[6]) {
		srcpts = srcftp->flen;
		valp = &srcftp->ftable[0];
		rvalp = NULL;
	}
	else {
		srcpts = srcftp->flen >>1;
		valp = &srcftp->ftable[srcpts];
		rvalp = valp - 1;
	}
	if ((ptratio = srcpts / flen) < 1)
		FTERR("table size too large")
	if (val = *valp++) {
		if (val < 0.0f)	val = -val;
		max = val;
		maxinv = 1.0f / max;
	}
	else {
		max = 0.0f;
		maxinv = 1.0f;
	}
	*fp++ = maxinv;
	for (n = flen; n--; ) {
		for (r = ptratio; r--; ) {
			if (val = *valp++) {
				if (val < 0.0f)	val = -val;
				if (val > max) {
					max = val;
					maxinv = 1.0f / max;
				}
			}
			if (rvalp != NULL && (val = *rvalp--)) {
				if (val < 0.)	val = -val;
				if (val > max) {
					max = val;
					maxinv = 1.0f / max;
				}
			}
		*fp++ = maxinv;
	}
	}
	guardreq = 1;			/* disable new guard point */
	e->p[4] = -4.0f;		/*   and rescaling	   */
}

static void gen05(void)
{
	int	nsegs, seglen;
        float	*valp, *fp, *finp;
        float	amp1, mult;

	if ((nsegs = (nargs - 1) >> 1) <= 0)	     /* nsegs = nargs-1 /2 */
		return;
	valp = &e->p[5];
	fp = ftp->ftable;
	finp = fp + flen;
	if (*valp == 0) goto gn5er2;
	do {	amp1 = *valp++;
		if (!(seglen = (int)*valp++)) continue;
		if (seglen < 0) goto gn5er1;
		if ((mult = *valp/amp1) <= 0) goto gn5er2;
		mult = (float)pow( (double)mult, 1.0/(double)seglen );
		while (seglen--) {
			*fp++ = amp1;
			amp1 *= mult;
			if (fp > finp) return;
		}
	} while (--nsegs);
	if (fp == finp)			/* if 2**n pnts, add guardpt */
		*fp = amp1;
	return;

gn5er1: fterror("gen call has negative segment size:");
        return;
gn5er2:	fterror("illegal input vals for gen call, beginning:");
}

static void gen07(void)
{
	int	nsegs, seglen;
        float	*valp, *fp, *finp;
        float	amp1, incr;

	if ((nsegs = (nargs - 1) >> 1) <= 0)	     /* nsegs = nargs-1 /2 */
		return;
	valp = &e->p[5];
	fp = ftp->ftable;
	finp = fp + flen;
	do {	amp1 = *valp++;
		if (!(seglen = (int)*valp++)) continue;
		if (seglen < 0) goto gn7err;
		incr = (*valp - amp1) / seglen;
		while (seglen--) {
			*fp++ = amp1;
			amp1 += incr;
			if (fp > finp) return;
		}
	} while (--nsegs);
	if (fp == finp)			/* if 2**n pnts, add guardpt */
		*fp = amp1;
        return;

gn7err: fterror("gen call has negative segment size:");
}

static void gen06(void)
{
	float	*segp, *extremp, *inflexp, *segptsp, *fp, *finp;
	float	y, diff2;
        int	pntno, pntinc, nsegs, npts;

	if ((nsegs = (nargs - 1) >>1) < 1)
		FTERR("insufficient args")
	fp = ftp->ftable;
	finp = fp + flen;
	pntinc = 1;
	for (segp = &e->p[3]; nsegs > 0; nsegs--) {
		segp += 2;
		segptsp = segp + 1;
		if ((npts = (int)*segptsp) < 0)
			FTERR("negative segsiz")
		if (pntinc > 0) {
			pntno = 0;
			inflexp = segp + 2;
			extremp = segp;
		}
		else {
			pntno = npts;
			inflexp = segp;
			extremp = segp + 2;
		}
		diff2 = (*inflexp - *extremp) / 2.0f;
		for ( ; npts > 0 && fp < finp; pntno += pntinc, npts--) {
			y = (float)pntno / *segptsp;
			*fp++ = (3.0f-y) * y * y * diff2 + *extremp;
		}
		pntinc = -pntinc;
	}
	*fp = *(segp + 2);			/* write last target point */
}

static void gen08(void)
{
	float	R, x, c3, c2, c1, c0, *fp, *fplim, *valp;
	float	f2, f1, f0, df1, df0, dx01, dx02, dx12, curx;
	float	slope, resd1, resd0;
	int	nsegs, npts;

	if ((nsegs = (nargs - 1) >>1) <= 0)
		FTERR("insufficient args");
	valp = &e->p[5];
	fp = ftp->ftable;
	fplim = fp + flen;
	f0 = *valp++;			/* 1st 3 params give vals at x0, x1  */
	if ((dx01 = *valp++) <= 0.0f)	/*	and dist between	     */
		FTERR("illegal x interval");
	f1 = *valp++;
	curx = df0 = 0.0f;		/* init x to origin; slope at x0 = 0 */
	do {				/* for each spline segmnt (x0 to x1) */
	    if (nsegs > 1) {			/* if another seg to follow  */
		if ((dx12 = *valp++) <= 0.)	/*    read its distance	     */
			FTERR("illegal x interval");
		f2 = *valp++;			/*    and the value at x2    */
		dx02 = dx01 + dx12;
		df1 = ( f2*dx01*dx01 + f1*(dx12-dx01)*dx02 - f0*dx12*dx12 )
			/ (dx01*dx02*dx12);
	    }				   /* df1 is slope of parabola at x1 */
	    else df1 = 0.0f;
	    if ((npts = (int)(dx01 - curx)) > fplim - fp)
		npts = fplim - fp;
	    if (npts > 0) {			/* for non-trivial segment: */
		slope = (f1 - f0) / dx01;	/*   get slope x0 to x1	    */
		resd0 = df0 - slope;		/*   then residual slope    */
		resd1 = df1 - slope;		/*     at x0 and x1	    */
		c3 = (resd0 + resd1) / (dx01*dx01);
		c2 = - (resd1 + 2.0f*resd0) / dx01;
		c1 = df0;			/*   and calc cubic coefs   */
		c0 = f0;
		for (x = curx; npts>0; --npts, x += 1.0f) {
		    R = c3;
		    R *= x;
		    R += c2;	     /* f(x) = ((c3 x + c2) x + c1) x + c0  */
		    R *= x;
		    R += c1;
		    R *= x;
		    R += c0;
		    *fp++ = R;			/* store n pts for this seg */
		}
		curx = x;
	    }
	    curx -= dx01;		/* back up x by length last segment */
	    dx01 = dx12;		/* relocate to the next segment	*/
	    f0 = f1;			/*   by assuming its parameters	*/
	    f1 = f2;
	    df0 = df1;
	}
	while (--nsegs && fp<fplim);	/* loop for remaining segments	*/
	while (fp <= fplim)
	    *fp++ = f0;			/* & repeat the last value	*/
}

static void gen09(void)
{
	int	hcnt;
        float	*valp, *fp, *finp;
	double	phs, inc, amp;

	if ((hcnt = nargs / 3) <= 0)		/* hcnt = nargs / 3 */
		return;
	valp = &e->p[5];
	finp = &ftp->ftable[flen];
	do	for (inc=(*valp++)*tpdlen, amp=(*valp++),
		     phs=(*valp++)*tpd360, fp=ftp->ftable; fp<=finp; fp++) {
			*fp += (float)(sin(phs) * amp);
			if ((phs += inc) >= TWOPI)
				phs -= TWOPI;
		}
	while (--hcnt);
}

static void gen10(void)
{
	long	phs, hcnt;
        float	amp, *fp, *finp;

	if ((hcnt = nargs) <= 0)			/* hcnt is nargs   */
		return;
	finp = &ftp->ftable[flen];
	do if ((amp = e->p[hcnt+4]) != 0)		/* for non-0 amps,  */
		for (phs=0, fp=ftp->ftable; fp<=finp; fp++) {
			*fp += (float)sin(phs*tpdlen) * amp;	/* accum sin pts  */
			phs += hcnt;			/* phsinc is hno   */
			phs &= lenmask;
		}
	while (--hcnt);
}

static void gen11(void)
{
	float  *fp, *finp;
        long   phs;
	double	x;
	float	denom, r, scale;
	int	n, k;

	if (nargs < 1)
		FTERR ("insufficient arguments");
	if ((n = (int)e->p[5]) < 1)
		FTERR ("nh partials < 1");
	k = 1;
	r = 1.0f;
	if (nargs > 1)
		k = (int)e->p[6];
	if (nargs > 2)
		r = e->p[7];
	fp = ftp->ftable;
	finp = fp + flen;
	if (nargs == 1 || k == 1 && r == 1.) {     /* simple "buzz" case */
		int tnp1;
		float pdlen;

		tnp1 = (n << 1) + 1;
		scale = 0.5f / n;
		pdlen = (float)tpdlen / 2.0f;
		for (phs = 0; fp <= finp; phs++) {
			x = phs * pdlen;
			if (!(denom = (float)sin(x)))
				*fp++ = 1.0f;
			else *fp++ = ((float)sin(tnp1 * x) / denom - 1.0f) * scale;
		}
	}
	else {                                   /* complex "gbuzz" case */
		float numer, twor, rsqp1, rtn, rtnp1, absr;
		int   km1, kpn, kpnm1;

		km1   = k - 1;
		kpn   = k + n;
		kpnm1 = kpn - 1;
		twor  = r * 2.0f;
		rsqp1 = r * r + 1.0f;
		rtn   = (float)pow((double) r, (double) n);
		rtnp1 = rtn * r;
		if ((absr = (float)fabs(r)) > .999f && absr < 1.001f)
			scale = 1.0f / n;
		else scale = (1.0f - absr) / (1.0f - (float)fabs(rtn));
		for (phs=0; fp <= finp; phs++) {
			x = phs * tpdlen;
			numer = (float)cos(x*k) - r * (float)cos(x*km1) - rtn * (float)cos(x*kpn)
				+ rtnp1 * (float)cos(x*kpnm1);
			if ((denom = rsqp1 - twor*(float)cos(x)) > .0001f
			  || denom < -.0001f)
			  	*fp++ = numer / denom * scale;
			else *fp++ = 1.0f;
		}
	}
}

static void gen12(void)
{
static double coefs[] = { 3.5156229, 3.0899424, 1.2067492,
			  0.2659732, 0.0360768, 0.0045813 };
	double *coefp, sum, tsquare, evenpowr, *cplim = coefs + 6;
        int    n;
        float	*fp;
        double xscale;

	if (nargs < 1)
		FTERR ("insufficient arguments");
	xscale = (double) e->p[5] / flen / 3.75;
	for (n=0,fp=ftp->ftable; n<=flen; n++) {
	        tsquare = (double) n * xscale;
		tsquare *= tsquare;
		for (sum=evenpowr=1.0, coefp=coefs; coefp<cplim; coefp++) {
			evenpowr *= tsquare;
			sum += *coefp * evenpowr;
	        }
		*fp++ = (float) log(sum);
	}
}

static	float	mxval, mxscal;
static  void   gn1314(void), gen03(void);

static void gen13(void)
{
	mxval = 2.0f;
	mxscal = 0.5f;
	gn1314();
}

static void gen14(void)
{
	mxval = 1.0f;
	mxscal = 1.0f;
	gn1314();
}

static void gn1314(void)
{
	long	nh, nn;
        float	*mp, *mspace, *hp, *oddhp;
	float	xamp, xintvl, scalfac, sum, prvm;

	if ((nh = nargs - 2) <= 0)
		FTERR("insufficient args")
	if ((xintvl = e->p[5]) <= 0)
		FTERR("illegal xint value")
	if ((xamp = e->p[6]) <= 0)
		FTERR("illegal xamp value")
	e->p[5] = -xintvl;
	e->p[6] = xintvl;
        nn = nh * sizeof(float) / 2;	    /* alloc spc for terms 3,5,7,... */
	mp = mspace = (float *)mcalloc(nn);     /* of 1st row of matrix, and */
	for (nn = (nh + 1) >>1; --nn; )		/* form array of non-0 terms */
		*mp++ = mxval = -mxval;		/*  -val, val, -val, val ... */
	scalfac = 2 / xamp;
	hp = &e->p[7];				/* beginning with given h0,  */
	do {
		mp = mspace;
		oddhp = hp;
		sum = *oddhp++;			/* sum = diag(=1) * this h   */
		for (nn = (nh+1) >>1; --nn; ) {
			oddhp++;		/*  + odd terms * h+2,h+4,.. */
			sum += *mp++ * *oddhp++;
		}
		*hp++ = sum * mxscal;		/* repl this h w. coef (sum) */
		mp = mspace;
		prvm = 1.0f;
		for (nn = nh>>1; --nn > 0; mp++)/* calc nxt row matrix terms */
			*mp = prvm = *mp - prvm;
		mxscal *= scalfac;
	} while (--nh);				/* loop til all h's replaced */
	mfree((char *)mspace);
	gen03();				/* then call gen03 to write */
}

static void gen15(void)
{
	float	xint, xamp, hsin[PMAX/2], h, angle;
        float	*fp, *cosp, *sinp;
        int	n, nh;
        long	*lp, *lp13;

	if (nargs & 01)
		FTERR("uneven number of args");
	nh = (nargs - 2) >>1;
	fp = &e->p[5];					/* save p5, p6	*/
	xint = *fp++;
	xamp = *fp++;
	for (n = nh, cosp = fp, sinp = hsin; n > 0; n--) {
		h = *fp++;				/* rpl h,angle pairs */
		angle = (float)(*fp++ * tpd360);
		*cosp++ = h * (float)cos((double)angle);/*  with h cos angle */
		*sinp++ = h * (float)sin((double)angle);/* and save the sine */
	}
	nargs -= nh;
	gen13();					/* call gen13	*/
	if (fterrcnt) return;
	ftresdisp();					/* and display fno   */
	lp13 = (long *)ftp;
	fno++;					/* alloc eq. space for fno+1 */
	ftalloc();
	for (lp = (long *)ftp; lp < (long *)ftp->ftable; )  /* & copy header */
		*lp++ = *lp13++;
	fp = &e->p[5];
	*fp++ = xint;					/* restore p5, p6,   */
	*fp++ = xamp;
	for (n = nh-1, sinp = hsin+1; n > 0; n--)	/* then skip h0*sin  */
		*fp++ = *sinp++;			/* & copy rem hn*sin */
	nargs--;
	gen14();					/* now draw ftable   */
}

static void gen17(void)
{
	int	nsegs, ndx, nxtndx;
        float	*valp, *fp, *finp;
        float	val;

	if ((nsegs = nargs >> 1) <= 0)	     /* nsegs = nargs /2 */
	    goto gn17err;
	valp = &e->p[5];
	fp = ftp->ftable;
	finp = fp + flen;
	if ((ndx = (int)*valp++) != 0)
	    goto gn17err;
	while (--nsegs) {
	    val = *valp++;
	    if ((nxtndx = (int)*valp++) <= ndx)
		goto gn17err;
	    do {
	        *fp++ = val;
		if (fp > finp) return;
	    } while (++ndx < nxtndx);
	}
	val = *valp;
	while (fp <= finp)			/* include 2**n + 1 guardpt */
		*fp++ = val;
        return;

gn17err: fterror("gen call has illegal x-ordinate values:");
}

static void gen19(void)
{
	int	hcnt;
        float	*valp, *fp, *finp;
	double	phs, inc, amp, dc;

	if ((hcnt = nargs / 4) <= 0)		/* hcnt = nargs / 4 */
		return;
	valp = &e->p[5];
	finp = &ftp->ftable[flen];
	do	for (inc=(*valp++)*tpdlen, amp=(*valp++),
		     phs=(*valp++)*tpd360, dc=(*valp++),
		     fp=ftp->ftable; fp<=finp; fp++) {
			*fp += (float)(sin(phs) * amp + dc);   /* dc after str scale */
			if ((phs += inc) >= TWOPI)
				phs -= TWOPI;
		}
	while (--hcnt);
}

/*  GEN20 and GEN21 by Paris Smaragdis 1994 B.C.M. Csound development team  */
static void gen20()
{
    float cf[4], *ft;
    double arg, i, xarg, beta;

    ft = ftp->ftable;
    xarg = 1.0;

    if (e->p[4] < 0 )       {
	xarg = e->p[6];
	if ( nargs < 2 ) xarg = 1.0;
    }

    if (nargs > 2)
	beta = e->p[7];

    switch( (int)e->p[5])  {
    case 1:
	cf[0] = .54f;
	cf[1] = .46f;
	cf[2] = cf[3] = 0.0f;
	break;
    case 2:
	cf[0] = cf[1] = .5f;
	cf[2] = cf[3] = 0.0f;
	break;
    case 3:
	arg = 2.0/flen;
	for (i = 0.0 ; i < flen/2.0 ; i++)
	    *ft++ = (float)(i*arg*xarg);
	for (; i < flen ; i++)
	    *ft++ = (float)((2.0 - i*arg)*xarg);
	return;
    case 4:
	cf[0] = .42f;
	cf[1] = .5f;
	cf[2] = .08f;
	cf[3] = 0.0f;
	break;
    case 5:
	cf[0] = .35878f;
	cf[1] = .48829f;
	cf[2] = .14128f;
	cf[3] = .01168f;
	break;
    case 6:
	arg = 12.0/flen;
	for (i = -6.0 ; i < 0.0 ; i += arg)
	    *ft++ = (float)(xarg * (pow( 2.71828, -(i*i)/2.0)));
	for (i = arg ; i < 6.0 ; i += arg)
	    *ft++ = (float)(xarg * (pow( 2.71828, -(i*i)/2.0)));
	return;
    case 7:
	for (i = -flen/2.0 + .1 ; i < flen/2 ; i++)
	    *ft++ = (float)(xarg *
              besseli((beta * sqrt(1.0-pow((2.0*i/(flen - 1)), 2.0)))) /
              besseli( beta));
	return;
    case 8:
	for (i = 0 ; i < flen ; i++)
	    *ft++ = 1.0f;
	return;
    case 9:
	arg = TWOPI / flen;
	for (i = -PI ; i < 0 ; i += arg)
	    *ft++ = (float)(xarg * sin(i) / i);
	*ft++ = 1.0f;
	for (i = arg ; i < PI ; i += arg)
	    *ft++ = (float)(xarg * sin(i) / i);
	return;
    default:
	fterror("No such window!");
	return;
    }

    arg = TWOPI/flen;

    for (i = 0.0 ; i < TWOPI ; i += arg)
	*ft++ = (float)(xarg * (cf[0] - cf[1]*cos(i) +
                        cf[2]*cos(2.0*i) - cf[3]*cos(3.0*i)));
}

float besseli( double x)
{
    float ax, ans;
    double y;

    if (( ax = (float)fabs( x)) < 3.75f)     {
	y = x / 3.75;
	y *= y;
	ans = (float)(1.0 + y * ( 3.5156229 +
			  y * ( 3.0899424 +
				y * ( 1.2067492 +
				      y * ( 0.2659732 +
					    y * ( 0.360768e-1 +
						  y * 0.45813e-2))))));
    }
    else {
	y = 3.75 / ax;
	ans = (float)((exp ( ax) / sqrt(ax))
	    * (0.39894228 +
	       y * (0.1328592e-1 +
		    y * (0.225319e-2 +
			 y * (-0.157565e-2 +
			      y * (0.916281e-2 +
				   y * (-0.2057706e-1 +
					y * (0.2635537e-1 +
					     y * (-0.1647633e-1 +
						  y * 0.392377e-2)))))))));
    }
    return ans;
}

static void gen21(void)
{
    long i;
    float *ft;

    ft = ftp->ftable;

    if (nargs < 1)  {		/* All need at least 1 argument */
      fterror("Wrong number of input arguments\n");
      return;
    }
    switch ((int)e->p[5])  {
    case 1:			/* Uniform distribution */
	for (i = 0 ; i < flen ; i++)
	    *ft++ = unifrand((float)e->p[6]);
	break;
    case 2:			/* Linear distribution */
	for (i = 0 ; i < flen ; i++)
	    *ft++ = linrand( (float) e->p[6]);
	break;
    case 3:			/* Triangular about 0.5 */
	for (i = 0 ; i < flen ; i++)
	    *ft++ = trirand( (float) e->p[6]);
	break;
    case 4:			/* Exponential */
	for (i = 0 ; i < flen ; i++)
	    *ft++ = exprand( (float) e->p[6]);
	break;
    case 5:			/* Bilateral exponential */
	for (i = 0 ; i < flen ; i++)
	    *ft++ = biexprand( (float) e->p[6]);
	break;
    case 6:			/* Gaussian distribution */
	for (i = 0 ; i < flen ; i++)
	    *ft++ = gaussrand( (float) e->p[6]);
	break;
    case 7:			/* Cauchy distribution */
	for (i = 0 ; i < flen ; i++)
	    *ft++ = cauchrand( (float) e->p[6]);
	break;
    case 8:			/* Positive Cauchy */
	for (i = 0 ; i < flen ; i++)
	    *ft++ = pcauchrand( (float) e->p[6]);
	break;
    case 9:			/* Beta distribution */
	if (nargs < 3)  {
	    fterror("Wrong number of input arguments\n");
	    return;
	}
	for (i = 0 ; i < flen ; i++)
	    *ft++ = betarand((float)e->p[6],(float)e->p[7],(float)e->p[8]);
	break;
    case 10:			/* Weibull Distribution */
	if (nargs < 2)  {
	    fterror("Wrong number of input arguments\n");
	    return;
	}
	for (i = 0 ; i < flen ; i++)
	    *ft++ = weibrand( (float) e->p[6], (float) e->p[7]);
	break;
    case 11:			/* Poisson Distribution */
	for (i = 0 ; i < flen ; i++)
	    *ft++ = poissrand( (float) e->p[6]);
	break;
    default:
	fterror("Unknown distribution\n");
    }
}

static void gen25(void)
{
    int	nsegs,  seglen;
    float	*valp, *fp, *finp;
    float	x1, x2, y1, y2, mult;

    if ((nsegs = ((nargs / 2) - 1) )<= 0) return;
    valp = &e->p[5];
    fp = ftp->ftable;
    finp = fp + flen;
    do {
      x1 = *valp++;
      y1 =  *valp++;
      x2 = *valp++;
      if (nsegs > 1)
        y2 =  *valp++;
      else
        y2 = *valp;
      if (x2 < x1) goto gn25err;
      if (x1 > flen || x2 > flen) goto gn25err2;
      seglen = (int)(x2-x1);
      if (y1 <= 0 || y2 <= 0) goto gn25err3;
      mult = y2/y1;
      mult = (float)pow( (double)mult, 1.0/(double)seglen );
      while (seglen--) {
        *fp++ = y1;
        y1 *= mult;
        if (fp > finp) return;
      }
      valp -= 2;
    } while (--nsegs);
    if (fp == finp)			/* if 2**n pnts, add guardpt */
      *fp = y1;
    return;

 gn25err:
    fterror("x coordindates must all be in increasing order:");
    return;

 gn25err2:
    fterror("x coordindate greater than function size:");
    return;

 gn25err3:
    fterror("illegal input val (y <= 0) for gen call, beginning:");
    return;
}

static void gen27(void)
{
    int	nsegs;
    float	*valp, *fp, *finp;
    float	x1, x2, y1, y2, seglen, incr;

    if ((nsegs = ((nargs / 2) - 1) )<= 0) return;
    valp = &e->p[5];
    fp = ftp->ftable;
    finp = fp + flen;
    do {
      x1 = *valp++;
      y1 = *valp++;
      x2 = *valp++;
      if (nsegs > 1)
        y2 =  *valp++;
      else
        y2 = *valp;
      if (x2 < x1) goto gn27err;
      if (x1 > flen || x2 > flen) goto gn27err2;
      seglen = x2-x1;
      incr = (y2 - y1) / seglen;
      while (seglen--) {
        *fp++ = y1;
        y1 += incr;
        if (fp > finp) return;
      }
      valp -= 2;
    } while (--nsegs);
    if (fp == finp)			/* if 2**n pnts, add guardpt */
      *fp = y1;
    return;

 gn27err:
    fterror("x coordindates must all be in increasing order:");
    return;
 gn27err2:
    fterror("x coordindate greater than function size:");
    return;
}

static void gen28(void) /* read X Y values directly from ascii file */
{
    float	*fp = ftp->ftable, *finp;
    int 	seglen, resolution=100;
    FILE	*filp;
    char filename[256];
    int i=0, j=0;
    float *x, *y, *z;
    int arraysize = 1000;
    float x1, y1, z1, x2, y2, z2, incrx, incry;
    
    finp = fp + flen;
    strcpy(filename,e->strarg);
    if ((filp = fopen(filename, "r" )) == NULL) goto gen28err1;
    
    x = (float*)mmalloc(arraysize*sizeof(float));
    y = (float*)mmalloc(arraysize*sizeof(float));
    z = (float*)mmalloc(arraysize*sizeof(float));
    while (fscanf( filp, "%f%f%f", &z[i], &x[i], &y[i])!= EOF) {
      i++;
      if (i>=arraysize) {
	arraysize += 1000;
	x = (float*)mrealloc(x, arraysize*sizeof(float));
	y = (float*)mrealloc(y, arraysize*sizeof(float));
	z = (float*)mrealloc(z, arraysize*sizeof(float));
      }
    }
    --i;

    flen = (long)(z[i]*resolution*2);
    flen = flen+2;
    lenmask=flen;
    flenp1=flen+2;
    ftp=NULL;
    mfree((char *)ftp);      	/*   release old space   */
    ftp = (FUNC *) mcalloc((long)sizeof(FUNC) + flen*sizeof(float));
    flist[fno] = ftp;
    ftp->flen = flen;
    ftp->lenmask=flen;
    fp = ftp->ftable;
    finp = fp + flen;

    do {
      x1 = x[j];
      y1 = y[j];
      x2 = x[j+1];
      y2 = y[j+1];
      z1 = z[j];
      z2 = z[j+1];
	
      if (z2 < z1) goto gen28err2;
      seglen = (int)((z2-z1) * resolution); /* printf("seglen= %f\n", seglen); */
      incrx = (x2 - x1) / (float)seglen;
      incry = (y2 - y1) / (float)seglen;
      while (seglen--) {
        *fp++ = x1; /* printf("x= %f  ", x1); fflush(stdout); */
        x1 += incrx;
        *fp++ = y1; /* printf("y= %f\n", y1); fflush(stdout); */
        y1 += incry;
      }
      
      j++;
    } while (--i);
    do {
      *fp++ = x[j];
      *fp++ = y[j+1];
    } while (fp < finp);

    mfree(x); mfree(y); mfree(z);
    fclose(filp);

    return;

gen28err1: fterror("couldn't open space file"); return;
gen28err2: fterror("Time values must be in increasing order"); return;
}


static void fterror(char *s)
{
	printf("FTERROR, ftable %d: %s\n",fno,s);
	printf("f%3.0f%8.2f%8.2f%8.2f",e->p[1],e->p2orig,e->p3orig,e->p[4]);
	if (e->p[5] == SSTRCOD)
	    printf("  \"%s\" ...\n",e->strarg);
	else printf("%8.2f ...\n",e->p[5]);
	fterrcnt++;
}

static void ftresdisp(void)   /* set guardpt, rescale the function, and display it */
{
	float	*fp, *finp = &ftp->ftable[flen];
        float	abs, maxval;
        static	WINDAT	dwindow;

	if (!guardreq)				/* if no guardpt yet, do it */
	  ftp->ftable[flen] = ftp->ftable[0];
	if (e->p[4] > 0.) {			/* if genum positve, rescale */
	  for (fp=ftp->ftable, maxval = 0.0f; fp<=finp; ) {
	    if ((abs = *fp++) < 0.0f)
	      abs = -abs;
	    if (abs > maxval)
	      maxval = abs;
	  }
	  if (maxval != 0.0f && maxval != 1.0f)
	    for (fp=ftp->ftable; fp<=finp; fp++)
	      *fp /= maxval;
	}
	sprintf(strmsg,"ftable %d:",fno);
	dispset(&dwindow,ftp->ftable,(long)(flen+guardreq),strmsg,0,"ftable");
	if (!displayed) display(&dwindow);
	displayed = 1;
}

static void ftalloc(void)   /* alloc ftable space for fno (or replace one)  */
{			/*	set ftp to point to that structure	*/
	if ((ftp = flist[fno]) != NULL) {
	    printf("replacing previous ftable %d\n",fno);
	    if (flen != ftp->flen) {    	/* if redraw & diff len, */
		extern INSDS actanchor;
		mfree((char *)ftp);      	/*   release old space   */
		flist[fno] = NULL;
		if (actanchor.nxtact != NULL) { /*   & chk for danger    */
		    sprintf(errmsg,"ftable %d relocating due to size change\n"
                            "currently active instruments may find this disturbing", fno);
		    warning(errmsg);
		}
	    }
	    else {				/* else clear it to zero */
	        float	*fp = ftp->ftable;
		float	*finp = &ftp->ftable[flen];
		while (fp <= finp)
		    *fp++ = 0.0f;
	    }
	}
	if ((ftp = flist[fno]) == NULL) {	/*   alloc space as reqd */
	    ftp = (FUNC *) mcalloc((long)sizeof(FUNC) + flen*sizeof(float));
	    flist[fno] = ftp;
	}
}

 FUNC *
ftfind(float *argp)     /* find the ptr to an existing ftable structure */
			/*   called by oscils, etc at init time         */
{
	int	fno;
	FUNC	*ftp;

	if ((fno = (int)*argp) <= 0 || fno > maxfnum || (ftp = flist[fno]) == NULL) {
		sprintf(errmsg, "invalid ftable no. %f", *argp);
		initerror(errmsg);
		return(NULL);
	}
	else if (!ftp->lenmask) {
		sprintf(errmsg, "deferred-size ftable %f illegal here", *argp);
		initerror(errmsg);
		return(NULL);
	}
	else return(ftp);
}

/* gab-A1 */
FUNC *
ftfind2(float *argp)  /* added for allowing ftlen2() can return table size */
{					/* see ftlen() in AOPS.C */
register int	fno;
register FUNC	*ftp;

	if ((fno = (int) *argp) <= 0 || fno > MAXFNUM || (ftp = flist[fno]) == NULL) {
		sprintf(errmsg, "invalid ftable no. %f", *argp);
		initerror(errmsg);
		return(NULL);
	}
	else return(ftp);
}

/* end gab-A1 */

/*************************************/
/* ftfindp()
 *
 * New function to find a function table at performance time.  Based
 * on ftfind() which is intended to run at init time only.
 *
 * This function can be called from other modules - such as ugrw1.c.
 *
 * It returns a pointer to a FUNC data structure which contains all
 * the details of the desired table.  0 is returned if it cannot be
 * found.
 *	
 * This does not handle deferred function table loads (gen01).
 *	
 * Maybe this could be achieved, but some exploration would be
 * required to see that this is feasible at performance time.
 *  */
FUNC * ftfindp(float *argp)     		
{
    int	fno;
    FUNC	*ftp;
    /* Check limits, and then index  directly into the flist[] which
     * contains pointers to FUNC data structures for each table.
     */
    if ((fno = (int)*argp) <= 0 || fno > maxfnum || (ftp = flist[fno]) == NULL) {
      sprintf(errmsg, "Invalid ftable no. %f", *argp);
      perferror(errmsg);
      return(NULL);
    }
    else if (!ftp->lenmask) {
      /* Now check that the table has a length > 0.  This should only
       * occur for tables which have not been loaded yet.  */
      sprintf(errmsg, 
              "Deferred-size ftable %f load not available at perf time.",
              *argp);
      perferror(errmsg);
      return(NULL);
    }
    else return(ftp);
}

 FUNC *
ftnp2find(float *argp)  /* find ptr to a deferred-size ftable structure */
			/*   called by loscil at init time, and ftlen   */
{
    EVTBLK evt;
    char strarg[SSTRSIZ];

    if ((fno = (int)*argp) <= 0 || fno > maxfnum || (ftp = flist[fno]) == NULL) {
	sprintf(errmsg, "invalid ftable no. %f", *argp);
	initerror(errmsg);
	return(NULL);
    }
    else {
	if (ftp->flen == 0) {
                /* The soundfile hasn't been loaded yet, so call GEN01 */
	    flen = 0;
	    e = &evt;
	    e->p[4] = ftp->gen01args.gen01;
	    e->p[5] = ftp->gen01args.ifilno;
	    e->p[6] = ftp->gen01args.iskptim;
	    e->p[7] = ftp->gen01args.iformat;
	    e->p[8] = ftp->gen01args.channel;
	    strcpy(strarg,ftp->gen01args.strarg);
	    e->strarg = strarg;
	    gen01raw();
	}
	return (ftp);
    }
}

static int ftldno = 100;        /* Count table number */
/* gab-A1 ------------------------------------- */

 static void gen22(void)             /* read table short values from a sound file */
{				/* stops reading when table is full	*/
	if (nargs < 4) FTERR("insufficient args")
	if (O.gen01defer) {
		/* We're deferring the soundfile load until performance time,
		   so allocate the function table descriptor, save the arguments,
		   and get out */
		ftalloc2();
		ftp->gen01args.gen01 = e->p[4];
		ftp->gen01args.ifilno = e->p[5];
		ftp->gen01args.iskptim = e->p[6];
		ftp->gen01args.iformat = e->p[7];
		ftp->gen01args.channel = e->p[8];
		strcpy(ftp->gen01args.strarg,e->strarg);
		ftp->flen = flen;                   
		return;
	}  
	gen22raw();
}



static void gen22raw()             /* read ftable values from a sound file */
{				                   /* stops reading when table is full	*/
	extern  int	close(int);
	static	ARGOFFS	argoffs = {0};		/* OUTOCOUNT-not applicable yet */
	static	OPTXT	optxt;			/* create dummy optext	*/
	register SOUNDIN *p;			/*   for sndgetset	*/
	AIFFDAT *adp;
	extern  int     sndgetset(SOUNDIN *);
	extern  long    getsndin2(int, short *, long, SOUNDIN *);
	SOUNDIN	tmpspace;		/* create temporary opds */
	int     fd, truncmsg = 0;
	long    inlocs = 0;

	optxt.t.outoffs = &argoffs;      /* point to dummy OUTOCOUNT */
	p = &tmpspace;
	p->h.optext = &optxt;
	p->ifilno = &e->p[5];
	p->iskptim = &e->p[6];
	p->iformat = &e->p[7];
	p->channel = (short) e->p[8];
	if (p->channel < 0 || p->channel > 4) {
	    sprintf(errmsg,"channel %d illegal",(int)p->channel);
	    FTERR(errmsg);
	}
	if (p->channel == 0)                    /* snd is chan 1,2,3,4 or all */
	    p->channel = ALLCHNLS;
	p->analonly = 0;
	p->STRARG = e->strarg;
	if (!flen)
		printf("deferred alloc\n");
	if ((fd = sndgetset(p))<0) 	/* gab-A3 */	/* sndinset to open the file */
		FTERR (errmsg)
	if (p->endfile) {
	    printf("GEN22 early end-of-file\n");
		goto gn1rtn;
	}
	if (!flen) {                            /* deferred ftalloc requestd: */
	    if ((flen = p->framesrem) <= 0)       /*   get minsize from soundin */
		FTERR ("deferred size, but filesize unknown")
	    if (p->channel == ALLCHNLS)
	        flen *= p->nchnls;
	    guardreq = 1;
	    flenp1 = flen;                      /* presum this includes guard */
	    flen -= 1;
	    ftalloc2();                          /*   alloc now, and           */
	    ftp->flen = flen;
	    ftp->lenmask = 0;                   /*   mark hdr partly filled   */
	    ftp->nchnls = p->nchnls;
	    ftp->flenfrms = flen / p->nchnls;  /* ?????????? */
	}
	ftp->gen01args.sample_rate = curr_func_sr; //GAB 26 jun 97
	ftp->cvtbas = LOFACT * p->sr / esr;
    if ((adp = p->aiffdata) != NULL) {            /* if file was aiff,    */
	    /* set up some necessary header stuff if not in aiff file */
		if (adp->natcps == 0)                      /* from Jeff Fried */
    		adp->natcps = ftp->cvtbas;
		if(adp->gainfac == 0)
    		adp->gainfac = 1.0;
		ftp->cpscvt = ftp->cvtbas / adp->natcps;  /*    copy data to FUNC */
    	ftp->loopmode1 = adp->loopmode1;          /* (getsndin does gain) */
		ftp->loopmode2 = adp->loopmode2;
		ftp->begin1 = adp->begin1;
		ftp->begin2 = adp->begin2;
		if (ftp->loopmode1)	/* Greg Sullivan */
	    	  ftp->end1 = adp->end1;
		else
	    	  ftp->end1 = ftp->flenfrms; 
		ftp->end1 = adp->end1;
		ftp->end2 = adp->end2;
		if (ftp->end1 > flen || ftp->end2 > flen) {
	        long maxend;
	        warning("GEN22: input file truncated by ftable size");
			if ((maxend = ftp->end1) < ftp->end2)
		    	maxend = ftp->end2;
			printf("\tlooping endpoint %ld exceeds ftsize %ld\n",maxend,flen);
			needsiz(maxend);
			truncmsg = 1;
	    }
	}
	else {
	    ftp->cpscvt = 0.;                  /* else no looping possible   */
	    ftp->loopmode1 = 0;
	    ftp->loopmode2 = 0;
	    ftp->end1 = ftp->flenfrms; /* Greg Sullivan */
	}
	if ((inlocs = getsndin2(fd, (short *) ftp->ftable, flenp1, p)) < 0)  /* read sound */
	    fterror("GEN22 read error");                       /* with opt gain */
gn1rtn: if (p->audrem > 0 && !truncmsg) {
		    warning("GEN22: aiff file truncated by ftable size");
	    	printf("\taudio samps %ld exceeds ftsize %ld\n", p->framesrem, flen);
        	needsiz(p->framesrem);     /* ????????????  */
	}
    ftp->soundend = inlocs / ftp->nchnls;   /* record end of sound samps */
    close(fd);
}


static void ftalloc2(void)   /* alloc ftable space for fno (or replace one)  */
{			                 /*	set ftp to point to that structure	*/
	if ((ftp = flist[fno]) != NULL) {
	    printf("replacing previous ftable %d\n",fno);
	    if (flen != ftp->flen) {    	/* if redraw & diff len, */
			extern INSDS actanchor;
			free((char *)ftp);      	/*   release old space   */
			flist[fno] = NULL;
			if (actanchor.nxtact != NULL) { /*   & chk for danger    */
		    	sprintf(errmsg,"ftable %d relocating due to size change\n\
  currently active instruments may find this disturbing", fno);
		    	warning(errmsg);
			}
	    }
	    else {				/* else clear it to zero */
	        register short	*fp = (short *) ftp->ftable; //gab
			register short	*finp = (short *) &ftp->ftable[flen/2]; //gab
			while (fp <= finp)
		    *fp++ = 0;
	    }
	}
	if ((ftp = flist[fno]) == NULL) {	/*   alloc space as reqd */
	    ftp = (FUNC *) mcalloc((long)sizeof(FUNC) + flen*sizeof(short)); //GAB!!!
	    flist[fno] = ftp;
	}
}

static void gen23(void)	 /*ascii file table read Gab 17-feb-98*/
{				
	int  c,j=0;
	char buf[512],  *p;
    register float *fp;
	FILE	*infile;

 	if(!(infile=fopen(e->strarg,"r"))) FTERR ("error opening ascii file");
	fp = ftp->ftable;
	p = buf;
	while ((c= getc(infile)) != EOF && j < flen) {
		if (   c != ' ' 
			&& c != '\t'
		    && c != '\n' )  {
			if (c == ';') {
				while( (c= getc(infile)) != '\n') ;	/* gab-A6 */
			}
			else *p++ = c ;
		}
		else {
			*p = '\0';
			for ( p = buf; *p != '\0'; p++) {
				if ((*p < '0' || *p > '9') && *p != '.' && *p != '\0') 	goto next ;
			}
			*fp++ = (float) atof (buf);
			j++;
		next: 
			while ((c=getc(infile)) == ' ' 
			                  ||  c == '\n'
			                  ||  c == '\t' 
							  ||  c == 0) ;
			ungetc(c,infile);				  
			p= buf;
		}
	}
	fclose(infile);

}

static void gen24(void)
{
register float	*fp = ftp->ftable, *fp_source;  // array valori destinazione
//register int	n, r;
register FUNC	*srcftp;	 // srcftp -> array valori sorgente
	//float	val, max, maxinv; 
	int	srcno, srcpts, j;
	float max , min, new_max, new_min,source_amp,target_amp ,amp_ratio;

	if (nargs < 3)
		FTERR("insufficient args")
	if ((srcno = (int)e->p[5]) <= 0  // cerca la tabella sorgente
	     || srcno > MAXFNUM	 
	     || (srcftp = flist[srcno]) == NULL)
	  		FTERR("unknown srctable number")
	fp_source = srcftp->ftable;

	new_min = e->p[6];
	new_max = e->p[7];
	srcpts = srcftp->flen;
	if ( srcpts!= flen)	// i numeri della tabella devono essere uguali alla sorgente
		FTERR("table size must be the same of source table")
	max=min=fp_source[0];
	for (j = 0; j < srcpts; j++) { // trova il massimo e il minimo della tabella sorgente
	 	if (fp_source[j] > max ) max = fp_source[j];
		if (fp_source[j] < min ) min =	fp_source[j];
	}

	
	source_amp = max-min;
	target_amp = new_max - new_min;
	amp_ratio = target_amp/source_amp;

	for (j = 0; j < srcpts; j++) {
		fp[j] = (fp_source[j]-min) * amp_ratio + new_min;
	}
	fp[j] = fp[j-1];
}

/* end gab-A1 ---------------------- */

static FUNC     *ftp;
#define FTPLERR(s)     {fterror(s);  die("ftable load error");return(NULL);}

FUNC *hfgens(EVTBLK *evtblkp)               /* create ftable using evtblk data */
{
    long    ltest, lobits, lomod, genum;

    e = evtblkp;
    fterrcnt = 0;
    if ((fno = (int)e->p[1]) < 0) {         /* fno < 0: remove */
      if ((fno = -fno) > maxfnum) {
        int size = maxfnum+1;
        FUNC **nn;
        int i;
        while (fno >= size) size += MAXFNUM;
        if (maxfnum!=0)
          printf("Increasing number of tables from %d to %d\n", maxfnum, size-1);
        nn = (FUNC**)mrealloc(flist, size*sizeof(FUNC*));
        flist = nn;
        for (i=maxfnum+1; i<size; i++) flist[i] = NULL; /* Clear new section */
        maxfnum = size-1;
      }
      if ((ftp = flist[fno]) == NULL)
        FTPLERR("ftable does not exist")
      flist[fno] = NULL;
      mfree((char *)ftp);
      printf("ftable %d now deleted\n",fno);
      return(NULL);                       /**************/
    }
    if (!fno)                               /* fno = 0, automatic number */
      e->p[1] = (float)(fno = ++ftldno);
    if (fno > maxfnum) {
        int size = maxfnum+1;
        FUNC **nn;
        int i;
        while (fno >= size) size += MAXFNUM;
        if (maxfnum!=0)
          printf("Increasing number of tables from %d to %d\n", maxfnum, size-1);
        nn = (FUNC**)mrealloc(flist, size*sizeof(FUNC*));
        flist = nn;
        for (i=maxfnum+1; i<size; i++) flist[i] = NULL; /* Clear new section */
        maxfnum = size-1;
    }
    if ((nargs = e->pcnt - 4) <= 0)         /* chk minimum arg count */
      FTPLERR("insufficient gen arguments")
    if ((genum = (long)e->p[4]) < 0)
      genum = -genum;
    if (!genum || genum > GENMAX)           /*   & legal gen number */
      FTPLERR("illegal gen number")
    if ((flen = (long)e->p[3]) != 0) {      /* if user flen given       */
      guardreq = flen & 01;                 /*   set guard request flg  */
      flen &= -2;                           /*   flen now w/o guardpt   */
      flenp1 = flen + 1;                    /*   & flenp1 with guardpt  */
      if (flen <= 0 || flen > MAXLEN)
        FTPLERR("illegal table length")
      for (ltest=flen,lobits=0; (ltest & MAXLEN) == 0; lobits++,ltest<<=1);
      if (ltest != MAXLEN)                  /*   flen must be power-of-2 */
        FTPLERR("illegal table length")
      lenmask = flen-1;
      ftalloc();                            /*   alloc ftable space now */
      ftp->fno = fno;
      ftp->flen = flen;
      ftp->lenmask = lenmask;               /*   init hdr w powof2 data */
      ftp->lobits = lobits;
      lomod = MAXLEN / flen;
      ftp->lomask = lomod - 1;
      ftp->lodiv = 1.0f/((float)lomod);       /*    & other useful vals    */
      tpdlen = TWOPI / flen;
      ftp->nchnls = 1;                      /*    presume mono for now   */
      ftp->flenfrms = flen;     /* Is this necessary?? */
    }
    else if (genum != 1 && genum != 28) /* else defer alloc to gen01 */
      FTPLERR("deferred size for GEN1 only")
    printf("ftable %d:\n", fno);
    (*gensub[genum])();                     /* call gen subroutine  */
    if (!fterrcnt) {
      dispinit();
      ftresdisp();                          /* rescale and display */
    }
    return(ftp);
}

#define FTPMAX	(100)
static  EVTBLK  *ftevt = NULL;

void ftgen(FTGEN *p)                    /* set up and call any GEN routine */
{
    int nargs;
    float *fp;
    FUNC *ftp;

    if (ftevt == NULL) {
      ftevt = (EVTBLK *)mcalloc((long)sizeof(EVTBLK) + FTPMAX * sizeof(float));
      ftevt->opcod = 'f';
    }
    fp = &ftevt->p[1];
    *fp++ = *p->p1;
    *fp++ = *p->p2;                               /* copy p1 - p5 */
    *fp++ = *p->p3;
    *fp++ = *p->p4;
    *fp++ = *p->p5;
    if ((nargs = p->INOCOUNT - 5) > 0) {
      float **argp = p->argums;
      while (nargs--)                             /* copy rem arglist */
        *fp++ = **argp++;
    }
    ftevt->p[2] = 0.0f;                             /* force time 0    */
    if (ftevt->p[5] == SSTRCOD) {                 /* if string p5    */
      if (ftevt->p[4] == 1.0) {                   /*   must be Gen01 */
        ftevt->strarg = p->STRARG;
      }
      else {
        initerror("ftgen string arg not allowed");
        return;
      }
    }
    else ftevt->strarg = NULL;                    /* else no string */
    ftevt->pcnt = p->INOCOUNT;
    if ((ftp = hfgens(ftevt)) != NULL)            /* call the fgen  */
      *p->ifno = (float)ftp->fno;                        /* record the fno */
    else initerror("ftgen error");
}

