/* ALSArtaudio.c - hacked version of rtaudio.c to enable realtime full-duplex
 audio support for csound under Linux/ALSA.
This file incorporates the functions from LINUXaudio.c (with the exception of
sndsetvolume() which isn't used in this hacked version) so that file is no
longer needed  - fcf */
/*
 * $Id: ALSArtaudio.c,v 1.5 1998/12/26 16:01:15 nicb Exp $
 */

/*  This module is included when RTAUDIO is defined at compile time.
    It provides an interface between Csound realtime record/play calls
    and the device-driver code that controls the actual hardware.
*/

#include <sys/asoundlib.h>
#include "cs.h"
#include "soundio.h"


#include <unistd.h>
#include <fcntl.h>

static void *record_handle = NULL, *playback_handle = NULL;

static  int     ishift = 0, oshift = 0, oMaxLag;
extern  long    nrecs;
        long    inrecs;
extern  OPARMS  O;

#ifdef PIPES
extern FILE* Linepipe;
#define _pclose pclose
#endif

char errorstring[1024];

static int getformat()
{
	int p = 0;

	switch ( O.informat ) {
		case AE_UNCH:  /* unsigned char - standard Linux 8-bit format */
			p = SND_PCM_SFMT_U8;
			break;
		case AE_CHAR:  /* signed char. supported by ALSA */
			p = SND_PCM_SFMT_S8;
			break;
		case AE_ULAW:
			p = SND_PCM_SFMT_MU_LAW; 
			break;
		case AE_ALAW:
			p = SND_PCM_SFMT_A_LAW;
			break;
		case AE_SHORT:
			p = SND_PCM_SFMT_S16_LE; /* Linux on Intel x86 is little-endian */
			break;
		case AE_LONG:
			die("ALSA sound driver does not (yet) support long integer samples");
		case AE_FLOAT:
			die("ALSA sound driver does not (yet) support floating-point samples");
		default:
			die("unknown sample format");
	}
	return (p);
}

static int getshift(int dsize)  /* turn sample- or frame-size into shiftsize */
{
	switch(dsize) {
		case 1:  return(0);
		case 2:  return(1);
		case 4:  return(2);
		case 8:  return(3);
		default: die("rtaudio: illegal dsize");
			 return(-1);		/* Not reached */
        }
}

void recopen(int nchnls, int dsize, float esr, int scale)
                                /* open for audio input */
{
	extern int incard;
	static snd_pcm_record_params_t rp;
	static snd_pcm_format_t parms;
	static snd_pcm_playback_info_t pbinfo;
	int err;

	oMaxLag = O.oMaxLag;		/* import DAC setting from command line   */
	if (oMaxLag <= 0)		/* if DAC sampframes ndef in command line */
		oMaxLag = IODACSAMPS;	/*    use the default value               */


	/* Open ALSA audio driver, card # incard, device #0 in RECORD mode*/
	if((err = snd_pcm_open(&record_handle, incard, 0, SND_PCM_OPEN_RECORD)) != 0){
		sprintf(errorstring, "Opening audio device: %s\n", snd_strerror(err));
		die(errorstring);
	}

	parms.format = getformat();

	if(nchnls > 2) nchnls = 2;

	parms.channels = nchnls;
	parms.rate = (int) esr;

	if(err = snd_pcm_record_format(record_handle, &parms)){
		sprintf(errorstring,"%s\n", snd_strerror(err));
		die(errorstring);
	}

	rp.fragment_size = O.outbufsamps * O.outsampsiz;
	rp.fragments_min = 1;
	if((err = snd_pcm_record_params(record_handle, &rp)) < 0){
		sprintf(errorstring, "Error setting record fragment size: %s rp.fragment_size = %d\n",
							snd_strerror(err), rp.fragment_size);
		die(errorstring);
	}
	ishift = getshift(dsize);
	fprintf(stderr, "Running in RECORD mode at %d hz on card #%d\n", parms.rate, incard);
}

void playopen(int nchnls, int dsize, float esr, int scale)
                                /* open for audio output */
{
	extern int outcard;
	static snd_pcm_format_t parms;
	static snd_pcm_playback_params_t pp;

	int err, par, frag_size, bufsiz;

	oMaxLag = O.oMaxLag;		/* import DAC setting from command line   */
	if (oMaxLag <= 0)		/* if DAC sampframes ndef in command line */
		oMaxLag = IODACSAMPS;	/*    use the default value               */


        /* Open ALSA audio driver, card # outcard, device #0 in PLAYBACK mode */
        if((err = snd_pcm_open(&playback_handle, outcard, 0, SND_PCM_OPEN_PLAYBACK)) != 0){
       	        sprintf(errorstring, "Opening audio device: %s\n", snd_strerror(err));
               	die(errorstring);
       	}

	parms.format = getformat();

	if(nchnls > 2) nchnls = 2;

        parms.channels = nchnls;
        parms.rate = (int) esr;

        if(err = snd_pcm_playback_format(playback_handle, &parms)){
                sprintf(errorstring,"%s\n", snd_strerror(err));
                die(errorstring);
        }

	/* set DMA buffer fragment size */

	pp.fragment_size = O.outbufsamps * O.outsampsiz;
	pp.fragments_max = -1; /* -1 = maximum */
	pp.fragments_room = 1;
	if((err = snd_pcm_playback_params(playback_handle, &pp)) < 0){
		sprintf(errorstring, "Error setting fragment size: %s pp.fragment_size = %d\n",
							snd_strerror(err), pp.fragment_size);
		die(errorstring);
	}

        oshift = getshift(nchnls * dsize);
	fprintf(stderr, "Running in PLAYBACK mode at %d hz on card #%d\n", parms.rate, outcard);

#ifdef HIPRI
	setscheduler();
#endif
}

int rtrecord(char *inbuf, int nbytes) /* get samples from ADC */
{
        if((nbytes = snd_pcm_read(record_handle, (void *)inbuf, (size_t)nbytes)) < 0){
		sprintf(errorstring, "Recording error: %s", snd_strerror(nbytes));
		die(errorstring);
	}
	return(nbytes);
}

void rtplay(char *outbuf, int nbytes) /* put samples to DAC - see notes in rtaudio.c */
{
/*	long sampframes = nbytes >> oshift; */
	int err;

	if ((err = snd_pcm_write(playback_handle, (void *)outbuf, (size_t)nbytes)) < nbytes)
		printf("/dev/dsp: couldn't write all bytes requested\n");

	nrecs++;
}

void rtclose(void)              /* close the I/O device entirely  */
{                               /* called only when both complete */
	if(record_handle){
		snd_pcm_flush_record(record_handle);
		if (snd_pcm_close(record_handle) < 0)
          		die("unable to close record handle");
	}
	if(playback_handle){
		snd_pcm_flush_playback(playback_handle);
        	if (snd_pcm_close(playback_handle) < 0)
          		die("unable to close playback handle");
	}
	if (O.Linein) {
#ifdef PIPES
	  if (O.Linename[0]=='|') _pclose(Linepipe);
#endif
	}
}

