
typedef struct {
	float *ictlno, *imin, *imax, *initvalue, *ifn;
} SLD;

typedef struct {
    OPDS   h;
    float   *r[8];  	  /* output */
  	float	*ichan;								/* input */
	SLD		s[8];				
	float min[8], max[8];
	char  slchan, slnum[8];
	FUNC  *ftp[8];
} SLIDER8;

typedef struct {
    OPDS   h;
    float   *r[16];  	  /* output */
  	float	*ichan;								/* input */
	SLD		s[16];				
	float min[16], max[16];
	char  slchan, slnum[16];
	FUNC  *ftp[16];
} SLIDER16;

typedef struct {
    OPDS   h;
    float   *r[32];  	  /* output */
  	float	*ichan;								/* input */
	SLD		s[32];				
	float min[32], max[32];
	char  slchan, slnum[32];
	FUNC  *ftp[32];
} SLIDER32;

typedef struct {
    OPDS   h;
    float   *r[64];  	  /* output */
  	float	*ichan;								/* input */
	SLD		s[64];				
	float min[64], max[64];
	char  slchan, slnum[64];
	FUNC  *ftp[64];
} SLIDER64;

/*=============================*/


typedef struct {
	float *ictlno, *imin, *imax, *initvalue, *ifn, *ihp;
} SLDf;

typedef struct {
    OPDS   h;
    float   *r[8];  	  						/* output */
  	float	*ichan;								/* input */
	SLDf	s[8];				
	float min[8], max[8];
	char  slchan, slnum[8];
	FUNC  *ftp[8];
	float	c1[8], c2[8]; 
	float	yt1[8];

} SLIDER8f;

typedef struct {
    OPDS   h;
    float   *r[16];  	  						/* output */
  	float	*ichan;								/* input */
	SLDf	s[16];				
	float min[16], max[16];
	char  slchan, slnum[16];
	FUNC  *ftp[16];
	float	c1[16], c2[16]; 
	float	yt1[16];

} SLIDER16f;

typedef struct {
    OPDS   h;
    float   *r[32];  	  						/* output */
  	float	*ichan;								/* input */
	SLDf	s[32];				
	float min[32], max[32];
	char  slchan, slnum[32];
	FUNC  *ftp[32];
	float	c1[32], c2[32]; 
	float	yt1[32];

} SLIDER32f;

typedef struct {
    OPDS   h;
    float   *r[64];  	  						/* output */
  	float	*ichan;								/* input */
	SLDf	s[64];				
	float min[64], max[64];
	char  slchan, slnum[64];
	FUNC  *ftp[64];
	float	c1[64], c2[64]; 
	float	yt1[64];

} SLIDER64f;

/*---------------------*/

typedef struct {
	float *ictlno, *imin, *imax, *ifn;
} ISLD;

typedef struct {
    OPDS   h;
    float   *r[8];  	/* output */
  	float	*ichan;		/* input */
	ISLD		s[8];				
} ISLIDER8;

typedef struct {
    OPDS   h;
    float   *r[16];  	/* output */
  	float	*ichan;		/* input */
	ISLD		s[16];			
} ISLIDER16;


typedef struct {
    OPDS   h;
    float   *r[32];  	/* output */
  	float	*ichan;		/* input */
	ISLD		s[32];			
} ISLIDER32;


typedef struct {
    OPDS   h;
    float   *r[64];  	/* output */
  	float	*ichan;		/* input */
	ISLD		s[64];			
} ISLIDER64;


/*------------------------------*/


typedef struct {
	float *ictlno_msb, *ictlno_lsb, *imin, *imax, *initvalue, *ifn;
} SLD14;

typedef struct {
    OPDS   h;
    float   *r[16];  	  /* output */
  	float	*ichan;								/* input */
	SLD14		s[16];				
	float min[16], max[16];
	char  slchan, slnum_msb[16],slnum_lsb[16];
	FUNC  *ftp[16];
} SLIDER16BIT14;
 
typedef struct {
    OPDS   h;
    float   *r[32];  	  /* output */
  	float	*ichan;								/* input */
	SLD14		s[32];				
	float min[32], max[32];
	char  slchan, slnum_msb[32],slnum_lsb[32];
	FUNC  *ftp[32];
} SLIDER32BIT14;
/*--------------------*/

typedef struct {
	float *ictlno_msb, *ictlno_lsb, *imin, *imax, *ifn;
} ISLD14;


typedef struct {
    OPDS   h;
    float   *r[16];  	/* output */
  	float	*ichan;		/* input */
	ISLD14		s[16];			
} ISLIDER16BIT14;

typedef struct {
    OPDS   h;
    float   *r[32];  	/* output */
  	float	*ichan;		/* input */
	ISLD14		s[32];			
} ISLIDER32BIT14;
