#include "cs.h"			/*				OLOAD.C	  */
#include "oload.h"
#include "midiops.h"

#define DKEY_DFLT  60

#ifdef RESET
#  include <string.h>
#endif

static  float   *gbloffbas;
float   **pctlist = NULL;
INSTRTXT **instrtxtp, instxtanchor;
short	*argoffspace;
float	*pool = NULL;
/* INSDS   **insalloc; */
short   *insbusy;
int	maxinsno = MAXINSNO;

OPARMS	O = {0,0, 0,1,1,0, 0,0, 0,0, 0,0, 1,0,0,7, 0,0,0, 0,0,0,0, 0,0 };

float	esr = DFLT_SR, ekr = DFLT_KR, ensmps = (float)DFLT_KSMPS;
int	nchnls = DFLT_NCHNLS, ksmps = DFLT_KSMPS;
float	tpidsr, mpidsr, mtpdsr;
float	hfkprd, *spin, *spout;
float	sicvt, kicvt, fmaxlen = (float)MAXLEN;
float	dv32768, dvensmps, loscal, onedsr, onedkr;
int	nspin, nspout, spoutactive, pnum(char*);
int	odebug = 0;
INX	inxbas;
int	strsmax = 0;

extern	void	cpsoctinit(void), reverbinit(void), sssfinit(void);
extern	OENTRY	opcodlst[];
extern  MCHNBLK *m_chnbp[];

/* RWD for reentry */
#ifdef RESET
void oloadreset(void)
{
    int i;
    memset(&instxtanchor,0,sizeof(INSTRTXT));
    argoffspace = NULL;
    pool = NULL;
    gbloffbas = NULL;
    fmaxlen = MAXLEN;
    spin = NULL;
    spout = NULL;
    odebug = 0;
    /* clear instrtxtp array */
    mfree(instrtxtp);		/* Start again */
    maxinsno = MAXINSNO;
}
#endif

void oload(void)
{
    long   n, nn, combinedsize, gblabeg, lclabeg, insno, *lp;
    float  *combinedspc, *gblspace, *fp1, *fp2;
    short  *pgmdim = NULL;
    INSTRTXT *ip;
    OPTXT *optxt;

    odebug = O.odebug;
    ip = instxtanchor.nxtinstxt;		/* for instr 0 optxts:  */
    optxt = (OPTXT *) ip;
    while ((optxt = optxt->nxtop) !=  NULL) {
      TEXT  *ttp = &optxt->t;
      ARGOFFS *inoffp, *outoffp;
      int opnum = ttp->opnum;
      if (opnum == ENDIN) break;
      if (opnum == LABEL) continue;
      outoffp = ttp->outoffs;		/* use unexpanded ndxes */
      inoffp = ttp->inoffs;		/* to find sr.. assigns */
      if (outoffp->count == 1 && inoffp->count == 1) {
	short rindex = (short)outoffp->indx[0] - (short)O.poolcount;
	float conval = pool[inoffp->indx[0] - 1];
	switch(rindex) {
	case 1:  esr = conval;  break;	/* & use those values */
	case 2:  ekr = conval;  break;	/*  to set params now */
	case 3:  ksmps = (int)(ensmps = conval);  break;
	case 4:  nchnls = (int)conval;  break;
	default: break;
	}
      }
    }
    VMSG( printf("esr = %7.1f, ekr = %7.1f, ksmps = %d, nchnls = %d\n",
		 esr ,ekr, ksmps, nchnls); ) ; 
    if (O.sr_override) {	/* if command-line overrides, apply now */
      esr = (float)O.sr_override;
      ekr = (float)O.kr_override;
      ksmps = (int)(ensmps = (float)(O.sr_override / O.kr_override));
      printf("sample rate overrides: esr = %7.1f, ekr = %7.1f, ksmps = %d\n",
	     esr, ekr, ksmps);
    }
    combinedsize = (O.poolcount + O.gblfixed + O.gblacount * ksmps)
      * sizeof(float);
    combinedspc = (float *)mcalloc((long)combinedsize);
    for (fp1 = pool, fp2 = combinedspc, nn = O.poolcount; nn--; )
      *fp2++ = *fp1++;	            /* copy pool into combined space */
    mfree((char *)pool);
    pool = combinedspc;
    gblspace = pool + O.poolcount;
    gblspace[0] = esr;	            /*   & enter	*/
    gblspace[1] = ekr;	            /*   rsvd word	*/
    gblspace[2] = ensmps;	    /*   curr vals  */
    gblspace[3] = (float)nchnls;
    gbloffbas = pool - 1;

    gblabeg = O.poolcount + O.gblfixed + 1;
    ip = &instxtanchor;
    while ((ip = ip->nxtinstxt) != NULL) {      /* EXPAND NDX for A Cells */
      optxt = (OPTXT *) ip; 		/*   (and set localen)    */
      lclabeg = (long)(ip->pmax + ip->lclfixed + 1);
      VMSG( printf("lclabeg %ld\n",lclabeg); ) ; 
#ifdef __alpha__
      /*
       * On Alpha, we need to align on 2*sizeof(float) (i.e. 64 bits).  So
       * we round up to that size.  heh 981101
       */
      ip->localen = ((ip->lclfixed + ip->lclacnt*ksmps + 1) & ~0x1) *
	sizeof(float);
#else
      ip->localen = (ip->lclfixed + ip->lclacnt*ksmps) * sizeof(float);
#endif
      for (insno=0, n=0; insno <= maxinsno; insno++)
	if (instrtxtp[insno] == ip)  n++;              /* count insnos  */
      lp = ip->inslist = (long *) mmalloc((long)(n+1) * sizeof(long));
      for (insno=0; insno <= maxinsno; insno++)
	if (instrtxtp[insno] == ip)  *lp++ = insno;    /* creat inslist */
      *lp = -1;                                        /*   & terminate */
      insno = *ip->inslist;                            /* get the first */
      while ((optxt = optxt->nxtop) !=  NULL) {
	TEXT *ttp = &optxt->t;
	ARGOFFS *aoffp;
	long  indx, posndx;
	short *ndxp;
	int opnum = ttp->opnum;
	if (opnum == ENDIN) break;
	if (opnum == LABEL) continue;
	aoffp = ttp->outoffs;
	for (n=aoffp->count, ndxp=aoffp->indx; n--; ndxp++) {
	  if ((indx = *ndxp) > gblabeg)
	    indx = gblabeg + (indx - gblabeg) * ksmps;
	  else if (indx <= 0 && (posndx = -indx) > lclabeg
		   && indx >= LABELIM)
	    indx = -(lclabeg + (posndx - lclabeg) * ksmps);
	  else if (indx > 0 && indx <= 3 && O.sr_override
		   && ip == instxtanchor.nxtinstxt)  /* for instr 0 */
	    indx += 3;    /* deflect any old sr,kr,ksmps targets */
	  else continue;
	  if ((short)indx != indx) {
	    printf("indx=%ld (%lx); (short)indx = %d (%x)\n",
		   indx, indx, (short)indx, (short)indx);
	    die("indexing overflow error");
	  }
	  *ndxp = (short)indx;
	}
	aoffp = ttp->inoffs;            /* inargs:                  */
	if (opnum >= SETEND) goto realops;
	switch(opnum) {                 /*      do oload SETs NOW  */
	case STRSET:
	  if (strsets == NULL)
	    strsets = (char **)
	      mcalloc((long)((strsmax=STRSMAX)+1) * sizeof(char *));
	  indx = (long)gbloffbas[*aoffp->indx];
	  if (indx > strsmax) {
	    long newmax = strsmax + STRSMAX;
	    int i;
	    while (indx > newmax) newmax += STRSMAX;
	    strsets = (char**)mrealloc(strsets, (newmax+1)*sizeof(char *));
	    for (i=strsmax; i<newmax+1; i++) strsets[i] = NULL;
	    strsmax = newmax;
	  }
	  if (strsets == NULL || indx < 0) { /* No space left or -ve index */
	    warning("illegal strset index");
	    exit(1);
	  }
	  if (strsets[indx] != NULL)
	    warning("strset index conflict");
	  else {
	    strsets[indx] = ttp->strarg;     
	  }
          printf("Strsets[%d]:%s\n", indx, strsets[indx]);
	  break;    
	case PSET:
	  if ((n = aoffp->count) != ip->pmax) {
	    sprintf(errmsg,"i%ld pset args != pmax", insno);
	    warning(errmsg);
	    if (n < ip->pmax) n = ip->pmax; /* cf pset, pmax    */
	  }                                   /* alloc the larger */
	  ip->psetdata = (float *) mcalloc((long)n * sizeof(float));
	  for (n=aoffp->count,fp1=ip->psetdata,ndxp=aoffp->indx;
	       n--; )
	    *fp1++ = gbloffbas[*ndxp++];
	  break;
	}

	continue;       /* no runtime role for the above SET types */

      realops:
	for (n=aoffp->count, ndxp=aoffp->indx; n--; ndxp++) {
	  if ((indx = *ndxp) > gblabeg)
	    indx = gblabeg + (indx - gblabeg) * ksmps;
	  else if (indx <= 0 && (posndx = -indx) > lclabeg
		   && indx >= LABELIM)
	    indx = -(lclabeg + (posndx - lclabeg) * ksmps);
	  else continue;
	  if ((short)indx != indx) {
	    printf("Case2: indx=%ld (%lx); (short)indx = %d (%x)\n",
		   indx, indx, (short)indx, (short)indx);
	    die("indexing overflow error");
	  }
	  *ndxp = (short)indx;
	}
      }
      if (!POLL_EVENTS()) exit(1);		/* on Mac/Win, allow system events */
    }
    if (pgmdim != NULL) free((char *)pgmdim);
	pctlist = (float **) mcalloc((long)256 * sizeof(float *));
    insbusy = (short *) mcalloc((long)((maxinsno+1) * sizeof(short)));

    if ((nn = init0()) > 0)				/* run instr 0 inits */
      die("header init errors");
    if (gblspace[0]/gblspace[1] != gblspace[2]) {	/* & chk consistency */
      printf("sr = %f, kr = %f, ksmps = %f\n",
	     gblspace[0], gblspace[1], gblspace[2]);
      die("inconsistent sr, kr, ksmps");		/*   one more time   */
    }
    tpidsr = TWOPI_F / esr;				/* now set internal  */
    mtpdsr = -tpidsr;				        /*    consts	     */
    mpidsr = -PI_F / esr;
    sicvt = fmaxlen / esr;
    kicvt = fmaxlen / ekr;
    hfkprd = 0.5f / ekr;
    onedsr = 1.0f / esr;
    onedkr = 1.0f / ekr;
    dv32768 = 1.0f / 32768.0f;
    loscal = 1.0f / LOFACT;
    dvensmps = 1.0f / ensmps;
    cpsoctinit();
    reverbinit();
    sssfinit();
    nspin = nspout = ksmps * nchnls;		        /* alloc spin & spout */
    spin =  (float *) mcalloc((long)nspout*sizeof(float));
    spout = (float *) mcalloc((long)nspout*sizeof(float));
}

extern short nlabels;
extern short ngotos;

/* static int curpgm; */

 INSDS *
instance(int insno)		/* create instance of an instr template	*/
				/*   allocates and sets up all pntrs	*/
{
	INSTRTXT *tp;
	INSDS	*ip, *prvip;
	OPTXT	*optxt;
	OPDS	*opds, *prvids, *prvpds;
	OENTRY	*ep;
	LBLBLK  **lopds, **lopdsp;
        LARGNO  *larg, *largp;
	int	n, pextent, opnum, reqd;
	char	*nxtopds, *opdslim;
	float   **argpp, *fltp, *lclbas, *lcloffbas, *csetoffbas;
	ARGOFFS *aoffp;
	short	indx, posndx,*ndxp;
	MCHNBLK *chp;

	lopds = (LBLBLK**)mmalloc(sizeof(LBLBLK*)*nlabels);
	lopdsp = lopds;
	larg = (LARGNO*)mmalloc(sizeof(LARGNO)*ngotos);
	largp = larg;
	tp = instrtxtp[insno];
	if (tp->mdepends & 06) {                /* if need midi chan, chk ok */
	    MCHNBLK **chpp = m_chnbp;
	    for (n = MAXCHAN; n--; )
	    {
		if ((chp = *chpp++) !=((MCHNBLK*)NULL))
		{ 
		    	csetoffbas = chp->ctl_val;
			if (!chp->insno) 
			{
				chp->insno = insno;
	    			printf("instr %d seeking midi chnl data, assigned chnl %d\n",
                   		insno, chp->insno);
				break;
			}
			if (chp->insno != insno)
		    		continue;
		}
	    }
	}
pext:   pextent = sizeof(INSDS) + tp->pextrab;          /* alloc new space,  */
	ip = (INSDS *) mcalloc((long)pextent + tp->localen + tp->opdstot);
	if (tp->mdepends & 06)
	    ip->m_chnbp = chp;
	if ((prvip = tp->instance) == NULL)
	    tp->instance = ip;				/*    and add to     */
	else {
	    while (prvip->nxtinstance != NULL)		/*    txt instance   */
		prvip = prvip->nxtinstance;		/*    chain	     */
	    prvip->nxtinstance = ip;
	    ip->prvinstance = prvip;
	}
	lcloffbas = &ip->p0;
	lclbas = (float *)((char *)ip + pextent);	/* split local space */
	nxtopds = (char *)lclbas + tp->localen;
	opdslim = nxtopds + tp->opdstot;
	VMSG( printf("instr %d allocated at %p\n\tlclbas %p, opds %p\n",
				insno,ip,lclbas,nxtopds); )
	optxt = (OPTXT *)tp;
	prvids = prvpds = (OPDS *)ip;
	while ((optxt = optxt->nxtop) != NULL) {     /* for each op in instr */
	    TEXT *ttp = &optxt->t;
	    if ((opnum = ttp->opnum) == ENDIN)		/*  (until ENDIN)  */
		break;
	    if (opnum == STRSET) {
	      nxtopds +=  2 * sizeof(float*);
	      continue; /* Only at load time */
	    }
	    if (opnum == PSET) {
	      ip->p1 = (float)insno; continue;
	    }
	    ep = &opcodlst[opnum];			/* for all ops:     */
	    opds = (OPDS *) nxtopds;			/*   take reqd opds */
	    nxtopds += ep->dsblksiz;
	    VMSG( printf("op %d (%s) allocated at %p\n",
			opnum,ep->opname,opds); )
	    opds->optext = optxt;			/* set common headata */
	    opds->insdshead = ip;
	    if (opnum == LABEL) {			/* LABEL:	*/
		LBLBLK	*lblbp = (LBLBLK *) opds;
		lblbp->prvi = prvids;			/*    save i/p links */
		lblbp->prvp = prvpds;
		*lopdsp++ = lblbp;			/*    log the lbl bp */
		continue;				/*    for later refs */
	    }
	    if ((ep->thread & 07)==0) {                   /* thread 1 OR 2:  */
		if (ttp->pftype == 'b') {
		    prvids = prvids->nxti = opds;
		    opds->iopadr = ep->iopadr;
		}
		else {
		    prvpds = prvpds->nxtp = opds;
		    opds->opadr = ep->kopadr;
		}
		goto args;
	    }
	    if ((ep->thread & 01)!=0) {			/* thread 1:	    */
		prvids = prvids->nxti = opds;		/* link into ichain */
		opds->iopadr = ep->iopadr;		/*   & set exec adr */
		if (opds->iopadr == NULL)
		    die("null iopadr");
	    }
	    if ((n = ep->thread & 06)!=0) {			/* thread 2 OR 4:   */
		prvpds = prvpds->nxtp = opds;		/* link into pchain */
		if (!(n & 04)
		  || ttp->pftype == 'k' && ep->kopadr != NULL)
		    opds->opadr = ep->kopadr;		/*	krate or    */
		else opds->opadr = ep->aopadr;		/*	arate	    */
		VMSG( printf("opadr = %p\n",opds->opadr); )
		if (opds->opadr == NULL)
		    die("null opadr");
	    }
      args: argpp = (float **)((char *)opds + sizeof(OPDS));
	    VMSG( printf("argptrs:"); )
	    aoffp = ttp->outoffs;		/* for outarg codes: */
	    reqd = strlen(ep->outypes);
	    for (n=aoffp->count, ndxp=aoffp->indx; n--; reqd--) {
		if ((indx = *ndxp++) > 0)           /* cvt index to lcl/gbl adr */
		    fltp = gbloffbas + indx;    
		else if ((posndx = -indx) < CBAS)
		    fltp = lcloffbas + posndx;
		else 
		    fltp = csetoffbas + posndx - CBAS;      
		VMSG( printf("\t%p", fltp); )
		*argpp++ = fltp;
	    }
	    while (reqd--) {     		/* if more outypes, pad */
		VMSG( printf("\tPADOUT"); )
		*argpp++ = NULL;
	    }
	    aoffp = ttp->inoffs;		/* for inarg codes: */
	    for (n=aoffp->count, ndxp=aoffp->indx; n--; ) {
	        if ((indx = *ndxp++) < LABELIM) {
		    VMSG( printf("\t***lbl"); )
		    largp->lblno = indx - MINSHORT;  /* if label ref, defer */
		    largp->argpp = argpp++;
		    largp++;
		} else {
		    if (indx > 0)                   /* else cvt ndx to lcl/gbl */
			fltp = gbloffbas + indx; 
		    else if ((posndx = -indx) < CBAS)
			fltp = lcloffbas + posndx;
		    else 
			fltp = csetoffbas + posndx - CBAS;      
		    VMSG( printf("\t%p", fltp); )
		    *argpp++ = fltp;
		}
	    }
	    VMSG( {putchar('\n');  if (dribble) putc('\n', dribble);} )
	}
	if (nxtopds != opdslim) {
	  printf("nxtopds = %p opdslim = %p\n", nxtopds, opdslim);
	  /* if (nxtopds > opdslim) */ die("inconsistent opds total");
	}
	while (--largp >= larg)
	    *largp->argpp = (float *) lopds[largp->lblno]; /* now label refs */
	return(ip);
}

int pnum(char *s)		/* check a char string for pnum format	*/
				/*   and return the pnum ( >= 0 )	*/
{				/* else return -1			*/
    int	n;

    if (*s == 'p' || *s == 'P')
      if (sscanf(++s, "%d", &n))
	return(n);
    return(-1);
}

