#include "cs.h"         /*                                      PIYCH.C       */
#include <math.h>
#include "window.h"
#include "spectra.h"
#include "pitch.h"

extern  long    kcounter;
extern void DOWNset(DOWNDAT *, long);
extern void SPECset(SPECDAT *, long);

#define STARTING 1
#define PLAYING  2
#define LOGTWO (0.693147)
#define LOG10D20 (0.11512925)

static float bicoefs[] =
    { -0.2674054f, 0.7491305f, 0.7160484f, 0.0496285f, 0.7160484f,
      0.0505247f, 0.3514850f, 0.5257536f, 0.3505025f, 0.5257536f,
      0.3661840f, 0.0837990f, 0.3867783f, 0.6764264f, 0.3867783f };

void pitchset(PITCH *p)    /* pitch - uses specta technology */
{
    float	b;              /* For RMS */
    int     n, nocts, nfreqs, ncoefs;
    float   Q, *fltp;
    OCTDAT  *octp;
    DOWNDAT *dwnp = &p->downsig;
    SPECDAT *specp = &p->wsig;
    long    npts, nptls, nn, lobin;
    int     *dstp, ptlmax;
    float   fnfreqs, rolloff, *oct0p, *flop, *fhip, *fundp, *fendp, *fp;
    float   weight, weightsum, dbthresh, ampthresh;


                                /* RMS of input signal */
    b = 2.0f - (float)cos((double)(10.0f * tpidsr));
    p->c2 = b - (float)sqrt((double)(b * b - 1.0));
    p->c1 = 1.0f - p->c2;
    if (!*p->istor) p->prvq = 0.0f;
                                /* End of rms */
                                /* Initialise spectrum */
      p->timcount = (int)(ekr * *p->iprd + .001f); /* for mac roundoff */
      nocts = (int)*p->iocts; if (nocts<=0) nocts = 6;
      nfreqs = (int)*p->ifrqs; if (nfreqs<=0) nfreqs = 12;
      ncoefs = nocts * nfreqs;
      Q = *p->iq; if (Q<=0.0f) Q = 15.0f;

      if (p->timcount <= 0)     initerror("illegal iprd");
      if (nocts > MAXOCTS)      initerror("illegal iocts");
      if (nfreqs > MAXFRQS)     initerror("illegal ifrqs");
      if (inerrcnt)             return;

      if (nocts != dwnp->nocts || nfreqs != p->nfreqs  /* if anything has changed */
	  || Q != p->curq ) {                /*     make new tables */
        double      basfrq, curfrq, frqmlt, Qfactor;
        double      theta, a, windamp, onedws, pidws;
        float       *sinp, *cosp;
        int         k, sumk, windsiz, halfsiz, *wsizp, *woffp;
        long        auxsiz, bufsiz;
        long        majr, minr, totsamps;
        double      hicps,locps,oct;  /*   must alloc anew */
        extern double onept;

        p->nfreqs = nfreqs;
        p->curq = Q;
        p->ncoefs = ncoefs;
        dwnp->srate = esr;
        hicps = dwnp->srate * 0.375;            /* top freq is 3/4 pi/2 ...   */
        oct = log(hicps / onept) / LOGTWO;      /* octcps()  (see aops.c)     */
        dwnp->looct = (float)(oct - nocts);     /* true oct val of lowest frq */
        locps = hicps / (1L << nocts);
        basfrq = hicps/2.0;                          /* oct below retuned top */
        frqmlt = pow((double)2.0,(double)1./nfreqs);   /* nfreq interval mult */
        Qfactor = Q * dwnp->srate;
        curfrq = basfrq;
        for (sumk=0,wsizp=p->winlen,woffp=p->offset,n=nfreqs; n--; ) {
	  *wsizp++ = k = (int)(Qfactor/curfrq) | 01;  /* calc odd wind sizes */
	  *woffp++ = (*(p->winlen) - k) / 2;          /* & symmetric offsets */
	  sumk += k;                                  /*    and find total   */
  	  curfrq *= frqmlt;
        }
        windsiz = *(p->winlen);
        auxsiz = (windsiz + 2*sumk) * sizeof(float);   /* calc lcl space rqd */
	    
        auxalloc((long)auxsiz, &p->auxch1);            /*  & alloc auxspace  */

        fltp = (float *) p->auxch1.auxp;
        p->linbufp = fltp;      fltp += windsiz; /* linbuf must take nsamps */
        p->sinp = sinp = fltp;  fltp += sumk;
        p->cosp = cosp = fltp;                         /* cos gets rem sumk  */
        wsizp = p->winlen;
        curfrq = basfrq * TWOPI / dwnp->srate;
        for (n = nfreqs; n--; ) {                      /* now fill tables */
	  windsiz = *wsizp++;                          /*  (odd win size) */
	  halfsiz = windsiz >> 1;
	  onedws = 1.0 / (windsiz-1);
	  pidws = PI / (windsiz-1);
	  for (k = -halfsiz; k<=halfsiz; k++) {        /*   with sines    */
	    a = cos(k * pidws);
            windamp = 0.08 + 0.92 * a * a;             /*   times hamming */
	    windamp *= onedws;                         /*   scaled        */
	    theta = k * curfrq;
	    *sinp++ = (float)(windamp * sin(theta));
	    *cosp++ = (float)(windamp * cos(theta));
	  }
	  curfrq *= frqmlt;                        /*   step by log freq  */
        }
        dwnp->hifrq = (float)hicps;
        dwnp->lofrq = (float)locps;
        dwnp->nsamps = windsiz = *(p->winlen);
        dwnp->nocts = nocts;
        minr = windsiz >> 1;                  /* sep odd windsiz into maj, min */
        majr = windsiz - minr;                /*      & calc totsamps reqd     */
        totsamps = (majr*nocts) + (minr<<nocts) - minr;
        DOWNset(dwnp, totsamps);              /* auxalloc in DOWNDAT struct */
        fltp = (float *) dwnp->auxch.auxp;    /*  & distrib to octdata */
        for (n=nocts,octp=dwnp->octdata+(nocts-1); n--; octp--) {
	  bufsiz = majr + minr;
          octp->begp = fltp;  fltp += bufsiz; /*        (lo oct first) */
	  octp->endp = fltp;  minr *= 2;
        }
        SPECset(specp, (long)ncoefs);         /* prep the spec dspace */
        specp->downsrcp = dwnp;               /*  & record its source */
      }
      for (octp=dwnp->octdata; nocts--; octp++) { /* reset all oct params, &    */
        octp->curp = octp->begp;
        for (fltp=octp->feedback,n=6; n--; )
	  *fltp++ = 0.0f;
        octp->scount = 0;
      }
      specp->nfreqs = p->nfreqs;               /* save the spec descriptors */
      specp->dbout = 0;
      specp->ktimstamp = 0;                    /* init specdata to not new  */
      specp->ktimprd = p->timcount;
      p->scountdown = p->timcount;             /* prime the spect countdown */
                                /* Start specptrk */
    if ((npts = specp->npts) != p->winpts) {        /* if size has changed */
      SPECset(&p->wfund, (long)npts);               /*   realloc for wfund */
      p->wfund.downsrcp = specp->downsrcp;
      p->fundp = (float *) p->wfund.auxch.auxp;
      p->winpts = npts;
    }
    if (*p->inptls<=0.0f) nptls = 4;
    else nptls = (long)*p->inptls;
    if (nptls > MAXPTL) {
      initerror("illegal no of partials");
      return;
    }
    if (*p->irolloff<=0.0f) *p->irolloff = 0.6f;
    p->nptls = nptls;        /* number, whether all or odd */
      ptlmax = nptls;
    dstp = p->pdist;
    fnfreqs = (float)specp->nfreqs;
    for (nn = 1; nn <= ptlmax; nn++)
      *dstp++ = (int) ((log((double) nn) / LOGTWO) * fnfreqs + .5);
    if ((rolloff = *p->irolloff) == 0. || rolloff == 1. || nptls == 1) {
      p->rolloff = 0;
      weightsum = (float)nptls;
    } else {
      float *fltp = p->pmult;
      float octdrop = (1.0f - rolloff) / fnfreqs;
      weightsum = 0.0f;
      for (dstp = p->pdist, nn = nptls; nn--; ) {
	weight = 1.0f - octdrop * *dstp++;       /* rolloff * octdistance */
	weightsum += weight;
	*fltp++ = weight;
      }
      if (*--fltp < 0.0f)
	initerror("per oct rolloff too steep");
      p->rolloff = 1;
    }
    lobin = (long)(specp->downsrcp->looct * fnfreqs);
    oct0p = p->fundp - lobin;                   /* virtual loc of oct 0 */
    
    flop = oct0p + (int)(*p->ilo * fnfreqs);
    fhip = oct0p + (int)(*p->ihi * fnfreqs);
    fundp = p->fundp;
    fendp = fundp + specp->npts;
    if (flop < fundp) flop = fundp;
    if (fhip > fendp) fhip = fendp;
    if (flop >= fhip) {         /* chk hi-lo range valid */
      initerror("illegal lo-hi values");
      return;
    }
    for (fp = fundp; fp < flop; )
      *fp++ = 0.0f;   /* clear unused lo and hi range */
    for (fp = fhip; fp < fendp; )
      *fp++ = 0.0f;
    
    dbthresh = *p->idbthresh;                     /* thresholds: */
    ampthresh = (float)exp((double)dbthresh * LOG10D20);
    p->threshon = ampthresh;              /* mag */
    p->threshoff = ampthresh * 0.5f;
    p->threshon *= weightsum;
    p->threshoff *= weightsum;
    p->oct0p = oct0p;                 /* virtual loc of oct 0 */
    p->confact = *p->iconf;
    p->flop = flop;
    p->fhip = fhip;
    p->playing = 0;
    p->kvalsav = (*p->istrt>=0.0f ? *p->istrt : (*p->ilo+*p->ihi)*0.5f);
    p->kval = p->kinc = 0.0f;
    p->kavl = p->kanc = 0.0f;
    p->jmpcount =  0;
}

void pitch(PITCH *p)
{
    float	*asig;
    float	q;
    float	c1 = p->c1, c2 = p->c2;

    float   a, b, *dftp, *sigp = p->asig, SIG, yt1, yt2;
    int     nocts, nsmps = ksmps, winlen;
    DOWNDAT *downp = &p->downsig;
    OCTDAT  *octp;
    SPECDAT *specp;
    double  c;
    float kvar;
                                /* RMS */
    q = p->prvq;
    asig = p->asig;
    do {
      float as = *asig++;
      q = c1 * as * as + c2 * q;
      SIG = *sigp++;                        /* for each source sample:     */
      octp = downp->octdata;                /*   align onto top octave     */
      nocts = downp->nocts;
      do {                                  /*   then for each oct:        */
	float *coefp,*ytp,*curp;
	int   nfilt;
	curp = octp->curp;
	*curp++ = SIG;                      /*  write samp to cur buf  */
	if (curp >= octp->endp)
	  curp = octp->begp;                /*    & modulo the pointer */
	octp->curp = curp;
	if (!(--nocts))  break;             /*  if lastoct, break      */
	coefp = bicoefs;  ytp = octp->feedback;
	for (nfilt = 3; nfilt--; ) {        /*  apply triple biquad:   */
	  yt2 = *ytp++; yt1 = *ytp--;             /* get prev feedback */
	  SIG -= (*coefp++ * yt1);                /* apply recurs filt */
	  SIG -= (*coefp++ * yt2);
	  *ytp++ = yt1; *ytp++ = SIG;             /* stor nxt feedback */
	  SIG *= *coefp++;
	  SIG += (*coefp++ * yt1);                /* apply forwrd filt */
	  SIG += (*coefp++ * yt2);
	}
      } while (!(++octp->scount & 01) && octp++); /* send alt samps to nxtoct */
    } while (--nsmps);
    p->prvq = q;
    kvar = (float) sqrt((double)q); /* End of spectrun part */

    if ((--p->scountdown)) goto nxt;  /* if not yet time for new spec */
    p->scountdown = p->timcount;     /* else reset counter & proceed:        */
    downp = &p->downsig;
    specp = &p->wsig;
    nocts = downp->nocts;
    octp = downp->octdata + nocts;
    dftp = (float *) specp->auxch.auxp;
    winlen = *(p->winlen);
    while (nocts--) {
      float  *bufp, *sinp, *cosp;
      int    len, *lenp, *offp, nfreqs;
      float    *begp, *curp, *endp, *linbufp;
      int      len2;
      octp--;                              /* for each oct (low to high)   */
      begp = octp->begp;
      curp = octp->curp;
      endp = octp->endp;
      if ((len = endp - curp) >= winlen)     /*   if no wrap               */
	linbufp = curp;                    /*     use samples in circbuf */
      else {
	len2 = winlen - len;
	linbufp = bufp = p->linbufp;       /*   else cp crcbuf to linbuf */
	while (len--)               
	  *bufp++ = *curp++;
	curp = begp;
	while (len2--)
	  *bufp++ = *curp++;
      }
      cosp = p->cosp;                        /*   get start windowed sines */
      sinp = p->sinp;
      lenp = p->winlen;
      offp = p->offset;
      for (nfreqs=p->nfreqs; nfreqs--; ) {   /*   now for ea. frq this oct */
	a = 0.0f;
	b = 0.0f;
	bufp = linbufp + *offp++;
	for (len = *lenp++; len--; bufp++) {  /* apply windowed sine seg */
	  a += *bufp * *cosp++;
	  b += *bufp * *sinp++;
	}
	c = a*a + b*b;                        /* get magnitude    */
        c = sqrt(c);
	*dftp++ = (float)c;                       /* store in out spectrum   */
      }
    }
    specp->ktimstamp = kcounter;                  /* time-stamp the output   */

 nxt:
                                /* specptrk */
    {
      float *inp = (float *) specp->auxch.auxp;
      float *endp = inp + specp->npts;
      float *inp2, sum, *fp;
      int   nn, *pdist, confirms;
      float kval, fmax, *fmaxp, absdiff, realbin;
      float *flop, *fhip, *ilop, *ihip, a, b, c, denom, delta;
      long  lobin, hibin;
      
      if (inp==NULL) {             /* RWD fix */
 	initerror("pitch: not initialised"); 
	return; 
      }
      kval = p->playing == PLAYING ? p->kval : p->kvalsav;
      lobin = (long)((kval - kvar) * specp->nfreqs);  /* set lims of frq interest */
      hibin = (long)((kval + kvar) * specp->nfreqs);
      if ((flop = p->oct0p + lobin) < p->flop)  /*       as fundp bin pntrs */
	flop = p->flop;
      if ((fhip = p->oct0p + hibin) > p->fhip)  /*       within hard limits */
	fhip = p->fhip;
      ilop = inp + (flop - p->fundp);           /* similar for input bins   */
      ihip = inp + (fhip - p->fundp);
      inp = ilop;
      fp = flop;
      if (p->rolloff) {
	float *pmult;
	do {
	  sum = *inp;
	  pdist = p->pdist + 1;
	  pmult = p->pmult + 1;
	  for (nn = p->nptls; --nn; ) {
	    if ((inp2 = inp + *pdist++) >= endp)
	      break;
	    sum += *inp2 * *pmult++;
	  }
	  *fp++ = sum;
	} while (++inp < ihip);
      }
      else {
	do {
	  sum = *inp;
	  pdist = p->pdist + 1;
	  for (nn = p->nptls; --nn; ) {
	    if ((inp2 = inp + *pdist++) >= endp)
	      break;
	    sum += *inp2;
	  }
	  *fp++ = sum;
	} while (++inp < ihip);
      }
      fp = flop;                               /* now srch fbins for peak */
      for (fmaxp = fp, fmax = *fp; ++fp<fhip; )
	if (*fp > fmax) {
	  fmax = *fp;
	  fmaxp = fp;
	}
      if (!p->playing) {
	if (fmax > p->threshon)         /* not playing & threshon? */
	  p->playing = STARTING;      /*   prepare to turn on    */
	else goto output;
      }
      else {
	if (fmax < p->threshoff) {      /* playing & threshoff ? */
	  if (p->playing == PLAYING)
	    p->kvalsav = p->kval;   /*   save val & turn off */
	  p->kval = 0.0f;
	  p->kavl = 0.0f;
	  p->kinc = 0.0f;
	  p->kanc = 0.0f;
	  p->playing = 0;
	  goto output;
	}
      }
      a = fmaxp>flop ? *(fmaxp-1) : 0.0f;     /* calc a refined bin no */
      b = fmax;
      c = fmaxp<fhip-1 ? *(fmaxp+1) : 0.0f;
      if (b < 2.0f * (a + c))
	denom = b + b - a - c;
      else denom = a + b + c;
      if (denom != 0.0f)
	delta = 0.5f * (c - a) / denom;
      else delta = 0.0f;
      realbin = (fmaxp - p->oct0p) + delta;    /* get modified bin number  */
      kval = realbin / specp->nfreqs;        /*     & cvt to true decoct */
      
      if (p->playing == STARTING) {            /* STARTING mode:           */
	if ((absdiff = kval - p->kvalsav) < 0.0f)
	  absdiff = -absdiff;
	confirms = (int)(absdiff * p->confact); /* get interval dependency  */
	if (p->jmpcount < confirms) {
	  p->jmpcount += 1;                /* if not enough confirms,  */
	  goto output;                     /*    must wait some more   */
	} else {
	  p->playing = PLAYING;            /* else switch on playing   */
	  p->jmpcount = 0;
	  p->kval = kval;                  /*    but suppress interp   */
	  p->kinc = 0.0f;
	}
      } else {                                 /* PLAYING mode:            */
	if ((absdiff = kval - p->kval) < 0.0f)
	  absdiff = -absdiff;
	confirms = (int)(absdiff * p->confact); /* get interval dependency  */
	if (p->jmpcount < confirms) {
	  p->jmpcount += 1;                /* if not enough confirms,  */
	  p->kinc = 0.0f;                 /*    must wait some more   */
	} else {
	  p->jmpcount = 0;                 /* else OK to jump interval */
          p->kval = kval;
	}
      }
      fmax += delta * (c - a) / 4.0f;           /* get modified amp */
      p->kavl = fmax;
    }
output:
    *p->koct = p->kval;                   /* output true decoct & amp */
    *p->kamp = p->kavl;
}




