        		/*					SPECTRA.H	*/

#define MAXFRQS 120

typedef struct {
	OPDS	h;
	SPECDAT *wsig;
	float	*signal,*iprd,*iocts,*ifrqs,*iq,*ihann;
        float   *idbout,*idisprd,*idsines;
	int	nfreqs, hanning, ncoefs, dbout, nsmps, scountdown, timcount;
	float	curq, *sinp, *cosp, *linbufp;
	int     disprd, dcountdown, winlen[MAXFRQS], offset[MAXFRQS];
	DOWNDAT downsig;
	WINDAT  sinwindow, octwindow;
	AUXCH	auxch1, auxch2;
} SPECTRUM;

#ifdef never
typedef struct {
	OPDS	h;
	SPECDAT *wsig;
	DOWNDAT *dsig;
	float	*iprd, *ifrqs, *iq, *ihann, *idbout, *idsines;
	int	nfreqs, hanning, ncoefs, dbout;
	float	curq, *sinp, *cosp, *linbufp;
	int     countdown, timcount, winlen[MAXFRQS];
	WINDAT  dwindow;
	AUXCH	auxch;
} NOCTDFT;
#endif

typedef struct {
	OPDS	h;
	SPECDAT *wsig;
	float	*iprd, *iwtflg;
	int     countdown, timcount;
	WINDAT  dwindow;
} SPECDISP;

#define MAXPTL 10

typedef struct {
	OPDS	h;
	float	*koct, *kamp;
	SPECDAT *wsig;
	float	*kvar, *ilo, *ihi, *istrt, *idbthresh, *inptls, *irolloff;
	float	*iodd, *iconf, *interp, *ifprd, *iwtflg;
	int	pdist[MAXPTL], nptls, rolloff, kinterp, ftimcnt;
	float	pmult[MAXPTL], confact, kvalsav, kval, kavl, kinc, kanc;
	float   *flop, *fhip, *fundp, *oct0p, threshon, threshoff;
	int	winpts, jmpcount, playing;
	SPECDAT	wfund;
	SPECDISP fdisplay;
} SPECPTRK;

typedef struct {
	OPDS	h;
	float	*ksum;
	SPECDAT *wsig;
	float   *interp;
	int     kinterp;
	float	kval, kinc;
} SPECSUM;

typedef struct {
	OPDS	h;
	SPECDAT	*waddm;
	SPECDAT *wsig1, *wsig2;
	float   *imul2;
	float	mul2;
} SPECADDM;

typedef struct {
	OPDS	h;
	SPECDAT *wdiff;
	SPECDAT *wsig;
	SPECDAT specsave;
} SPECDIFF;

typedef struct {
	OPDS	h;
	SPECDAT *wscaled;
	SPECDAT *wsig;
	float	*ifscale, *ifthresh;
	int	thresh;
	float	*fscale, *fthresh;
	AUXCH	auxch;
} SPECSCAL;

typedef struct {
	OPDS	h;
	SPECDAT *wacout;
	SPECDAT *wsig;
	SPECDAT accumer;
} SPECHIST;

typedef struct {
	OPDS	h;
	SPECDAT *wfil;
	SPECDAT *wsig;
	float	*ifhtim;
	float   *coefs, *states;
	AUXCH	auxch;
} SPECFILT;
