/*
 * @(#)$Id: exec_shell.c,v 1.3 1994/04/17 12:00:41 shin Exp $
 *
 * - working shell handling routines
 *
 * Exec a shell process, dup'ing the specified "fd" as its
 * stdin, stdout and stderr.
 */

static char *rcsid =
	"@(#)$Id: exec_shell.c,v 1.3 1994/04/17 12:00:41 shin Exp $";

#include	<stdio.h>
#include	"systype.h"

extern int	LogShell;

exec_shell(fd, logf, argc, argv, envp)
int	fd;
FILE	*logf;
int	argc;
char	**argv;
char	**envp;
{
	char	*shell;
	char	*getenv(), *rindex();

	/*
	 * do not use stdin, stdout, stderr which are shared with parent.
	 * clear fd's for dup().
	 */

	if ( LogShell )
		fprintf(logf,"closing 0, 1, 2\n");

	close(0); close(1); close(2);

	if ( dup(fd) !=0 || dup(fd) !=1 || dup(fd) !=2 )
		err_sys("dup error");
	close(fd);

	/*
	 * set up the pathname of the shell to be executed and its
	 * argv[0].
	 */

	if ( (shell = getenv("SHELL")) == NULL)
		shell = "/bin/sh";		/* default */

	if ( (argv[0] = rindex(shell, '/')) != NULL)
		argv[0]++;			/* step past rightmost slash */
	else
		argv[0] = shell;		/* no slashes in pathname */

	/* setup an interactive shell */
	/* - XX
	for ( i=1; i< argc; i++ ) {
		if ( !strcmp(argv[i],"-i") ) break;
	}
	if ( i==argc ) {
		argv[argc] = "-i";
		argv[argc++] = "";
	}
	*/
	strcpy(argv[1],"-i");

	if ( LogShell ) {
		fprintf(logf,"shell: %s argv0: %s\n", shell, argv[0]);
		fflush(logf);
	}

#ifdef	CHG_MORE
	putenv("MORE=-c -f");
#endif
	execve(shell, argv, envp);
	err_sys("execve error");
} /* main */

/*
 * History:
 *
 * $Log: exec_shell.c,v $
 * Revision 1.3  1994/04/17  12:00:41  shin
 * 1. set interactive shell (-i) by default
 * 2. add 'argc' as another parameter to exec_shell()
 *
 * Revision 1.2  1994/03/19  17:27:25  shin
 * 1. log file controlling #define now changed to LOGF_SH
 * 2. add fflush(logf)
 *
 * Revision 1.1  1994/03/16  17:29:00  shin
 * Initial revision
 */
