#!/bin/sh
# install X11 fonts

# definitions

if [ "$ECHONONL" = "" ]; then
    ECHONONL="echo -n"
fi

# functions

zZcat ()
{
    case $i in
    *.Z )	zcat $i ;;
    *.gz )	gzip -dc $i ;;
    * )		cat $i ;;
    esac
}

mkalldir ()
{
    ALLDIRS=`echo $1 | awk -F/ '{ p=$1; print p; for (i=2; i<=NF; i++) {
		p=sprintf("%s/%s", p, $i); print p } }'`
    for d in $ALLDIRS ; do
	if [ ! -d $d ]; then
	    echo "mkdir $d"
	    mkdir $d || return $status
	fi
    done
}

findfc ()
{
    for p in $allpathes; do
	if [ -x $p/$1 ]; then
	    echo $1
	    return 0
	fi
    done
    echo ""
    return 1
}

# main script

# find the font compiler first.

allpathes=`echo $PATH | sed -e 's/:/ /g'`
FC=`findfc bdftopcf`
test "$FC" = ""  &&  FC=`findfc bdftosnf`
test "$FC" = ""  &&  FC=`findfc convertfont`
test "$FC" = ""  &&  FC=`findfc dxfc`
if [ "$FC" = "" ]; then
    echo "Cannot find a font compiler (like bdftopcf, etc.)"
    echo "Abort font installation."
    exit 1 
fi

# input the source dir

if [ -d ./fonts ]; then
    def_src=./fonts
    default='[$def_src] '
elif [ -d ./xfonts ]; then
    def_src=./xfonts
    default='[$def_src] '
elif [ -d ./x-fonts ]; then
    def_src=./x-fonts
    default='[$def_src] '
else
    def_src=''
    default=''
fi

if [ "$1" != "" ]; then
    src_fontdir="$1"
else
    src_fontdir=""
fi

while [ "$src_fontdir" = "" ]; do
    echo "What is the directory that contains fonts to be installed?"
    $ECHONONL "Enter the path name ${default}:" $NONL
    read src_fontdir
    if [ "$def_src" != "" ]; then
	if [ "$src_fontdir" = "" ]; then
	    src_fontdir="$def_src"
	fi
    fi
    if [ ! -d "$src_fontdir" ]; then
	echo "Directory $src_fontdir does not exist." 1>&2
	src_fontdir=""
    fi
done

dst_fontdir=""
while [ "$dst_fontdir" = "" ]; do
    echo "Where do you want to install the fonts to?"
    $ECHONONL "Enter full path name [$HOME/xfonts] :" $NONL
    read dst_fontdir
    if [ "$dst_fontdir" = "" ]; then
        dst_fontdir="$HOME/xfonts"
    fi
    mkalldir $dst_fontdir
    if [ "$?" -ne 0 ]; then
	echo "The given directory cannot be created."
	echo "Please double check and try again."
	dst_fontdir=""
    fi
done

echo "The following fonts are found in the source directory:"
(cd $src_fontdir; echo *.bdf *.bdf.Z *bdf.gz)
$ECHONONL "Please enter the fonts you want to install :" $NONL
read fonts
if [ "$fonts" = "" ]; then
    echo "No font to install"
    exit 0;
fi

for i in $fonts ; do
    fontname=`basename $i .bdf`
    srcfont=$src_fontdir/$i
    if [ -f $src_fontdir/$i ]; then
	case $FC in
	 bdftopcf )		# X11R5, R6
	    zZcat $src_fontdir/$i | $FC -t > $dst_fontdir/$fontname.pcf
	    ;;
	 bdftosnf )		# X11R4, R3, ...
	    zZcat $src_fontdir/$i | $FC -t > $dst_fontdir/$fontname.snf
	    ;;
	 convertfont )		# OpenWindow
	    zZcat $src_fontdir/$i > $dst_fontdir/$fontname.bdf
	    ( cd $dst_fontdir
	      $FC -M -n $fontname -o $fontname $fontname.bdf
	      rm -f $fontname.bdf )
	    ;;
	 dxfc )			# DECwindow
	    zZcat $src_fontdir/$i | $FC -t > $dst_fontdir/$fontname.pcf
	    ;;
	esac
    fi
done
test -f $src_fontdir/fonts.alias  &&  cp $src_fontdir/fonts.alias $dst_fontdir
case $FC in
 bdftopcf | bdftosnf )
    mkfontdir $dst_fontdir
    ;;
 convertfont )
    ( cd $dst_fontdir; bldfamily )
    ;;
 dxfc )
    dxmkfontdir $dst_fontdir
    ;;
esac

cat << _END_OF_FC_

If everything is right, the font installation is completed.  To use the
font path, you need to add the following line to your X window startup
files (such as ~/.xinitrc):

	xset fp+ $dst_fontdir

WARNING:  However, if you are using an X terminal (instead of a normal
	  workstation), special font installation may be required.
	  Ask your system manager or the vendor's technical support.

_END_OF_FC_
