#include <stdio.h>

#include <X11/Xlib.h>

#include "generic.h"

typedef struct {
	ltgenericd g;
	Cursor c;
	} ltcursord, *ltcursor;

tcursor tcursor_new(where, w, h, xhot, yhot, sbits, mbits, fg, bg)
titem where;
int w, h, xhot, yhot;
char *sbits;
char *mbits;
tcolor fg, bg;
{
	Display *xdpy;
	tdisplay dpy;
	Pixmap src, msk;
	Drawable win;
	ltcursor c;

	/* check types */
	if(where==NULL || sbits==NULL || mbits==NULL || fg==NULL || bg==NULL)
		return(NULL);
	if(w<=0 || h<=0)
		return(NULL);
	if(xhot<0 || xhot>=w || yhot<0 || yhot>=h)
		return(NULL);
	if(titem_type(fg)!=lt_color ||
			titem_type(bg)!=lt_color)
		return(NULL);

	dpy=(tdisplay)titem_display(where);
	win=(Drawable)titem_drawable(where);
    xdpy=(Display *)tdisplay_X(dpy);

	src=XCreateBitmapFromData(xdpy, win, sbits, w, h);
	if(src==NULL)
		return(NULL);

	msk=XCreateBitmapFromData(xdpy, win, mbits, w, h);
	if(msk==NULL)
	{
		XFreePixmap(xdpy, src);
		return(NULL);
	}

	c=(ltcursor)titem_new(NULL, lt_cursor, sizeof(ltcursord));
	if(c==NULL)
	{
		XFreePixmap(xdpy, src);
		XFreePixmap(xdpy, msk);
		return(NULL);
	}


	c->c=XCreatePixmapCursor(xdpy, src, msk,
		tcolor_Xcolor(fg), tcolor_Xcolor(bg), xhot, yhot);
	XFreePixmap(xdpy, src);
	XFreePixmap(xdpy, msk);
	if(c->c==NULL)
	{
		free(c);
		return(NULL);
	}

	return(c);
}

Cursor tcursor_X(c)
ltcursor c;
{
	if(c==NULL)
		return(NULL);
	if(titem_type(c)!=lt_cursor)
		return(NULL);
	
	return(c->c);
}

int tcursor_set(c, where)
ltcursor c;
titem where;
{
	Display *xdpy;
	tdisplay dpy;
	Window w;

	if(c==NULL || where==NULL)
		return(0);
	if(titem_type(c)!=lt_cursor)
		return(0);

	dpy=(tdisplay)titem_display(where);
	w=(Drawable)titem_drawable(where);
    xdpy=(Display *)tdisplay_X(dpy);

	XDefineCursor(xdpy, w, c->c);
	return(1);
}

int tcursor_unset(where)
titem where;
{
	Display *xdpy;
	tdisplay dpy;
	Window w;

	if(where==NULL)
		return(0);

	dpy=(tdisplay)titem_display(where);
	w=(Drawable)titem_drawable(where);
    xdpy=(Display *)tdisplay_X(dpy);

	XUndefineCursor(xdpy, w);
	return(1);
}
