#include <stdio.h>

#include <X11/Xlib.h>

#include "generic.h"

typedef struct {
	ltgenericd g;
	Display *dpy;
	int depth;
	char *name;
	int screen;
	Window root;
	Colormap cmap;
	tcolor black, white;
	} ltdisplayd, *ltdisplay;

tdisplay tdisplay_new(name, args)
char *name;
targs args;
{
	ltdisplay dpy;
	
	/* allocate memory */
	dpy=(ltdisplay)titem_new(NULL, lt_display, sizeof(ltdisplayd));
	if(dpy==NULL)
		return(NULL);
	
	/* check format of name */
	if(strlen(name)==0)
		name=NULL;

	/* open the display */
	if((dpy->dpy=XOpenDisplay(name))==NULL)
	{
		titem_free(dpy);
		return(NULL);
	}

	/* store name, screen, root window, colormap, black and white colors */
	dpy->name=(char *)strdup(name);
	dpy->screen=DefaultScreen(dpy->dpy);
	dpy->root=RootWindow(dpy->dpy, dpy->screen);
	dpy->cmap=DefaultColormap(dpy->dpy, dpy->screen);
	dpy->black=tcolor_black(dpy);
	dpy->white=tcolor_white(dpy);
	dpy->depth=DefaultDepth(dpy->dpy, dpy->screen);

	return((tdisplay)dpy);
}

tdisplay tdisplay_create_from_xdpy(xdpy)
Display *xdpy;
{
	ltdisplay dpy;
	
	if(xdpy==NULL)
		return(NULL);
	dpy=(ltdisplay)titem_new(NULL, lt_display, sizeof(ltdisplayd));
	if(dpy==NULL)
		return(NULL);
	dpy->dpy=xdpy;
	dpy->name=NULL;
	dpy->screen=DefaultScreen(dpy->dpy);
	dpy->root=RootWindow(dpy->dpy, dpy->screen);
	dpy->cmap=DefaultColormap(dpy->dpy, dpy->screen);
	dpy->black=tcolor_black(dpy);
	dpy->white=tcolor_white(dpy);
	dpy->depth=DefaultDepth(dpy->dpy, dpy->screen);
	return((tdisplay)dpy);
}

int tdisplay_free(dpy)
ltdisplay dpy;
{
	/* check type of dpy */
	if(dpy==NULL)
		return(0);
	if(titem_type(dpy)!=lt_display)
		return(0);

	/* free the name */
	if(dpy->name!=NULL)
		free(dpy->name);
	
	/* close it */
	XCloseDisplay(dpy->dpy);

	/* free the memory */
	titem_free(dpy);
	return(1);
}

Display *tdisplay_X(dpy)
ltdisplay dpy;
{
	/* check type of dpy */
	if(dpy==NULL)
		return(NULL);
	if(titem_type(dpy)!=lt_display)
		return(NULL);
	
	/* return X display */
	return(dpy->dpy);
}

Window tdisplay_XRoot(dpy)
ltdisplay dpy;
{
	/* check type of dpy */
	if(dpy==NULL)
		return(NULL);
	if(titem_type(dpy)!=lt_display)
		return(NULL);
	
	/* return Root */
	return(dpy->root);
}

Colormap tdisplay_XColormap(dpy)
ltdisplay dpy;
{
	/* check type of dpy */
	if(dpy==NULL)
		return(NULL);
	if(titem_type(dpy)!=lt_display)
		return(NULL);
	
	/* return Colormap */
	return(dpy->cmap);
}

int tdisplay_XScreen(dpy)
ltdisplay dpy;
{
	/* check type of dpy */
	if(dpy==NULL)
		return(NULL);
	if(titem_type(dpy)!=lt_display)
		return(NULL);
	
	/* return screen */
	return(dpy->screen);
}

tcolor tdisplay_Black(dpy)
ltdisplay dpy;
{
	/* check type of dpy */
	if(dpy==NULL)
		return(NULL);
	if(titem_type(dpy)!=lt_display)
		return(NULL);
	
	/* return black color */
	return(dpy->black);
}

tcolor tdisplay_White(dpy)
ltdisplay dpy;
{
	/* check type of dpy */
	if(dpy==NULL)
		return(NULL);
	if(titem_type(dpy)!=lt_display)
		return(NULL);
	
	/* return white color */
	return(dpy->white);
}

int tdisplay_depth(dpy)
ltdisplay dpy;
{
	/* check type of dpy */
	if(dpy==NULL)
		return(NULL);
	if(titem_type(dpy)!=lt_display)
		return(NULL);
	
	/* return depth */
	return(dpy->depth);
}

double tdisplay_dpi_x(dpy)
titem dpy;
{
	ltdisplay d;
	int width, millimeters;
	double dpi;

	d=(ltdisplay)titem_display(dpy);
	if(d==NULL)
		return(0.0);
	
	width=DisplayWidth(d->dpy, d->screen);
	millimeters=DisplayWidthMM(d->dpy, d->screen);
	dpi=width/(millimeters/25.4);	/* convert to inches */
	return(dpi);
}

double tdisplay_dpi_y(dpy)
titem dpy;
{
	ltdisplay d;
	int height, millimeters;
	double dpi;

	d=(ltdisplay)titem_display(dpy);
	if(d==NULL)
		return(0.0);
	
	height=DisplayHeight(d->dpy, d->screen);
	millimeters=DisplayHeightMM(d->dpy, d->screen);
	dpi=height/(millimeters/25.4);	/* convert to inches */
	return(dpi);
}

tdisplay_beep(dpy)
titem dpy;
{
	ltdisplay d;

	d=(ltdisplay)titem_display(dpy);
	if(d==NULL)
		return;
	
	XBell(d->dpy, 100);
}

int tdisplay_height(dpy)
titem dpy;
{
	ltdisplay d;

	d=(ltdisplay)titem_display(dpy);
	if(d==NULL)
		return;
	
	return(DisplayHeight(d->dpy, d->screen));
}

int tdisplay_width(dpy)
titem dpy;
{
	ltdisplay d;

	d=(ltdisplay)titem_display(dpy);
	if(d==NULL)
		return;
	
	return(DisplayWidth(d->dpy, d->screen));
}
