#include <stdio.h>

#include <xview/xview.h>
#include <xview/win_input.h>

#include <X11/keysym.h>
#include <X11/Xutil.h>

#include "generic.h"

typedef struct {
	ltgenericd g;
	type_tevent t;			/* type of event */
	int x,y,w,h;			/* canvas coordinates,only used on
								resize,repaint,mouseup/down */
	special_key k;			/* a special key, for keyup/down */
	char *string;			/* keypresses, for keyup/down */
	Event *e;				/* xview event */
	} lteventd, *ltevent;

tevent tevent_create_from_xviewevent(e, x, y, w, h)
Event *e;
int x, y, w, h;
{
	int action;
	ltevent tmp;
	char st[2];

	/* check type */
	if(e==NULL)
		return(NULL);

	tmp=(ltevent)titem_new(NULL, lt_event, sizeof(lteventd));
	if(tmp==NULL)
		return(NULL);

	tmp->string=NULL;
	tmp->e=NULL;
	tmp->k=tk_none;
	tmp->t=te_unknown;

	action=event_action(e);
	switch(action)
	{
		case ACTION_SELECT:
		case ACTION_ADJUST:
		case ACTION_MENU:
			if(event_is_down(e))
				tmp->t=te_mousedown;
			else
				tmp->t=te_mouseup;
			break;
		case WIN_REPAINT:
			tmp->t=te_repaint;
			break;
		case WIN_RESIZE:
			tmp->t=te_resize;
			break;
		case WIN_CREATE_NOTIFY:
			tmp->t=te_create;
			break;
		case LOC_WINENTER:
			tmp->t=te_enter;
			break;
		case LOC_WINEXIT:
			tmp->t=te_exit;
			break;
		case LOC_MOVE:
			tmp->t=te_move;
			break;
		case LOC_DRAG:
			tmp->t=te_drag;
			break;
		default:
			if(e->ie_xevent!=NULL)
				if(e->ie_xevent->type==KeyPress ||
					e->ie_xevent->type==KeyRelease)
				{
					static int charcount;
					static char buffer[5];
					KeySym key;
					XComposeStatus compose;

					charcount=XLookupString(e->ie_xevent, buffer,
						5, &key, &compose);

					if(e->ie_xevent->type==KeyPress)
						tmp->t=te_keydown;
					else
						tmp->t=te_keyup;
					if(event_is_string(e))
						tmp->string=(char *)strdup(event_string(e));
					else
					{
						st[1]='\0';
						st[0]=event_action(e);
						tmp->string=(char *)strdup(st);
					}

					switch(key)
					{
						case XK_Delete:
						case XK_BackSpace:
							tmp->k=tk_delete;
							break;
						case XK_Left:
						case XK_KP_4:
							tmp->k=tk_left;
							break;
						case XK_Right:
						case XK_KP_6:
							tmp->k=tk_right;
							break;
						case XK_Up:
						case XK_KP_8:
							tmp->k=tk_up;
							break;
						case XK_Down:
						case XK_KP_2:
							tmp->k=tk_down;
							break;
						case XK_KP_9:
						case XK_R9:
							tmp->k=tk_page_up;
							break;
						case XK_KP_3:
						case XK_R15:
							tmp->k=tk_page_down;
							break;
						case XK_L10:/*Cut*/
							tmp->k=tk_cut;
							break;
						case XK_L6:/*Copy*/
							tmp->k=tk_copy;
							break;
						case XK_L8:/*Paste*/
							tmp->k=tk_paste;
							break;
						case XK_Undo:
							tmp->k=tk_undo;
							break;
						case XK_Help:
							tmp->k=tk_help;
							break;
						default:
							tmp->k=tk_none;
							break;
					}
				}
			break;
	}

	/* set the coordinates */
	tmp->x=x;
	tmp->y=y;
	tmp->w=w;
	tmp->h=h;
	tmp->e=e;

	return(tmp);
}

type_tevent tevent_type(e)
ltevent e;
{
	/* check type */
	if(e==NULL)
		return(te_unknown);
	if(titem_type(e)!=lt_event)
		return(te_unknown);
	
	return(e->t);
}

int tevent_location(e,x,y)
ltevent e;
int *x,*y;
{
	/* check type */
	if(e==NULL)
		return(0);
	if(titem_type(e)!=lt_event)
		return(0);

	*x=e->x;
	*y=e->y;
	return(1);
}

int tevent_size(e,w,h)
ltevent e;
int *w,*h;
{
	/* check type */
	if(e==NULL)
		return(0);
	if(titem_type(e)!=lt_event)
		return(0);

	*w=e->w;
	*h=e->h;
	return(1);
}

int tevent_area(e,x,y,w,h)
ltevent e;
int *x,*y,*w,*h;
{
	/* check type */
	if(e==NULL)
		return(0);
	if(titem_type(e)!=lt_event)
		return(0);

	*x=e->x;
	*y=e->y;
	*w=e->w;
	*h=e->h;
	return(1);
}

t_button tevent_button(e)
ltevent e;
{
	type_tevent t;

	/* check type */
	if(e==NULL)
		return(tb_none);
	if(titem_type(e)!=lt_event)
		return(tb_none);
	if(e->e==NULL)
		return(tb_none);

	t=e->t;
	switch(t)
	{
		case te_mousedown:
		case te_mouseup:
			switch(event_action(e->e))
			{
				case ACTION_SELECT:
					return(tb_select);
				case ACTION_ADJUST:
					return(tb_adjust);
				case ACTION_MENU:
					return(tb_menu);
				default:
					return(tb_none);
			}
		default:
			return(tb_none);
		
	}
}

special_key tevent_special_key(e)
ltevent e;
{
	type_tevent t;

	/* check type */
	if(e==NULL)
		return(tk_none);
	if(titem_type(e)!=lt_event)
		return(tk_none);
	if(e->e==NULL)
		return(tk_none);

	t=e->t;
	switch(t)
	{
		case te_keydown:
		case te_keyup:
			return(e->k);
		default:
			return(tk_none);
		
	}
}

char *tevent_string(e)
ltevent e;
{
	type_tevent t;

	/* check type */
	if(e==NULL)
		return(NULL);
	if(titem_type(e)!=lt_event)
		return(NULL);
	if(e->e==NULL)
		return(NULL);

	t=e->t;
	switch(t)
	{
		case te_keydown:
		case te_keyup:
			if(e->string!=NULL)
				return(e->string);
			else
				return(NULL);
		default:
			return(NULL);
		
	}
}

int tevent_button_down(e, b)
ltevent e;
t_button b;
{
	type_tevent t;

	/* check type */
	if(e==NULL)
		return(0);
	if(titem_type(e)!=lt_event)
		return(0);
	if(e->e==NULL)
		return(0);

	switch(b)
	{
		case tb_select:
			return(event_left_is_down(e->e));
		case tb_adjust:
			return(event_middle_is_down(e->e));
		case tb_menu:
			return(event_right_is_down(e->e));
		default:
			return(0);
	}
}

int tevent_modifier_down(e,m)
ltevent e;
t_modifier m;
{
	type_tevent t;

	/* check type */
	if(e==NULL)
		return(0);
	if(titem_type(e)!=lt_event)
		return(0);
	if(e->e==NULL)
		return(0);

	switch(m)
	{
		case tm_shift:
			return(event_shift_is_down(e->e));
		case tm_ctrl:
			return(event_ctrl_is_down(e->e));
		case tm_meta:
			return(event_meta_is_down(e->e));
		default:
			return(0);
	}
}

tevent tevent_create_user(x,y)
int x,y;
{
	ltevent tmp;

	tmp=(ltevent)titem_new(NULL, lt_event, sizeof(lteventd));
	if(tmp==NULL)
		return(NULL);
	
	tmp->t=te_user;
	tmp->x=x;
	tmp->y=y;
	tmp->k=tk_none;
	tmp->string=NULL;
	tmp->e=NULL;
	return(tmp);
}

tevent_free(e)
ltevent e;
{
	if(e==NULL)	
		return;
	if(titem_type(e)!=lt_event)
		return;
	if(e->string!=NULL)
		free(e->string);
	free(e);
}

tevent tevent_create_repaint(x,y,w,h)
int x,y,w,h;
{
	ltevent tmp;

	tmp=(ltevent)titem_new(NULL, lt_event, sizeof(lteventd));
	if(tmp==NULL)
		return(NULL);
	
	tmp->t=te_repaint;
	tmp->x=x;
	tmp->y=y;
	tmp->w=w;
	tmp->h=h;
	tmp->k=tk_none;
	tmp->string=NULL;
	tmp->e=NULL;
	return(tmp);
}

tevent tevent_create_done()
{
	ltevent tmp;

	tmp=(ltevent)titem_new(NULL, lt_event, sizeof(lteventd));
	if(tmp==NULL)
		return(NULL);
	
	tmp->t=te_done;
	tmp->k=tk_none;
	tmp->string=NULL;
	tmp->e=NULL;
	return(tmp);
}

Event *tevent_xview(e)
ltevent e;
{
	/* check type */
	if(e==NULL)
		return(NULL);
	if(titem_type(e)!=lt_event)
		return(NULL);

	return(e->e);
}

Time tevent_time(e)
ltevent e;
{
	/* check type */
	if(e==NULL)
		return(NULL);
	if(titem_type(e)!=lt_event)
		return(NULL);
	
	return(event_xevent(e->e)->xbutton.time);
}

int tevent_xview_x(e)
ltevent e;
{
	/* check type */
	if(e==NULL)
		return(NULL);
	if(titem_type(e)!=lt_event)
		return(NULL);
	
	return(event_x(e->e));
}

int tevent_xview_y(e)
ltevent e;
{
	/* check type */
	if(e==NULL)
		return(NULL);
	if(titem_type(e)!=lt_event)
		return(NULL);
	
	return(event_y(e->e));
}

Xv_object tevent_xview_window(e)
ltevent e;
{
	/* check type */
	if(e==NULL)
		return(NULL);
	if(titem_type(e)!=lt_event)
		return(NULL);
	
	return(event_window(e->e));
}
