#include <stdio.h>

#include <xview/xview.h>
#include <xview/panel.h>
#include "generic.h"
#include "list.h"

typedef struct {
	ltgenericd g;
	Menu m;			/* xview menu */
	Panel_item b;	/* xview button */
	int exclusive;
	tpitem sel;	/* selected item */
	tpitem i;		/* parent menu item */
	list items;		/* pitems */
	int width;		/* maximum width */
	int (*do_events)();
	} ltpchoiced, *ltpchoice;

extern void tpitem_notify();

int tpchoice_right_side(m)
ltpchoice m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pchoice)
		return(0);
	if(m->b==NULL)
		return(0);
	
	/*return(xv_get(m->b, XV_X)+xv_get(m->b, XV_WIDTH));*/
	return(xv_get(m->b, XV_X)+m->width);
}

int tpchoice_bottom_side(m)
ltpchoice m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pchoice)
		return(0);
	if(m->b==NULL)
		return(0);
	
	return(xv_get(m->b, XV_Y)+xv_get(m->b, XV_HEIGHT));
}

void tpchoicebutton_notify(i, e)
Panel_item i;
Event *e;
{
	/*fprintf(stderr, "Panel Choice Button Pushed\n");*/
	return;
}

void tpchoice_notify(m, i)
ltpchoice m;
tpitem i;
{
    char *s;

    if(m->exclusive)
	tpitem_unselect(m->sel);
    tpitem_select(i);
    if(m->exclusive)
    {
		s=tpitem_get_name(i);
		xv_set(m->b,
			PANEL_LABEL_STRING, s,
			XV_WIDTH, m->width,
			NULL);
    }
    m->sel=i;
    if(m->do_events!=NULL)
	(void) (*m->do_events)(m, i);
}

tpchoice tpchoice_new(parent, x,y,w,h,right,below, name, exclusive)
tpanel parent;
int x,y,w,h;
titem right,below;
char *name;
int exclusive;
{
	ltpchoice tmp;
	int submenu;

	/* check types */
	if(parent==NULL)
		return(NULL);
	if(titem_type(parent)==lt_panel)
		submenu=0;
	else if(titem_type(parent)==lt_pitem)
		submenu=1;
	else
		return(NULL);
	

	if(name==NULL)
		name="Choice";
	
	tmp=(ltpchoice)titem_new(parent, lt_pchoice, sizeof(ltpchoiced));
	if(tmp==NULL)
		return(NULL);
	
	if(!submenu)
	{
		tmp->b=(Panel_item)xv_create(tpanel_xview(parent), PANEL_BUTTON,
			PANEL_LABEL_STRING, name,
			XV_WIDTH, w,
			XV_HEIGHT, h,
			NULL);
		if(tmp->b==NULL)
		{
			titem_free(tmp);
			return(NULL);
		}
		
		if(right!=NULL)
			x=tp_right_side(right);
		if(below!=NULL)
			y=tp_bottom_side(below);

		xv_set(tmp->b,
			XV_X, x,
			XV_Y, y,
			PANEL_CLIENT_DATA, tmp,
			PANEL_NOTIFY_PROC, tpchoicebutton_notify,
			NULL);
		/* now button is created */
		tmp->i=NULL;
	}
	else
	{
		tmp->b=NULL;
		tpitem_set_submenu(parent, tmp->m);
		tmp->i=parent;

	}

	tmp->m=xv_create(NULL, MENU,
		MENU_CLIENT_DATA, tmp,
		MENU_NOTIFY_PROC, tpitem_notify,
		NULL);
	if(tmp->m==NULL)
	{
		xv_destroy_safe(tmp->b);
		titem_free(tmp);
		return(NULL);
	}
	
	/* now choice is created */
	xv_set(tmp->b, PANEL_ITEM_MENU, tmp->m, NULL);

	tmp->items=newlist();
	tmp->exclusive=exclusive;
	tmp->width=w;

	return(tmp);
}

int tpchoice_free(m)
ltpchoice m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pchoice)
		return(0);
	
	xv_destroy_safe(m->m);
	if(m->b!=NULL)
		xv_destroy_safe(m->b);
	freelist(m->items);
	return(titem_free(m));
}

int tpchoice_enable(m)
ltpchoice m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pchoice)
		return(0);
	
	if(m->b!=NULL)
		xv_set(m->b, PANEL_INACTIVE, FALSE, NULL);
	else
		tpitem_enable(m->i);
	return(1);
}

int tpchoice_disable(m)
ltpchoice m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pchoice)
		return(0);
	
	if(m->b!=NULL)
		xv_set(m->b, PANEL_INACTIVE, TRUE, NULL);
	else
		tpitem_disable(m->i);
	return(1);
}

extern void *tpitem_get_event_procedure();

int tpchoice_add(m, i, after)
ltpchoice m;
tpitem i;
tpitem after;
{
	tpitem current;
	list oldnode;
	Menu_item m1, m2;
	int must_select=0;

	/* check type */
	if(m==NULL || i==NULL)
		return(0);
	if(titem_type(m)!=lt_pchoice || titem_type(i)!=lt_pitem)
		return(0);

	oldnode=listnode(m->items);
	
	if(listemptyp(m->items) && m->exclusive)
	    must_select=1;
	
	/*xv_set(tpitem_xview_item(i), MENU_IMAGE, item_off, NULL);*/
	
	if(after==m)
	{
		/* insert item at start */
		m1=tpitem_xview_item(i);
		startlist(m->items);
		if(listnext(m->items)==NULL)
			xv_set(m->m, MENU_INSERT, 0, m1, NULL);
		else
			xv_set(m->m, MENU_APPEND_ITEM, m1, NULL);
		startlist(m->items);
		addnode(m->items, i);
	}
	else if(after==NULL)
	{
		/* add at end */
		endlist(m->items);
		addnode(m->items, i);
		m1=tpitem_xview_item(i);
		xv_set(m->m, MENU_APPEND_ITEM, m1, NULL);
	}
	else
	{
		/* insert after given item */
		if(titem_type(after)!=lt_pitem)
			return(0);
		if(findnode(m->items, after)==NULL)
			return(0);
		m2=tpitem_xview_item(after);
		if(m2==NULL)
			return(0);
		addnode(m->items, i);
		m1=tpitem_xview_item(i);
		xv_set(m->m, MENU_INSERT_ITEM, m2, m1, NULL);
	}

	setnode(m->items, oldnode);
	if(must_select)
	{
	    char *s;

	    tpitem_select(i);
	    s=tpitem_get_name(i);
	    xv_set(m->b,
			PANEL_LABEL_STRING, s,
			XV_WIDTH, m->width,
			NULL);
	    m->sel=i;
	}
	(void *)(m->do_events)=tpitem_get_event_procedure(i);
	tpitem_set_event_procedure(i, tpchoice_notify);
	return(1);
}

int tpchoice_remove(m, i)
ltpchoice m;
tpitem i;
{
	list oldnode;
	tpitem t;
	Menu_item m1;
	int must_select=0;

	/* check type */
	if(m==NULL || i==NULL)
		return(0);
	if(titem_type(m)!=lt_pchoice || titem_type(i)!=lt_pitem)
		return(0);

	oldnode=listnode(m->items);
	
	if(findnode(m->items, i)==NULL)
		return(0);
	rmcurr(m->items);
	tpitem_unselect(i);
	if(m->exclusive && tpitem_selected(i))
	    must_select=1;
	m1=tpitem_xview_item(i);
	xv_set(m->m, MENU_REMOVE_ITEM, m1, NULL);

	if(must_select)
	{
	    startlist(m->items);
	    while((t=listnext(m->items))!=NULL)
	    {
		if(tpitem_enabled(t))
		{
		    char *s;

		    tpitem_select(t);
		    s=tpitem_get_name(t);
		    xv_set(m->b,
				PANEL_LABEL_STRING, s,
				XV_WIDTH, m->width,
				NULL);
		    m->sel=t;
		    break;
		}
	    }
	}
	setnode(m->items, oldnode);
	return(1);
}

tpitem tpchoice_first_item(m)
ltpchoice m;
{
	/* check type */
	if(m==NULL)
		return(NULL);
	if(titem_type(m)!=lt_pchoice)
		return(NULL);

	startlist(m->items);
	return(listnext(m->items));
}

tpitem tpchoice_next_item(m)
ltpchoice m;
{
	/* check type */
	if(m==NULL)
		return(NULL);
	if(titem_type(m)!=lt_pchoice)
		return(NULL);

	return(listnext(m->items));
}

tpitem tpchoice_selected(m)
ltpchoice m;
{
	list oldnode;
	tpitem i;

	/* check type */
	if(m==NULL)
		return(NULL);
	if(titem_type(m)!=lt_pchoice)
		return(NULL);

	/*oldnode=listnode(m->items);*/
	
	/*startlist(m->items);*/
	/*while((i=listnext(m->items))!=NULL)*/
	/*{*/
	    /*if(xv_get(tpitem_xview_item(i), MENU_IMAGE)==item_on)*/
		    /*char *s;*/

		    /*tpitem_select(t);*/
		    /*s=tpitem_get_name(t);*/
		    /*xv_set(m->b, PANEL_LABEL_STRING, s, NULL);*/
		/*break;*/
	/*}*/
	/*setnode(m->items, oldnode);*/

	return(m->sel);

	/*if(i!=NULL)*/
		/*return(i);*/
	/*else*/
		/*return(NULL);*/
}

int tpchoice_disable_item(m, i)
ltpchoice m;
tpitem i;
{
	list oldnode;
	tpitem t;
	Menu_item m1;
	int must_select=0;

	/* check type */
	if(m==NULL || i==NULL)
		return(0);
	if(titem_type(m)!=lt_pchoice || titem_type(i)!=lt_pitem)
		return(0);

	oldnode=listnode(m->items);
	
	if(tpitem_selected(i))
	{
	    tpitem_unselect(i);
	    if(m->exclusive)
		must_select=1;
	}

	tpitem_disable(i);

	if(must_select)
	{
	    startlist(m->items);
	    while((t=listnext(m->items))!=NULL)
	    {
		if(tpitem_enabled(t))
		{
		    char *s;

		    tpitem_select(t);
		    s=tpitem_get_name(t);
		    xv_set(m->b,
				PANEL_LABEL_STRING, s,
				XV_WIDTH, m->width,
				NULL);
		    m->sel=t;
		    break;
		}
	    }
	}
	setnode(m->items, oldnode);
	return(1);
}

int tpchoice_select_item(m, i)
ltpchoice m;
tpitem i;
{
	list oldnode;
	list t;
	char *s;

	/* check type */
	if(m==NULL || i==NULL)
	    return(0);
	if(titem_type(m)!=lt_pchoice || titem_type(i)!=lt_pitem)
	    return(0);

	if(m->exclusive)
	    tpitem_unselect(m->sel);

	tpitem_select(i);
	s=tpitem_get_name(i);
	xv_set(m->b,
	    PANEL_LABEL_STRING, s,
	    XV_WIDTH, m->width,
	    NULL);
	m->sel=i;
	return(1);
}

int tpchoice_set_default_item(m, i)
ltpchoice m;
int i;
{
	/* check type */
	if(m==NULL || i<0)
	    return(0);
	if(titem_type(m)!=lt_pchoice)
	    return(0);

	xv_set(m->m, MENU_DEFAULT, i, NULL);
	return(1);
}

int tpchoice_fix_width(m)
ltpchoice m;
{
	list oldnode, t;
	char *s;
	int w;

	/* check type */
	if(m==NULL)
	    return(0);
	if(titem_type(m)!=lt_pchoice)
	    return(0);

	oldnode=listnode(m->items);

	m->width=0;
	startlist(m->items);
	while((t=listnext(m->items))!=NULL)
	{
	    s=tpitem_get_name(t);
	    xv_set(m->b, PANEL_LABEL_STRING, s, NULL);
	    w=xv_get(m->b, XV_WIDTH);
	    if(w>m->width) m->width=w;
	}

	s=tpitem_get_name(m->sel);
	xv_set(m->b,
	    PANEL_LABEL_STRING, s,
	    XV_WIDTH, m->width,
	    NULL);
	return(1);
}


