#include <stdio.h>
#include <time.h>
#include <sys/types.h>
#include <sys/time.h>

#include "list.h"
#include "generic.h"

#define PAGE_MARGIN_WIDTH 18.0
#define PAGE_MARGIN_HEIGHT 13.0
#define PAGE_FULL_HEIGHT 792.0
#define PAGE_FULL_WIDTH 612.0
#define PAGE_WIDTH (PAGE_FULL_WIDTH-PAGE_MARGIN_WIDTH-PAGE_MARGIN_WIDTH)
#define PAGE_HEIGHT (PAGE_FULL_HEIGHT-PAGE_MARGIN_HEIGHT-PAGE_MARGIN_HEIGHT)

typedef enum {
	pr_line,
	pr_text,
	pr_box,
	pr_circle,
	pr_none
	} print_command;

typedef struct {
	print_command c;	/* type, line, text, box, circle, etc... */
	int printed;		/* 1 if already printed */
	int linewidth;		/* linewidth, if it's a line */
	tcap_style capstyle;/* capstyle for lines */
	int r,g,b;			/* colors */
	int x1, y1, x2, y2;	/* coordinates */
	int sx, sy;			/* origin of text */
	char *s;			/* string for text, must be freed */
	char *fontname;		/* font name for text */
	int fontsize;		/* size for font */
	int macnum;			/* for quickdraw */
	int macstyle;
	} qentryd, *qentry;

#define qIsOnPage (!((q->x1>cr && q->x2>cr) || (q->y1<cb && q->y2<cb) || (q->x2<cl && q->x1<cl) || (q->y2>ct && q->y1>ct)))

static tcanvas printcanvas;
static list printq;
static FILE *outfile;
static tp_type outtype;
static int pw, ph;
static int maxx, maxy, minx, miny;
static int maxset;
static int cl, cr, ct, cb;
static int linewidth;
static int red,green,blue;
static tcap_style capstyle;
static double hres, vres;
static char *filename;

int pdraw_set_noneprinted()
{
	qentry q;

	startlist(printq);
	while((q=listnext(printq))!=NULL)
		q->printed=0;
	return(1);
}

int pdraw_shove_line_PICT(x1, y1, x2, y2, lw, ls)
int x1, y1, x2, y2;
int lw;
tcap_style ls;
{
	/* change linewidth if necessary */
	/* change capstyle if necessary */
	/* print endpoint first, then startpoint */
	x1*=72/hres;
	y1*=72/vres;
	x2*=72/hres;
	y2*=72/vres;
	fprintf(outfile,
		"%c%c%c%c%c%c%c%c%c%c",
		0, 0x20, y1/256, y1%256, x1/256, x1%256,
			y2/256, y2%256, x2/256, x2%256);
}

int pdraw_shove_text_PICT(x1, y1, s)
int x1, y1;
char *s;
{
	int i;
	x1*=72/hres;
	y1*=72/vres;
	fprintf(outfile,
		"%c%c%c%c%c%c%c",
		0, 0x28, y1/256, y1%256, x1/256, x1%256, strlen(s));
	for(i=0;s[i]!='\0';i++)
		fprintf(outfile, "%c", s[i]);
	/* padding after text */
	if(i%2==0)
		fprintf(outfile, "%c", 0);
}

int pdraw_shove_font_PICT(n, s, size)
int n;
int s;
int size;
{
	fprintf(outfile,
		"%c%c%c%c%c%c%c%c%c%c%c%c",
		0, 0x3, 0, n, 0, 0x4, s, 0, 0, 0xd, 0, size);
}

/* size of all data other than actual tree picture data in PICT file */
/* includes header, bounding box, initial drawing opcodes, and ending opcode */
#define HEADERSIZE 564

int pdraw_shove_data_fork()
{
	qentry q;
	list savenode;
	char *cfont;
	int csize;
	int i, j;
	float mx, my;
	char hi, lo;

	int tt, tb, tr, tl;	/* total dimensions, calculated below */

	fprintf(outfile, "Treetool PICT file");
	for(i=strlen("Treetool PICT file");i<512;i++)
		fprintf(outfile, "%c", 0); 		/* application header */

	/* picture size, unimportant in PICT2 */
	fprintf(outfile, "%c%c", 0, 0);

	/* bounding box */
	/* first round to full pages */
	i=PAGE_FULL_HEIGHT;
	miny-=miny%i;
	maxy+=i-(maxy%i);
	i=PAGE_FULL_WIDTH;
	minx-=minx%i;
	maxx+=i-(maxx%i);
	/* next convert to 72bpi */
	miny*=72/vres;
	minx*=72/hres;
	maxy*=72/vres;
	maxx*=72/hres;
	hi=(miny>>8)%256; lo=miny%256;
	fprintf(outfile, "%c%c", hi, lo);
	hi=(minx>>8)%256; lo=minx%256;
	fprintf(outfile, "%c%c", hi, lo);
	hi=(maxy>>8)%256; lo=maxy%256;
	fprintf(outfile, "%c%c", hi, lo);
	hi=(maxx>>8)%256; lo=maxx%256;
	fprintf(outfile, "%c%c", hi, lo);

	/* vers opcode, vers number, header opcode */
	fprintf(outfile, "%c%c%c%c%c%c", 0x00, 0x11, 0x02, 0xff, 0x0c, 0x00);

	/* total size, bounding box, reserved, all -1 */
	for(i=0;i<24;i++)
		fprintf(outfile, "%c", -1);

	/* now ready for opcodes */
	fprintf(outfile, "%c", 0);
	fprintf(outfile, "%c", 0x1e); /* change default hilite */
	fprintf(outfile, "%c", 0); /* change text font */
	fprintf(outfile, "%c", 3);
	fprintf(outfile, "%c", 0);
	fprintf(outfile, "%c", 3);
	fprintf(outfile, "%c", 0); /* change size */
	fprintf(outfile, "%c", 0xd);
	fprintf(outfile, "%c", 0);
	fprintf(outfile, "%c", 12);
	/*fprintf(outfile, "%c", 0);		/* change foreground color */
	/*fprintf(outfile, "%c", 0x1a);*/

	startlist(printq);
	while((q=listnext(printq))!=NULL)
	{
		switch(q->c)
		{
			case pr_line:
				pdraw_shove_line_PICT(q->x1, q->y1, q->x2, q->y2,
					q->linewidth, q->capstyle);
				break;
			case pr_text:
				pdraw_shove_font_PICT(q->macnum, q->macstyle, q->fontsize);
				pdraw_shove_text_PICT(q->sx, q->sy, q->s);
			default:
				break;
		}
	}

	/* finish off with ending opcode */
	fprintf(outfile, "%c%c", 0, 255);
}

int pdraw_shove_q_PICT()
{
	int num_bytes;
	int i;
	char byte3, byte2, byte1, byte0;
	qentry q;

	/* counts up size for mac-binary format, then writes header,
		then calls pdraw_shove_data_fork */
	
	num_bytes=HEADERSIZE;

	startlist(printq);
	while((q=listnext(printq))!=NULL)
	{
		switch(q->c)
		{
			case pr_line:
				num_bytes+=10;				/* for line drawing opcode */
				break;
			case pr_text:
				num_bytes+=12;				/* for font opcode */
				num_bytes+=7+strlen(q->s);	/* for text drawing opcode */
				if(strlen(q->s)%2==0)
					num_bytes++;			/* padding byte */
			default:
				break;
		}
	}

	/* write header */
	fprintf(outfile, "%c", 0);					/* version */
	fprintf(outfile, "%c", strlen(filename));	/* filename length */
	for(i=0;i<63 && filename[i]!='\0';i++)		/* filename */
		fprintf(outfile, "%c", filename[i]);
	for(;i<63;i++)								/* pad to 63 bytes */
		fprintf(outfile, "%c", 0);
	fprintf(outfile, "%s", "PICT");				/* file type */
	fprintf(outfile, "%s", "MDPL");				/* file creator */
	fprintf(outfile, "%c", 0);					/* finder flags */
	fprintf(outfile, "%c", 0);					/* zero byte--unused */
	fprintf(outfile, "%c%c", 0, 0);				/* vertical position */
	fprintf(outfile, "%c%c", 0, 0);				/* horizontal position */
	fprintf(outfile, "%c%c", 0, 0);				/* folder id */
	fprintf(outfile, "%c", 0);					/* protected flag */
	fprintf(outfile, "%c", 0);					/* zero byte--unused */
	byte3=(num_bytes>>24)%256;
	byte2=(num_bytes>>16)%256;
	byte1=(num_bytes>>8)%256;
	byte0=num_bytes%256;
	fprintf(outfile, "%c%c%c%c",
		byte3, byte2, byte1, byte0);			/* data fork length */
	fprintf(outfile, "%c%c%c%c", 0, 0, 0, 0);	/* resource fork length, 0 */
	fprintf(outfile, "%c%c%c%c", 0, 0, 0, 0);	/* creation data */
	fprintf(outfile, "%c%c%c%c", 0, 0, 0, 0);	/* last modified data */
	for(i=0;i<27;i++)
		fprintf(outfile, "%c", 0);				/* zero fill--reserved */
	fprintf(outfile, "%c%c", 0, 0);				/* type and ID */

	/* write PICT fork */
	pdraw_shove_data_fork();

	/* write padding */
	if(num_bytes%128!=0)	/* must pad data fork */
		for(i=0;i<128-(num_bytes%128);i++)
			fprintf(outfile, "%c", 0);


}

pdraw_shove_header(filename, docfonts)
char *filename;
list docfonts;
{
	time_t t;
	char hostname[40];
	char username[15];
	list c;

	fprintf(outfile, "%%!PS-Adobe-3.0\n");
	fprintf(outfile, "%%%%Creator: Treetool1.0\n");
	time(&t);
	fprintf(outfile, "%%%%CreationDate: %s", ctime(&t));
	gethostname(hostname, 40);
	fprintf(outfile, "%%%%For: %s@%s\n", getlogin(), hostname);
	fprintf(outfile, "%%%%Pages: (atend)\n");
	fprintf(outfile, "%%%%Title: %s\n", filename);
	if(!listemptyp(docfonts))
	{
		fprintf(outfile, "%%%%DocumentNeededResources:\n");
		lfor(docfonts, c)
			fprintf(outfile, "%%%%+ font %s\n", nodeobj(c));
	}
	fprintf(outfile, "%%%%EndComments\n");
}

pdraw_shove_docsetup(offx, offy, magx, magy)
double offx, offy, magx, magy;
{
	fprintf(outfile, "%%%%BeginSetup\n");
	fprintf(outfile,
		"/ln { newpath moveto lineto stroke closepath } bind def\n");
	fprintf(outfile,
		"/tx { newpath moveto show closepath } bind def\n");
	fprintf(outfile,
		"/sl { setlinewidth } def\n");
	fprintf(outfile,
		"/sc { setlinecap } def\n");
	fprintf(outfile,
		"/sr { setrgbcolor } def\n");
	fprintf(outfile,
		"/sf { exch findfont exch scalefont setfont } def\n");
	fprintf(outfile,
		"/tr { translate } def\n");
	fprintf(outfile,
		"/sp { 1 sc 1 sl 0.0 0.0 0.0 sr\n");
	fprintf(outfile,
		"\t%.5lf %.5lf tr %.5lf %.5lf scale tr } def\n",
		offx, offy, magx, magy);
	fprintf(outfile, "%%%%EndSetup\n");
}

pdraw_shove_pagesetup(num)
int num;
{
	fprintf(outfile, "%%%%Page: tree %d\n", num);
	fprintf(outfile, "%%%%PageResources: (atend)\n");
	fprintf(outfile, "%%%%BeginPageSetup\n");
	fprintf(outfile, "/pgsave save def\n");
	fprintf(outfile, "%%%%EndPageSetup\n");
}

pdraw_shove_pagetrailer(pagefonts)
list pagefonts;
{
	list c;

	fprintf(outfile, "showpage\n");
	fprintf(outfile, "pgsave restore\n");
	fprintf(outfile, "%%%%PageTrailer\n");
	fprintf(outfile, "%%%%PageResources:\n");
	if(!listemptyp(pagefonts))
		lfor(pagefonts, c)
			fprintf(outfile, "%%%%+ font %s\n", nodeobj(c));
}

pdraw_shove_doctrailer(num)
int num;
{
	fprintf(outfile, "%%%%Trailer\n");
	fprintf(outfile, "%%%%Pages: %d\n", num);
	fprintf(outfile, "%%%%EOF\n");
}

int pdraw_shove_color(r, g, b)
int r, g, b;
{
	double rr, gg, bb;

	red=r;
	green=g;
	blue=b;
	rr=r/65536.0;
	gg=g/65536.0;
	bb=b/65536.0;
	fprintf(outfile, "%.5f %.5f %.5f sr\n",
		rr, gg, bb);
}

int pdraw_shove_line(x1, y1, x2, y2, lw, ls, r, g, b)
int x1, y1, x2, y2;
int lw;
tcap_style ls;
int r, g, b;
{
	/* change linewidth if necessary */
	if(lw!=linewidth)
	{
		linewidth=lw;
		if(linewidth==0)
			linewidth=1;
		fprintf(outfile, "%d sl\n", lw);
	}
	/* change capstyle if necessary */
	if(ls!=capstyle)
	{
		capstyle=ls;
		switch(ls)
		{
			case tcap_butt:
			case tcap_notlast:
				fprintf(outfile, "%d sc\n", 0);
				break;
			case tcap_round:
				fprintf(outfile, "%d sc\n", 1);
				break;
			case tcap_projecting:
				fprintf(outfile, "%d sc\n", 2);
				break;
			case tcap_none:
			default:
				break;
		}
	}
	/* change color if necessary */
	if(r!=red || g!=green || b!=blue)
		pdraw_shove_color(r, g, b);
	/* print endpoint first, then startpoint */
	fprintf(outfile,
		"%d %d %d %d ln\n",
		x2, y2, x1, y1);
}

int pdraw_shove_text(x1, y1, s, r, g, b)
int x1, y1;
char *s;
int r, g, b;
{
	/* change color if necessary */
	if(r!=red || g!=green || b!=blue)
		pdraw_shove_color(r, g, b);
	/* print string first, then point */
	fprintf(outfile,
		"(%s) %d %d tx\n",
		s, x1, y1);
}

int pdraw_shove_font(n, s)
char *n;
int s;
{
	fprintf(outfile,
		"/%s %d sf\n",
		n, s);
}

int pdraw_shove_q()
{
	qentry q;
	list savenode;
	char *cfont;
	int csize;
	int i, j;
	float mx, my;
	list docfonts, cf, cq;
	int pnum;

	int tt, tb, tr, tl;	/* total dimensions, calculated below */

	mx=PAGE_WIDTH/pw;
	my=PAGE_HEIGHT/ph;

	/*fprintf(outfile, "%%! TreeTool print file\n");*/
	/*fprintf(outfile, "%s\n", LINETO);*/
	/*fprintf(outfile, "%s\n", TEXTTO);*/
	/*fprintf(outfile, "1 setlinecap\n");*/
	/*fprintf(outfile, "1 setlinewidth\n");*/

	if(minx>0)
		tl=minx/pw;
	else
		tl=minx/pw-1;
	if(maxx>0)
		tr=maxx/pw;
	else
		tr=maxx/pw-1;
	if(miny>0)
		tb=miny/ph;
	else
		tb=miny/ph-1;
	if(maxy>0)
		tt=maxy/ph;
	else
		tt=maxy/ph-1;

#define thisqentry(c) ((qentry)nodeobj(c))
#define thisfontname(c) ((char *)nodeobj(c))
	
	docfonts=newlist();
	lfor(printq, cq)
		if(thisqentry(cq)->c==pr_text)
		{
			lfor(docfonts, cf)
				if(strcmp(thisfontname(cf), thisqentry(cq)->fontname)==0)
					break;
			if(cf!=NULL)
				addnode(docfonts, thisfontname(cf));
		}
	pdraw_shove_header(filename, docfonts);
	pdraw_shove_docsetup(PAGE_MARGIN_WIDTH, PAGE_MARGIN_HEIGHT, mx, my);
	freelist(docfonts);


	pnum=0;
	for(i=tl;i<=tr;i++)
	for(j=tt;j>=tb;j--)
	{
		pdraw_set_noneprinted();

		/* calculate cl,cr,ct,cb */
		cl=pw*i;
		cr=pw*(i+1);
		cb=ph*j;
		ct=ph*(j+1);

		/* check if any on page */
		startlist(printq);
		while((q=listnext(printq))!=NULL)
			if(qIsOnPage)
				break;


		if(q!=NULL)
		{
			pnum++;
			pdraw_shove_pagesetup(pnum);
			/* we've determined there's something on this page */

			/* translate by the number of pages */
			fprintf(outfile, "%d %d sp\n", -pw*i, -ph*j);
			/* initial linewidth is 1 */
			/* initial cap style is round */
			linewidth=1;
			capstyle=tcap_round;
			red=0;
			green=0;
			blue=0;

			/* print non text */
			startlist(printq);
			while((q=listnext(printq))!=NULL)
			{
				if(qIsOnPage)
					/* on page */
					switch(q->c)
					{
						case pr_line:
							pdraw_shove_line(q->x1, q->y1, q->x2, q->y2,
								q->linewidth, q->capstyle,
								q->r, q->g, q->b);
							break;
						default:
							break;
					}
			}

			/* print text */
			fprintf(outfile, "0 sc\n");

			docfonts=newlist();
			startlist(printq);
			while((q=listnext(printq))!=NULL)
			{
				/* find a text to be printed */
				if(q->c==pr_text && !q->printed)
				{
					if(qIsOnPage)
					{
						/* on page */
						addnode(docfonts, q->fontname);
						pdraw_shove_font(q->fontname, q->fontsize);
						pdraw_shove_text(q->sx, q->sy, q->s,
							q->r, q->g, q->b);
						q->printed=1;
						cfont=q->fontname;
						csize=q->fontsize;
						savenode=listnode(printq);
						/* find all others of this font and size */
						while((q=listnext(printq))!=NULL)
						{
							if(q->c==pr_text && !q->printed)
							{
								if(qIsOnPage)
								{
									/* on page */
									if(strcmp(cfont, q->fontname)==0 &&
											csize==q->fontsize)
									{
										/* same font */
										pdraw_shove_text(q->sx, q->sy, q->s,
											q->r, q->g, q->b);
										q->printed=1;
									} /* if same font and size */

								} /* if on page */
							} /* if pr_text */

						} /* end of search for more of same font */

						setnode(printq, savenode);

					} /* if on page */
				} /* if pr_text, find a text */

			} /* end of print text */

			pdraw_shove_pagetrailer(docfonts);
			freelist(docfonts);
		
		} /* end of something on this page */

	} /* end of each page */
	pdraw_shove_doctrailer(pnum);
}

qentry pdraw_new(t, x1, y1, x2, y2, l, lw, ls, r, g, b)
/* allocate new q entry, and throw on end of q */
/* and update min/max */
/* also, convert coordinates */
print_command t;
int x1, y1, x2, y2, l;
int lw;
tcap_style ls;
int r, g, b;
{
	qentry tmp;

	tmp=(qentry)malloc(sizeof(qentryd));
	if(tmp==NULL)
		return(NULL);

	tmp->c=t;
	tmp->linewidth=lw;
	tmp->capstyle=ls;
	tmp->printed=0;
	tmp->r=r;
	tmp->g=g;
	tmp->b=b;
	if(l==0)
		tmp->s=NULL;
	else
	{
		tmp->s=(char *)malloc(l+1);
		if(tmp->s==NULL)
		{
			free(tmp);
			return(NULL);
		}
	}
	if(outtype==tp_postscript)
	{
		y1=-y1;
		y2=-y2;
	}
	if(maxset)
	{
		if(x2>maxx)
			maxx=x2;
		if(x1<minx)
			minx=x1;
		if(y1>maxy)
			maxy=y1;
		if(y2<miny)
			miny=y2;
	}
	else
	{
		maxx=x2;
		maxy=y1;
		minx=x1;
		miny=y2;
		maxset=1;
	}
	tmp->x1=x1;
	tmp->y1=y1;
	tmp->x2=x2;
	tmp->y2=y2;
	addnode(printq, tmp);
	return(tmp);
}

int pdraw_start(c, f, fname, pagew, pageh, type)
/* page size in normalized canvas pixels */
/* this area will be expanded to fill one paper page */
tcanvas c;
FILE *f;
char *fname;
int pagew, pageh;
tp_type type;
{
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_canvas)
		return(0);
	if(f==NULL)
		return(0);

	printcanvas=c;
	printq=newlist();
	outfile=f;
	outtype=type;
	filename=fname;
	maxset=0;
	pw=pagew;
	ph=pageh;
	/* use to convert to 72dpi */
	hres=tdisplay_dpi_x(c);
	vres=tdisplay_dpi_y(c);

	return(1);
}

int pdraw_end()
{
	qentry q;

	/* actually print it all out */
	if(outtype==tp_postscript)
		pdraw_shove_q();
	else if(outtype==tp_PICT)
		pdraw_shove_q_PICT();

	startlist(printq);
	while((q=listnext(printq))!=NULL)
	{
		if(q->s!=NULL)
			free(q->s);
		free(q);
	}
	freelist(printq);
	outfile=NULL;
	return(1);
}

int pdraw_text(gc, x, y, s, l)
tcontext gc;
int x, y;
char *s;
int l;
{
	int bx, by, bw, bh;
	qentry q;
	tfont font;
	tcolor c;
	int r, g, b;

	bx=x;
	by=y;
	tcontext_get_font(gc, &font);
	tfont_get_extents(font, s, l, &bx, &by, &bw, &bh);
	tcontext_get_foreground(gc, &c);
	tcolor_values(c, &r, &g, &b);

	q=pdraw_new(pr_text, bx, by, bx+bw, by+bh, l, 0, tcap_none, r, g, b);
	if(q==NULL)
		return(0);

	strncpy(q->s, s, l);
	q->s[l]='\0';
	q->fontname=(char *)tfont_get_lasername(font);
	q->fontsize=(int)tfont_get_lasersize(font);
	q->macnum=tfont_get_mac_number(font);
	q->macstyle=tfont_get_mac_style(font);
	q->sx=x;
	if(outtype==tp_postscript)
		q->sy=-y;
	else
		q->sy=y;

	return(1);
}

pdraw_arc(gc, x, y, w, h, a1, a2)
tcontext gc;
int x, y, w, h, a1, a2;
{
	/* don't need yet */
}

pdraw_line(gc, x1, y1, x2, y2)
tcontext gc;
int x1, y1, x2, y2;
{
	int lw;
	tcap_style ls;
	int r, g, b;
	tcolor c;

	tcontext_get_linewidth(gc, &lw);
	tcontext_get_capstyle(gc, &ls);
	tcontext_get_foreground(gc, &c);
	tcolor_values(c, &r, &g, &b);

	if(pdraw_new(pr_line, x1, y1, x2, y2, 0, lw, ls, r, g, b)==NULL)
		return(0);
	else
		return(1);
}

pdraw_rect(gc, x, y, w, h)
tcontext gc;
int x, y, w, h;
{
	/* don't need yet */
}
