#include <stdio.h>

#include <xview/xview.h>
#include <xview/panel.h>
#include "generic.h"
#include "list.h"

typedef struct {
	ltgenericd g;
	Menu m;			/* xview menu */
	Panel_item b;	/* xview button */
	tpitem i;		/* menu item, for submenus */
	list items;		/* pitems */
	} ltpmenud, *ltpmenu;

extern void tpitem_notify();

int tpmenu_right_side(m)
ltpmenu m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pmenu)
		return(0);
	if(m->b==NULL)
		return(0);
	
	return(xv_get(m->b, XV_X)+xv_get(m->b, XV_WIDTH));
}

int tpmenu_bottom_side(m)
ltpmenu m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pmenu)
		return(0);
	if(m->b==NULL)
		return(0);
	
	return(xv_get(m->b, XV_Y)+xv_get(m->b, XV_HEIGHT));
}

tpmenu tpmenu_new(parent, x,y,w,h,right,below, name)
tpanel parent;
int x,y,w,h;
titem right,below;
char *name;
{
	ltpmenu tmp;
	int submenu;

	/* check types */
	if(parent==NULL)
		return(NULL);
	if(titem_type(parent)==lt_panel)
		submenu=0;
	else if(titem_type(parent)==lt_pitem)
		submenu=1;
	else
		return(NULL);
	
	if(name==NULL)
		name="Menu";
	
	tmp=(ltpmenu)titem_new(parent, lt_pmenu, sizeof(ltpmenud));
	if(tmp==NULL)
		return(NULL);
	
	tmp->m=xv_create(NULL, MENU,
		MENU_CLIENT_DATA, tmp,
		MENU_NOTIFY_PROC, tpitem_notify,
		NULL);
	if(tmp->m==NULL)
	{
		titem_free(tmp);
		return(NULL);
	}
	
	/* now menu is created */

	if(!submenu)
	{
		tmp->b=(Panel_item)xv_create(tpanel_xview(parent), PANEL_BUTTON,
			PANEL_LABEL_STRING, name,
			XV_WIDTH, w,
			XV_HEIGHT, h,
			PANEL_ITEM_MENU, tmp->m,
			NULL);
		if(tmp->b==NULL)
		{
			xv_destroy_safe(tmp->m);
			titem_free(tmp);
			return(NULL);
		}
		
		if(right!=NULL)
			x=tp_right_side(right);
		if(below!=NULL)
			y=tp_bottom_side(below);

		xv_set(tmp->b,
			XV_X, x,
			XV_Y, y,
			PANEL_CLIENT_DATA, tmp,
			NULL);
		/* now button is created */
		tmp->i=NULL;
	}
	else
	{
		tmp->b=NULL;
		tpitem_set_submenu(parent, tmp->m);
		tmp->i=parent;
	}


	tmp->items=newlist();

	return(tmp);
}

int tpmenu_free(m)
ltpmenu m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pmenu)
		return(0);
	
	xv_destroy_safe(m->m);
	if(m->b!=NULL)
		xv_destroy_safe(m->b);
	freelist(m->items);
	return(titem_free(m));
}

int tpmenu_enable(m)
ltpmenu m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pmenu)
		return(0);
	
	if(m->b!=NULL)
		xv_set(m->b, PANEL_INACTIVE, FALSE, NULL);
	else
		tpitem_enable(m->i);
	return(1);
}

int tpmenu_disable(m)
ltpmenu m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pmenu)
		return(0);
	
	if(m->b!=NULL)
		xv_set(m->b, PANEL_INACTIVE, TRUE, NULL);
	else
		tpitem_disable(m->i);
	return(1);
}

int tpmenu_add(m, i, after)
ltpmenu m;
tpitem i;
tpitem after;
{
	tpitem current;
	list oldnode;
	Menu_item m1, m2;

	/* check type */
	if(m==NULL || i==NULL)
		return(0);
	if(titem_type(m)!=lt_pmenu || titem_type(i)!=lt_pitem)
		return(0);

	oldnode=listnode(m->items);
	
	if(after==m)
	{
		/* insert item at start */
		m1=tpitem_xview_item(i);
		startlist(m->items);
		if(listnext(m->items)==NULL)
			xv_set(m->m, MENU_APPEND_ITEM, m1, NULL);
		else
			xv_set(m->m, MENU_INSERT, 0, m1, NULL);
		startlist(m->items);
		addnode(m->items, i);
	}
	else if(after==NULL)
	{
		/* add at end */
		endlist(m->items);
		addnode(m->items, i);
		m1=tpitem_xview_item(i);
		xv_set(m->m, MENU_APPEND_ITEM, m1, NULL);
	}
	else
	{
		/* insert after given item */
		if(titem_type(after)!=lt_pitem)
			return(0);
		if(findnode(m->items, after)==NULL)
			return(0);
		m2=tpitem_xview_item(after);
		if(m2==NULL)
			return(0);
		addnode(m->items, i);
		m1=tpitem_xview_item(i);
		xv_set(m->m, MENU_INSERT_ITEM, m2, m1, NULL);
	}

	setnode(m->items, oldnode);
	return(1);
}

int tpmenu_remove(m, i)
ltpmenu m;
tpitem i;
{
	list oldnode;
	Menu_item m1;

	/* check type */
	if(m==NULL || i==NULL)
		return(0);
	if(titem_type(m)!=lt_pmenu || titem_type(i)!=lt_pitem)
		return(0);

	oldnode=listnode(m->items);
	
	if(findnode(m->items, i)==NULL)
		return(0);
	rmcurr(m->items);
	m1=tpitem_xview_item(i);
	xv_set(m->m, MENU_REMOVE_ITEM, m1, NULL);

	setnode(m->items, oldnode);
	return(1);
}

tpitem tpmenu_first_item(m)
ltpmenu m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pmenu)
		return(0);

	startlist(m->items);
	return(listnext(m->items));
}

tpitem tpmenu_next_item(m)
ltpmenu m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pmenu)
		return(0);

	return(listnext(m->items));
}
