#include <stdio.h>

#include <xview/xview.h>
#include <xview/panel.h>
#include "generic.h"
#include "list.h"

typedef struct {
	ltgenericd g;
	Panel_item s;	/* xview stack */
	int exclusive;
	int (*do_events)();
	int is_images;
	int num_choices;
	int cols, rows;
	} ltpstackd, *ltpstack;

int tpstack_right_side(m)
ltpstack m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pstack)
		return(0);
	if(m->s==NULL)
		return(0);
	
	return(xv_get(m->s, XV_X)+xv_get(m->s, XV_WIDTH));
}

int tpstack_bottom_side(m)
ltpstack m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pstack)
		return(0);
	if(m->s==NULL)
		return(0);
	
	return(xv_get(m->s, XV_Y)+xv_get(m->s, XV_HEIGHT));
}

void tpstack_notify(i, v, e)
Panel_item i;
int v;
Event *e;
{
    ltpstack t;
	tevent te;

    t=(ltpstack)xv_get(i, PANEL_CLIENT_DATA);

    if(t->do_events!=NULL)
	{
		te=tevent_create_from_xviewevent(e, event_x(e), event_y(e), 0, 0);
		(void) (*t->do_events)(t, v, te);
		tevent_free(te);
	}
}

tpstack tpstack_new(parent, x,y,w,h,right,below, name, exclusive, cols, rows)
tpanel parent;
int x,y,w,h;
titem right,below;
char *name;
int exclusive;
int cols, rows;
{
	ltpstack tmp;

	/* check types */
	if(parent==NULL)
	    return(NULL);
	if(titem_type(parent)!=lt_panel)
	    return(NULL);
	

	if(name==NULL)
	    name="Stack";
	
	tmp=(ltpstack)titem_new(parent, lt_pstack, sizeof(ltpstackd));
	if(tmp==NULL)
	    return(NULL);
	
	tmp->s=(Panel_item)xv_create(tpanel_xview(parent), PANEL_CHOICE_STACK,
		PANEL_LABEL_STRING, name,
		XV_WIDTH, w,
		XV_HEIGHT, h,
		NULL);
	if(tmp->s==NULL)
	{
		titem_free(tmp);
		return(NULL);
	}
	
	if(right!=NULL)
		x=tp_right_side(right);
	if(below!=NULL)
		y=tp_bottom_side(below);

	xv_set(tmp->s,
		XV_X, x,
		XV_Y, y,
		PANEL_CLIENT_DATA, tmp,
		PANEL_NOTIFY_PROC, tpstack_notify,
		NULL);

	/* now stack is created */

	tmp->exclusive=exclusive;
	if(exclusive)
	    xv_set(tmp->s, PANEL_TOGGLE, FALSE, NULL);
	else
	    xv_set(tmp->s, PANEL_TOGGLE, TRUE, NULL);

	tmp->is_images=-1;
	tmp->num_choices=0;
	tmp->cols=cols;
	tmp->rows=rows;
	return(tmp);
}

int tpstack_free(m)
ltpstack m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pstack)
		return(0);
	
	xv_destroy_safe(m->s);
	return(titem_free(m));
}

int tpstack_enable(m)
ltpstack m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pstack)
		return(0);
	
	xv_set(m->s, PANEL_INACTIVE, FALSE, NULL);
	return(1);
}

int tpstack_disable(m)
ltpstack m;
{
	/* check type */
	if(m==NULL)
		return(0);
	if(titem_type(m)!=lt_pstack)
		return(0);
	
	xv_set(m->s, PANEL_INACTIVE, TRUE, NULL);
	return(1);
}

int tpstack_add(m, name, vertical)
ltpstack m;
char *name;
int vertical;
{
    /* check type */
    if(m==NULL || name==NULL)
	    return(0);
    if(titem_type(m)!=lt_pstack)
	    return(0);
    if(m->is_images==-1)
	m->is_images=0;
    else if(m->is_images)
	return(0);

    if(vertical)
	xv_set(m->s,
	    PANEL_LAYOUT, PANEL_VERTICAL,
	    PANEL_CHOICE_STRING, m->num_choices, name,
	    NULL);
    else
	xv_set(m->s,
	    PANEL_LAYOUT, PANEL_HORIZONTAL,
	    PANEL_CHOICE_STRING, m->num_choices, name,
	    NULL);
    m->num_choices++;
    if(m->num_choices==1 && m->exclusive)
	xv_set(m->s, PANEL_VALUE, 0, NULL);

    return(1);
}

int tpstack_add_image(m, p, vertical)
ltpstack m;
tpic p;
int vertical;
{
    /* check type */
    if(m==NULL || p==NULL)
	return(0);
    if(titem_type(m)!=lt_pstack || titem_type(p)!=lt_pic)
	return(0);
    if(m->is_images==-1)
	m->is_images=1;
    else if(!m->is_images)
	return(0);


    if(vertical)
	xv_set(m->s,
	    PANEL_LAYOUT, PANEL_VERTICAL,
	    PANEL_CHOICE_IMAGE, m->num_choices, tpic_xview(p),
	    NULL);
    else
	xv_set(m->s,
	    PANEL_LAYOUT, PANEL_HORIZONTAL,
	    PANEL_CHOICE_IMAGE, m->num_choices, tpic_xview(p),
	    NULL);
    m->num_choices++;
    if(m->num_choices==1 && m->exclusive)
	xv_set(m->s, PANEL_VALUE, 0, NULL);

    return(1);
}

char *tpstack_nth_string(m, n)
ltpstack m;
int n;
{
	/* check type */
	if(m==NULL)
		return(NULL);
	if(titem_type(m)!=lt_pstack)
		return(NULL);
	if(m->is_images!=0 || n<0 || n>=m->num_choices)
		return(NULL);

	return((char *)xv_get(m->s, PANEL_CHOICE_STRING, n));
}

int tpstack_selected(m)
ltpstack m;
{
    /* check type */
    if(m==NULL)
	return(NULL);
    if(titem_type(m)!=lt_pstack)
	return(NULL);
    if(!m->exclusive)
	return(NULL);

    return(xv_get(m->s, PANEL_VALUE));
}

int tpstack_is_selected(m, i)
ltpstack m;
int i;
{
    unsigned v;

    /* check type */
    if(m==NULL)
	return(NULL);
    if(titem_type(m)!=lt_pstack)
	return(NULL);
    if(m->exclusive || i<0 || i>=m->num_choices)
	return(NULL);

    v=(unsigned)xv_get(m->s, PANEL_VALUE);
    return(v && (1>>i));
}

int tpstack_select_item(m, i)
ltpstack m;
int i;
{
    unsigned v;

    /* check type */
    if(m==NULL || i==NULL)
	return(0);
    if(titem_type(m)!=lt_pstack)
	return(0);
    if(i<0 || i>=m->num_choices)
	return(NULL);

    if(m->exclusive)
		xv_set(m->s, PANEL_VALUE, i, NULL);
    else
    {
		v=(unsigned)xv_get(m->s, PANEL_VALUE);
		v=v||(1>>i);
		xv_set(m->s, PANEL_VALUE, v, NULL);
    }
    return(1);
}

int tpstack_unselect_item(m, i)
ltpstack m;
int i;
{
    unsigned v;

    /* check type */
    if(m==NULL || i==NULL)
	return(0);
    if(titem_type(m)!=lt_pstack)
	return(0);
    if(m->exclusive || i<0 || i>=m->num_choices)
	return(NULL);

    v=(unsigned)xv_get(m->s, PANEL_VALUE);
    v=v^(1>>i);
    xv_set(m->s, PANEL_VALUE, v, NULL);
    return(1);
}

int tpstack_set_event_procedure(t, do_events)
ltpstack t;
int (*do_events)();
{
    /* check type */
    if(t==NULL)
	return(0);
    if(titem_type(t)!=lt_pstack)
	return(0);

    t->do_events=do_events;
    return(1);
}
