#include <stdio.h>

#include <xview/xview.h>
#include <xview/panel.h>
#include "generic.h"

typedef struct {
	ltgenericd g;
	Panel_item t;	/* xview panel item */
	tptext_action (*do_events)();
	} ltptextd, *ltptext;

int tptext_right_side(t)
ltptext t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_ptext)
		return(0);
	
	return(xv_get(t->t, XV_X)+xv_get(t->t, XV_WIDTH));
}

int tptext_bottom_side(t)
ltptext t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_ptext)
		return(0);
	
	return(xv_get(t->t, XV_Y)+xv_get(t->t, XV_HEIGHT));
}

Panel_setting tptext_notify(item, e)
Panel_item item;
Event *e;
{
	ltptext t;
	tptext_action a;
	tevent te;

	t=(ltptext)xv_get(item, PANEL_CLIENT_DATA);

	if(t->do_events!=NULL)
	{
		te=tevent_create_from_xviewevent(e, event_x(e), event_y(e), 0, 0);
		a=(*t->do_events)(t, te);
		tevent_free(te);
		switch(a)
		{
			case tptext_next:
				return(PANEL_NEXT);
			case tptext_previous:
				return(PANEL_PREVIOUS);
			case tptext_insert:
				return(PANEL_INSERT);
			case tptext_none:
				return(PANEL_NONE);
			case tptext_dontknow:
			default:
				return(panel_text_notify(item, e));
		}
	}
	else
		return(panel_text_notify(item, e));
}

tptext tptext_new(parent, x,y,w,h,right,below, name)
tpanel parent;
int x,y,w,h;
titem right,below;
char *name;
{
	ltptext tmp;

	/* check types */
	if(parent==NULL)
		return(NULL);
	if(titem_type(parent)!=lt_panel)
		return(NULL);
	
	if(name==NULL)
		name="Text Item";
	
	tmp=(ltptext)titem_new(parent, lt_ptext, sizeof(ltptextd));
	if(tmp==NULL)
		return(NULL);
	
	tmp->t=(Panel_item)xv_create(tpanel_xview(parent), PANEL_TEXT,
		PANEL_LABEL_STRING, name,
		XV_WIDTH, w,
		XV_HEIGHT, h,
		NULL);
	
	if(right!=NULL)
		x=tp_right_side(right);
	if(below!=NULL)
		y=tp_bottom_side(below);

	xv_set(tmp->t,
		XV_X, x,
		XV_Y, y,
		PANEL_CLIENT_DATA, tmp,
		PANEL_NOTIFY_LEVEL, PANEL_ALL,
		PANEL_NOTIFY_PROC, tptext_notify,
		NULL);

	tmp->do_events=NULL;

	return(tmp);
}

tptext_set_displayed_characters(t, n)
ltptext t;
int n;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_ptext)
		return(0);
	
	xv_set(t->t, PANEL_VALUE_DISPLAY_LENGTH, n, NULL);
}

int tptext_free(t)
ltptext t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_ptext)
		return(0);
	
	xv_destroy_safe(t->t);
	return(titem_free(t));
}

char *tptext_get_val(t)
ltptext t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_ptext)
		return(0);
	
	return((char *)xv_get(t->t, PANEL_VALUE));
}

int tptext_set_val(t, s)
ltptext t;
char *s;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_ptext)
		return(0);
	
	xv_set(t->t, PANEL_VALUE, s, NULL);
	return(1);
}

int tptext_enable(t)
ltptext t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_ptext)
		return(0);
	
	xv_set(t->t, PANEL_INACTIVE, FALSE, NULL);
	return(1);
}

int tptext_disable(t)
ltptext t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_ptext)
		return(0);
	
	xv_set(t->t, PANEL_INACTIVE, TRUE, NULL);
	return(1);
}

int tptext_set_event_procedure(t, do_events)
ltptext t;
tptext_action (*do_events)();
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_ptext)
		return(0);
	
	t->do_events=do_events;
	return(1);
}

tptext_set_current(t)
ltptext t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_ptext)
		return(0);
	
	xv_set(xv_get(t->t, PANEL_PARENT_PANEL), PANEL_CARET_ITEM, t->t, NULL);
}
