#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

int do_drag_branch(c, e, x, y, f)
tcanvas c;
tevent e;
int x, y;
int (*f)();
{
	static int dragging=0;
	static treebranch dragbranch;
	static double dragdistance;
	static double dragpercent;
	static tree dragtree;
	static char s[100];
	static treebranch lastbranch;
	static unsigned long lasttime, thistime;

	static int result;

	result=0;

	if(installing)
	{
		dragging=0;
		lastbranch=NULL;
		canvas_add_event_function(do_drag_branch, f);
		return(1);
	}
	else if(uninstalling)
	{
		canvas_remove_event_function(do_drag_branch);
		return(1);
	}
	else if(printing) printf("zdragbranch\n");

	switch(tevent_type(e))
	{
		case te_mousedown:
			if(!dragging)
			{
				dragbranch=(treebranch)which_branch(c, x, y, &dragpercent);
				if(dragbranch!=NULL)
				{
					thistime=tevent_time(e);
					if(lastbranch==dragbranch && thistime-lasttime<DBLCLICK)
					{
						show_branch_info_frame();
						lastbranch=NULL;
						select_by_state(BranchPointSel,
							dragbranch, dragpercent, e);
						result=1;
					}
					else
					{
						lasttime=thistime;
						lastbranch=dragbranch;

						select_by_state(NoSel, NULL, 0.0, e);
						dragging=1;
						install_dragging_function(do_drag_branch);
						branchdistance(dragbranch, &dragdistance);
						drag_branch_point_selection(dragbranch,
							dragpercent, c);
						sprintf(s,
							"Percent from parent: %6.2lf (distance:%8.4lf)",
							dragpercent*100, dragdistance*dragpercent);
						set_main_message(s);
						result=1;
					}
				}
			}
			else
				result=1;
			break;
		case te_mouseup:
			if(dragging)
			{
				drag_branch_point_selection(dragbranch,
					dragpercent, c);
				near_branch(dragbranch, x, y, &dragpercent);
				select_by_state(BranchPointSel, dragbranch, dragpercent, e);
				dragging=0;
				uninstall_dragging_function(do_drag_branch);
				result=1;
			}
			break;
		case te_drag:
			if(dragging)
			{
				drag_branch_point_selection(dragbranch,
					dragpercent, c);
				near_branch(dragbranch, x, y, &dragpercent);
				drag_branch_point_selection(dragbranch,
					dragpercent, c);
				sprintf(s,
					"Percent from parent: %6.2lf (distance:%8.4lf)",
					dragpercent*100, dragdistance*dragpercent);
				set_main_message(s);
				result=1;
			}
			break;
		default:
			if(dragging)
				result=1;
			break;
	}
	return(result);
}
