/*
 * xcutbuf.c : Retrieve value of an X cut buffer
 *
 * George Ferguson, ferguson@cs.rochester.edu, 9 Feb 1993.
 *
 * Compile with local variant of:
 *	cc -o xcutbuf -I/usr/staff/include xcutbuf.c -L/usr/staff/lib -lX11
 *
 */

#include <stdio.h>
#include <X11/Xlib.h>
extern char *getenv();

char *program;

static void
usage()
{
    fprintf(stderr,"usage: %s [-display display] [0-7]\n",program);
    exit(1);
}

main(argc,argv)
int argc;
char *argv[];
{

    Display *display;
    char *dispname = NULL, *data;
    int bufnum = 0, n;

    program = argv[0];
    argc -= 1;
    argv += 1;
    while (argc > 0) {
	if (strncmp(argv[0],"-d",2) == 0) {
	    if (argc == 1) {
		usage();
	    } else {
		dispname = argv[1];
		argc -= 1;
		argv += 1;
	    }
	} else if (*argv[0] < '0' || *argv[0] > '7') {
	    usage();
	} else {
	    bufnum = *argv[0] - '0';
	}
	argc -= 1;
	argv += 1;
    }
    if ((display=XOpenDisplay(dispname)) == NULL) {
	if (dispname == NULL)
	    dispname = getenv("DISPLAY");
	if (dispname == NULL)
	    dispname = "(null)";
	fprintf(stderr,"%s: couldn't open display \"%s\"\n",program,dispname);
	exit(2);
    }
    data = XFetchBuffer(display,&n,bufnum);
    if (data != NULL) {
	printf(data);
	XFree(data);
    }
    XCloseDisplay(display);
    exit(0);
}
