/************************** color reduction ****************************

			Copyright 1993-1996 by Susumu Shiohara

					All Rights Reserved

************************************************************************/

#include "xslideshow.h"

#if defined(__STDC__) || defined(__cplusplus)
# define P_(s) s
#else
# define P_(s) ()
#endif

extern void myevent P_(());
extern void goodbyekiss P_(());

/******************************* Median Cut *****************************/

typedef struct {
	byte min;
	byte max;
} Element;

typedef struct {
	long num_pix;
	word start_idx,end_idx;
	Element	r,g,b;
} ColorSpace;

typedef struct {
	word rgb;
	word num;
} NumPix;

static ColorSpace *colorSpaceTable;
static int numSpace;
static word *rgbTable;
static word *colorElementTable;
static word red[256],green[256],blue[256];

#define ABOUT_RED   0
#define ABOUT_GREEN 1
#define ABOUT_BLUE	2

#if defined(__STDC__) || defined(__cplusplus)
static void qsortRed(int from,int to)
#else
static void qsortRed(from,to)
int from,to;
#endif
{
int i,j;
int mean,tmp;

	i=from;
	j=to;
	mean=(GET_RGB(rgbTable[i])+GET_RGB(rgbTable[j]))/2;
	while(True){
		while(GET_RGB(rgbTable[i])>mean) i++;
		while(GET_RGB(rgbTable[j])<mean) j--;
		if(i<=j){
			tmp=rgbTable[i];
			rgbTable[i]=rgbTable[j];
			rgbTable[j]=tmp;
			i++;
			j--;
		}
		else
			break;
	}
	if(from<j) qsortRed(from,j);
	if(i<to) qsortRed(i,to);
}

#if defined(__STDC__) || defined(__cplusplus)
static void qsortGreen(int from,int to)
#else
static void qsortGreen(from,to)
int from,to;
#endif
{
int i,j;
int mean,tmp;

	i=from;
	j=to;
	mean=(GET_GRB(rgbTable[i])+GET_GRB(rgbTable[j]))/2;
	while(True){
		while(GET_GRB(rgbTable[i])>mean) i++;
		while(GET_GRB(rgbTable[j])<mean) j--;
		if(i<=j){
			tmp=rgbTable[i];
			rgbTable[i]=rgbTable[j];
			rgbTable[j]=tmp;
			i++;
			j--;
		}
		else
			break;
	}
	if(from<j) qsortGreen(from,j);
	if(i<to) qsortGreen(i,to);
}

#if defined(__STDC__) || defined(__cplusplus)
static void qsortBlue(int from,int to)
#else
static void qsortBlue(from,to)
int from,to;
#endif
{
int i,j;
int mean,tmp;

	i=from;
	j=to;
	mean=(GET_BGR(rgbTable[i])+GET_BGR(rgbTable[j]))/2;
	while(True){
		while(GET_BGR(rgbTable[i])>mean) i++;
		while(GET_BGR(rgbTable[j])<mean) j--;
		if(i<=j){
			tmp=rgbTable[i];
			rgbTable[i]=rgbTable[j];
			rgbTable[j]=tmp;
			i++;
			j--;
		}
		else
			break;
	}
	if(from<j) qsortBlue(from,j);
	if(i<to) qsortBlue(i,to);
}

#if defined(__STDC__) || defined(__cplusplus)
static void updateSpace(word cur_idx, int about)
#else
static void updateSpace(cur_idx, about)
word cur_idx;
int	about;
#endif
{
word idx, end_idx, min, max, rgb, color;
long total_numpix=0;

	idx=colorSpaceTable[cur_idx].start_idx;
	end_idx=colorSpaceTable[cur_idx].end_idx;
	switch(about){
	case ABOUT_RED:
		min=max=GET_R(rgbTable[idx]);
		for(;idx<=end_idx;idx++){
			rgb=rgbTable[idx];
			total_numpix +=colorElementTable[rgb];
			color=GET_R(rgb);
			if(max<color) max=color;
			else if(min>color) min=color;
		}
		colorSpaceTable[cur_idx].r.min=min;
		colorSpaceTable[cur_idx].r.max=max;
		break;
	case ABOUT_GREEN:
		min=max=GET_G(rgbTable[idx]);
		for(;idx<=end_idx;idx++){
			rgb=rgbTable[idx];
			total_numpix +=colorElementTable[rgb];
			color=GET_G(rgb);
			if(max<color) max=color;
			else if(min>color) min=color;
		}
		colorSpaceTable[cur_idx].g.min=min;
		colorSpaceTable[cur_idx].g.max=max;
		break;
	case ABOUT_BLUE:
		min=max=GET_B(rgbTable[idx]);
		for(;idx<=end_idx;idx++){
			rgb=rgbTable[idx];
			total_numpix +=colorElementTable[rgb];
			color=GET_B(rgb);
			if(max<color) max=color;
			else if(min>color) min=color;
		}
		colorSpaceTable[cur_idx].b.min=min;
		colorSpaceTable[cur_idx].b.max=max;
		break;
	}
	colorSpaceTable[cur_idx].num_pix=total_numpix;
}

#if defined(__STDC__) || defined(__cplusplus)
static void splitColorSpace(word cur_idx)
#else
static void splitColorSpace(cur_idx)
word cur_idx;
#endif
{
byte r_dist, g_dist, b_dist;
word idx, start_idx, end_idx, num_idx, median_idx, new_idx;
long threshold, numpix, total_numpix=0;
int	about;

	idx=colorSpaceTable[cur_idx].start_idx;
	num_idx=colorSpaceTable[cur_idx].end_idx-idx+1;

	r_dist=colorSpaceTable[cur_idx].r.max-colorSpaceTable[cur_idx].r.min;
	g_dist=colorSpaceTable[cur_idx].g.max-colorSpaceTable[cur_idx].g.min;
	b_dist=colorSpaceTable[cur_idx].b.max-colorSpaceTable[cur_idx].b.min;

	if(r_dist>g_dist)
		about=(r_dist>b_dist ? ABOUT_RED:ABOUT_BLUE);
	else
		about=(g_dist>b_dist ? ABOUT_GREEN:ABOUT_BLUE);

	switch(about){
	case ABOUT_RED: qsortRed(idx,idx+num_idx-1); break;
	case ABOUT_GREEN: qsortGreen(idx,idx+num_idx-1); break;
	case ABOUT_BLUE: qsortBlue(idx,idx+num_idx-1); break;
	}

	threshold=colorSpaceTable[cur_idx].num_pix/2;
	start_idx=colorSpaceTable[cur_idx].start_idx;
	end_idx=colorSpaceTable[cur_idx].end_idx;


	/*
	Find out the mediaun index for all color element
	*/
	for(idx=median_idx=start_idx;idx<=end_idx;idx++){
		numpix=colorElementTable[rgbTable[idx]];
		if((total_numpix+numpix) < threshold){
			total_numpix += numpix;
			median_idx=idx;
		}
		else if((total_numpix+numpix) == threshold
			||	(total_numpix+(numpix/2)) < threshold){
			median_idx=idx;
			break;
		}
		else {
			break;
		}
	}


	/*
	Split the space
	*/
	new_idx=numSpace;
	colorSpaceTable[new_idx]=colorSpaceTable[cur_idx];
	colorSpaceTable[new_idx].start_idx=median_idx+1;
	colorSpaceTable[cur_idx].end_idx=median_idx;


	/*
	Update current space
	*/
	updateSpace(cur_idx,about);
	

	/*
	Update new (another) space
	*/
	updateSpace(new_idx,about);

}


/*
* Create a color space
*/
static void initSpace()
{
word idx,end_idx;
word r_min,r_max,g_min,g_max,b_min,b_max;
word rgb,r,g,b;
long total_numpix=0;

	idx=colorSpaceTable[0].start_idx;
	r_min=r_max=GET_R(rgbTable[idx]);
	g_min=g_max=GET_G(rgbTable[idx]);
	b_min=b_max=GET_B(rgbTable[idx]);
	end_idx=colorSpaceTable[0].end_idx;

	for(;idx<=end_idx;idx++){
		rgb=rgbTable[idx];
		total_numpix +=colorElementTable[rgb];
		r=GET_R(rgb);
		g=GET_G(rgb);
		b=GET_B(rgb);
		if(r_max<r) r_max=r; else if(r_min>r) r_min=r;
		if(g_max<g) g_max=g; else if(g_min>g) g_min=g;
		if(b_max<b) b_max=b; else if(b_min>b) b_min=b;
	}

	colorSpaceTable[0].r.min=r_min; colorSpaceTable[0].r.max=r_max;
	colorSpaceTable[0].g.min=g_min; colorSpaceTable[0].g.max=g_max;
	colorSpaceTable[0].b.min=b_min; colorSpaceTable[0].b.max=b_max;
	colorSpaceTable[0].num_pix=total_numpix;
}



#if defined(__STDC__) || defined(__cplusplus)
static void qsortNumPix(NumPix *p,int from,int to)
#else
static void qsortNumPix(p,from,to)
NumPix *p;
int from,to;
#endif
{
int i,j;
word mean,tmprgb,tmpnum;

	i=from;
	j=to;
	mean=(word)((int)(p[i].num+p[j].num))/2;
	while(True){
		while(p[i].num>mean) i++;
		while(p[j].num<mean) j--;
		if(i<=j){
			tmprgb=p[i].rgb;
			tmpnum=p[i].num;
			p[i].rgb=p[j].rgb;
			p[i].num=p[j].num;
			p[j].rgb=tmprgb;
			p[j].num=tmpnum;
			i++;
			j--;
		}
		else
			break;
	}
	if(from<j) qsortNumPix(p,from,j);
	if(i<to) qsortNumPix(p,i,to);
}


/*
*
*/
#if False
static void makeColorMap()
{
int idx;
long r,g,b;
word i,rgb,numpix,numidx,threshold;
NumPix *npp;

	for(idx=0;idx<numSpace;idx++){
		numidx=colorSpaceTable[idx].end_idx-colorSpaceTable[idx].start_idx+1;
		if((npp=(NumPix *)XtMalloc(sizeof(NumPix) * numidx))==NULL){
			fprintf(stderr,"xslideshow: mediancut() memory allocation error\n");
			goodbyekiss();
		}
		for(i=0; i<numidx; i++){
			rgb=rgbTable[i+colorSpaceTable[idx].start_idx];
			npp[i].rgb=rgb;
			npp[i].num=colorElementTable[rgb];
		}
		if(numidx>1) qsortNumPix(npp,0,numidx-1);
		threshold = colorSpaceTable[idx].num_pix/2;
		if(threshold==0) threshold=1;
		for(numpix=0,r=0,g=0,b=0,i=0; i<numidx; i++){
			numpix += npp[i].num;
			rgb = npp[i].rgb;
			r += (long)GET_R(rgb)*npp[i].num;
			g += (long)GET_G(rgb)*npp[i].num;
			b += (long)GET_B(rgb)*npp[i].num;
			if(numpix >= threshold){
				break;
			}
		}
		red[idx]  =(byte)(r*8/numpix);
		green[idx]=(byte)(g*8/numpix);
		blue[idx] =(byte)(b*8/numpix);
		XtFree((char *)npp);
	}
}
#else
static void makeColorMap()
{
int idx,numpix,numelem;
dword r,g,b;
word i,rgb;

	for(idx=0;idx<numSpace;idx++){
		for(r=0,g=0,b=0,i=colorSpaceTable[idx].start_idx;
				i<=colorSpaceTable[idx].end_idx;
				i++){
			rgb=rgbTable[i];
			numelem=colorElementTable[rgb];
			r += (dword)GET_R(rgb)*numelem;
			g += (dword)GET_G(rgb)*numelem;
			b += (dword)GET_B(rgb)*numelem;
		}
		numpix=colorSpaceTable[idx].num_pix;
		red[idx]  =(byte)(r*8/numpix);
		green[idx]=(byte)(g*8/numpix);
		blue[idx] =(byte)(b*8/numpix);
	}
}
#endif


/*
*
*/
#if defined(__STDC__) || defined(__cplusplus)
static int doMedianCut(int num_color)
#else
static int doMedianCut(num_color)
int num_color;
#endif
{
word i, rgb;
int idx, max_idx;
long num_pix;

	/* List a color to the color element table */
	for(idx=0,i=0;i<MAX_COLOR_24;i++) {
		if(colorElementTable[i]) /* element number > 0 */
			rgbTable[idx++]=i;
	}

	colorSpaceTable[0].start_idx=0;
	colorSpaceTable[0].end_idx=idx-1;
	colorSpaceTable[0].r.min=colorSpaceTable[0].g.min=colorSpaceTable[0].b.min=0;
	colorSpaceTable[0].r.max=colorSpaceTable[0].g.max=colorSpaceTable[0].b.max=31;
	/* a color is max 5bit (0x1f = 31) */


	/*
	Find out the min,max color value and total elem num in a color space
	*/
	initSpace();



	/*
	Split the color space until its number becomes specified color number.
	*/
	for(numSpace=1;numSpace<num_color;numSpace++) {

		/*
		Find out the most populated space
		*/
		for(num_pix=0,max_idx= -1,idx=0;
				idx<numSpace;
				idx++) {
			if(colorSpaceTable[idx].start_idx<colorSpaceTable[idx].end_idx
				&& num_pix<(long)colorSpaceTable[idx].num_pix) {
				num_pix=colorSpaceTable[idx].num_pix;
				max_idx=idx;
			}
		}
		if(max_idx<0) break;

		/*
		Split the space
		*/
		splitColorSpace(max_idx);

		myevent();
	}



	/*
	Calculate the center of gravity about each color space
	and make it the representative color of the space.
	*/
	makeColorMap();




	/*
	Create the index color conversion table
	*/
	for(i=0;i<(word)numSpace;i++) {
		for(rgb=colorSpaceTable[i].start_idx;
			rgb<=colorSpaceTable[i].end_idx;
			rgb++) {
			colorElementTable[rgbTable[rgb]]=i;
		}
	}


	return(numSpace);
}

/*
*
*/
#if defined(__STDC__) || defined(__cplusplus)
void mediancut(int numcolor)
#else
void mediancut(numcolor)
int numcolor;
#endif
{
int i,j;
byte *src,*dst,r,g,b;
word rgb;

	if((rgbTable=(word *)XtCalloc(MAX_COLOR_24, sizeof(word)))==NULL){
		fprintf(stderr,"xslideshow: mediancut() memory allocation error\n");
		goodbyekiss();
	}
	if((colorSpaceTable=(ColorSpace *)XtCalloc(256, sizeof(ColorSpace)))==NULL){
		fprintf(stderr,"xslideshow: mediancut() memory allocation error\n");
		goodbyekiss();
	}
	if((colorElementTable=(word *)XtCalloc(MAX_COLOR_24,sizeof(word)))==NULL){
		fprintf(stderr,"xslideshow: mediancut() memory allocation error\n");
		goodbyekiss();
	}



	if(app_data.verbose)
		fprintf(stderr,"xslideshow: mediancut() median cut\n");



	/* Make the histgram */
	if(gim.subImageList->bits_per_pixel == 8) {
		for(src=gim.subImageList->image,j=0;
			j<gim.subImageList->height;
			j++	){
			for(i=0;i<gim.subImageList->width;i++) {
				r=(byte)gim.subImageList->red[*src];
				g=(byte)gim.subImageList->green[*src];
				b=(byte)gim.subImageList->blue[*src++];
				rgb=PUT_RGB(r,g,b);
				if(colorElementTable[rgb]<MAX_COLOR_24)
					colorElementTable[rgb] += 1;
			}
			myevent();
		}
	}
	else {
		for(src=gim.subImageList->image,j=0;
			j<gim.subImageList->height;
			j++	){
			for(i=0;i<gim.subImageList->width;i++) {
				r= *src++;
				g= *src++;
				b= *src++;
				rgb=PUT_RGB(r,g,b);
				if(colorElementTable[rgb]<MAX_COLOR_24)
					colorElementTable[rgb] += 1;
			}
			myevent();
		}
	}



	/* Split the color space */
	gim.subImageList->mapsize=doMedianCut(numcolor);
	XtFree((char *)rgbTable);
	XtFree((char *)colorSpaceTable);



	/* Update the pixel map */
	src=(byte *)gim.subImageList->image;
	dst=(byte *)gim.subImageList->image;
	if(gim.subImageList->bits_per_pixel == 8) {
		for(j=0;j<gim.subImageList->height;j++){
			for(i =0;i<gim.subImageList->width;i++,dst++){
				r=(byte)gim.subImageList->red[*src];
				g=(byte)gim.subImageList->green[*src];
				b=(byte)gim.subImageList->blue[*src++];
				*dst=(byte)(colorElementTable[PUT_RGB(r,g,b)]);
			}
			myevent();
		}
	}
	else {
		for(j=0;j<gim.subImageList->height;j++){
			for(i =0;i<gim.subImageList->width;i++,dst++){
				r= *src++;
				g= *src++;
				b= *src++;
				*dst=(byte)(colorElementTable[PUT_RGB(r,g,b)]);
			}
			myevent();
		}
	}
	XtFree((char *)colorElementTable);




	/* Update the color map table */
	for(i=0;i<gim.subImageList->mapsize;i++){
		gim.subImageList->red[i]  =red[i];
		gim.subImageList->green[i]=green[i];
		gim.subImageList->blue[i] =blue[i];
	}



	/* Update the image */
	gim.subImageList->image=(byte *)XtRealloc((char *)gim.subImageList->image, sizeof(char) * gim.subImageList->width * gim.subImageList->height);
	gim.subImageList->bits_per_pixel=8;



	if(app_data.verbose)
		fprintf(stderr,"xslideshow: mediancut() done.\n");
}

