/*
   resource.h

   Author:   Susumu Shiohara (shiohara@tpp.epson.co.jp)

          Copyright 1993-1997 by Susumu Shiohara

                    All Rights Reserved

*/

/* Define options */
static XtResource resources[]={

	{"geometry", "Geometry",
		XtRString, sizeof(char *),
		XtOffset(ApplicationDataPtr, geometry),
		XtRString, ""},	/* Specify the window geometry */


/* Show help message */
	{"help", "Help",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, help),
		XtRString, "False"},



/* Stuff options */
	{"debug", "Debug",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, debug),
		XtRString, "False"},

	{"verbose", "Verbose",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, verbose),
		XtRString, "False"},



/* Default translations */
#if False
		tail_frame()   		/* go to bottom of the frame */
       	head_frame()   		/* go to top of the frame */
       	next_frame()   		/* go to next frame */
       	prev_frame()   		/* go to previous frame */
       	change_frame()   	/* go to next or previous frame */
       	pause_frame()   	/* pause */
       	stop()   			/* exit xslideshow */
       	resize()   			/* resize the image to the original size */
       	fit()   			/* resize the image to the window size */
       	right()   			/* move the image position to right in an window */
       	left()   			/* move the image position to left in an window */
       	up()   				/* move the image position to up in an window */
       	down()   			/* move the image position to down in an window */
       	remove()   			/* remove the image file */
       	move()   			/* move the image file to the specified path */
#endif

	{"translations", "Translations",
		XtRString, sizeof(String),
		XtOffset(ApplicationDataPtr, translations),
		XtRString, 
		 " Shift<Btn1Down>: tail_frame()\n\
       	   Shift<Btn2Down>: stop()\n\
       	            <Key>q: stop()\n\
       	        Ctrl<Key>c: stop()\n\
       	   Shift<Btn3Down>: head_frame()\n\
       	        <Btn1Down>: next_frame()\n\
       	            <Key>n: next_frame()\n\
       	        <Btn2Down>: pause_frame()\n\
       	            <Key>s: pause_frame()\n\
       	        <Btn3Down>: prev_frame()\n\
       	            <Key>p: prev_frame()\n\
       	        <Key>space: change_frame()\n\
       	            <Key>r: resize()\n\
       	            <Key>f: fit()\n\
       	            <Key>h: right()\n\
       	            <Key>l: left()\n\
       	            <Key>j: up()\n\
       	            <Key>k: down()\n\
       	        Ctrl<Key>x: remove()\n\
       	            <Key>m: move()\n\
     <Message>WM_PROTOCOLS: quit()" },
	


/* Window drawing options */
	{"root", "Root",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, root),
		XtRString, "False"},	/* Draw a window on a root window */

	{"override", "Override",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, override),
		XtRString, "False"},	/* Draw a window with no matte */


/* Window sizing options */
	{"full", "Full",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, full),
		XtRString, "False"},	/* Draw a max sized window */

	{"resize", "Resize",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, resize),
		XtRString, "False"},	/* Draw a window with the original image size */

	{"fit", "Fit",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, fit),
		XtRString, "True"},		/* Fit the image size to the window size */

	{"maxfit", "Maxfit",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, maxfit),
		XtRString, "False"},	/* Fit the image size to the window size even if the image size is smaller than the window size */



/* Display options */
	{"clock", "Clock",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, clock),
		XtRString, "False"},	/* Draw a digital clock on top of the window */

	{"clockMilitary", "ClockMilitary",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, clockMilitary),
		XtRString, "False"},	/* Draw a digital clock with military mode */

	{"clockSeconds", "ClockSeconds",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, clockSeconds),
		XtRString, "False"},	/* Draw a digital clock with second */

	{"biff", "Biff",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, biff),
		XtRString, "False"},	/* Enable mail biff */

	{"mail_spool", "Mail_spool",
		XtRString, sizeof(char *),
		XtOffset(ApplicationDataPtr, mail_spool),
		XtRString, "/usr/spool/mail"},	/* Specify the mail spooling path */

	{"showFileName", "ShowFileName",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, showFileName),
		XtRString, "False"},	/* Show the file name */

	{"showFilePath", "ShowFilePath",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, showFilePath),
		XtRString, "False"},	/* Show the file name with full path */

	{XtNfont, XtCFont,
		XtRFontStruct, sizeof(XFontStruct *),
		XtOffset(ApplicationDataPtr, font),
		XtRString, "-adobe-times-bold-i-normal--*-240-*-*-p-*-iso8859-1"},




/* Color and Colormap options */
	{"private", "Private",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, privateCmap),
		XtRString, "False"},	/* Use a private colormap */

	{"color", "Color",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, color),
		XtRImmediate, (XtPointer)256},	/* Specify the number of colors */




/* Reduce algorithms
		Quality
		perfect >> dither >> quantize > nquant >> mediancut

		Initial Speed
		mediancut >> dither >> nquant > quantize >> perfect

		Final speed
		perfect >> mediancut >> dither >> nquant > quantize
*/
	{"reduce", "Reduce",
		XtRString, sizeof(char *),
		XtOffset(ApplicationDataPtr, reduce),
		XtRString, "dither"},	/* dither, mediancut, quantize, nquant */

	{"perfect", "Perfect", XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, perfect),
		XtRString, "False"},	/* 65536 color is avail on the TrueColor Display only */




/* Zoom algorithms
		Quality
		slow >> fast (enlarge)
		slow >= fast (reduce)

		Speed
		fast >> slow
*/
	{"zoom", "Zoom",
		XtRString, sizeof(char *),
		XtOffset(ApplicationDataPtr, zoom),
		XtRString, "fast"},		/* fast or slow */




/* Slide show options */
	{"intervalTime", "IntervalTime",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, intervalTime),
		XtRImmediate, (XtPointer)15},	/* Specify the interval time (second) */

	{"fileSelectionMode", "FileSelectionMode",
		XtRString, sizeof(char *),
		XtOffset(ApplicationDataPtr, fileSelectionMode),
		XtRString, "sequent"},	/* Specify the file selection mode (sequent, random) */

	{"forceChange", "ForceChange",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, forceChange),
		XtRString, "False"},	/* Force change frame even if it is in the middle of animating */




/* Gif Animation options */
	{"gifAnimTicks", "GifAnimTicks",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, gifAnimTicks),
		XtRImmediate, (XtPointer)100000},	/* Gif Animation change ticks (micro second) */

	{"gifAnimFade", "GifAnimFade",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, gifAnimFade),
		XtRString, "True"},	/* Apply fade effect */




/* Animate options */
	{"animate", "Animate",
		XtRString, sizeof(char *),
		XtOffset(ApplicationDataPtr, animate),
		XtRString, "slide"},	/* Specify an animation mode */
								/* If "random" is specified, then use the animateList */

	{"animateList", "AnimateList",
		XtRString, sizeof(char *),
		XtOffset(ApplicationDataPtr, animateList),
		XtRString, "fade flush monotone reverse coloranim coloranim2 wipe block mosaic shuffle puzzle slit"},

/* Fade */
	{"fadeSteps", "FadeSteps",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, fadeSteps),
		XtRImmediate, (XtPointer)2},	/* Specify the intensity step (0-255 step FadeSteps) */

	{"fadeTicks", "FadeTicks",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, fadeTicks),
		XtRImmediate, (XtPointer)20000},	/* fade ticks (micro second) */


/* Wipe */
	{"wipeSteps", "WipeSteps",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, wipeSteps),
		XtRImmediate, (XtPointer)2},	/* wipe step (pixel) */

	{"wipeTicks", "WipeTicks",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, wipeTicks),
		XtRImmediate, (XtPointer)50000}, /* wipe ticks (micro second) */


/* Move */
	{"moveSteps", "MoveSteps",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, moveSteps),
		XtRImmediate, (XtPointer)2},	/* move step (pixel) */

	{"moveTicks", "MoveTicks",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, moveTicks),
		XtRImmediate, (XtPointer)100000},	/* move ticks (micro second) */


/* float24 */
	{"float24Steps", "Float24Steps",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, float24Steps),
		XtRImmediate, (XtPointer)2},	/* move step (pixel) */

	{"float24Ticks", "Float24Ticks",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, float24Ticks),
		XtRImmediate, (XtPointer)100000},	/* move ticks (micro second) */

	{"floatImageSize", "FloatImageSize",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, floatImageSize),
		XtRImmediate, (XtPointer)100}, /* 100 x 100 (pixel) */

	{"floatImageLifeTime", "FloatImageLifeTime",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, floatImageLifeTime),
		XtRImmediate, (XtPointer)60}, /* Life time (sec) */


/* Block */
	{"blockSteps", "BlockSteps",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, blockSteps),
		XtRImmediate, (XtPointer)8},	/* block step (pixel) */


/* Mosaic */
	{"mosaicTicks", "MosaicTicks",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, mosaicTicks),
		XtRImmediate, (XtPointer)1000000}, /* block ticks (micro second) */


/* Monotone */
	{"monotoneSteps", "MonotoneSteps",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, monotoneSteps),
		XtRImmediate, (XtPointer)2},	/* intensity step (0-255 step MonotoneSteps) */

	{"monotoneTicks", "MonotoneTicks",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, monotoneTicks),
		XtRImmediate, (XtPointer)20000}, /* monotone ticks (micro second) */


/* Flush */
	{"flushCount", "FlushCount",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, flushCount),
		XtRImmediate, (XtPointer)1},	/* number of flushing */

	{"flushSteps", "FlushSteps",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, flushSteps),
		XtRImmediate, (XtPointer)2},	/* intensity step (0-255 step flushSteps) */

	{"flushTicks", "FlushTicks",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, flushTicks),
		XtRImmediate, (XtPointer)10000}, /* flush ticks (micro second) */


/* Reverse */
	{"reverseSteps", "ReverseSteps",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, reverseSteps),
		XtRImmediate, (XtPointer)2},	/* intensity step (0-255 step reverseSteps) */

	{"reverseTicks", "ReverseTicks",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, reverseTicks),
		XtRImmediate, (XtPointer)20000}, /* reverse ticks (micro second) */


/* ColorAnim */
	{"colorAnimSort", "ColorAnimSort",
		XtRString, sizeof(char *),
		XtOffset(ApplicationDataPtr, colorAnimSort),
		XtRString, "quick"},	/* sorting algorithm (quick, shell, bubble) */

	{"colorAnimTicks", "ColorAnimTicks",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, colorAnimTicks),
		XtRImmediate, (XtPointer)10000},	/* colorAnim ticks (micro second) */


/* Shuffle */
	{"shuffleSort", "ShuffleSort",
		XtRString, sizeof(char *),
		XtOffset(ApplicationDataPtr, shuffleSort),
		XtRString, "quick"},	/* sorting algorithm (quick, shell, bubble) */

	{"shuffleSteps", "ShuffleSteps",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, shuffleSteps),
		XtRImmediate, (XtPointer)100},	/* one block size (pixel) */

	{"shuffleTicks", "ShuffleTicks",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, shuffleTicks),
		XtRImmediate, (XtPointer)500000}, /* move ticks (micro second) */

	{"shuffleFade", "ShuffleFade",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, shuffleFade),
		XtRString, "True"},		/* Apply fade effect */


/* Puzzle */
	{"puzzleSteps", "PuzzleSteps",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, puzzleSteps),
		XtRImmediate, (XtPointer)100},	/* one block size (pixel) */

	{"puzzleTicks", "PuzzleTicks",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, puzzleTicks),
		XtRImmediate, (XtPointer)500000}, /* move ticks (micro second) */

	{"puzzleFade", "PuzzleFade",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, puzzleFade),
		XtRString, "True"},	/* Apply fade effect */


/* Slit */
	{"slitSort", "SlitSort",
		XtRString, sizeof(char *),
		XtOffset(ApplicationDataPtr, slitSort),
		XtRString, "quick"},	/* sorting algorithm (quick, shell, bubble) */

	{"slitSteps", "SlitSteps",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, slitSteps),
		XtRImmediate, (XtPointer)20},	/* slip size (pixel) */

	{"slitTicks", "SlitTicks",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, slitTicks),
		XtRImmediate, (XtPointer)500000}, /* slit ticks (micro second) */

	{"slitFade", "slitFade",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, slitFade),
		XtRString, "True"},	/* Apply fade effect */


/* Transparent */
	{"transparentMode", "TransparentMode",
		XtRString, sizeof(char *), 
		XtOffset(ApplicationDataPtr, transparentMode),
		XtRString, "sequent"}, /* sequent, random */




/* Misc settings */
	{"moveOnTheLineTicks", "MoveOnTheLineTicks",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, moveOnTheLineTicks),
		XtRImmediate, (XtPointer)10000}, /* Specify the moving ticks on the line (micro second) */

	{"borderWidth", "BorderWidth",
		XtRInt, sizeof(int),
		XtOffset(ApplicationDataPtr, borderWidth),
		XtRImmediate, (XtPointer)1},	/* Specify the window border width (pixel) */

	{"pathDir", "PathDir",
		XtRString, sizeof(char *),
		XtOffset(ApplicationDataPtr, pathDir),
		XtRString, "."},	/* Specify the search path dir */

	{"destDir", "DestDir",
		XtRString, sizeof(char *),
		XtOffset(ApplicationDataPtr, destDir),
		XtRString, ""},		/* Specify the destination path dir */

	{"confirm", "Confirm",
		XtRBoolean, sizeof(Boolean),
		XtOffset(ApplicationDataPtr, confirm),
		XtRString, "False"}	/* Specify to confirm or not when move or delete the image file */

};




/* Define the command line options */
static XrmOptionDescRec options[]={
	{"-help",			"*help",				XrmoptionNoArg, "True"},
	{"-debug",			"*debug",				XrmoptionNoArg, "True"},
	{"-verbose",		"*verbose",				XrmoptionNoArg, "True"},

	{"-root",			"*root",				XrmoptionNoArg, "True"},
	{"-override",		"*override",			XrmoptionNoArg, "True"},

	{"-full",			"*full",				XrmoptionNoArg, "True"},
	{"-resize",			"*resize",				XrmoptionNoArg, "True"},
	{"-fit",			"*fit",					XrmoptionNoArg, "True"},
	{"-maxfit",			"*maxfit",				XrmoptionNoArg, "True"},
	{"-zoom",			"*zoom",				XrmoptionSepArg, ""},

	{"-animate",		"*animate",				XrmoptionSepArg, ""},
	{"-interval",		"*intervalTime",		XrmoptionSepArg, ""},
	{"-change",			"*forceChange",			XrmoptionNoArg, "True"},
	{"-fname",			"*showFileName",		XrmoptionNoArg, "True"},
	{"-clock",			"*clock",				XrmoptionNoArg, "True"},
	{"-biff",			"*biff",				XrmoptionNoArg, "True"},
	{"-mail_spool",		"*mail_spool",			XrmoptionSepArg, ""},

	{"-private",		"*private",				XrmoptionNoArg, "True"},
	{"-perfect",		"*perfect",				XrmoptionNoArg, "True"},
	{"-color",			"*color",				XrmoptionSepArg, ""},
	{"-reduce",			"*reduce",				XrmoptionSepArg, ""},

	{"-selection",		"*fileSelectionMode",	XrmoptionSepArg, ""},
	{"-path",			"*pathDir",				XrmoptionSepArg, ""},
	{"-dest",			"*destDir",				XrmoptionSepArg, ""},
	{"-confirm",		"*confirm",				XrmoptionNoArg, "True"}
};



/* Define default options */
static char *defaults[]={
	"*geometry:           400x400",	/* Default window size */
	"*foreground:         White",
	"*background:         Black",
	0
};


void goodbyekiss();
void wm_quit();
void action_dummy();
void action_head_frame();
void action_tail_frame();
void action_next_frame();
void action_prev_frame();
void action_pause_frame();
void action_change_frame();
void action_resize();
void action_left();
void action_right();
void action_up();
void action_down();
void action_fit();
#if defined _EDIT
void action_move();
void action_remove();
#endif

static XtActionsRec actions[] = { 
        {"pause_frame", (XtActionProc)action_pause_frame},
        {"head_frame",  (XtActionProc)action_head_frame},
        {"prev_frame",  (XtActionProc)action_prev_frame},
        {"stop",        (XtActionProc)goodbyekiss},
        {"next_frame",  (XtActionProc)action_next_frame},
        {"tail_frame",  (XtActionProc)action_tail_frame},
        {"change_frame",(XtActionProc)action_change_frame},
        {"resize", 		(XtActionProc)action_resize},
        {"left", 		(XtActionProc)action_left},
        {"right", 		(XtActionProc)action_right},
        {"up", 			(XtActionProc)action_up},
        {"down", 		(XtActionProc)action_down},
        {"fit", 		(XtActionProc)action_fit},
#if defined _EDIT
        {"move", 		(XtActionProc)action_move},
        {"remove",      (XtActionProc)action_remove},
#else
        {"move", 		(XtActionProc)action_dummy},
        {"remove",      (XtActionProc)action_dummy},
#endif
        {"quit",        (XtActionProc)wm_quit}
};


/* End of resource.h */

