/*
	slide.c - animate slide

	Author:	Susumu Shiohara (shiohara@tpp.epson.co.jp)

		Copyright 1993-1997 by Susumu Shiohara

			All Rights Reserved

*/

#include "xslideshow.h"
#include "animproto.h"

static Window imageWindow=(Window)0;
static int slideWindowX,slideWindowY,slideWindowW,slideWindowH;
static int mapsize;
static int cx,cy;

#if defined(__STDC__) || defined(__cplusplus)
ActionStatus xslideshow(char *fname)
#else
ActionStatus xslideshow(fname)
char *fname;
#endif
{
int x, y;

	PreDisplay();
	StoreColors(xcolors,gim.subImageList->mapsize);

	if(app_data.showFileName)
		createFileNameWindow(fname);

	/* Set the image window position in the bottom of the main window */
	x = (windowWidth - gim.subImageList->width) / 2;
	y =  windowHeight + gim.subImageList->height;
	slideWindowW = gim.subImageList->width;
	slideWindowH = gim.subImageList->height;
	ShowImageWindow(&imageWindow, x, y, slideWindowW, slideWindowH);

	/* move the image window position to the center of the main window */
	cx = slideWindowX = (windowWidth - gim.subImageList->width) / 2;
	cy = slideWindowY = (windowHeight - gim.subImageList->height) / 2;
	move_on_bresenham_line(
						imageWindow,
						x, y,
						slideWindowX, slideWindowY,
						10, 0);

	if(app_data.showFileName)
		raiseFileNameWindow();

	return(mywait());
}

/* Move the picture by key operation */
void up_slide()
{
	move_on_bresenham_line(
						imageWindow,
						cx, cy,
						cx, cy-10,
						10, 0);
	cy -= 10;
}
void down_slide()
{
	move_on_bresenham_line(
						imageWindow,
						cx, cy,
						cx, cy+10,
						10, 0);
	cy += 10;
}
void left_slide()
{
	move_on_bresenham_line(
						imageWindow,
						cx, cy,
						cx-10, cy,
						10, 0);
	cx -= 10;
}
void right_slide()
{
	move_on_bresenham_line(
						imageWindow,
						cx, cy,
						cx+10, cy,
						10, 0);
	cx += 10;
}



#if defined(__STDC__) || defined(__cplusplus)
void postxslideshow(char *fname)
#else
void postxslideshow(fname)
char *fname;
#endif
{
	if(imageWindow != (Window)0) {

		/* move the image window position to the top of the main window */
		move_on_bresenham_line(
							imageWindow,
							slideWindowX, slideWindowY,
							slideWindowX, -slideWindowH,
							10, 0);

		removeImageWindow(&imageWindow);
	}

	if(app_data.showFileName)
		removeFileNameWindow();
}

#if defined(__STDC__) || defined(__cplusplus)
ActionStatus xgifanimshow(char *fname)
#else
ActionStatus xgifanimshow(fname)
char *fname;
#endif
{
int x, y;

	mapsize =  gim.subImageList->mapsize;

	if(gim.subImageList->isTop) {
		PreDisplay();
	}

	x = (windowWidth - gim.subImageList->width) / 2;
	y = (windowHeight - gim.subImageList->height) / 2;
	slideWindowW = gim.subImageList->width;
	slideWindowH = gim.subImageList->height;
	ShowImage(x, y, slideWindowW, slideWindowH);

	if(gim.subImageList->isTop) {
		if(app_data.gifAnimFade){
			PreFadeColors(mapsize);
			FadeColors(False,mapsize);
		}
	}
	StoreColors(xcolors,mapsize);

	if(gim.subImageList->isTop) {
		if(app_data.showFileName) {
			createFileNameWindow(fname);
			raiseFileNameWindow();
		}
	}

	if(gim.subImageList->next != (SUBGIMAGE *)NULL) {
		myusleep(app_data.gifAnimTicks);
		return(mynowait());
	}
	else {
		return(mywait());
	}
}


#if defined(__STDC__) || defined(__cplusplus)
void postxgifanimshow(char *fname)
#else
void postxgifanimshow(fname)
char *fname;
#endif
{
	if(gim.subImageList->isTop) {
		if(app_data.showFileName)
			removeFileNameWindow();
		if(app_data.gifAnimFade){
			PreFadeColors(mapsize);
			FadeColors(True,mapsize);
		}
		XClearWindow(theDisp,theWindow);
	}
}


