/*
 * shell.c
 *
 * Executes the shell script given as the argument. If the argument is
 * empty, commands are read from standard input.
 *
 */

#include "../include/voice.h"

char *libvoice_shell_c = "$Id: shell.c,v 1.4 1996/07/25 19:23:27 marc Exp $";

int voice_shell_state = OFF_LINE;
int voice_shell_signal;
static int voice_shell_input_fd = NO_VOICE_FD;
static int voice_shell_output_fd = NO_VOICE_FD;
static int child_pid = 0;

int voice_execute_shell_script _P2((shell_script, shell_options),
 char *shell_script, char **shell_options)
     {
     int arg_index = 0;
     int start_index;
     char **shell_arguments;

     if (strlen(shell_script) == 0)
          lprintf(L_MESG, "%s: Executing shell %s", program_name,
           shell_script, cvd.voice_shell.d.p);
     else
          lprintf(L_MESG, "%s: Executing shell script %s with shell %s",
           program_name, shell_script, cvd.voice_shell.d.p);

     if (getenv("VOICE_PID") == NULL)
          {
          int parent_pid = getpid();
          int pipe_in[2];
          int pipe_out[2];

          lprintf(L_JUNK, "%s: opening pipes", program_name);

          if (pipe(pipe_in))
               {
               lprintf(L_ERROR, "%s: cannot open input pipe!", program_name);
               return(FAIL);
               };

          if (pipe(pipe_out))
               {
               lprintf(L_ERROR, "%s: cannot open output pipe!", program_name);
               return(FAIL);
               };

          lprintf(L_JUNK, "%s: forking shell", program_name);

          switch((child_pid = fork()))
               {
               case -1:
                    lprintf(L_ERROR, "%s: cannot fork!", program_name);
                    return(FAIL);
               case 0:
                    {
                    char buffer1[VOICE_BUF_LEN];
                    char buffer2[VOICE_BUF_LEN];
                    char buffer3[VOICE_BUF_LEN];
                    char buffer4[VOICE_BUF_LEN];

                    close(voice_fd);
                    close(pipe_in[1]);
                    close(pipe_out[0]);
                    sprintf(buffer1, "VOICE_PID=%d", parent_pid);
                    putenv(buffer1);
                    sprintf(buffer2, "VOICE_PROGRAM=%s", program_name);
                    putenv(buffer2);
                    sprintf(buffer3, "VOICE_INPUT=%d", pipe_in[0]);
                    putenv(buffer3);
                    sprintf(buffer4, "VOICE_OUTPUT=%d", pipe_out[1]);
                    putenv(buffer4);
                    break;
                    };
               default:
                    {
                    int child_status;

                    voice_shell_input_fd = pipe_out[0];
                    voice_shell_output_fd = pipe_in[1];
                    close(pipe_in[0]);
                    close(pipe_out[1]);

                    if (voice_write_shell("HELLO SHELL") != OK)
                         return(FAIL);

                    voice_shell_state = INITIALIZING;

                    do
                         {
                         voice_shell_signal = FALSE;
                         wait(&child_status);
                         }
                    while (voice_shell_signal);

                    voice_shell_state = OFF_LINE;
                    close(voice_shell_input_fd);
                    close(voice_shell_output_fd);

                    if (WIFEXITED(child_status) != 0)
                         {
                         child_status = WEXITSTATUS(child_status);
                         lprintf(L_NOISE,
                          "%s: shell exited normally with status 0x%04x",
                          program_name, child_status);
                         return(child_status);
                         };

                    lprintf(L_NOISE,
                     "%s: shell exited not normally with status 0x%x",
                     program_name, child_status);
                    return(FAIL);
                    };
               };

          };

     if (shell_options != NULL)

          for (arg_index = 0; shell_options[arg_index] != NULL; arg_index++)
               ;

     shell_arguments = (char**) malloc((3 + arg_index) * sizeof(char*));
     start_index = 1;
     shell_arguments[0] = cvd.voice_shell.d.p;

     if (strlen(shell_script) != 0)
          {
          start_index = 2;
          shell_arguments[1] = shell_script;
          };

     if (shell_options != NULL)

          for (arg_index = 0; shell_options[arg_index] != NULL; arg_index++)
               shell_arguments[arg_index + start_index] =
                shell_options[arg_index];

     shell_arguments[arg_index + start_index] = NULL;
     execv(cvd.voice_shell.d.p, shell_arguments);
     lprintf(L_ERROR, "%s: cannot execute %s %s", program_name,
      cvd.voice_shell.d.p, shell_script);
     return(FAIL);
     };

int voice_read_shell _P1((buffer), char *buffer)
     {
     char char_read;
     int number_chars = 0;

     lprintf(L_NOISE, "shell: ");

     do
          {

          if (read(voice_shell_input_fd, &char_read, 1) != 1)
               {
               lprintf(L_ERROR, "could not read from shell");

               if (child_pid != 0)
                    kill(child_pid, SIGKILL);

               return(FAIL);
               };

          if (char_read != NL)
               {
               *buffer = char_read;
               buffer++;
               number_chars++;
               lputc(L_NOISE, char_read);
               };

          }
     while (((char_read != NL) || (number_chars == 0)) &&
      (number_chars < (VOICE_BUF_LEN - 1)));

     *buffer = 0x00;
     return(OK);
     };

#if !defined(NeXT) || defined(NEXTSGTTY)
# include <varargs.h>
#else
# include "../include/NeXT.h"
#endif

int voice_write_shell(format, va_alist)
     const char *format;
     va_dcl

     {
     va_list arguments;
     char answer[VOICE_BUF_LEN];

     va_start(arguments);
     vsprintf(answer, format, arguments);
     va_end(arguments);
     lprintf(L_NOISE, "%s: %s", program_name, answer);

     if ((write(voice_shell_output_fd, answer, strlen(answer)) !=
      strlen(answer)) || (write(voice_shell_output_fd, "\n", 1) != 1))
          {
          lprintf(L_ERROR, "%s: could not write to shell", program_name);

          if (child_pid != 0)
               kill(child_pid, SIGKILL);

          return(FAIL);
          };

     return(OK);
     };
