/*
 * answer.c
 *
 */

#include "../include/voice.h"

char *vgetty_answer_c = "$Id: answer.c,v 1.6 1996/07/25 19:24:31 marc Exp $";

int answer_mode;
char dtmf_code[VOICE_BUF_LEN];
int execute_dtmf_script;
int first_dtmf;
int hangup_requested;
int switch_to_data_fax_mode;

static void enter_data_fax_mode _P1((answer_mode), int answer_mode)
     {
     int bit_order = 0;
     char *fax_mode = NULL;

     answer_mode &= (ANSWER_DATA | ANSWER_FAX);

     if (answer_mode == 0)
          {
          lprintf(L_MESG,
           "%s: answer mode is set to not accept data or fax connections",
           program_name);
          exit(1);
          };

     if (cvd.force_autodetect.d.i)
          answer_mode = ANSWER_DATA | ANSWER_FAX;

     if (modem_type == Mt_class2)
          {
          bit_order = 0;
          fax_mode = "2";
          };

     if (modem_type == Mt_class2_0)
          {
          bit_order = 1;
          fax_mode = "2.0";
          };

     if ((modem_type == Mt_data) || (fax_mode == NULL))
          answer_mode &= ANSWER_DATA;

     if (answer_mode == 0)
          {
          lprintf(L_MESG, "%s: modem does not support wanted answer mode",
           program_name);
          exit(1);
          };

     switch (answer_mode)
          {
          case ANSWER_DATA | ANSWER_FAX:
               lprintf(L_JUNK, "%s: trying data and fax connection",
                program_name);
               voice_switch_to_data_fax((void *) fax_mode);
               voice_command("AT+FAA=1", "OK");
               fax_set_bor(voice_fd, bit_order);
               break;
          case ANSWER_DATA:
               lprintf(L_JUNK, "%s: trying data connection", program_name);
               voice_switch_to_data_fax((void *) "0");
               voice_command("AT+FAA=0", "OK");
               break;
          case ANSWER_FAX:
               lprintf(L_JUNK, "%s: trying fax connection", program_name);
               voice_switch_to_data_fax((void *) fax_mode);
               voice_command("AT+FAA=0", "OK");
               fax_set_bor(voice_fd, bit_order);
               break;
          };

     };

static int get_answer_mode _P0(void)
     {
     char answer_mode[VOICE_BUF_LEN] = "";
     int result = 0;

     if (virtual_ring)
          strcpy(answer_mode, cvd.sigusr1_answer_mode.d.p);
     else
          strcpy(answer_mode, cvd.ring_answer_mode.d.p);

     if (strlen(answer_mode) != 0)
          {
          int i;
          char *prefix = "";

          if (strncmp(answer_mode, "/", 1) == 0)
               {
               char answer_mode_file_name[VOICE_BUF_LEN];
               FILE *answer_mode_file;

               sprintf(answer_mode_file_name, "%s.%s",
                answer_mode, DevID);
               answer_mode_file = fopen(answer_mode_file_name, "r");

               if (answer_mode_file != NULL)
                    {
                    lprintf(L_JUNK, "%s: reading answer mode file %s",
                     program_name, answer_mode_file_name);
                    fscanf(answer_mode_file, "%s", answer_mode);
                    fclose(answer_mode_file);
                    }
               else
                    {
                    sprintf(answer_mode_file_name, "%s", answer_mode);
                    answer_mode_file = fopen(answer_mode_file_name, "r");

                    if (answer_mode_file != NULL)
                         {
                         lprintf(L_JUNK, "%s: reading answer mode file %s",
                          program_name, answer_mode_file_name);
                         fscanf(answer_mode_file, "%s", answer_mode);
                         fclose(answer_mode_file);
                         };

                    };

               }
          else
               lprintf(L_JUNK, "%s: answer mode was set directly",
                program_name);

          for (i = 0; i < strlen(answer_mode); i++)
               answer_mode[i] = tolower(answer_mode[i]);

          lprintf(L_JUNK, "%s: answer mode is [", program_name);

          if (strstr(answer_mode, "data"))
               {
               result |= ANSWER_DATA;
               lputs(L_JUNK, "data");
               prefix = "|";
               };

          if (strstr(answer_mode, "fax"))
               {
               result |= ANSWER_FAX;
               lputs(L_JUNK, prefix);
               lputs(L_JUNK, "fax");
               prefix = "|";
               };

          if (strstr(answer_mode, "voice"))
               {
               result |= ANSWER_VOICE;
               lputs(L_JUNK, prefix);
               lputs(L_JUNK, "voice");
               };

          lputs(L_JUNK, "]");
          };

     if (result == 0)
          {
          lprintf(L_MESG,
           "%s: answer mode is set to not accept any kind of call",
           program_name);
          clean_line(STDIN, 80);
          exit(1);
          };

     return(result);
     };

static void get_greeting_message _P1((message), char *message)
     {
     char message_dir[VOICE_BUF_LEN];
     char list_file_name[VOICE_BUF_LEN];
     char message_file_name[VOICE_BUF_LEN];
     FILE *list;

     strcpy(message_file_name, cvd.backup_message.d.p);
     make_path(message_dir, cvd.voice_dir.d.p, cvd.message_dir.d.p);
     make_path(list_file_name, message_dir, cvd.message_list.d.p);
     lprintf(L_JUNK, "%s: opening list file %s", program_name,
      list_file_name);
     list = fopen(list_file_name, "r");

     if (list != NULL)
          {
          int choice;
          int count = 0;
          int i;

          while (fgets(message_file_name, VOICE_BUF_LEN, list) != NULL)
               count++;

          choice = time(NULL) % count + 1;
          lprintf(L_JUNK, "%s: found %d messages, picked message number %d",
           program_name, count, choice);
          rewind(list);

          for (i = 0; i < choice; i++)
               fgets(message_file_name, VOICE_BUF_LEN, list);

          i = strlen(message_file_name) - 1;

          if ((i > 0) && (message_file_name[i] == NL))
               message_file_name[i] = 0x00;

          fclose(list);
          };

     make_path(message, message_dir, message_file_name);
     lprintf(L_JUNK, "%s: message name is %s", program_name, message);
     };

static void remove_message _P1((message), char *message)
     {

     if (!cvd.rec_always_keep.d.i)
          {
          lprintf(L_JUNK, "%s: removing message %s", program_name, message);
          unlink(message);
          };

     };

void vgetty_answer _P3((rings, rings_wanted, ring_action), int rings,
 int rings_wanted, action_t ring_action)
     {
     time_t call_start;
     time_t call_end;
     time_t call_length;
     char greeting_message[VOICE_BUF_LEN];
     char receive_dir[VOICE_BUF_LEN];
     char message[VOICE_BUF_LEN];
     char message_name[VOICE_BUF_LEN] = "vXXXXXX";

     answer_mode = get_answer_mode();

     if ((ring_action >= A_RING1) && (ring_action <= A_RING5))

          if ((ring_action != (cvd.dist_ring_fax.d.i + A_RING1 - 1)) &&
           (ring_action != (cvd.dist_ring_data.d.i + A_RING1 - 1)) &&
           (ring_action != (cvd.dist_ring_voice.d.i + A_RING1 - 1)))
               {
               lprintf(L_AUDIT, "ignoring distinctive RING %d call",
                ring_action - A_RING1 + 1);
               clean_line(STDIN, 80);
               exit(1);
               };

     if (ring_action == (cvd.dist_ring_fax.d.i + A_RING1 - 1))
          {
          enter_data_fax_mode(answer_mode & ANSWER_FAX);
          return;
          };

     if ((rings < rings_wanted) || !(answer_mode & ANSWER_VOICE))
          {
          enter_data_fax_mode(answer_mode);
          return;
          };

     get_greeting_message(greeting_message);
     make_path(receive_dir, cvd.voice_dir.d.p, cvd.receive_dir.d.p);
     mktemp(message_name);
     strcat(message_name, ".rmd");
     make_path(message, receive_dir, message_name);
     strcpy(dtmf_code, "");
     execute_dtmf_script = FALSE;
     first_dtmf = TRUE;
     hangup_requested = FALSE;
     switch_to_data_fax_mode = FALSE;

     voice_mode_on();
     voice_answer_phone();

     if (strlen(cvd.call_program.d.p) != 0)
          {
          char *arguments[2];
          char call_program[VOICE_BUF_LEN];
          int result;

          arguments[0] = DevID;
          arguments[1] = NULL;
          make_path(call_program, cvd.voice_dir.d.p, cvd.call_program.d.p);
          result = voice_execute_shell_script(call_program, arguments);

          if (result == FAIL)
               lprintf(L_ERROR, "%s: shell script %s exited unnormally");
          else

               switch (result)
                    {
                    case 1:
                         enter_data_fax_mode(answer_mode & ANSWER_DATA);
                         return;
                    case 2:
                         enter_data_fax_mode(answer_mode & ANSWER_FAX);
                         return;
                    case 3:
                         enter_data_fax_mode(answer_mode & (ANSWER_DATA |
                          ANSWER_FAX));
                         return;
                    default:
                         voice_set_device(NO_DEVICE);
                         voice_mode_off();
                         voice_close_device();
                         exit(0);
                    };

          };

     voice_play_file(greeting_message);

     if ((execute_dtmf_script) && (strlen(cvd.dtmf_program.d.p) != 0))
          {
          char *arguments[2];
          char dtmf_program[VOICE_BUF_LEN];

          arguments[0] = dtmf_code;
          arguments[1] = NULL;
          make_path(dtmf_program, cvd.voice_dir.d.p, cvd.dtmf_program.d.p);
          lprintf(L_AUDIT,
           "got DTMF code - executing DTMF program, name='%s', caller=%s, dev=%s, pid=%d",
           CallName, CallerId, DevID, getpid());
          voice_execute_shell_script(dtmf_program, arguments);
          voice_set_device(NO_DEVICE);
          voice_mode_off();
          voice_close_device();
          exit(0);
          };

     if (hangup_requested)
          {
          lprintf(L_AUDIT,
           "hangup requested, name='%s', caller=%s, dev=%s, pid=%d",
           CallName, CallerId, DevID, getpid());
          voice_set_device(NO_DEVICE);
          voice_mode_off();
          voice_close_device();
          exit(0);
          };

     if (switch_to_data_fax_mode)
          {
          enter_data_fax_mode(answer_mode);
          return;
          };

     voice_beep(cvd.beep_frequency.d.i, cvd.beep_length.d.i);

     if ((execute_dtmf_script) && (strlen(cvd.dtmf_program.d.p) != 0))
          {
          char *arguments[2];
          char dtmf_program[VOICE_BUF_LEN];

          arguments[0] = dtmf_code;
          arguments[1] = NULL;
          make_path(dtmf_program, cvd.voice_dir.d.p, cvd.dtmf_program.d.p);
          lprintf(L_AUDIT,
           "got DTMF code - executing DTMF program, name='%s', caller=%s, dev=%s, pid=%d",
           CallName, CallerId, DevID, getpid());
          voice_execute_shell_script(dtmf_program, arguments);
          voice_set_device(NO_DEVICE);
          voice_mode_off();
          voice_close_device();
          exit(0);
          };

     if (hangup_requested)
          {
          lprintf(L_AUDIT,
           "hangup requested, name='%s', caller=%s, dev=%s, pid=%d",
           CallName, CallerId, DevID, getpid());
          voice_set_device(NO_DEVICE);
          voice_mode_off();
          voice_close_device();
          exit(0);
          };

     if (switch_to_data_fax_mode)
          {
          enter_data_fax_mode(answer_mode);
          return;
          };

     time(&call_start);
     voice_record_file(message);
     time(&call_end);
     call_length = call_end - call_start;

     if ((execute_dtmf_script) && (strlen(cvd.dtmf_program.d.p) != 0))
          {
          char *arguments[2];
          char dtmf_program[VOICE_BUF_LEN];

          arguments[0] = dtmf_code;
          arguments[1] = NULL;
          remove_message(message);
          make_path(dtmf_program, cvd.voice_dir.d.p, cvd.dtmf_program.d.p);
          lprintf(L_AUDIT,
           "got DTMF code - executing DTMF program, name='%s', caller=%s, dev=%s, pid=%d",
           CallName, CallerId, DevID, getpid());
          voice_execute_shell_script(dtmf_program, arguments);
          voice_set_device(NO_DEVICE);
          voice_mode_off();
          voice_close_device();
          exit(0);
          };

     if (!hangup_requested && (switch_to_data_fax_mode))
          {
          remove_message(message);
          enter_data_fax_mode(answer_mode);
          return;
          };

     if (!hangup_requested)
          voice_beep(cvd.beep_frequency.d.i, cvd.beep_length.d.i);

     if (strlen(cvd.message_program.d.p) != 0)
          {
          char *arguments[4];
          char message_program[VOICE_BUF_LEN];

          arguments[0] = message;
          arguments[1] = CallerId;
          arguments[2] = CallName;
          arguments[3] = NULL;
          lprintf(L_AUDIT, "executing message program, dev=%s, pid=%d",
           DevID, getpid());
          make_path(message_program, cvd.voice_dir.d.p,
           cvd.message_program.d.p);
          voice_execute_shell_script(message_program, arguments);
          };

     voice_set_device(NO_DEVICE);
     voice_mode_off();
     voice_close_device();
     lprintf(L_AUDIT,
      "message keep, length=%02d:%02d:%02d, name='%s', caller=%s, dev=%s, pid=%d",
      (int) (call_length / 3600), (int) ((call_length / 60) % 60),
      (int) (call_length % 60), CallName, CallerId, DevID, getpid());
     vgetty_create_message_flag_file();
     exit(0);
     };
