/**
 *
 * $Id: ArrowBG.c,v 1.16 1996/04/20 05:54:39 toshok Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: ArrowBG.c,v 1.16 1996/04/20 05:54:39 toshok Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/ArrowBGP.h>
#include <Xm/DebugUtil.h>
#include <stdio.h>

/* Forward Declarations */

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static void expose(Widget w, XEvent *event, Region region);
static XtGeometryResult query_geometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer);
static Boolean set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);

static void input_dispatch(Widget gadget, XEvent *event, Mask event_mask);

#define Offset(field) XtOffsetOf(XmArrowButtonGadgetRec, arrowbutton.field)

/* Resources for the arrowbuttongadget class */
static XtResource resources[] = {
    {
	XmNmultiClick, XmCMultiClick, XmRMultiClick,
	sizeof(unsigned char), Offset(multiClick),
	XmRImmediate, (XtPointer)XmMULTICLICK_KEEP
    },
    {
	XmNarrowDirection, XmCArrowDirection, XmRArrowDirection,
	sizeof(unsigned char), Offset(direction),
	XmRImmediate, (XtPointer)XmARROW_UP
    },
    {
	XmNactivateCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(activate_callback),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNarmCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(arm_callback),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNdisarmCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(disarm_callback),
	XmRPointer, (XtPointer)NULL
    }
};

static XmBaseClassExtRec _XmArrowBGRectClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ NULL, /* FIXME */
    /* set_values_prehook        */ NULL, /* FIXME */
    /* initialize_posthook       */ NULL, /* FIXME */
    /* set_values_posthook       */ NULL, /* FIXME */
    /* secondary_object_class    */ NULL, /* FIXME */
    /* secondary_object_create   */ NULL, /* FIXME */
    /* get_secondary_resources   */ NULL, /* FIXME */
    /* fast_subclass             */ { 0 }, /* FIXME */
    /* get_values_prehook        */ NULL, /* FIXME */
    /* get_values_posthook       */ NULL, /* FIXME */
    /* class_part_init_prehook   */ NULL,
    /* class_part_init_posthook  */ NULL,
    /* ext_resources             */ NULL,
    /* compiled_ext_resources    */ NULL,
    /* num_ext_resources         */ 0,
    /* use_sub_resources         */ FALSE,
    /* widget_navigable          */ XmInheritWidgetNavigable,
    /* focus_change              */ XmInheritFocusChange,
    /* wrapper_data              */ NULL
};

static XmGadgetClassExtRec _XmArrowBGadgetClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,
    /* version                   */ XmGadgetClassExtVersion,
    /* size                      */ sizeof(XmGadgetClassExtRec),
    /* widget_baseline_proc      */ NULL, /* FIXME */
    /* display_rect_proc         */ NULL, /* FIXME */
};

XmArrowButtonGadgetClassRec xmArrowButtonGadgetClassRec = {
    /* RectObj class part */
    {
	/* superclass            */ (WidgetClass) &xmGadgetClassRec,
	/* class_name            */ "XmArrowButtonGadget",
	/* widget_size           */ sizeof(XmArrowButtonGadgetRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ NULL,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ FALSE,
	/* compress_exposure     */ XtExposeCompressMaximal,
	/* compress_enterleave   */ FALSE,
	/* visible_interest      */ FALSE,
	/* destroy               */ destroy,
	/* resize                */ NULL,
	/* expose                */ expose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ query_geometry,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)&_XmArrowBGRectClassExtRec
    },
    /* XmGadget part */
    {
	/* border_highlight   */ XmInheritBorderHighlight, 
	/* border_unhighlight */ XmInheritBorderUnhighlight,
	/* arm_and_activate   */ NULL, /* fix me */
	/* input_dispatch     */ input_dispatch,
	/* visual_change      */ NULL, /* fix me */
	/* syn_resources      */ NULL,
	/* num_syn_resources  */ 0,
	/* cache_part         */ NULL,
	/* extension          */ (XtPointer)&_XmArrowBGadgetClassExtRec
    },
    /* XmArrowButtonGadget part */
    {
	/* extension */ NULL
    },
};

WidgetClass xmArrowButtonGadgetClass = (WidgetClass)&xmArrowButtonGadgetClassRec;

#define ABG_DEFAULT_HEIGHT	20
#define ABG_DEFAULT_WIDTH	20

static void
class_initialize()
{
    _XmArrowBGRectClassExtRec.record_type = XmQmotif;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    _XmFastSubclassInit(widget_class, XmARROW_BUTTON_GADGET_BIT);
}

static void
initialize(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    XmArrowButtonGadget abg = (XmArrowButtonGadget) new;
    XGCValues values;

    if (! XtIsSubclass(XtParent(new), xmManagerWidgetClass))
	_XmError(new, "parent should be manager.");

    if (XtWidth(new) == 0)
	XtWidth(new) = ABG_DEFAULT_WIDTH;
    
    if (XtHeight(new) == 0)
	XtHeight(new) = ABG_DEFAULT_HEIGHT;

    /* Gadget override */
    G_HighlightOnEnter(new) = True;

    ABG_Armed(abg) = False;

    values.foreground = XmParentForeground(new);
    values.background = XmParentBackground(new);

    ABG_ArrowGC(abg) = XtGetGC(new,
			       GCForeground | GCBackground,
			       &values);

    values.fill_style = FillStippled;

    ABG_InsensitiveGC(abg) = XtGetGC(new,
				     GCForeground | GCBackground | GCFillStyle,
				     &values);

    abg->gadget.event_mask = XmARM_EVENT | XmACTIVATE_EVENT |
			     XmENTER_EVENT | XmLEAVE_EVENT |
			     XmFOCUS_IN_EVENT | XmFOCUS_OUT_EVENT;
			     /* FIXME -- there should be Smore here */
	
    /* FIXME -- if the parent is a rc in a menu, need to set
       multiClick to XmMULTICLICK_DISCARD */
}

static void
destroy(Widget w)
{
    XtReleaseGC(w, ABG_ArrowGC(w));
    XtReleaseGC(w, ABG_InsensitiveGC(w));
}

static Boolean
set_values(Widget old,
	   Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{

    XmArrowButtonGadget abg = (XmArrowButtonGadget) new;
    XmArrowButtonGadget og = (XmArrowButtonGadget) old;
    Boolean refresh_needed = False;

    if (ABG_Direction(abg) != ABG_Direction(og)) 
	refresh_needed = True;

    return refresh_needed;
}

static void
expose(Widget w,
       XEvent *event,
       Region region)
{
    Dimension x, y, xsize, ysize;
    Dimension margin=G_ShadowThickness(w) + G_HighlightThickness(w) + 1;
    Boolean State;
    GC myGC;

    x = XtX(w) + margin;
    y = XtY(w) + margin;

    xsize = XtWidth(w) - margin * 2;
    ysize = XtHeight(w) - margin * 2;

    /* use the right GC */
    if (XtIsSensitive(w))
	myGC = ABG_ArrowGC(w);
    else
	myGC = ABG_InsensitiveGC(w);

    _XmDrawShadows(XtDisplayOfObject(w), 
		   XtWindowOfObject(w), 
		   XmParentTopShadowGC(w),
		   XmParentBottomShadowGC(w),
 		   XtX(w) + G_HighlightThickness(w),
		   XtY(w) + G_HighlightThickness(w),
		   XtWidth(w) - 2 * G_HighlightThickness(w),
		   XtHeight(w) - 2 * G_HighlightThickness(w),
		   G_ShadowThickness(w),
		   XmSHADOW_OUT);
		   
    State = ABG_Armed(w);
    if (State) {
	_XmDrawArrow(XtDisplayOfObject(w),
		     XtWindowOfObject(w),
		     XmParentTopShadowGC(w),
		     XmParentBottomShadowGC(w),
		     myGC,
		     x, y,
		     xsize, ysize,
		     /* Per tegla@katalin.csoma.elte.hu, M*tif ignores
			this
		     G_ShadowThickness(w),
		      */
		     1,
		     ABG_Direction(w));
    }
    else {
	_XmDrawArrow(XtDisplayOfObject(w),
		     XtWindowOfObject(w),
		     XmParentBottomShadowGC(w),
		     XmParentTopShadowGC(w),
		     myGC,
		     x, y,
		     xsize, ysize,
		     /* Per tegla@katalin.csoma.elte.hu, M*tif ignores
			this
		     G_ShadowThickness(w),
		      */
		     1,
		     ABG_Direction(w));
    }
}

static XtGeometryResult 
query_geometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer)
{
    answer->request_mode = CWWidth | CWHeight;

    answer->width = XtWidth(w);

    answer->height = XtHeight(w);
    
    if (((proposed->request_mode & (CWWidth | CWHeight))
	 == (CWWidth | CWHeight)) &&
	proposed->width == answer->width &&
	proposed->height == answer->height)

	return XtGeometryYes;
    else if (answer->width == XtWidth(w) &&
	     answer->height == XtHeight(w))
	return XtGeometryNo;
    else 
	return XtGeometryAlmost;    
}

static void
Arm(Widget w,
    XEvent *event,
    String *params,
    Cardinal *num_params)
{
    XmArrowButtonCallbackStruct cbs;

    ABG_Armed(w) = True;

    expose(w, NULL, (Region)NULL);

    cbs.reason = XmCR_ARM;
    cbs.event = event;
    cbs.click_count = ABG_ClickCount(w);
    XtCallCallbackList(w,
		       ABG_ArmCallback(w),
		       (XtPointer)&cbs);
}

static void 
Disarm(Widget w,
       XEvent *event,
       String *params,
       Cardinal *num_params)
{
    XmArrowButtonCallbackStruct cbs;
    
    cbs.reason = XmCR_DISARM;
    cbs.event = event;
    cbs.click_count = ABG_ClickCount(w);
    XtCallCallbackList(w,
		       ABG_DisarmCallback(w),
		       (XtPointer)&cbs);

    ABG_Armed(w) = False;
    expose(w, NULL, (Region)NULL);
}

static void 
Activate(Widget w,
	 XEvent *event,
	 String *params,
	 Cardinal *num_params)
{
    XButtonEvent *ev = (XButtonEvent *)event;
    XmArrowButtonCallbackStruct cbs;

    if ((ev->x > XtX(w) && ev->x < XtX(w) + XtWidth(w)) &&
	(ev->y > XtY(w) && ev->y < XtY(w) + XtHeight(w))) {
	cbs.reason = XmCR_ACTIVATE;
	cbs.event = event;
	cbs.click_count = ABG_ClickCount(w);
	XtCallCallbackList(w,
		           ABG_ArmCallback(w),
		           (XtPointer)&cbs);
    }

    Disarm(w,event,params,num_params);
}

static void
ArmAndActivate(Widget w,
	       XEvent *event,
	       String *params,
	       Cardinal *num_params)
{
    Arm(w, event, params, num_params);
    Activate(w, event, params, num_params);
}

static void
EnterWindow(Widget w,
      XEvent *event,
      String *params,
      Cardinal *num_params)
{
    int margin = G_ShadowThickness(w) + G_HighlightThickness(w) + 1;
    int xsize = XtWidth(w) - margin * 2;
    int ysize = XtHeight(w) - margin * 2;

    if (ABG_Armed(w)) 
        _XmDrawArrow(XtDisplayOfObject(w),
                     XtWindowOfObject(w),
                     XmParentTopShadowGC(w),
                     XmParentBottomShadowGC(w),
		     ABG_ArrowGC(w),
                     XtX(w) + margin, XtY(w) + margin,
                     xsize, ysize,
                     /* Per tegla@katalin.csoma.elte.hu, M*tif ignores
                        this
                     Prim_ShadowThickness(w),
                      */
                     1,
                     ABG_Direction(w));
}

static void
LeaveWindow(Widget w,
      XEvent *event,
      String *params,
      Cardinal *num_params)
{
    int margin = G_ShadowThickness(w) + G_HighlightThickness(w) + 1;
    int xsize = XtWidth(w) - margin * 2;
    int ysize = XtHeight(w) - margin * 2;

    if (ABG_Armed(w)) 
        _XmDrawArrow(XtDisplayOfObject(w),
                     XtWindowOfObject(w),
                     XmParentBottomShadowGC(w),
                     XmParentTopShadowGC(w),
		     ABG_ArrowGC(w),
                     XtX(w) + margin, XtY(w) + margin,
                     xsize, ysize,
                     /* Per tegla@katalin.csoma.elte.hu, M*tif ignores
                        this
                     Prim_ShadowThickness(w),
                      */
                     1,
                     ABG_Direction(w));
}

static void
input_dispatch(Widget gadget, 
	       XEvent *event, 
	       Mask event_mask) 
{
    switch (event_mask)
    {
    case XmARM_EVENT:
	XdbDebug(__FILE__, gadget, "ArrowButtonGadget got arm event\n");
	Arm(gadget, event, NULL, NULL);
	break;
    case XmACTIVATE_EVENT:
	XdbDebug(__FILE__, gadget, "ArrowButtonGadget got activate event\n");
	Activate(gadget, event, NULL, NULL);
	break;
    case XmENTER_EVENT:
	XdbDebug(__FILE__, gadget, "ArrowButtonGadget got enter event\n");
	EnterWindow(gadget, event, NULL, NULL);
	break;
    case XmLEAVE_EVENT:
	XdbDebug(__FILE__, gadget, "ArrowButtonGadget got leave event\n");
	LeaveWindow(gadget, event, NULL, NULL);
    case XmFOCUS_IN_EVENT:
	_XmFocusInGadget(gadget, event, NULL, NULL);
	break;
    case XmFOCUS_OUT_EVENT:
	_XmFocusOutGadget(gadget, event, NULL, NULL);
	break;
    }
}

Widget
XmCreateArrowButtonGadget(Widget parent,
			  char *name,
			  Arg *arglist,
			  Cardinal argcount)
{
    return XtCreateWidget(name,
			  xmArrowButtonGadgetClass,
			  parent,
			  arglist,
			  argcount);
}

