/**
 *
 * $Id: FontList.c,v 1.17 1996/04/20 14:59:50 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: FontList.c,v 1.17 1996/04/20 14:59:50 miers Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/DebugUtil.h>
#include <Xm/XmosP.h>
#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <stdio.h>

static XmFontList
__XmFontListAlloc(int numberOfEntries)
{
    XmFontList newFontList = (XmFontList)XtMalloc(sizeof(XmFontListRec));
    int i;

    newFontList->entries = (XmFontListEntry*)XtMalloc(numberOfEntries *
						      sizeof(XmFontListEntry));


    for (i=0; i<numberOfEntries; i++)
	newFontList->entries[i] = (XmFontListEntry)XtMalloc(sizeof(XmFontListEntryRec));

    newFontList->number_of_font_entries = numberOfEntries;

    return newFontList;
}

static void
__XmFontListDealloc(XmFontList list)
{

    int i;

    for (i=0; i<list->number_of_font_entries; i++)
	XmFontListEntryFree(&(list->entries[i]));

    XtFree((char*)list);
}

XmFontList 
XmFontListAppendEntry(XmFontList old,
		      XmFontListEntry entry)
{
    XmFontList newFontList;

    if (old == NULL)
    {
	newFontList = __XmFontListAlloc(1);
	newFontList->number_of_font_entries = 0;
    }
    else
    {
/** Danny, I didn't patch this area of this code, since the man page reads that
    XmFontListAppendEntry copies the old, instead of doing an update in-place.
    -- Chris
 ** You're right, but (1) nobody should be able to tell the difference,
    and (2) I've seen 2.0 comments saying this will be different in 2.0
    -- Danny
 **/
	int i;

	newFontList = __XmFontListAlloc(old->number_of_font_entries + 1);
	
	for (i=0; i<old->number_of_font_entries; i++)
	{
	    newFontList->entries[i]->tag = XtNewString(old->entries[i]->tag);
	    newFontList->entries[i]->type = old->entries[i]->type;
	    newFontList->entries[i]->font = old->entries[i]->font;
	}
	
	newFontList->number_of_font_entries = old->number_of_font_entries;

	__XmFontListDealloc(old);
    }

    newFontList->entries[newFontList->number_of_font_entries]->tag 
	= XtNewString(entry->tag);
    newFontList->entries[newFontList->number_of_font_entries]->type
	= entry->type;
    newFontList->entries[newFontList->number_of_font_entries]->font
	= entry->font;

    newFontList->number_of_font_entries++;

    XdbDebug(__FILE__, NULL, "XmFontListAppendEntry() => 0x%X\n", newFontList);

    return newFontList;
}

/*
 * this function is "obsolete"; however Xmt uses it.
 */
XmFontList
XmFontListAdd(XmFontList old, XFontStruct *font, XmStringCharSet charset)
{
    XmFontList newFontList;

    if (old == NULL)
    {
	newFontList = __XmFontListAlloc(1);
	newFontList->number_of_font_entries = 0;
    }
    else
    {
	int i;

	newFontList = __XmFontListAlloc(old->number_of_font_entries + 1);
	
	for (i=0; i<old->number_of_font_entries; i++)
	{
	    newFontList->entries[i]->tag = XtNewString(old->entries[i]->tag);
	    newFontList->entries[i]->type = old->entries[i]->type;
	    newFontList->entries[i]->font = old->entries[i]->font;
	}
	
	newFontList->number_of_font_entries = old->number_of_font_entries;

	__XmFontListDealloc(old);
    }

    newFontList->entries[newFontList->number_of_font_entries]->tag 
	= XtNewString(charset);
    newFontList->entries[newFontList->number_of_font_entries]->type
	= XmFONT_IS_FONT;
    newFontList->entries[newFontList->number_of_font_entries]->font
	= font;

    newFontList->number_of_font_entries++;

    XdbDebug(__FILE__, NULL, "XmFontListAdd() => 0x%X\n", newFontList);

    return newFontList;
}

XmFontList 
XmFontListCopy(XmFontList fontlist)
{
    XmFontList newFontList;
    int i;

    newFontList = __XmFontListAlloc(fontlist->number_of_font_entries);

    for (i=0; i<newFontList->number_of_font_entries; i++)
    {
	newFontList->entries[i]->tag = XtNewString(fontlist->entries[i]->tag);
	newFontList->entries[i]->type = fontlist->entries[i]->type;
	newFontList->entries[i]->font = fontlist->entries[i]->font;
    }

    XdbDebug(__FILE__, NULL, "XmFontListCopy(0x%X) => 0x%X\n",
	fontlist, newFontList);

    return newFontList;
}

void 
XmFontListEntryFree(XmFontListEntry *entry)
{
    XdbDebug(__FILE__, NULL, "XmFontListEntryFree(0x%x)\n", entry);

    if (entry)
    {
	XtFree((*entry)->tag);
	
	XtFree((char*)*entry);
    }
}

XtPointer
XmFontListEntryGetFont(XmFontListEntry entry,
		       XmFontType *type_return)
{
    if (entry == NULL) {
	XdbDebug(__FILE__, NULL, "XmFontListEntryGetFont(NULL)\n");
	if (type_return)
	    *type_return = XmFONT_IS_FONT;
	return NULL;
    }

    XdbDebug(__FILE__, NULL, "XmFontListEntryGetFont()\n");

    if (type_return)
	*type_return = entry->type;
    return entry->font;
}

char *
XmFontListEntryGetTag(XmFontListEntry entry)
{
    return entry->tag;
}

XmFontListEntry 
XmFontListEntryLoad(Display *display,
		    char *font_name,
		    XmFontType type,
		    char *tag)
{
    XmFontListEntry entry = (XmFontListEntry)XtMalloc(sizeof(XmFontListEntryRec));
    XrmValue fromString, toFont, cvtArg;
    Boolean success = False;

    fromString.addr = font_name;
    fromString.size = strlen(font_name) + 1;

    cvtArg.addr = (XtPointer)&display;
    cvtArg.size = sizeof(Display *);

    switch (type)
    {
    case XmFONT_IS_FONT:
	toFont.addr = (XtPointer)&(entry->font);
	toFont.size = sizeof(XFontStruct*);

	success = XtCallConverter(display, XtCvtStringToFontStruct, &cvtArg, (Cardinal)1, &fromString, &toFont, NULL);
	break;
    case XmFONT_IS_FONTSET:
	toFont.addr = (XtPointer)&(entry->font);
	toFont.size = sizeof(XFontSet);

	success = XtCallConverter(display, XtCvtStringToFontSet, &cvtArg, (Cardinal)1, &fromString, &toFont, NULL);
	break;
    }

    if (!success)
	return NULL;
    else 
    {
	entry->tag = XtNewString(tag);
	entry->type = type;

	return entry;
    }
}

void 
XmFontListFree(XmFontList list)
{
    XdbDebug(__FILE__, NULL, "XmFontListFree(0x%X)\n", list);

    __XmFontListDealloc(list);
}

void 
XmFontListFreeFontContext(XmFontContext context)
{
    XdbDebug(__FILE__, NULL, "XmFontListFreeFontContext(0x%X)\n", context);
    XtFree((char*)context);
}

Boolean 
XmFontListInitFontContext(XmFontContext *context,
			  XmFontList fontlist)
{
    if (fontlist && context)
    {
	*context = (XmFontContext)XtMalloc(sizeof(XmFontContextRec));
	(*context)->fontlist = fontlist;
	(*context)->current_entry = -1;

	return TRUE;
    }
    else
	return FALSE;
}

XmFontListEntry 
XmFontListEntryCreate(char *tag,
		      XmFontType type,
		      XtPointer font)
{
    XmFontListEntry entry = (XmFontListEntry)XtMalloc(sizeof(XmFontListEntryRec));
    
    entry->tag = XtNewString(tag);
    entry->type = type;
    entry->font = font;

    return entry;
}

XmFontListEntry 
XmFontListNextEntry(XmFontContext context)
{
    context->current_entry ++;

    if (context->current_entry < context->fontlist->number_of_font_entries)
	return context->fontlist->entries[context->current_entry];
    else
	return NULL;
}

Boolean
XmFontListGetNextFont(XmFontContext context, XmStringCharSet *charset, XFontStruct **font)
{
    context->current_entry ++;
    if (context->current_entry < context->fontlist->number_of_font_entries)
    {
	if (context->fontlist->entries[context->current_entry]->type
		== XmFONT_IS_FONT) {
	    *font = (XFontStruct*)(context->fontlist->
				   entries[context->current_entry]->font);
	    *charset = XtNewString(context->fontlist->
				   entries[context->current_entry]->tag);
	}
	else
	{
	    XFontStruct **foo;
	    char **bar;

	    if (XFontsOfFontSet((XFontSet)(context->fontlist->
					 entries[context->current_entry]->font),
				&foo,
				&bar) < 1)
		*font = NULL;
	    else
		*font = foo[0];
	    *charset = XtNewString(context->fontlist->
				   entries[context->current_entry]->tag);
	}
	return True;
    }
    else
	return False;
}

XmFontList 
XmFontListRemoveEntry(XmFontList oldlist,
		      XmFontListEntry entry)
{    
    XmFontList newFontList;
    int i,j;

    newFontList = __XmFontListAlloc(oldlist->number_of_font_entries-1);

    j=0;

    for (i=0; i<oldlist->number_of_font_entries; i++)
	if (!(!strcmp(entry->tag, oldlist->entries[i]->tag) &&
	      entry->type == oldlist->entries[i]->type &&
	      entry->font == oldlist->entries[i]->font))
	{
	    newFontList->entries[j]->tag = XtNewString(oldlist->entries[i]->tag);
	    newFontList->entries[j]->type = oldlist->entries[i]->type;
	    newFontList->entries[j]->font = oldlist->entries[i]->font;
	    
	    j++;
	}

    __XmFontListDealloc(oldlist);

    return newFontList;
}

XmFontList
XmFontListCreate(XFontStruct *font, XmStringCharSet charset)
{
    /* this function is obsolete and should not be used.  Use
       XmFontListAppendEntry instead */

    XmFontList	r;
    XmFontListEntry entry = (XmFontListEntry)XtMalloc(sizeof(XmFontListEntryRec));

    entry->tag = XtNewString(charset);
    entry->type = XmFONT_IS_FONT;
    entry->font = (XtPointer)font;

    r = XmFontListAppendEntry(NULL, entry);

    XdbDebug(__FILE__, NULL, "XmFontListCreate() => 0x%X\n", r);

    return r;
}

XmFontListEntry 
_XmFontListEntryFromTag(XmFontList fontlist,
			char *tag)
{
    int i;

    if (fontlist == NULL) {
	XdbDebug(__FILE__, NULL, "_XmFontListEntryFromTag(NULL,_)\n");
	return NULL;
    }

    for (i=0; i<fontlist->number_of_font_entries; i++) {
	if (!strcmp(tag, fontlist->entries[i]->tag))
	    return fontlist->entries[i];
    }

    if (strcmp(tag, XmFONTLIST_DEFAULT_TAG))
	return _XmFontListEntryFromTag(fontlist, XmFONTLIST_DEFAULT_TAG);

    XdbDebug(__FILE__, NULL, "_XmFontListEntryFromTag => NULL\n");
    if (fontlist->number_of_font_entries)
	return fontlist->entries[0];
    else
	return NULL;
}

XmFontList 
_XmFontListCreateDefault(Display *d)
{
    XmFontListEntry defaultEntry;
    XmFontList defaultList;
    XFontStruct *fs = XLoadQueryFont(d, XmDEFAULT_FONT);

    defaultEntry = XmFontListEntryCreate(XmFONTLIST_DEFAULT_TAG,
					 XmFONT_IS_FONT,
					 (XtPointer)fs);

    defaultList = XmFontListAppendEntry(NULL,
					defaultEntry);

    XdbDebug(__FILE__, NULL, "_XmFontListCreateDefault() => 0x%X\n", defaultList);

    return defaultList;
}

Boolean
_XmFontListGetDefaultFont(XmFontList fontlist,
			  XFontStruct **font_struct)
{
    XmFontListEntry entry = _XmFontListEntryFromTag(fontlist,
						    XmFONTLIST_DEFAULT_TAG);

    if (entry)
    {
	*font_struct = (XFontStruct*)entry->font;
	return True;
    }
    else
    {
	*font_struct = NULL;
	return False;
    }
}

/*
 * FIXME
 * I don't know what this should do, but this is probably close.
 */
Boolean
_XmFontListSearch(XmFontList fontlist,
		  XmStringCharSet charset,
		  short *indx,
		  XFontStruct **font_struct)
{
    XmFontListEntry entry = _XmFontListEntryFromTag(fontlist, charset);

    *indx = 0;
    if (entry)
    {
        *font_struct = (XFontStruct*)entry->font;
        return True;
    }
    else
    {
        *font_struct = NULL;
        return False;
    }
}

