/**
 *
 * $Id: Region.c,v 1.4 1996/04/23 17:40:31 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/
static char rcsid[] = "$Id: Region.c,v 1.4 1996/04/23 17:40:31 miers Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <stdio.h>

/*
 * MLM - initial implementation.  This isn't right, as Motif (for some
 * reason) uses a point pair, instead of a point/width-height (as XRectangle
 * does).  Oh well.
 */

XmRegion
_XmRegionCreate(void)
{
    return (XmRegion)XCreateRegion();
}

XmRegion
_XmRegionCreateSize(long size)
{
    return NULL;
}

void
_XmRegionComputeExtents(XmRegion r)
{
}

void
_XmRegionGetExtents(XmRegion r, XRectangle *rect)
{
    memcpy((void *)rect, &r->extents, sizeof(XRectangle));
}

void
_XmRegionUnionRectWithRegion(XRectangle *rect, XmRegion source, XmRegion dest)
{
    XUnionRectWithRegion(rect, (Region)source, (Region)dest);
}

void
_XmRegionIntersectRectWithRegion(XRectangle *rect, XmRegion source, XmRegion dest)
{
}

long 
_XmRegionGetNumRectangles(XmRegion r)
{
    return r->numRects;
}

void
_XmRegionGetRectangles(XmRegion r, XRectangle **rects, long *nrects)
{
    *rects = (XRectangle *)(r->rects);
    *nrects = r->numRects;
}

void
_XmRegionSetGCRegion(Display *dpy, GC gc, int x_origin, int y_origin, XmRegion r)
{
    XGCValues values;

    XSetRegion(dpy, gc, (Region)r);
    values.clip_x_origin = x_origin;
    values.clip_y_origin = y_origin;
    XChangeGC(dpy, gc, GCClipXOrigin|GCClipYOrigin, &values);
}

void _XmRegionDestroy(XmRegion r)
{
    XDestroyRegion((Region)r);
}

void _XmRegionOffset(XmRegion pRegion, int x, int y)
{
    XOffsetRegion((Region)pRegion, x, y);
}

void _XmRegionIntersect(XmRegion reg1, XmRegion reg2, XmRegion newReg)
{
    XIntersectRegion((Region)reg1, (Region)reg2, (Region)newReg);
}

void _XmRegionUnion(XmRegion reg1, XmRegion reg2, XmRegion newReg)
{
    XUnionRegion((Region)reg1, (Region)reg2, (Region)newReg);
}

void _XmRegionSubtract(XmRegion regM, XmRegion regS, XmRegion regD)
{
    XSubtractRegion((Region)regM, (Region)regS, (Region)regD);
}

Boolean _XmRegionIsEmpty(XmRegion r)
{
    return XEmptyRegion((Region)r);
}

Boolean _XmRegionEqual(XmRegion r1, XmRegion r2)
{
    return XEqualRegion((Region)r1, (Region)r2);
}

Boolean _XmRegionPointInRegion(XmRegion pRegion, int x, int y)
{
    return XPointInRegion((Region)pRegion, x, y);
}

void _XmRegionClear(XmRegion r)
{
}

void _XmRegionShrink(XmRegion r, int dx, int dy)
{
    XShrinkRegion((Region)r, dx, dy);
}

void _XmRegionDrawShadow(Display *display,
			 Drawable d,
			 GC top_gc,
			 GC bottom_gc,
			 XmRegion region,
			 Dimension border_thick,
			 Dimension shadow_thick,
			 unsigned int shadow_type)
{
}


