'\"
'\" Copyright (c) 1994 The Regents of the University of California.
'\" Copyright (c) 1994 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) image.n 1.6 95/06/07 21:15:16
'\" 
.so man.macros
.TH image n 4.0 Tk "Tk Image Classes"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
image \- Create and manipulate images
.SH SYNOPSIS
\fI$image\fR = \fI$widget\fR->\fItype\fR(?\fIarg arg ...\fR?)
.br
\fI$image\fR->\fImethod\fR(?\fIarg arg ...\fR?)
.BE

.SH DESCRIPTION
.PP
The \fBimage\fR constructors and methods are used to create, delete, and query images.
It can take several different forms, depending on the
\fIoption\fR argument.  
.PP
The constructors require a \fI$widget\fR to invoke them, this is used
to locate a \fBMainWindow\fR. (This is because the underlying Tk code
registers the images in the data structure for the \fBMainWindow\fR.)
.PP
The legal forms are:
.TP
\fI$widget\fR->\fItype\fR?(?\fIname\fR?,?\fIoption\fR=>\fIvalue ...\fR)?
Creates a new image and returns an object.
\fItype\fR specifies the type of the image, which must be one of
the types currently defined (e.g., \fBbitmap\fR).
\fIname\fR specifies the name for the image;  if it is omitted then
Tk picks a name of the form \fBimage\fIx\fR, where \fIx\fR is
an integer.
There may be any number of \fIoption\fR\=>\fIvalue\fR pairs,
which provide configuration options for the new image.
The legal set of options is defined separately for each image
type;  see below for details on the options for built-in image types.
If an image already exists by the given name then it is replaced
with the new image and any instances of that image will redisplay
with the new contents.
.TP
\fI$image\fR->\fBdelete\fR
Deletes the image \fI$image\fR and returns an empty string.
If there are instances of the image displayed in widgets,
the image won't actually be deleted until all of the instances
are released.
However, the association between the instances and the image
manager will be dropped.
Existing instances will retain their sizes but redisplay as
empty areas.
If a deleted image is recreated (with the same \fIname\fR)
the existing instances will use the new image.
.TP
\fI$image\fR->\fBheight\fR
Returns a decimal string giving the height of image \fIname\fR
in pixels.
.TP
\fI$widget\fR->\fBimageNames\fR
Returns a list containing all existing images for \fI$widget\fR's
\fBMainWindow\fR.
.TP
\fI$image\fR->\fBtype\fR
Returns the type of  \fI$image\fR (the value of the \fItype\fR
method when the image was created).
.TP
\fI$widget\fR->\fBimageTypes\fR
Returns a list whose elements are all of the valid image types
(i.e., all of the values that may be supplied for the \fItype\fR
to create an image).
.TP
\fI$image\fR->\fBwidth\fR
Returns a decimal string giving the width of image \fIname\fR
in pixels.

.SH "BUILT-IN IMAGE TYPES"
.PP
The following image types are defined by Tk so they will be available
in any Tk application.
Individual applications or extensions may define additional types.
.TP
\fBBitmap\fR
Each pixel in the image displays a foreground color, a background
color, or nothing.
See the \fBbitmap\fR manual entry for more information.
.TP
\fBPhoto\fR
Displays a variety of full-color images, using dithering to
approximate colors on displays with limited color capabilities.
See the \fBphoto\fR manual entry for more information.

.SH KEYWORDS
height, image, types of images, width
