$B!X(Bgnus-mime 0.8 Reference manual$B!Y(B
by MORIOKA Tomohiko
$Id: gnus-mime_en.ol,v 1.1 1996/10/05 19:46:09 morioka Exp $

* [Introduction] What is gnus-mime?

tm-gnus is a MIME extender for Gnus using tm.

Note: gnus-mime is for only Gnus. Please use tm-gnus for GNUS.
      (@pxref{(tm-gnus_en.info)})

gnus-mime supports automatic MIME preview in *Article* buffer using
tm-view. In particular, with XEmacs, it decodes images as same as
text.

In addition, gnus-mime supports multilingual/internationalization
feature for mule such as MULE, XEmacs/mule and mule merged Emacs. It
supports code-conversion by MIME charset or depended default MIME
charset of newsgroups.

For RFC 1522, original Gnus supports only Q-encoded iso-8859-1 encoded
words. So gnus-mime supports more MIME charsets, such as iso-8859-2,
iso-8859-3, ..., iso-2022-jp, euc-kr, iso-2022-kr, gb2312, big5, and
B-encoding. In addition, original Gnus does not support unfolding or
space elimination rule of RFC 1522. gnus-mime is more rightful.


* [Automatic MIME Preview] Inline display for MIME message

``Automatic MIME preview'' feature is available for gnus-mime. In
automatic MIME preview mode, when reading an article in summary mode,
gnus-mime displays preview buffer processed by tm-view instead of raw
article buffer. (@pxref{(tm_en.info)tm-view})

Therefore if an article is encoded by Quoted-Printable or Base64, a
decoded article is displayed. Or rich text article is automatic
formated. Of course, multipart article is dealt with correctly.

Different from using metamail, speaker does not roar just then read an
article includes audio content, video player does not play just then
read an article includes video content, it does not do anonymous ftp
or send mail when read an article includes external-message. These
contents are played when you do decoding command in preview buffer.

In addition, in XEmacs, images are displayed in preview buffer as same
as text.

However if you use a slow machine, or are just really impatient, you
can stop automatic MIME preview.


** [MIME processing] How to process MIME in Article Buffer

When @code{gnus-show-mime} is not @code{nil} and an article has
Mime-Version field in its message header, namely it is a MIME message,
Gnus calls @code{gnus-show-mime-method} to process MIME.

When @code{gnus-strict-mime} is @code{nil} and @code{gnus-show-mime}
is not @code{nil}, Gnus calls @code{gnus-show-mime-method} even if an
message does not have Mime-Version field in its message header.

Gnus 5.2 or later calls @code{gnus-show-mime-method} when
@code{gnus-strict-mime} is not @code{nil} and an article does not have
Mime-Version field. Notice that old Gnus does not have it, so it may
be better to set @code{gnus-strict-mime} to @code{nil}.


[Variable] gnus-show-mime

	If it is not @code{nil}, Gnus do automatic MIME preview.
	Default value is @code{t}.

	It is a variable of Gnus, so if gnus is loaded before
	gnus-mime is loaded, default value is not guaranteed.
	(@pxref{(gnus)Using MIME})

[Variable] gnus-show-mime-method

	Gnus calls function bound by it to process MIME.  Default
	value is @code{gnus-article-preview-mime-message}.

	It is a variable of Gnus, so if gnus is loaded before
	gnus-mime is loaded, default value is not guaranteed.
	(@pxref{(gnus)Using MIME})

[Variable] gnus-decode-encoded-word-method

	Gnus calls function bound by it to decode encoded-words.
	Default value is @code{gnus-article-decode-encoded-word}.

	It is a variable of Gnus, so if gnus is loaded before
	gnus-mime is loaded, default value is not guaranteed.
	(@pxref{(gnus)Using MIME})

	In addition, it is not available at Gnus 5.0.* or Gnus 5.1.


*** Notice

gnus-mime uses some variables of Gnus and defines different default
values by @code{defvar}. For example, gnus-mime's default value of
@code{gnus-show-mime} is @code{t} instead of @code{nil}.  Or its
default value of @code{gnus-show-mime-method} is
@code{gnus-article-preview-mime-message} instead of
@code{metamail-buffer}. (@pxref{(gnus)Using MIME})

gnus-mime uses @code{defvar} instead of @code{setq}, because of
respect user's setting before gnus-mime is loaded.  But it has a
problem.  If gnus is loaded before gnus-mime is loaded, features of
gnus-mime is not available in default even if gnus-mime is loaded.
Therefore there is serious problem to load gnus before gnus-mime is
loaded.  In other words, setting in @file{~/.gnus}, such as to load
@file{gnus-mime} or @file{mime-setup}, is not good way.


** [Two buffers for an article] Mechanism of Automatic MIME preview

Gnus 5.2 or later has two buffers for an article,
@code{gnus-original-article-buffer} (@code{" *Original Article*"}) and
@code{gnus-article-buffer} (@code{"*Article*"}).  The former is called
``raw article buffer'', the latter is called ``preview buffer''.

Content of ``raw article buffer'' is non-processed ``raw message''.
In particular, for emacs variants includes mule features, message is
not code-converted in it.

Content of ``preview buffer'' is MIME processed message to display for
user. In particular, for emacs variants includes mule features,
non-ASCII message is code-converted in it by MIME charset or default
MIME charset for selected newsgroup.

Gnus 5.0.* and Gnus 5.1 don't have distinction between ``raw article
buffer'' and ``preview buffer''.  So gnus-mime emulate ``raw article
buffer''.  It may be better to use Gnus 5.2 or later.


* [mule] Internationalization

For emacs variants includes mule feature, such as MULE, XEmacs/mule
and mule merged Emacs (*1), gnus-mime supports code-conversion by MIME
charset or default MIME charset of selected newsgroup.

(*1) It means next generation of Emacs includes mule features. Now
     (October 1996), HANDA Ken'ichi and RMS are developing it.


Detail of code conversion is following:

(1) If a newsgroup is selected, MIME charset for the newsgroup is
    searched from @code{gnus-newsgroup-default-charset-alist}.  If it
    is found, it is set to buffer local variable
    @code{default-mime-charset} of Summary Buffer. If not found,
    global value of @code{default-mime-charset} is used.

(2) Non-ASCII characters in Summary Buffer are code-converted by
    @code{default-mime-charset} in Summary Buffer.

(3) encoded-words are code-converted by their specified charsets.

(4) Code-conversion of articles are following:

	(a) If a part of a MIME message has charset parameter of
            Content-Type field, it is code-converted by the MIME
            charset.

	(b) When there are no specified MIME charset, such as message
            header or non-MIME message, they are code-converted by 
            @code{default-mime-charset} in Summary Buffer.


[Variable] gnus-newsgroup-default-charset-alist

	Alist regexp for newsgroup vs. symbol for default MIME
	charset.

	Default setting are following:

		@code{hz}:   alt.chinese.*

		@code{big5}: alt.chinese.text.big5,
				hk.*, hkstar.* and tw.*

		@code{iso-2022-jp-2}: fj.*

		@code{euc-kr}: han.*

		@code{koi8-r}: relcom.*

	If there is no MIME charsets for a newsgroup, 
	@code{default-mime-charset} is used as default MIME charset.

[Function] gnus-set-newsgroup-default-charset	NEWSGROUP CHARSET

	Set default MIME CHARSET of NEWSGROUP to
	@code{gnus-newsgroup-default-charset-alist}.
	
	NEWSGROUP is string of newsgroup name or category, for example
	"gnu.emacs.gnus", "gnu.emacs", "gnu".

	CHARSET is symbol of MIME charset, for example
	@code{iso-8859-1}, @code{iso-2022-jp}.


* [MIME-Edit] Composing MIME messages

If using mime-setup (@pxref{(tm_en.info)Setting}), you can edit MIME
message in mh-letter-mode using tm-edit. (@pxref{(tm_en.info)tm-edit})

Note: Default setting of mime-setup avoids automatic inserting
      signature when sending a message. Its reason is described at
      @pxref{(tm_en.info)mime-setup}.

gnus-mime does not have implementation for @kbd{C-c C-x C-m}
(@code{mime-editor/insert-mail}).  Because gnus-mime does not know
which mail-reader should be used.  In addition, @kbd{C-c C-x C-y}
(@code{mime-editor/insert-message}) is enough to insert mail (namely
to select a mail group and select a message to insert, then it is
available to insert the mail message).

However you can use @kbd{C-c C-x C-m} to specify an implementation of
message-mode to @code{mime-editor/mail-inserter-alist}.

Example: same as @kbd{C-c C-x C-m}

[[E
(set-alist 'mime-editor/mail-inserter-alist
	   'message-mode (function message-mime-insert-article))
]]E


Example: including from MH folder

[[E
(autoload 'tm-mh-e/insert-mail "tm-mh-e")

(set-alist 'mime-editor/mail-inserter-alist
	   'message-mode (function tm-mh-e/insert-mail))
]]E
