
/* Written by Peter Ekberg, peda@lysator.liu.se */

#include <string.h>
#include <stdio.h>
#include <vgagl.h>
#include <vga.h>
#include "thrust.h"

byte *bild;

byte fuelblink;

void
putscr(x, y)
     int x,y;
{
  byte *tmp;
  byte *maxtmp;
  int res;

  maxtmp=bild+((PBILDY-1)*PBILDX<<1);
  tmp=bild+y*(PBILDX<<1)+x;

  for(res=0; res<PSCRX*PSCRY; res+=PSCRX) {
    memcpy(graph_mem+res, tmp, PSCRX);
    if(tmp>=maxtmp)
      tmp=bild+x;
    else
      tmp+=PBILDX<<1;
  }
}

void
savegraphics(x, y)
     int x,y;
{
  byte *tmp;
  byte *maxtmp;
  int res;
  FILE *f;

  maxtmp=bild+((PBILDY-1)*PBILDX<<1);
  tmp=bild+y*(PBILDX<<1)+x;
  
  f=fopen("screendump.bin","wb");
  for(res=0; res<PSCRX*PSCRY; res+=PSCRX) {
    fwrite(tmp,1,PSCRX,f);
    if(tmp>=maxtmp)
      tmp=bild+x;
    else
      tmp+=PBILDX<<1;
  }
  fclose(f);
}

void
putblock(x, y, source)
     int x,y;
     byte *source;
{
  int i;
  byte *dest1, *dest2;

  dest1=bild+((y<<3)*(PBILDX<<1))+(x<<3);
  dest2=dest1+((x>=BBILDX)?-(PBILDX):(PBILDX));
  
  for(i=0; i<8; i++) {
    memcpy(dest1, source, 8);
    memcpy(dest2, source, 8);
    source+=8;
    dest1+=PBILDX<<1;
    dest2+=PBILDX<<1;
  }
}

void
drawfuel(fuel)
     int fuel;
{
/*
  byte *dest;
  byte color;
  int size,i;

  dest=graph_mem+195*320+249;
  fuelblink=(fuelblink-1)&31;
  size=(fuel+9)/10;
  if(size>10 || fuelblink&16)
    color=4;
  else
    color=0;

  for(i=0; i<4; i++) {
    memset(dest,color,size);
    memset(dest+size,0,70-size);
    dest+=320;
  }
*/
  char str[16];
  byte tmpcol, tmppap, tmpflg;
  tmpcol=chcolor;
  tmppap=chpaper;
  tmpflg=chflag;
  chpaper=0;
  fuelblink=(fuelblink-1)&31;
  if(((fuel+9)/10)>10 || fuelblink&16)
    chcolor=4;
  else
    chcolor=0;
  chflag=1;
  sprintf(str, "%d  ", fuel);
  printgs(249, 195, str);
  chflag=tmpflg;
  chpaper=tmppap;
  chcolor=tmpcol;
}

void
drawship(bx, by, ship, storage)
     word bx,by;
     byte *ship, *storage;
{
  byte *maxtmp, *tmp, pix;
  int i,j;

  maxtmp=bild+((PBILDY-1)*PBILDX<<1);
  tmp=bild+by*(PBILDX<<1)+bx;
  for(i=0; i<256; i+=16) {
    memcpy(storage+i, tmp, 16);
    for(j=0; j<16; j++) {
      pix=*(ship++);
      if(pix)
	*(tmp+j)=pix;
    }
    if(tmp>=maxtmp)
      tmp=bild+bx;
    else
      tmp+=PBILDX<<1;
  }
}

void
undrawship(bx, by, storage)
     word bx,by;
     byte *storage;
{
  byte *maxtmp, *tmp;
  int i;

  maxtmp=bild+((PBILDY-1)*PBILDX<<1);
  tmp=bild+by*(PBILDX<<1)+bx;
  for(i=0; i<256; i+=16) {
    memcpy(tmp, storage+i, 16);
    if(tmp>=maxtmp)
      tmp=bild+bx;
    else
      tmp+=PBILDX<<1;
  }    
}

void
drawsquare(bx, by, object, storage, deltax, deltay)
     word bx,by;
     byte *object, *storage, deltax, deltay;
{
  byte *maxtmp, *tmp, pix;
  int i,j;
  word deltaxy;

  deltaxy=(word)deltax*deltay;
  maxtmp=bild+((PBILDY-1)*PBILDX<<1);
  tmp=bild+by*(PBILDX<<1)+bx;
  for(i=0; i<deltaxy; i+=(int)deltax) {
    memcpy(storage+i, tmp, (int)deltax);
    for(j=0; j<(int)deltax; j++) {
      pix=*(object++);
      if(pix)
	*(tmp+j)=pix;
    }
    if(tmp>=maxtmp)
      tmp=bild+bx;
    else
      tmp+=PBILDX<<1;
  }
}

void
undrawsquare(bx, by, storage, deltax, deltay)
     word bx,by;
     byte *storage, deltax, deltay;
{
  byte *maxtmp, *tmp;
  int i;
  word deltaxy;

  deltaxy=(word)deltax*deltay;
  maxtmp=bild+((PBILDY-1)*PBILDX<<1);
  tmp=bild+by*(PBILDX<<1)+bx;
  for(i=0; i<deltaxy; i+=(int)deltax) {
    memcpy(tmp, storage+i, (int)deltax);
    if(tmp>=maxtmp)
      tmp=bild+bx;
    else
      tmp+=PBILDX<<1;
  }
}

word
testcrash(object, storage, len, shield)
     byte *object, *storage;
     word len;
     byte shield;
{
  word i;
  byte res=0;

  for(i=0; i<len; i++) {
    if(*(object++)) {
      if(*storage>res && (!shield || (shield && *storage<224)))
	res=*storage;
    }
    storage++;
  }
  return(((word)res)>>5);
}

void
fadepalette(first, last, RGBtable, fade, flag)
     word first, last;
     Palette *RGBtable;
     word fade;
     word flag;
{
/*
  static Palette tmpRGBtable;
  int entries,e,i;
  byte *c;

  entries=(e=last-first+1)*3;
  memcpy(&tmpRGBtable, RGBtable, sizeof(Palette));
  c=(char *)&tmpRGBtable;
  for(i=0; i<sizeof(Palette); i++)
    *(c++)=((*c)*fade)>>8;
  if(flag)
    vga_waitretrace();
  gl_setpalettecolors(first, e, &tmpRGBtable);
*/
  static int tmpRGBtable[768];
  int entries,i;
  int *c;
  byte *d;

  entries=last-first+1;
  
  c=(int *)&tmpRGBtable;
  d=(byte *)RGBtable;
  i=0;

  while(i<3*entries) {
    *c = (*d * fade) >> 8;
    if(++i<3*entries) {
      c++;
      d++;
    }
  }

  if(flag)
    vga_waitretrace();
  vga_setpalvec(first, entries, tmpRGBtable);
}

void
setmargin(color, flag)
     byte color,flag;
{
  if(!flag)
    vga_waitretrace();

/* The color isn't changed */
}
