/*
** Copyright (c) 1996 Thorsten Kukuk
**
** This file is part of the NYS YP Server.
**
** The NYS YP Server is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS YP Server is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
** 
** You should have received a copy of the GNU General Public
** License along with the NYS YP Server; see the file COPYING.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Author: Thorsten Kukuk <kukuk@uni-paderborn.de>
*/

#ifndef _DATA_H_
#define _DATA_H_

#define TABLESIZE 997 /*Should be a prime */

typedef struct data {
  char *key;
  char *val;
  struct data *next;
} data_t;

extern int hash_insert (data_t **table, const char *key, const char *val);
extern int hash_free (data_t **table);
extern char *hash_search (data_t **table, const char *key);
extern int hash_delkey (data_t **table, const char *key);
extern data_t **hash_malloc (void);
extern data_t *hash_first (data_t **table);
extern data_t *hash_next (data_t **table, const char *key);

#endif
