/* Copyright (C) 1994 
            Olav Woelfelschneider (wosch@rbg.informatik.th-darmstadt.de)

 This library is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <X11/Xlib.h>
#include <stdio.h>
#include <string.h>
#include "McAlloc.h"
#include "McApp.h"
#include "McGadget.h"
#include "McLoad.h"

#define LOAD ((McLoad *)(gadget->specialInfo))

static void McLoadUpdate(McGadget *gadget, int busy, int all);
static int McLoadEvent(McGadget *gadget, XEvent *event);
static void McLoadCleanup(McGadget *gadget);

McSpecialInfo *McCreateLoad(unsigned int flags, int depth,
			    int min, int max, int base) {
  McLoad *load = (McLoad *) McAlloc(sizeof(McLoad));
  load->flags = flags;
  load->depth=depth;
  load->ptr=0;
  load->min=min;
  load->max=max;
  load->base=base;

  load->data = (signed short *)McAlloc(depth * sizeof(signed short));

  load->specialInfo.updateProc = McLoadUpdate;
  load->specialInfo.eventProc = McLoadEvent;
  load->specialInfo.cleanupProc = McLoadCleanup;

  return (McSpecialInfo *)load;
}

static void McLoadCleanup(McGadget *gadget) {
  McFree(LOAD->data);
  McFree(gadget->specialInfo);
}

static void McLoadUpdate(McGadget *gadget, int busy,int all) {

  int ptr,py,px,x=gadget->x,y=gadget->y,w=gadget->width,h=gadget->height;
  int ye = y+h-1;
  McWindow *mcw=gadget->mcw;
  McApp *app = mcw->app;
  Display *dsp = app->display;
  GC gc1,gc2;

  if (gadget->flags & GAD_SELECTED) {
    gc1=app->gc[GC_SELECTED];
    gc2=app->gc[GC_DARK];
  } else {
    gc1=app->gc[GC_NORMAL];
    gc2=app->gc[GC_DARK];
  }

  ptr=LOAD->ptr;
  if (LOAD->flags & LOAD_RIGHT_ALIGNED) {
    px=x+w-1;
  } else {
    if (ptr>=w) {
      px=x+w-1;
    } else {
      px=x+ptr;
      if (px<=(x+w-1))
	XFillRectangle(dsp, mcw->window, gc1, px, y, w-(px-x), h);
    }
    px--;
  }

  if (LOAD->flags & LOAD_BAR) {
    while ((px>=x) && ptr) {
      py = y + h - ((LOAD->data[--ptr]-LOAD->min) * h / LOAD->max);
      if (py)   XDrawLine(dsp, mcw->window, gc1, px,  y, px, py-1);
      if (py<h) XDrawLine(dsp, mcw->window, gc2, px, py, px, y+h-1);
      px--;
    }
  } else {
    while ((px>=x) && ptr) {
      py = y + h - ((LOAD->data[--ptr]-LOAD->min) * h / LOAD->max);
      XDrawLine (dsp, mcw->window, gc1, px,  y, px, ye);
      XDrawPoint(dsp, mcw->window, gc2, px, py-1);
      px--;
    }
  }
  if (px>=x) {
    XFillRectangle(dsp, mcw->window, gc1, x, y, px-x+1, h);
  }
}

static int McLoadEvent(McGadget *gadget, XEvent *event) {
  return 0;
}

void McLoadShiftIn(McGadget *gadget, signed short val) {
  if (LOAD->ptr >= LOAD->depth) {
    memmove(LOAD->data,&LOAD->data[1],(LOAD->depth-1)*sizeof(signed short));
    LOAD->ptr=LOAD->depth-1;
    LOAD->data[LOAD->ptr++]=val;
  } else {
    LOAD->data[LOAD->ptr++]=val;
  }
  McGadgetUpdate(gadget);
}
