/*
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2, or (at your option)
     any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/**************************************************************************/

#include <X11/Xlib.h>
#include <X11/xpm.h>

#include "McApp.h"
#include "McBitmap.h"
#include "icons.h"

#include "aux.xpm"
#include "blaster.xpm"
#include "cd.xpm"
#include "fm.xpm"
#include "mic.xpm"
#include "mon.xpm"
#include "tape.xpm"
#include "wave.xpm"
#include "speaker.xpm"
#include "mix_play.xpm"
#include "mix_rec.xpm"
#include "bass.xpm"
#include "treble.xpm"
#include "vol.xpm"

#include "speaker.xbm"
#include "speaker_mask.xbm"
#include "wide.xbm"
#include "wideoff.xbm"
#include "mute.xbm"
#include "volume.xbm"

McBitmap pmap[] = {
  MCBITMAP(speaker_bits, speaker_width, speaker_height, 0, 0),
  MCBITMAP(speaker_mask_bits, speaker_mask_width, speaker_mask_height, 0, 0),
  MCBITMAP(wide_bits, wide_width, wide_height, 5, 2),
  MCBITMAP(mute_bits, mute_width, mute_height, 8, 2),
  MCBITMAP(volume_bits, volume_width, volume_height, 8, 2),
  MCBITMAP(wideoff_bits, wideoff_width, wideoff_height, 8, 2),

  MCPIXMAP(vol_xpm,                                  4, 1), /*vol*/
  MCPIXMAP(bass_xpm,                                 4, 1), /*bass*/
  MCPIXMAP(treble_xpm,                               4, 1), /*treble*/
  MCPIXMAP(fm_xpm,                                   4, 1), /*synth*/
  MCPIXMAP(wave_xpm,                                 4, 1), /*pcm*/
  MCPIXMAP(speaker_xpm,                              4, 1), /*spkr*/
  MCPIXMAP(aux_xpm,                                  4, 1), /*line*/
  MCPIXMAP(mic_xpm,                                  4, 1), /*mic*/
  MCPIXMAP(cd_xpm,                                   4, 1), /*cd*/
  MCPIXMAP(mon_xpm,                                  4, 1), /*mix*/
  MCPIXMAP(blaster_xpm,                              4, 1), /*pcm2*/
  MCPIXMAP(tape_xpm,                                 4, 1), /*rec*/

  MCPIXMAP(mix_play_xpm,                             0, 0),
  MCPIXMAP(mix_rec_xpm,                              0, 0),
};






