/* Fichier contenant les fonctions attachees aux objets graphiques */
#include "objects.h"
#include <string.h>
#include <stdio.h>

/* Constante de couleurs utilise dans le tableau TabColor */
#define black 0
#define white 1
#define back 2
#define fore 3
#define shad 4
#define li 5

/* Constante pour les type de message envoie entre objets */
/* <0 valeur reserve pour les messages internes */
/* =0 message changment de valeur */
/* >0 message envoie par l'utilisateur */
#define ModifValue 0


/***********************************************/
/* Fonction de dessin d'un rectangle en relief */
/***********************************************/
void DrawReliefRect(int x,int y,int width,int height,struct XObj *xobj,
		unsigned int LiC, unsigned int ShadC,int PosRect)
{
 XSegment segm[2];
 int i;
 int j; 

/* XSetForeground(xobj->display,xobj->gc,xobj->TabColor[back].pixel);
 XFillRectangle(xobj->display,xobj->ObjWin,xobj->gc,x,y,width,height);*/

 for (i=0;i<3;i++)
 {
  j=-1-i;
  segm[0].x1=i;
  segm[0].y1=i;
  segm[0].x2=i;
  segm[0].y2=height+j;
  segm[1].x1=i;
  segm[1].y1=i;
  segm[1].x2=width+j;
  segm[1].y2=i;
  XSetForeground(xobj->display,xobj->gc,LiC);
  XDrawSegments(xobj->display,xobj->ObjWin,xobj->gc,segm,2);
 
  segm[0].x1=width+j;
  segm[0].y1=i+1;
  segm[0].x2=width+j;
  segm[0].y2=height+j;
  segm[1].x1=i+1;
  segm[1].y1=height+j;
  segm[1].x2=width+j;
  segm[1].y2=height+j;
  XSetForeground(xobj->display,xobj->gc,ShadC);
  XDrawSegments(xobj->display,xobj->ObjWin,xobj->gc,segm,2);
 }
 XSetForeground(xobj->display,xobj->gc,xobj->TabColor[black].pixel);
 XDrawRectangle(xobj->display,xobj->ObjWin,xobj->gc,PosRect,PosRect,
		width-1-(PosRect*2),height-1-(PosRect*2));
 XSetForeground(xobj->display,xobj->gc,xobj->TabColor[fore].pixel);
}

/***********************************************/
/* Fonction d'ecriture en relief               */
/***********************************************/
void DrawReliefString(Display *disp,Window win,GC gc,int x,
	int y,char *str,int strl,unsigned long ForeC,unsigned long BackC)
{
 XSetForeground(disp,gc,BackC);
 XDrawImageString(disp,win,gc,x+1,y+1,str,strl);
 XSetForeground(disp,gc,ForeC);
 XDrawString(disp,win,gc,x,y,str,strl);
}

/***********************************************/
/* Calcul ascent de la police                  */
/***********************************************/
int GetAscFont(XFontStruct *xfont)
{
 return xfont->max_bounds.ascent;
}

/***********************************************/
/* Fonction pour PushButton                    */
/***********************************************/
void InitPushButton(struct XObj *xobj)
{
 unsigned long mask;
 XSetWindowAttributes Attr;
 unsigned long White,Black;
 XColor TempColor;

 /* Enregistrement des couleurs et de la police */
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->forecolor,&xobj->TabColor[fore],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->backcolor,&xobj->TabColor[back],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->licolor,&xobj->TabColor[li],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->shadcolor,&xobj->TabColor[shad],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	"black",&xobj->TabColor[black],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	"white",&xobj->TabColor[white],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");

 mask=0;
 Attr.background_pixel=xobj->TabColor[back].pixel;
 mask|=CWBackPixel;
 Attr.cursor=XCreateFontCursor(xobj->display,XC_hand2); 
 mask|=CWCursor;		/* Curseur pour la fenetre */

 /* Epaisseur de la fenetre = 0 */
 xobj->ObjWin=XCreateWindow(xobj->display,*xobj->ParentWin,
		xobj->x,xobj->y,xobj->width,xobj->height,0,
		CopyFromParent,InputOutput,CopyFromParent,
		mask,&Attr);
 xobj->gc=XCreateGC(xobj->display,xobj->ObjWin,0,NULL);
 XSetForeground(xobj->display,xobj->gc,xobj->TabColor[fore].pixel);
 XSetBackground(xobj->display,xobj->gc,xobj->TabColor[back].pixel);
 if ((xobj->xfont=XLoadQueryFont(xobj->display,xobj->font))==NULL)
  {
   fprintf(stderr,"Can't load font %s\n",xobj->font);
  }
 else
  XSetFont(xobj->display,xobj->gc,xobj->xfont->fid);

 XSetLineAttributes(xobj->display,xobj->gc,1,LineSolid,CapRound,JoinMiter);
}

void DestroyPushButton(struct XObj *xobj)
{
 XFreeFont(xobj->display,xobj->xfont);
 XFreeGC(xobj->display,xobj->gc);
 XDestroyWindow(xobj->display,xobj->ObjWin);
}

void DrawPushButton(struct XObj *xobj)
{
 int i,j;

 DrawReliefRect(xobj->x,xobj->y,xobj->width,xobj->height,xobj,
	xobj->TabColor[li].pixel,xobj->TabColor[shad].pixel,0);

 /* Calcul de la position de la chaine de charactere */
 j=xobj->height/2+3;
 i=(xobj->width-XTextWidth(xobj->xfont,xobj->title,strlen(xobj->title)))/2;
 DrawReliefString(xobj->display,xobj->ObjWin,xobj->gc,i,j,xobj->title,
	strlen(xobj->title),xobj->TabColor[fore].pixel,xobj->TabColor[white].pixel);
}

void EvtMousePushButton(struct XObj *xobj)
{
 static XEvent event;
 int End=1;
 unsigned int modif;
 int x1,x2,y1,y2,i,j;
 Window Win1,Win2;
 Window WinBut=0;
 int In;
 char **Buff;

 j=xobj->height/2+3;
 i=(xobj->width-XTextWidth(xobj->xfont,xobj->title,strlen(xobj->title)))/2;

 while (End)
 {
  XNextEvent(xobj->display, &event);
  switch (event.type)
    {
      case EnterNotify:
	   XQueryPointer(xobj->display,*xobj->ParentWin,
		&Win1,&Win2,&x1,&y1,&x2,&y2,&modif);
	   if (WinBut==0)
	   {
	    WinBut=Win2;
	    DrawReliefRect(xobj->x,xobj->y,xobj->width,xobj->height,xobj,
		xobj->TabColor[shad].pixel,xobj->TabColor[li].pixel,0);
	    DrawReliefString(xobj->display,xobj->ObjWin,xobj->gc,i+1,j+1,xobj->title,
		strlen(xobj->title),xobj->TabColor[fore].pixel,xobj->TabColor[white].pixel);
	    In=1;
	   }
	   else
	   {
	    if (Win2==WinBut)
	    {
	     DrawReliefRect(xobj->x,xobj->y,xobj->width,xobj->height,xobj,
		xobj->TabColor[shad].pixel,xobj->TabColor[li].pixel,0);
	    DrawReliefString(xobj->display,xobj->ObjWin,xobj->gc,i+1,j+1,xobj->title,
		strlen(xobj->title),xobj->TabColor[fore].pixel,xobj->TabColor[white].pixel);
	     In=1;
	    }
	    else if (In)
	    {
	     In=0;
	     DrawReliefRect(xobj->x,xobj->y,xobj->width,xobj->height,xobj,
		xobj->TabColor[li].pixel,xobj->TabColor[shad].pixel,0);
	     DrawReliefString(xobj->display,xobj->ObjWin,xobj->gc,i,j,xobj->title,
		strlen(xobj->title),xobj->TabColor[fore].pixel,xobj->TabColor[white].pixel);
	    }
	   }
	  break;
      case LeaveNotify:
	   XQueryPointer(xobj->display,*xobj->ParentWin,
		&Win1,&Win2,&x1,&y1,&x2,&y2,&modif);
	   if (Win2==WinBut)
	   {
	    In=1;
	    DrawReliefRect(xobj->x,xobj->y,xobj->width,xobj->height,xobj,
		xobj->TabColor[shad].pixel,xobj->TabColor[li].pixel,0);
	    DrawReliefString(xobj->display,xobj->ObjWin,xobj->gc,i+1,j+1,xobj->title,
		strlen(xobj->title),xobj->TabColor[fore].pixel,xobj->TabColor[white].pixel);
	   }
	   else if (In)
	   {
	    DrawReliefRect(xobj->x,xobj->y,xobj->width,xobj->height,xobj,
		xobj->TabColor[li].pixel,xobj->TabColor[shad].pixel,0);
	    DrawReliefString(xobj->display,xobj->ObjWin,xobj->gc,i,j,xobj->title,
		strlen(xobj->title),xobj->TabColor[fore].pixel,xobj->TabColor[white].pixel);
	    In=0;
	   }
	  break;
      case ButtonRelease:
	   End=0;
	   DrawReliefRect(xobj->x,xobj->y,xobj->width,xobj->height,xobj,
		xobj->TabColor[li].pixel,xobj->TabColor[shad].pixel,0);
	   DrawReliefString(xobj->display,xobj->ObjWin,xobj->gc,i,j,xobj->title,
		strlen(xobj->title),xobj->TabColor[fore].pixel,xobj->TabColor[white].pixel);
	   if (In)
	   {
	    /* Envoie d'un message vide de type ModifValue pour un clique souris */
	    SendMsg(xobj,ModifValue);
	   }
	  break;
     }
 }
}

void EvtKeyPushButton(struct XObj *xobj,XKeyEvent *EvtKey)
{
}

/***********************************************/
/* Fonction pour RadioButton                    */
/***********************************************/
void InitRadioButton(struct XObj *xobj)
{
 unsigned long mask;
 XSetWindowAttributes Attr;
 unsigned long White,Black;
 XColor TempColor;

 /* Enregistrement des couleurs et de la police */
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->forecolor,&xobj->TabColor[fore],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->backcolor,&xobj->TabColor[back],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->licolor,&xobj->TabColor[li],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->shadcolor,&xobj->TabColor[shad],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	"black",&xobj->TabColor[black],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	"white",&xobj->TabColor[white],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");

 mask=0;
 Attr.background_pixel=xobj->TabColor[back].pixel;
 mask|=CWBackPixel;
 Attr.cursor=XCreateFontCursor(xobj->display,XC_hand2); 
 mask|=CWCursor;		/* Curseur pour la fenetre */

 xobj->ObjWin=XCreateWindow(xobj->display,*xobj->ParentWin,
		xobj->x,xobj->y,xobj->width,xobj->height,0,
		CopyFromParent,InputOutput,CopyFromParent,
		mask,&Attr);
 xobj->gc=XCreateGC(xobj->display,xobj->ObjWin,0,NULL);
 XSetForeground(xobj->display,xobj->gc,xobj->TabColor[fore].pixel);
 XSetBackground(xobj->display,xobj->gc,xobj->TabColor[back].pixel);
 if ((xobj->xfont=XLoadQueryFont(xobj->display,xobj->font))==NULL)
   fprintf(stderr,"Can't load font %s\n",xobj->font);
 else
  XSetFont(xobj->display,xobj->gc,xobj->xfont->fid);

 XSetLineAttributes(xobj->display,xobj->gc,1,LineSolid,CapRound,JoinMiter);
}

void DestroyRadioButton(struct XObj *xobj)
{
 XFreeFont(xobj->display,xobj->xfont);
 XFreeGC(xobj->display,xobj->gc);
 XDestroyWindow(xobj->display,xobj->ObjWin);
}

void DrawRadioButton(struct XObj *xobj)
{
 int i,j;

 j=xobj->height/2+3;
 i=16;
 /* Dessin du cercle arrondi */
 XSetForeground(xobj->display,xobj->gc,xobj->TabColor[shad].pixel);
 XDrawArc(xobj->display,xobj->ObjWin,xobj->gc,1,j-11,11,11,45*64,180*64);
 XSetForeground(xobj->display,xobj->gc,xobj->TabColor[li].pixel);  
 XDrawArc(xobj->display,xobj->ObjWin,xobj->gc,1,j-11,11,11,225*64,180*64); 
 XSetForeground(xobj->display,xobj->gc,xobj->TabColor[white].pixel);  
 XFillArc(xobj->display,xobj->ObjWin,xobj->gc,2,j-10,9,9,0*64,360*64);
 XSetForeground(xobj->display,xobj->gc,xobj->TabColor[black].pixel);  
 XDrawArc(xobj->display,xobj->ObjWin,xobj->gc,2,j-10,9,9,0*64,360*64);
 if (xobj->value)
 {
  XSetForeground(xobj->display,xobj->gc,xobj->TabColor[black].pixel);  
  XFillArc(xobj->display,xobj->ObjWin,xobj->gc,3,j-9,7,7,0*64,360*64);
 }

 /* Calcul de la position de la chaine de charactere */
 DrawReliefString(xobj->display,xobj->ObjWin,xobj->gc,i,j,xobj->title,
	strlen(xobj->title),xobj->TabColor[fore].pixel,xobj->TabColor[white].pixel);
}

void EvtMouseRadioButton(struct XObj *xobj)
{
 static XEvent event;
 int End=1;
 unsigned int modif;
 int x1,x2,y1,y2,i,j;
 Window Win1,Win2;
 Window WinBut=0;
 int In;
 char **Buff;

 j=xobj->height/2+3;
 i=(xobj->width-XTextWidth(xobj->xfont,xobj->title,strlen(xobj->title)))/2;

 while (End)
 {
  XNextEvent(xobj->display, &event);
  switch (event.type)
    {
      case EnterNotify:
	   XQueryPointer(xobj->display,*xobj->ParentWin,
		&Win1,&Win2,&x1,&y1,&x2,&y2,&modif);
	   if (WinBut==0)
	   {
	    WinBut=Win2;
	    /* Mouse on button */
	    XSetForeground(xobj->display,xobj->gc,xobj->TabColor[shad].pixel);  
	    XFillArc(xobj->display,xobj->ObjWin,xobj->gc,3,j-9,7,7,0*64,360*64);
	    In=1;
	   }
	   else
	   {
	    if (Win2==WinBut)
	    {
	    /* Mouse on button */
	     XSetForeground(xobj->display,xobj->gc,xobj->TabColor[shad].pixel);  
	     XFillArc(xobj->display,xobj->ObjWin,xobj->gc,3,j-9,7,7,0*64,360*64); 
	     In=1;
	    }
	    else if (In)
	    {
	     In=0;
	     /* Mouse not on button */
	     XSetForeground(xobj->display,xobj->gc,xobj->TabColor[white].pixel);  
	     XFillArc(xobj->display,xobj->ObjWin,xobj->gc,3,j-9,7,7,0*64,360*64); 
	    }
	   }
	  break;
      case LeaveNotify:
	   XQueryPointer(xobj->display,*xobj->ParentWin,
		&Win1,&Win2,&x1,&y1,&x2,&y2,&modif);
	   if (Win2==WinBut)
	   {
	    In=1;
	    /* Mouse on button */
	    XSetForeground(xobj->display,xobj->gc,xobj->TabColor[shad].pixel);  
	    XFillArc(xobj->display,xobj->ObjWin,xobj->gc,3,j-9,7,7,0*64,360*64); 
	   }
	   else if (In)
	   {
	    /* Mouse not on button */
	    XSetForeground(xobj->display,xobj->gc,xobj->TabColor[white].pixel);  
	    XFillArc(xobj->display,xobj->ObjWin,xobj->gc,3,j-9,7,7,0*64,360*64); 
	    In=0;
	   }
	  break;
      case ButtonRelease:
	   End=0;
	   /* Mouse not on button */
	   if (In)
	   {
	    /* Envoie d'un message vide de type ModifValue pour un clique souris */
	    xobj->value=1;
	    XSetForeground(xobj->display,xobj->gc,xobj->TabColor[black].pixel);  
	    XFillArc(xobj->display,xobj->ObjWin,xobj->gc,3,j-9,7,7,0*64,360*64);
	    SendMsg(xobj,ModifValue);
	   }
	   else if (xobj->value)
	   {
	    XSetForeground(xobj->display,xobj->gc,xobj->TabColor[black].pixel);  
	    XFillArc(xobj->display,xobj->ObjWin,xobj->gc,3,j-9,7,7,0*64,360*64);
	   }
	  break;
     }
 }
}

void EvtKeyRadioButton(struct XObj *xobj,XKeyEvent *EvtKey)
{
}

/***********************************************/
/* Fonction pour ItemDraw                      */
/***********************************************/
void InitItemDraw(struct XObj *xobj)
{
 unsigned long mask;
 XSetWindowAttributes Attr;
 unsigned long White,Black;
 XColor TempColor;

 /* Enregistrement des couleurs et de la police */
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->forecolor,&xobj->TabColor[fore],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->backcolor,&xobj->TabColor[back],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->licolor,&xobj->TabColor[li],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->shadcolor,&xobj->TabColor[shad],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	"black",&xobj->TabColor[black],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	"white",&xobj->TabColor[white],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");

 mask=0;
 Attr.background_pixel=xobj->TabColor[back].pixel;
 mask|=CWBackPixel;

 xobj->ObjWin=XCreateWindow(xobj->display,*xobj->ParentWin,
		xobj->x,xobj->y,xobj->width,xobj->height,0,
		CopyFromParent,InputOutput,CopyFromParent,
		mask,&Attr);
 xobj->gc=XCreateGC(xobj->display,xobj->ObjWin,0,NULL);
 XSetForeground(xobj->display,xobj->gc,xobj->TabColor[fore].pixel);
 XSetBackground(xobj->display,xobj->gc,xobj->TabColor[back].pixel);
 if ((xobj->xfont=XLoadQueryFont(xobj->display,xobj->font))==NULL)
   fprintf(stderr,"Can't load font %s\n",xobj->font);
 else
  XSetFont(xobj->display,xobj->gc,xobj->xfont->fid);

 XSetLineAttributes(xobj->display,xobj->gc,1,LineSolid,CapRound,JoinMiter);
}

void DestroyItemDraw(struct XObj *xobj)
{
 XFreeFont(xobj->display,xobj->xfont);
 XFreeGC(xobj->display,xobj->gc);
 XDestroyWindow(xobj->display,xobj->ObjWin);
}

void DrawItemDraw(struct XObj *xobj)
{
 int i,j;

 j=xobj->height/2+3;
 i=0;
 /* Calcul de la position de la chaine de charactere */
 DrawReliefString(xobj->display,xobj->ObjWin,xobj->gc,i,j,xobj->title,
	strlen(xobj->title),xobj->TabColor[fore].pixel,xobj->TabColor[white].pixel);
}

void EvtMouseItemDraw(struct XObj *xobj)
{
}

void EvtKeyItemDraw(struct XObj *xobj,XKeyEvent *EvtKey)
{
 fprintf(stderr,"Evt key\n");
}

/***********************************************/
/* Fonction pour CheckBox                      */
/***********************************************/
void InitCheckBox(struct XObj *xobj)
{
 unsigned long mask;
 XSetWindowAttributes Attr;
 unsigned long White,Black;
 XColor TempColor;

 /* Enregistrement des couleurs et de la police */
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->forecolor,&xobj->TabColor[fore],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->backcolor,&xobj->TabColor[back],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->licolor,&xobj->TabColor[li],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->shadcolor,&xobj->TabColor[shad],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	"black",&xobj->TabColor[black],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	"white",&xobj->TabColor[white],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");

 mask=0;
 Attr.background_pixel=xobj->TabColor[back].pixel;
 mask|=CWBackPixel;
 Attr.cursor=XCreateFontCursor(xobj->display,XC_hand2); 
 mask|=CWCursor;		/* Curseur pour la fenetre */

 xobj->ObjWin=XCreateWindow(xobj->display,*xobj->ParentWin,
		xobj->x,xobj->y,xobj->width,xobj->height,0,
		CopyFromParent,InputOutput,CopyFromParent,
		mask,&Attr);
 xobj->gc=XCreateGC(xobj->display,xobj->ObjWin,0,NULL);
 XSetForeground(xobj->display,xobj->gc,xobj->TabColor[fore].pixel);
 XSetBackground(xobj->display,xobj->gc,xobj->TabColor[back].pixel);
 if ((xobj->xfont=XLoadQueryFont(xobj->display,xobj->font))==NULL)
   fprintf(stderr,"Can't load font %s\n",xobj->font);
 else
  XSetFont(xobj->display,xobj->gc,xobj->xfont->fid);

 XSetLineAttributes(xobj->display,xobj->gc,1,LineSolid,CapRound,JoinMiter);
}

void DestroyCheckBox(struct XObj *xobj)
{
 XFreeFont(xobj->display,xobj->xfont);
 XFreeGC(xobj->display,xobj->gc);
 XDestroyWindow(xobj->display,xobj->ObjWin);
}

void DrawCheckBox(struct XObj *xobj)
{
 XSegment segm[2];

 /* Dessin du rectangle arrondi */
 DrawReliefRect(0,0,15,15,xobj,xobj->TabColor[li].pixel,xobj->TabColor[shad].pixel,0);

 /* Calcul de la position de la chaine de charactere */
 DrawReliefString(xobj->display,xobj->ObjWin,xobj->gc,23,12,xobj->title,
	strlen(xobj->title),xobj->TabColor[fore].pixel,xobj->TabColor[white].pixel);
 /* Dessin de la croix */
 if (xobj->value)
 {
  XSetLineAttributes(xobj->display,xobj->gc,2,LineSolid,CapProjecting,JoinMiter);
  segm[0].x1=5;
  segm[0].y1=5;
  segm[0].x2=9;
  segm[0].y2=9;
  segm[1].x1=5;
  segm[1].y1=9;
  segm[1].x2=9;
  segm[1].y2=5;
  XSetForeground(xobj->display,xobj->gc,xobj->TabColor[black].pixel);
  XDrawSegments(xobj->display,xobj->ObjWin,xobj->gc,segm,2);
  XSetLineAttributes(xobj->display,xobj->gc,1,LineSolid,CapRound,JoinMiter);
 }
}

void EvtMouseCheckBox(struct XObj *xobj)
{
 static XEvent event;
 int End=1;
 unsigned int modif;
 int x1,x2,y1,y2,i,j;
 Window Win1,Win2;
 Window WinBut=0;
 int In;
 char **Buff;
 XSegment segm[2];

 while (End)
 {
  XNextEvent(xobj->display, &event);
  switch (event.type)
    {
      case EnterNotify:
	   XQueryPointer(xobj->display,*xobj->ParentWin,
		&Win1,&Win2,&x1,&y1,&x2,&y2,&modif);
	   if (WinBut==0)
	   {
	    WinBut=Win2;
	    /* Mouse on button */
            DrawReliefRect(0,0,15,15,xobj,xobj->TabColor[shad].pixel,xobj->TabColor[li].pixel,0);
	    In=1;
	   }
	   else
	   {
	    if (Win2==WinBut)
	    {
	    /* Mouse on button */
             DrawReliefRect(0,0,15,15,xobj,xobj->TabColor[shad].pixel,xobj->TabColor[li].pixel,0);
	     In=1;
	    }
	    else if (In)
	    {
	     In=0;
	     /* Mouse not on button */
             DrawReliefRect(0,0,15,15,xobj,xobj->TabColor[li].pixel,xobj->TabColor[shad].pixel,0);
	    }
	   }
	  break;
      case LeaveNotify:
	   XQueryPointer(xobj->display,*xobj->ParentWin,
		&Win1,&Win2,&x1,&y1,&x2,&y2,&modif);
	   if (Win2==WinBut)
	   {
	    In=1;
	    /* Mouse on button */
            DrawReliefRect(0,0,15,15,xobj,xobj->TabColor[shad].pixel,xobj->TabColor[li].pixel,0);
	   }
	   else if (In)
	   {
	    /* Mouse not on button */
            DrawReliefRect(0,0,15,15,xobj,xobj->TabColor[li].pixel,xobj->TabColor[shad].pixel,0);
	    In=0;
	   }
	  break;
      case ButtonRelease:
	   End=0;
	   /* Mouse not on button */
	   if (In)
	   {
	    /* Envoie d'un message vide de type ModifValue pour un clique souris */
	    xobj->value=!xobj->value;
            DrawReliefRect(0,0,15,15,xobj,xobj->TabColor[li].pixel,xobj->TabColor[shad].pixel,0);
	    SendMsg(xobj,ModifValue);
	   }
	   if (xobj->value)
	   {
  	    XSetLineAttributes(xobj->display,xobj->gc,2,LineSolid,CapProjecting,JoinMiter);
	    segm[0].x1=5;
	    segm[0].y1=5;
	    segm[0].x2=9;
	    segm[0].y2=9;
	    segm[1].x1=5;
	    segm[1].y1=9;
	    segm[1].x2=9;
	    segm[1].y2=5;
	    XSetForeground(xobj->display,xobj->gc,xobj->TabColor[black].pixel);
	    XDrawSegments(xobj->display,xobj->ObjWin,xobj->gc,segm,2);
	    XSetLineAttributes(xobj->display,xobj->gc,1,LineSolid,CapRound,JoinMiter);
	   }
	  break;
     }
 }
}

void EvtKeyCheckBox(struct XObj *xobj,XKeyEvent *EvtKey)
{
}

/***********************************************/
/* Fonction for TextField                      */
/***********************************************/
void InitTextField(struct XObj *xobj)
{
 unsigned long mask;
 XSetWindowAttributes Attr;
 unsigned long White,Black;
 XColor TempColor;

 /* Enregistrement des couleurs et de la police */
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->forecolor,&xobj->TabColor[fore],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->backcolor,&xobj->TabColor[back],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->licolor,&xobj->TabColor[li],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	xobj->shadcolor,&xobj->TabColor[shad],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	"black",&xobj->TabColor[black],&TempColor)) 
   fprintf(stderr,"Can't alloc named color.\n");
 if (!XAllocNamedColor(xobj->display,*xobj->colormap,
	"white",&xobj->TabColor[white],&TempColor))
   fprintf(stderr,"Can't alloc named color.\n");

 mask=0;
 Attr.cursor=XCreateFontCursor(xobj->display,XC_xterm); 
 mask|=CWCursor;		/* Curseur pour la fenetre */
 Attr.background_pixel=xobj->TabColor[back].pixel;
 mask|=CWBackPixel;

 xobj->ObjWin=XCreateWindow(xobj->display,*xobj->ParentWin,
		xobj->x,xobj->y,xobj->width,xobj->height,0,
		CopyFromParent,InputOutput,CopyFromParent,
		mask,&Attr);
 xobj->gc=XCreateGC(xobj->display,xobj->ObjWin,0,NULL);
 XSetForeground(xobj->display,xobj->gc,xobj->TabColor[fore].pixel);
 XSetBackground(xobj->display,xobj->gc,xobj->TabColor[back].pixel);
 if ((xobj->xfont=XLoadQueryFont(xobj->display,xobj->font))==NULL)
   fprintf(stderr,"Can't load font %s\n",xobj->font);
 else
  XSetFont(xobj->display,xobj->gc,xobj->xfont->fid);

 XSetLineAttributes(xobj->display,xobj->gc,1,LineSolid,CapRound,JoinMiter);
}

void DestroyTextField(struct XObj *xobj)
{
 XFreeFont(xobj->display,xobj->xfont);
 XFreeGC(xobj->display,xobj->gc);
 XDestroyWindow(xobj->display,xobj->ObjWin);
}

/* Dessin du curseur du texte */
void DrawPointTxt(struct XObj *xobj,unsigned int color)
{
 #define dec 2
 int x,y;
 XSegment segm[2];

 x=XTextWidth(xobj->xfont,xobj->title,xobj->value)+5;
 y=xobj->xfont->max_bounds.ascent+5;

 segm[0].x1=x;
 segm[0].y1=y;
 segm[0].x2=x-dec;
 segm[0].y2=y+dec;
 segm[1].x1=x;
 segm[1].y1=y;
 segm[1].x2=x+dec;
 segm[1].y2=y+dec;
 XSetForeground(xobj->display,xobj->gc,color);
 XDrawSegments(xobj->display,xobj->ObjWin,xobj->gc,segm,2);
}

void DrawTextField(struct XObj *xobj)
{
 int y;

 /* Dessin du rectangle arrondi */
 DrawReliefRect(0,0,xobj->width,xobj->height,xobj,
	xobj->TabColor[shad].pixel,xobj->TabColor[li].pixel,3);
 XSetForeground(xobj->display,xobj->gc,xobj->TabColor[fore].pixel);
 y=xobj->xfont->max_bounds.ascent;
 XDrawImageString(xobj->display,xobj->ObjWin,xobj->gc,5,y+5,xobj->title,strlen(xobj->title));
 DrawPointTxt(xobj,xobj->TabColor[fore].pixel);
}

void EvtMouseTextField(struct XObj *xobj)
{
 unsigned int modif;
 int x1,x2,y1,y2,i,j;
 Window Win1,Win2;
 int PosCurs=0;

 /* On deplace le curseur a la position de la souris */
 /* On recupere la position de la souris */
 XQueryPointer(xobj->display,*xobj->ParentWin,&Win1,&Win2,&x1,&y1,&x2,&y2,&modif);
 x2=x2-xobj->x;
 if (Win2!=0)
 {
  while ((PosCurs<strlen(xobj->title))&&
		(x2>XTextWidth(xobj->xfont,xobj->title,PosCurs)+7))
   PosCurs++;

   DrawPointTxt(xobj,xobj->TabColor[back].pixel);
   xobj->value=PosCurs;
   DrawPointTxt(xobj,xobj->TabColor[fore].pixel);
   DrawTextField(xobj);
 }
}

void EvtKeyTextField(struct XObj *xobj,XKeyEvent *EvtKey)
{
 int i,y,x2,y2;
 char car[11];
 char *carks;
 KeySym ks;
 int Size;
 int NewPos;

 /* Recherche du charactere */
 i=XLookupString(EvtKey,car,10,&ks,NULL);
 NewPos=xobj->value;
 car[i]='\0';
 carks=XKeysymToString(ks);

 if (carks!=NULL)
 {
  if (strcmp(carks,"Right")==0)
  {
   NewPos++;
   if (NewPos>strlen(xobj->title))
    NewPos=strlen(xobj->title);
  }
  else if (strcmp(carks,"Left")==0)
  {
   NewPos--;
   if (NewPos<0)
    NewPos=0;
  }
  else if (strcmp(carks,"Delete")==0)
  {
   if (NewPos>0)
   {
    Size=strlen(xobj->title);
    memmove(&xobj->title[NewPos-1],&xobj->title[NewPos],
			Size-NewPos+1);
    xobj->title=(char*)realloc(xobj->title,(Size)*sizeof(char));
    NewPos--;
   }
  }
  else if (i!=0)	/* Cas d'un caractere normal */
  {
   /* Insertion du caractere dans le titre */
   Size=strlen(xobj->title);
   xobj->title=(char*)realloc(xobj->title,(2+Size)*sizeof(char));
   memmove(&xobj->title[NewPos+1],&xobj->title[NewPos],
			Size-NewPos+1);
   xobj->title[NewPos]=car[0];
   NewPos++;
  }

 }
 y=xobj->xfont->max_bounds.ascent;
 XDrawImageString(xobj->display,xobj->ObjWin,xobj->gc,5,y+5,xobj->title,strlen(xobj->title));
 /* Dessin d'un carre blanc */
 XSetForeground(xobj->display,xobj->gc,xobj->TabColor[back].pixel);
 x2=XTextWidth(xobj->xfont,xobj->title,strlen(xobj->title));
 XFillRectangle(xobj->display,xobj->ObjWin,xobj->gc,x2+4,4,xobj->width-x2-8,xobj->height-8);
 DrawReliefRect(0,0,xobj->width,xobj->height,xobj,
	xobj->TabColor[shad].pixel,xobj->TabColor[li].pixel,3);
 XSetForeground(xobj->display,xobj->gc,xobj->TabColor[fore].pixel);
 XDrawImageString(xobj->display,xobj->ObjWin,xobj->gc,5,y+5,xobj->title,strlen(xobj->title));
 DrawPointTxt(xobj,xobj->TabColor[back].pixel);
 xobj->value=NewPos;
 DrawPointTxt(xobj,xobj->TabColor[fore].pixel);
 DrawTextField(xobj);
}

/***********************************************/
/*Choix des fonctions suivant le type de bouton*/
/***********************************************/

void ChooseFunction(struct XObj *xobj,char *type)
{
 if (strcmp(type,"PushButton")==0)
 {
  xobj->InitObj=InitPushButton;
  xobj->DestroyObj=DestroyPushButton;
  xobj->DrawObj=DrawPushButton;
  xobj->EvtMouse=EvtMousePushButton;
  xobj->EvtKey=EvtKeyPushButton;
 }
 else if (strcmp(type,"RadioButton")==0)
 {
  xobj->InitObj=InitRadioButton;
  xobj->DestroyObj=DestroyRadioButton;
  xobj->DrawObj=DrawRadioButton;
  xobj->EvtMouse=EvtMouseRadioButton;
  xobj->EvtKey=EvtKeyRadioButton;
 }
 else if (strcmp(type,"ItemDraw")==0)
 {
  xobj->InitObj=InitItemDraw;
  xobj->DestroyObj=DestroyItemDraw;
  xobj->DrawObj=DrawItemDraw;
  xobj->EvtMouse=EvtMouseItemDraw;
  xobj->EvtKey=EvtKeyItemDraw;
 }
 else if (strcmp(type,"CheckBox")==0)
 {
  xobj->InitObj=InitCheckBox;
  xobj->DestroyObj=DestroyCheckBox;
  xobj->DrawObj=DrawCheckBox;
  xobj->EvtMouse=EvtMouseCheckBox;
  xobj->EvtKey=EvtKeyCheckBox;
 }
 else if (strcmp(type,"TextField")==0)
 {
  xobj->InitObj=InitTextField;
  xobj->DestroyObj=DestroyTextField;
  xobj->DrawObj=DrawTextField;
  xobj->EvtMouse=EvtMouseTextField;
  xobj->EvtKey=EvtKeyTextField;
 }
 else
 {
  fprintf(stderr,"Item %s unknow\n",type);
  exit(1);
 }
}

