// ICQ definitions:
#ifndef ICQDEFINES_H
#define ICQDEFINES_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// directory constants
//const char DEFAULT_BASE_DIR[]                     = "/usr/local/share/licq";
const char DEFAULT_HOME_DIR[]                      = ".licq";
const char CONF_DIR[]                              = "conf/";
const char DATA_DIR[]                              = "data/";
const char HISTORY_DIR[]                           = "history/";
const char TRANSLATION_DIR[]			   = "translations/";
const unsigned short MAX_FILENAME_LEN              = 256;
extern char BASE_DIR[];
extern unsigned short DEBUG_LEVEL;

// UDP commands
const unsigned short ICQ_CMDxRCV_SETxOFFLINE       = 0x0028;
const unsigned short ICQ_CMDxRCV_ACK               = 0x000A;
const unsigned short ICQ_CMDxRCV_HELLO             = 0x005A;
const unsigned short ICQ_CMDxRCV_WRONGxPASSWD      = 0x0064;
const unsigned short ICQ_CMDxRCV_SMxMSG            = 0x0001;
const unsigned short ICQ_CMDxRCV_SMxREQxAUTH       = 0x0006;
const unsigned short ICQ_CMDxRCV_SMxADDED          = 0x000C;
const unsigned short ICQ_CMDxRCV_USERxONLINE       = 0x006E;
const unsigned short ICQ_CMDxRCV_USERxOFFLINE      = 0x0078;
const unsigned short ICQ_CMDxRCV_SEARCHxFOUND      = 0x008C;
const unsigned short ICQ_CMDxRCV_SEARCHxDONE       = 0x00A0;
const unsigned short ICQ_CMDxRCV_SYSxMSGxOFFLINE   = 0x00DC;
const unsigned short ICQ_CMDxRCV_SYSxMSGxONLINE    = 0x0104;
const unsigned short ICQ_CMDxRCV_SYSxMSGxDONE      = 0x00E6;
const unsigned short ICQ_CMDxRCV_ERROR             = 0x00F0;
const unsigned short ICQ_CMDxRCV_BUSY              = 0x00FA;
const unsigned short ICQ_CMDxRCV_USERxINFO         = 0x0118;
const unsigned short ICQ_CMDxRCV_USERxSTATUS       = 0x01A4;
const unsigned short ICQ_CMDxRCV_USERxINVALIDxUIN  = 0x012C;
const unsigned short ICQ_CMDxRCV_USERxLISTxDONE    = 0x021C;

const unsigned short ICQ_CMDxSND_ACK               = 0x000A;
const unsigned short ICQ_CMDxSND_SEARCHxSTART      = 0x0424;
const unsigned short ICQ_CMDxSND_THRUxSERVER       = 0x010E;
const unsigned short ICQ_CMDxSND_PING              = 0x042E;
const unsigned short ICQ_CMDxSND_LOGON             = 0x03E8;
const unsigned short ICQ_CMDxSND_LOGOFF            = 0x0438;
const unsigned short ICQ_CMDxSND_SYSxMSGxREQ       = 0x044C;
const unsigned short ICQ_CMDxSND_USERxGETINFO      = 0x0460;
const unsigned short ICQ_CMDxSND_USERxADD          = 0x053C;
const unsigned short ICQ_CMDxSND_SETxSTATUS        = 0x04D8;
const unsigned short ICQ_CMDxSND_USERxLIST         = 0x0406;
const unsigned short ICQ_CMDxSND_SYSxMSGxDONExACK  = 0x0442;
const unsigned short ICQ_CMDxSND_AUTHORIZE         = 0x0456;

const unsigned short int ICQ_CMDxSND_PING2         = 0x051E;


// TCP commands
const unsigned short ICQ_CMDxTCP_START             = 0x07EE;
const unsigned short ICQ_CMDxTCP_CANCEL            = 0x07D0;
const unsigned short ICQ_CMDxTCP_ACK               = 0x07DA;
const unsigned short ICQ_CMDxTCP_MSG               = 0x0001;
const unsigned short ICQ_CMDxTCP_FILE              = 0x0003;
const unsigned short ICQ_CMDxTCP_CHAT              = 0x0002;
const unsigned short ICQ_CMDxTCP_URL               = 0x0004;
const unsigned short ICQ_CMDxTCP_READxAWAYxMSG     = 0x03E8;
const unsigned short ICQ_CMDxTCP_HANDSHAKE         = 0x03FF;
const unsigned short ICQ_CMDxTCP_HANDSHAKE2        = 0x04FF;
const unsigned short ICQ_CMDxTCP_HANDSHAKE3        = 0x02FF;


// status constants
const unsigned short int ICQ_STATUS_OFFLINE        = 0xFFFF;
const unsigned short int ICQ_STATUS_ONLINE         = 0x0000;
const unsigned short int ICQ_STATUS_AWAY           = 0x0001;
const unsigned short int ICQ_STATUS_NA             = 0x0005;
const unsigned short int ICQ_STATUS_OCCUPIED       = 0x0011;
const unsigned short int ICQ_STATUS_DND            = 0x0013;
const unsigned short int ICQ_STATUS_FREEFORCHAT    = 0x0020;
const unsigned short int ICQ_STATUS_PRIVATE        = 0x0100;

// miscellaneous constants
const unsigned short int ICQ_VERSION               = 0x0002;
const unsigned short MAX_MESSAGE_SIZE              = 450;
const unsigned short INT_VERSION                   = 43;
const unsigned short PING_FREQUENCY                = 120;
const unsigned short DEFAULT_SERVER_PORT           = 4000;
const unsigned short MAX_SERVER_RETRIES            = 3;
const unsigned short MAX_WAIT_ACK                  = 8;
const unsigned long LOCALHOST                  = 0x0100007F;
const char TCP[] = "[TCP] ";
const char UDP[] = "[UDP] ";


#endif
