/*

#
# This file is part of MindsEye
#
# MindsEye is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# MindsEye is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with MindsEye; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#

*/

%{
#include <parser.h>
#include <parse_tools.h>
#include <m_config.h>
%}

/*---- Definitions ----------------------------------------------------------*/

DIGIT	[0-9]*
FLOAT	[0-9]+*"."[0-9]+*

WORD	([a-z]|[A-Z]|[ /~!@#$%^&*()_+|`])+([a-zA-Z /~!@#$%^&*()_+|`1234567890-=\\]*)

GROUP	("["){WORD}("]")

STRING	("\""){WORD}("\"")

NAME	("<"){WORD}(">")

/*---- Rules ----------------------------------------------------------------*/

%%

{GROUP}		{
             #ifdef SHOW_PARSING               
			   printf ("\nGroup statement found: (%s)\n\n",
                       remove_delimit (yytext)); 
             #else
               create_group (parse_confclass,remove_delimit (yytext));
             #endif
			}

{NAME}		{
             #ifdef SHOW_PARSING
			   printf ("Name statement found: (%s)\n",
                       remove_delimit (yytext)); 
             #else
               create_var (parse_confclass,remove_delimit (yytext));
             #endif
			}

{STRING}	{
             #ifdef SHOW_PARSING
			   printf ("String found: (%s)\n",
                       remove_delimit (yytext)); 
             #else
               add_string (parse_confclass,remove_delimit (yytext));
             #endif
			}

{DIGIT}	    {
             #ifdef SHOW_PARSING
			   printf ("Number (int) found: (%d)\n",
                       atoi (yytext)); 
             #else
               add_integer (parse_confclass,atoi (yytext));
             #endif
			}

{FLOAT}	    {
             #ifdef SHOW_PARSING
			   printf ("Number (float) found: (%f)\n",
                       atof (yytext)); 
             #else
               add_float (parse_confclass,atof (yytext));
             #endif
			}

.			{
             #ifdef SHOW_UNKNOWN_TOKENS
			   printf ("Unidentified token found (%s)\n",yytext);
             #endif   
			}

\n			{
               //printf ("\n");
			}

%%



ConfigClass *parse_confclass;

/*---------------------------------------------------------------------------*/
void parse_a_file (ConfigClass *temp_config,FILE *parse_file)
{
 if ((parse_file!=NULL) && (temp_config!=NULL))
 {
   parse_confclass=temp_config;

   yyin = parse_file;
   yylex();
 }
}
/*---------------------------------------------------------------------------*/