#ifndef __FILE_TOOL_H__
#define __FILE_TOOL_H__

/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: file_tool.h,v $
 *
 * $Revision: 1.4 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: file_tool.h,v $
 * Revision 1.4  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 * compiled with -Wall -Werror, fixed bugs and potential bugs
 * fixed Mister Data bugs
 *
 * Revision 1.3  1997/05/27  09:02:10  ruben
 * reworked include strategy for developers ease
 * also some indent done
 *
 * Revision 1.3  1997/05/27  09:02:10  ruben
 * reworked include strategy for developers ease
 * also some indent done
 *
 * Revision 1.2  1997/04/06 21:34:09  ruben
 * Added FileNotify class
 *
 * Revision 1.1  1997/03/28 17:48:16  ruben
 * Initial revision
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/utsname.h>
#include <string.h>
#include <signal.h>

#include <qmsgbox.h>
#include <qlist.h>
#include <qcombo.h>

#include "data_tree.h"
#include "dialogs.h"

#include "vars.h"


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

struct FileEntry
{
	// a sort of extended stat structure
	// RvS 97032.9: should we make an own stat structure ?
	// 

	struct stat fe_stat;
	QString fe_fname;

        FileEntry(const char *szFilename, struct stat *st);
        FileEntry(const FileEntry & entry);

        FileEntry & operator = (const FileEntry & entry);
};

#if defined(DEFAULT_TEMPLATECLASS)
typedef QListT < FileEntry > FileListBase;
typedef QListIteratorT < FileEntry > FileListIterator;

#else
typedef Q_DECLARE(QListM, FileEntry) FileListBase;
typedef Q_DECLARE(QListIteratorM, FileEntry) FileListIterator;

#endif

class   FileList:public FileListBase
{
	enum Sortflags
	{
		DirsFirst = 0x01,
		DirsLast = 0x02,
		Ignorecase = 0x04,
		Names = 0x08,
		Sizes = 0x10
	};

	int     Sortspecs;

	int     compareItems(GCI item1, GCI item2);
	GCI     newItem(GCI item);
	void    deleteItem(GCI item);

	public:

	FileList(int flags = DirsFirst | Names);
	int     Scandir(const char *szDir);

};

class FileNotify: public QObject
{
	Q_OBJECT
	
	private:
		
	QString szFilename;
	time_t	spLastaccess;
	struct stat st;
	int iMicrosecs;
	
	protected:
	
	void  timerEvent( QTimerEvent * );
	
	public:
	
	FileNotify(int);
	~FileNotify();

	public slots:

	void startNotify(const char*);
	void endNotify();

	signals:

	void	fileChanged(const char*);

};

extern char link_dir [];
extern char temp_strng [];
extern char *temp_path;
extern char temp_string [];
 
//>---------- just some tools to make life easier


class MountBox;

extern int show_mount(MountBox *);
extern int check_directory(char *current_path);
extern RETSIGTYPE SigHandler(int);

#endif	 // __FILE_TOOL_H__
