// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: button.cc,v 1.4 1998/10/24 22:46:00 jgg Exp $
/* ######################################################################

   BasicButton - Simple button

   The basic button understands the Wf_Set flag and Wf_Toggle flags to
   indicate the type of button it's going to be. It takes care of
   altering it's child to have a different offset and colour. Right now
   the child must be of the BasicWidget type. This is not checked or
   enforced.
   
   ##################################################################### */
									/*}}}*/
// Include files							/*{{{*/
#ifdef __GNUG__
#pragma implementation "deity/button.h"
#endif
#include <deity/button.h>
#include <deity/textwidg.h>
									/*}}}*/

void *BasicButton::Type = (void *)&BasicButton::Type;

// BasicButton::BasicButton - Constructor				/*{{{*/
// ---------------------------------------------------------------------
/* */
BasicButton::BasicButton(Widget *Parent = 0) : BasicWidget(Parent)
{
   Flag(Focusable);
   iDepressed = Color(150,150,150,Color::Gray);
}
									/*}}}*/
// BasicButton::Render - Draw the button				/*{{{*/
// ---------------------------------------------------------------------
/* */
void BasicButton::Render(CombinedGC &GC)
{
   if (IsFlag(Widget::Set) == true)
   {
      Color Back = iBackground;
      Color Ul = iBorderUl;
      Color Lr = iBorderLr;
      iBorderLr = Ul;
      iBorderUl = Lr;
      iBackground = iDepressed;

      BasicWidget::Render(GC);

      iBackground = Back;
      iBorderUl = Ul;
      iBorderLr = Lr;
   }  
   else
      BasicWidget::Render(GC);
}
									/*}}}*/
// BasicButton::Key - Handle keystrokes					/*{{{*/
// ---------------------------------------------------------------------
/* */
bool BasicButton::Key(const KeyEvent & /*Key*/,Widget *)
{
   return true;
}
									/*}}}*/
// BasicButton::Mouse - Mouse event handler				/*{{{*/
// ---------------------------------------------------------------------
/* */
void BasicButton::Mouse(const MouseEvent &Event)
{
   if (Event.AnyButtonDn() == false)
      return;
      
   // Mouse button down
   if (Event.IsDn() == true)
      OldState = IsFlag(Widget::Set);

   if (Pos.w < Event.Pos.x || Pos.h < Event.Pos.y || 
       Event.Pos.x < 0 || Event.Pos.y < 0)       
   {
      Set(OldState);
      return;
   }
   else
   {
      // Toggle if in toggle mode, otherwise just set.
      if (IsFlag(Toggle) == true)
	 Set(!OldState);
      else
	 Set(true);
   }
   
   // Mouse button up
   if (Event.IsUp() == true)
   {      
      if (OldState == IsFlag(Widget::Set))
	 return;
      OldState = IsFlag(Widget::Set);
      
      if (IsFlag(Toggle) == true)
	 Trigger(Nt_State,(void *)IsFlag(Widget::Set));
      else
      {
	 Set(false);
	 
	 Trigger(Nt_Action,0);
      }
   }
}
									/*}}}*/
// BasicButton::IdealSize - Compute the size of the button		/*{{{*/
// ---------------------------------------------------------------------
/* */
Point BasicButton::IdealSize()
{
   if (Child == 0)
      return Point(10,10);

   Point Res = Child->IdealSize();
   Res.x += Child->Pos.x + 2*BorderX;
   Res.y += Child->Pos.y + 2*BorderY;
   return Res;
}
									/*}}}*/
// BasicButton::Set - Set the button state, depressed or not.		/*{{{*/
// ---------------------------------------------------------------------
/* */
void BasicButton::Set(bool State)
{
   if (State == IsFlag(Widget::Set))
       return;
       
   if (State == true)
      Flag(Widget::Set);
   else
      Flag(0,Widget::Set);

   if (Child == 0)
   {
      Damage();
      return;
   }
   
   // Adjust the child.
   if (State == true)
   {
      if (GraphicGC::GC != 0)
	 Child->Resize(Rect(1,1,Child->Pos.w,Child->Pos.h));
      ((BasicWidget *)Child)->Background(iDepressed);
   }
   else
   {      
      if (GraphicGC::GC != 0)
	 Child->Resize(Rect(0,0,Child->Pos.w,Child->Pos.h));
      ((BasicWidget *)Child)->Background(iBackground);
   }

   Damage();
}
									/*}}}*/

// TextButton::TextButton - Constructor					/*{{{*/
// ---------------------------------------------------------------------
/* We mearly construct a text widget inside a button. */
TextButton::TextButton(string Text,Widget *Parent = 0) : BasicButton(Parent)
{
   BasicWidget *Widg = new TextWidget(Text,this);

   if (GraphicGC::GC != 0)
      Widg->Margins(Point(1,1));
}
									/*}}}*/
