// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: widgetinit.cc,v 1.4 1998/08/27 04:10:26 jgg Exp $
/* ######################################################################

   Init - Widget library initilization

   ##################################################################### */
									/*}}}*/
// Include Files							/*{{{*/
#ifdef __GNUG__
#pragma implementation "deity/widgetinit.h"
#endif  
#include <deity/widgetinit.h>
#include <deity/selectloop.h>
#include <deity/widget.h>
#include <config.h>

#ifdef HAVE_X11
#include <deity/x11dev.h>
#endif
#ifdef HAVE_LIBSLANG
#include <deity/slangdev.h>
#endif
#ifdef HAVE_LIBGPM
#include <deity/gpmdev.h>
#endif

									/*}}}*/

// InitWidgets - Init the library					/*{{{*/
// ---------------------------------------------------------------------
/* First we try X then we try slang then try for gpm */
Widget *InitWidgets(SelectLoop &Loop)
{   
   Widget *&Result = Widget::Root;
   Result = 0;
   
#ifdef HAVE_X11
   if ((Result = XAttachDisplay(Loop)) != 0)
      return Result;
#endif
   
#ifdef HAVE_LIBSLANG
   if ((Result = SLangAttachDisplay(Loop)) == 0)
      return 0;
#endif
   
#ifdef HAVE_LIBGPM
   if (Result != 0)
      Loop.Add(new GPMFd(Result));
#endif   

   return Result;
}
									/*}}}*/
// InitWidgetsSupported - Return a string showing what is supported	/*{{{*/
// ---------------------------------------------------------------------
/* */
string InitWidgetsSupported()
{
   string Res;
   
#ifdef HAVE_X11
   Res += "X11 via XLib ";
#endif
   
#ifdef HAVE_LIBSLANG
   Res += "Terminal via SLang ";
   Res += "Mouse via Xterm ";
#endif
   
#ifdef HAVE_LIBGPM
   Res += "Mouse via GPM ";
#endif   

   return Res;
}
									/*}}}*/
