#include <stdlib.h>
#include <slang.h>
#include <newt.h>
#include INCLINGUA

static void drawRoot(void) {
    newtInit();
    newtCls();
    newtDrawRootText(0, 20, MSG_TITLE);
    newtRedrawHelpLine();
}

int color_or_monochrome (void) {
    newtComponent lb,t1,f;

#define OPT_Next  1000
#define OPT_Color 1001
#define OPT_Mono  1002
    int *data, ans[]= { OPT_Next, OPT_Color, OPT_Mono };

    setenv("TERM","linux-m",1);

    drawRoot();

    newtOpenWindow(10, 8, 60, 9, MSG_SELECT_DISPLAY);

    f = newtForm(NULL, NULL, 0);

    t1 = newtTextbox(0, 0, 60, 3, NEWT_FLAG_WRAP);
    newtTextboxSetText(t1, MSG_INFO_DISPLAY);

    lb = newtListbox(2, 3, 6, NEWT_FLAG_DOBORDER | NEWT_FLAG_RETURNEXIT);
    newtListboxAddEntry(lb, MSG_NEXT_DISPLAY, 
	&ans[0]);
    newtListboxAddEntry(lb, MSG_COLOR_DISPLAY, 
	&ans[1]);
    newtListboxAddEntry(lb, MSG_MONOCHROME_DISPLAY, 
	&ans[2]);

    newtFormAddComponents(f, t1, lb, NULL);
    newtListboxSetCurrent(lb, 1);

    do {
	newtRunForm(f);
	data = newtListboxGetCurrent(lb);
	switch (*data) {
	    case OPT_Color:
		if (! strcmp( getenv("TERM"),"linux-m" ) ) {
		    setenv("TERM","linux",1);
		    unsetenv("NEWT_MONO");
		    SLtt_Use_Ansi_Colors = 1;
		    newtSetThreeD(1);
		    newtPopWindow();
		    drawRoot();
		    newtOpenWindow(10, 8, 60, 9, MSG_SELECT_DISPLAY);
		}
		newtListboxSetCurrent(lb, 0);
		break;
	    case OPT_Mono:
		if (! strcmp( getenv("TERM"),"linux" ) ) {
		    setenv("TERM","linux-m",1);
		    setenv("NEWT_MONO","1",1);
		    SLtt_Use_Ansi_Colors = 0;
		    newtSetThreeD(0);
		    newtPopWindow();
		    drawRoot();
		    newtOpenWindow(10, 8, 60, 9, MSG_SELECT_DISPLAY);
		}
		newtListboxSetCurrent(lb, 0);
		break;
	}
    } while (*data != OPT_Next);

    newtPopWindow();

    newtFormDestroy(f);

    return 0;
}

#ifdef _TESTING_
/* To test, compile using: make color_or_monochrome_test */
void main(void){
  SLtt_Use_Ansi_Colors = 1;
  newtSetThreeD(1);
  newtInit();
  newtCls();
  newtDrawRootText(0, 0, "Color or Monochrome Config test program");
  newtOpenWindow(7, 2, 65, 18, "Root Window");
  newtPushHelpLine(NULL);

  color_or_monochrome();

  newtPopWindow();
  newtFinished();
}
#endif
