#include "config.h"
#if HAVE_AMIGA_PARTITION

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <asm/types.h>
#include "byteorder.h"

#include "fdisk.h"

struct RigidDiskBlock {
	__u32	rdb_ID;
	__u32	rdb_SummedLongs;
	__s32	rdb_ChkSum;
	__u32	rdb_HostID;
	__u32	rdb_BlockBytes;
	__u32	rdb_Flags;
	__u32	rdb_BadBlockList;
	__u32	rdb_PartitionList;
	__u32	rdb_FileSysHeaderList;
	__u32	rdb_DriveInit;
	__u32	rdb_Reserved1[6];
	__u32	rdb_Cylinders;
	__u32	rdb_Sectors;
	__u32	rdb_Heads;
	__u32	rdb_Interleave;
	__u32	rdb_Park;
	__u32	rdb_Reserved2[3];
	__u32	rdb_WritePreComp;
	__u32	rdb_ReducedWrite;
	__u32	rdb_StepRate;
	__u32	rdb_Reserved3[5];
	__u32	rdb_RDBBlocksLo;
	__u32	rdb_RDBBlocksHi;
	__u32	rdb_LoCylinder;
	__u32	rdb_HiCylinder;
	__u32	rdb_CylBlocks;
	__u32	rdb_AutoParkSeconds;
	__u32	rdb_HighRDSKBlock;
	__u32	rdb_Reserved4;
	char	rdb_DiskVendor[8];
	char	rdb_DiskProduct[16];
	char	rdb_DiskRevision[4];
	char	rdb_ControllerVendor[8];
	char	rdb_ControllerProduct[16];
	char	rdb_ControllerRevision[4];
	__u32	rdb_Reserved5[10];
};

#define	IDNAME_RIGIDDISK	0x5244534B	/* "RDSK" */

struct PartitionBlock {
	__u32	pb_ID;
	__u32	pb_SummedLongs;
	__s32	pb_ChkSum;
	__u32	pb_HostID;
	__u32	pb_Next;
	__u32	pb_Flags;
	__u32	pb_Reserved1[2];
	__u32	pb_DevFlags;
	__u8	pb_DriveName[32];
	__u32	pb_Reserved2[15];
	__u32	pb_Environment[17];
	__u32	pb_EReserved[15];
};

#define	IDNAME_PARTITION	0x50415254	/* "PART" */

#define RDB_ALLOCATION_LIMIT	16

static __inline__ __u32
checksum_block(__u32 *m, int size)
{
    __u32 sum = 0;

    while (size--)
	sum += __be32_to_cpu(*m++);
    return sum;
}

int parse_amiga_partition(char *device, int fd)
{
    struct RigidDiskBlock	*rdb;
    struct PartitionBlock	*pb;
    unsigned char		data[512];
    int			 	nr_sects;
    int			 	blk;
    int			 	part, res, minor = 1;
    
    res = 0;
    
    for (blk = 0; blk < RDB_ALLOCATION_LIMIT; blk++) {
	if (!sread(fd, blk, data)) {
	    res = -1;
	    goto rdb_done;
	}
	if (*(__u32 *)data == __cpu_to_be32(IDNAME_RIGIDDISK)) {
	    rdb = (struct RigidDiskBlock *)data;
	    if (checksum_block((__u32 *)data,
			       __be32_to_cpu(rdb->rdb_SummedLongs) & 0x7F))
		continue;
	    blk = __be32_to_cpu(rdb->rdb_PartitionList);
	    for (part = 1; blk > 0 && part <= 16; part++) {
		if (!sread(fd, blk, data)) {
		    res = -1;
		    goto rdb_done;
		}
		pb  = (struct PartitionBlock *)data;
		blk = __be32_to_cpu(pb->pb_Next);
		if (pb->pb_ID == __cpu_to_be32(IDNAME_PARTITION) &&
		    checksum_block((__u32 *)pb,
				   __be32_to_cpu(pb->pb_SummedLongs) & 0x7F) == 0 ) {
		    if (!(nr_sects = (__be32_to_cpu(pb->pb_Environment[10]) + 1 -
				      __be32_to_cpu(pb->pb_Environment[9])) *
			  __be32_to_cpu(pb->pb_Environment[3]) *
			  __be32_to_cpu(pb->pb_Environment[5]))) {
			continue;
		    }
		    fdisk_add_partition(device,minor,
					(PTYPE_PREFIX_AMIGA |
					 __be32_to_cpu(pb->pb_Environment[16])),
					nr_sects/2);
		    minor++;
		    res = 1;
		}
	    }
	    break;
	}
    }

  rdb_done:
    return res;
}

#endif /* HAVE_AMIGA_PARTITION */
