/* cfengine for GNU
 
        Copyright (C) 1995
        Free Software Foundation, Inc.
 
   This file is part of GNU cfengine - written and maintained 
   by Mark Burgess, Dept of Computing and Engineering, Oslo College,
   Dept. of Theoretical physics, University of Oslo
 
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
 

/*******************************************************************/
/*                                                                 */
/*  extern HEADER for cfengine                                     */
/*                                                                 */
/*******************************************************************/

extern int     allow_severity;
extern int     deny_severity;

extern char *tzname[2];
extern char *optarg;
extern int optind;
extern struct option OPTIONS[];

extern char *VPRECONFIG;
extern char *VRCFILE;

extern char VARCH[];
extern char VYEAR[];
extern char *ACTIONTEXT[]; 
extern char *ACTIONID[];
extern char *CLASSTEXT[];
extern char *CLASSATTRIBUTES[clssattr][attrdim];
extern char *FILEACTIONTEXT[];
extern char *COMMATTRIBUTES[];
extern char VINPUTFILE[];
extern char VCANONICALFILE[];
extern char VCURRENTFILE[];
extern char VLOGFILE[];
extern char VSETUIDLOG[];
extern FILE *VLOGFP;
extern char VEDITABORT[];
extern char LISTSEPARATOR;
extern char REPOSCHAR;
extern char DISCOMP;
extern char USESHELL;
extern char PURGE;
extern int  DISABLESIZE;

extern char VLOGDIR[];
extern char VLOCKDIR[];

extern struct tm TM1;
extern struct tm TM2;

extern int ERRORCOUNT;
extern int NUMBEROFEDITS;
extern time_t CFSTARTTIME;
extern int CF_TIMEOUT;

extern struct utsname VSYSNAME;

extern int LINENUMBER;
extern mode_t DEFAULTMODE;
extern mode_t DEFAULTSYSTEMMODE;
extern int HAVEUID;
extern char VUIDNAME[maxvarsize];
extern char VGIDNAME[maxvarsize];
extern char CFSERVER[maxvarsize];
extern char VIPADDRESS[];
extern char VPREFIX[];
extern int VRECURSE;
extern int VAGE;
extern int RPCTIMEOUT;
extern char MOUNTMODE;

extern short LINKSILENT;
extern char  LINKTYPE;
extern char  AGETYPE;
extern char  COPYTYPE;
extern char  LINKDIRS;
extern char  LOGP;
extern char  INFORMP;

extern char   CURRENTITEM[bufsize];
extern char   CURRENTPATH[bufsize];
extern char     GROUPBUFF[bufsize];
extern char    ACTIONBUFF[bufsize];
extern char     CLASSBUFF[bufsize];
extern char ALLCLASSBUFFER[bufsize];
extern char      LINKFROM[bufsize];
extern char        LINKTO[bufsize];
extern char         ERROR[bufsize];
extern char     MOUNTFROM[bufsize];
extern char     MOUNTONTO[bufsize];
extern char   DESTINATION[bufsize];
extern char   IMAGEACTION[bufsize];

extern char *HASH[hashtablesize];

extern char VBUFF[bufsize];
extern char OUTPUT[bufsize*2];

extern char VFACULTY[maxvarsize];
extern char VDOMAIN[maxvarsize];
extern char VSYSADM[maxvarsize];
extern char VNETMASK[maxvarsize];
extern char VBROADCAST[maxvarsize];
extern char VMAILSERVER[bufsize];
extern struct Item *VTIMEZONE;
extern char VDEFAULTROUTE[maxvarsize];
extern char VNFSTYPE[maxvarsize];
extern char VREPOSITORY[bufsize];
extern char VIFNAME[16];
extern char VIFNAMEOVERRIDE[16];
extern enum classes VSYSTEMHARDCLASS;
extern char VFQNAME[];
extern char VUQNAME[];
extern char LOGFILE[];

extern struct Item *VEXCLUDECOPY;
extern struct Item *VEXCLUDELINK;
extern struct Item *VCOPYLINKS;
extern struct Item *VLINKCOPIES;
extern struct Item *VEXCLUDEPARSE;
extern struct Item *VCPLNPARSE;
extern struct Item *VINCLUDEPARSE;
extern struct Item *VACLBUILD;

extern struct Item *VMOUNTLIST;
extern struct Item *VHEAP;      /* Points to the base of the attribute heap */
extern struct Item *VNEGHEAP;
extern struct Item *VMOUNTABLES;         /* Points to the list of mountables */
extern struct Item *VMOUNTED;
extern struct Tidy *VTIDY;               /* Points to the list of tidy specs */
extern struct Disk *VREQUIRED;              /* List of required file systems */
extern struct Disk *VREQUIREDTOP;
extern struct ShellComm *VSCRIPT;              /* List of scripts to execute */
extern struct ShellComm *VSCRIPTTOP;
extern struct Interface *VIFLIST;
extern struct Interface *VIFLISTTOP;
extern struct Mounted *MOUNTED;             /* Files systems already mounted */
extern struct Item VDEFAULTBINSERVER;
extern struct Item *VBINSERVERS;
extern struct Link *VLINK;
extern struct File *VFILE;
extern struct Item *VHOMESERVERS;
extern struct Item *VSETUIDLIST;
extern struct Disable *VDISABLELIST;
extern struct Disable *VDISABLETOP;
extern struct File *VMAKEPATH;
extern struct File *VMAKEPATHTOP;
extern struct Link *VCHLINK;
extern struct Item *VIGNORE;
extern struct Item *VHOMEPATLIST;
extern struct Item *VRESOLVE;
extern struct MiscMount *VMISCMOUNT;
extern struct MiscMount *VMISCMOUNTTOP;
extern struct Item *VIMPORT;
extern struct Item *VACTIONSEQ;
extern struct Item *VACCESSLIST;
extern struct Item *VADDCLASSES;
extern struct Item *VALLADDCLASSES;
extern struct Edit *VEDITLIST;
extern struct Edit *VEDITLISTTOP;
extern struct CFACL  *VACLLIST;
extern struct CFACL  *VACLLISTTOP;
extern struct Item *VUNMOUNT;
extern struct Item *VCLASSDEFINE;
extern struct Image *VIMAGE;
extern struct Image *VIMAGETOP;
extern struct Process *VPROCLIST;
extern struct Process *VPROCTOP;

extern struct Item *VREPOSLIST;

extern struct Auth *VADMIT;
extern struct Auth *VDENY;
extern struct Auth *VADMITTOP;
extern struct Auth *VDENYTOP;

/* Associated variables which simplify logic */

extern struct Link *VLINKTOP;
extern struct Link *VCHLINKTOP;
extern struct Tidy *VTIDYTOP;
extern struct File *VFILETOP;

extern char VERSION[];
extern char *COPYRIGHT;

extern short DEBUG;
extern short D1;
extern short D2;
extern short D3;

extern short ISCFENGINE;

extern short VERBOSE;
extern short INFORM;
extern short LOGGING;
extern short INFORM_save;
extern short LOGGING_save;

extern short TIDYDIRS;
extern short TRAVLINKS;
extern short DEADLINKS;
extern short PTRAVLINKS;
extern short DONTDO;
extern short IFCONF;
extern short PARSEONLY;
extern short GOTMOUNTINFO;
extern short NOMOUNTS;
extern short NOMODULES;
extern short NOPROCS;
extern short NOFILECHECK;
extern short NOTIDY;
extern short NOSCRIPTS;
extern short PRSYSADM;
extern short MOUNTCHECK;
extern short NOEDITS;
extern short KILLOLDLINKS;
extern short IGNORELOCK;
extern short NOPRECONFIG;
extern short WARNINGS;
extern short MINUSF;
extern short NOLINKS;
extern short ENFORCELINKS;
extern short FORCELINK;
extern short NOCOPY;
extern short SILENT;
extern short EDITVERBOSE;
extern short FORCECOPY;
extern short IMAGEBACKUP;
extern short ROTATE;
extern int   TIDYSIZE;
extern short USEENVIRON;
extern short PROMATCHES;
extern short EDABORTMODE;
extern short NOPROCS;
extern short UNDERSCORE_CLASSES;
extern short NOHARDCLASSES;
extern short NOSPLAY;

extern enum actions ACTION;
extern enum vnames CONTROLVAR;

extern mode_t PLUSMASK;
extern mode_t MINUSMASK;

extern flag  ACTION_IS_LINK;
extern flag  ACTION_IS_LINKCHILDREN;
extern flag  MOUNT_ONTO;
extern flag  MOUNT_FROM;
extern flag  HAVE_RESTART;
extern flag  ACTIONPENDING;
extern flag  HOMECOPY;

extern char *VPSCOMM[];
extern char *VPSOPTS[];
extern char *VMOUNTCOMM[];
extern char *VMOUNTOPTS[];
extern char *VIFDEV[];
extern char *VETCSHELLS[];
extern char *VRESOLVCONF[];
extern char *VHOSTEQUIV[];
extern char *VFSTAB[];
extern char *VMAILDIR[];
extern char *VNETSTAT[];
extern char *ACTIONSEQTEXT[];
extern char *VEDITNAMES[];
extern char *VUNMOUNTCOMM[];
extern char *VRESOURCES[];

extern int VTIMEOUT;

extern char *SIGNALS[];

extern char *tzname[2]; /* see man ctime */

extern int SENSIBLEFILECOUNT;
extern int SENSIBLEFSSIZE;
extern int EDITFILESIZE;
extern int VIFELAPSED;
extern int VEXPIREAFTER;
extern int VDEFAULTIFELAPSED;
extern int VDEFAULTEXPIREAFTER;
extern int AUTOCREATED;

extern enum fileactions FILEACTION;

extern unsigned short PORTNUMBER;

extern int CURRENTLINENUMBER;
extern struct Item *CURRENTLINEPTR;

extern int EDITGROUPLEVEL;
extern int SEARCHREPLACELEVEL;
extern int FOREACHLEVEL;

extern char *COMMENTSTART, *COMMENTEND;

/* GNU REGEXP */

extern struct re_pattern_buffer *SEARCHPATTBUFF;
extern struct re_pattern_buffer *PATTBUFFER;
