#include "global.h"
#include "graph.h"

GdkColor graph_default_colors [GRAPH_DEFAULT_COLORS] = {
	{0, 0x8fff, 0xefff, 0x8fff},
	{0, 0x8fff, 0xafff, 0xefff},
	{0, 0xefff, 0xafff, 0xafff},
	{0, 0xefff, 0xefff, 0x5fff},
};

static void
graph_expose (GtkWidget *w, GdkEventExpose *e, Graph *g)
{
	if (g->bs)
		gdk_window_copy_area (w->window,
				      w->style->black_gc,
				      e->area.x, e->area.y,
				      g->bs,
				      e->area.x, e->area.y,
				      e->area.width, e->area.height);
	else
		gdk_draw_rectangle (w->window,
				    w->style->black_gc,
				    TRUE,
				    e->area.x, e->area.y,
				    e->area.width, e->area.height);
}

Graph *
graph_new (gpointer (*d_fn) (GraphCmd, gpointer))
{
	Graph *g = g_new (Graph, 1);

	g->data_fn = d_fn;
	g->bs = NULL;
	g->n = 0;
	g->height = 0;
	g->colors_allocated = 0;

	g->da = gtk_drawing_area_new ();

	gtk_widget_set_events (g->da, GDK_EXPOSURE_MASK);
	gtk_signal_connect (GTK_OBJECT (g->da), "expose_event",
			    (GtkSignalFunc) graph_expose, (gpointer) g);
	/* gtk_signal_connect (GTK_OBJECT (pb->bar), "size_request",
			    (GtkSignalFunc) graph_request, (gpointer) g); */

	return g;
}

GtkWidget *
graph_widget (Graph *g)
{
	return g->da;
}

void
graph_minimal_height_set (Graph *g, gint h)
{
	g->height = h;
}

#define GRAPH_WIDTH       100
#define GRAPH_LINE_WIDTH   80
#define GRAPH_PAD_WIDTH    20

static void
graph_process_data (Graph *g)
{
	gint w ,h, draw;
	gpointer data;
	unsigned value, total;
	gchar *label;
	gint ll, mll = 0;
	gint th, gh=0, cgh;
	gint i, c = 0;
	GdkGC **tgcs;
	gint lines, fh, asc2, ht;
	gchar *head, *tail;
	gint bonus;
	
	lines = total = 0;
	w = h = 10;

	if (!GTK_WIDGET_REALIZED (g->da))
		gtk_widget_realize (g->da);

	if (!g->colors_allocated) {
		GdkColormap *cmap;

		cmap = gdk_window_get_colormap (g->da->window);
		for (i = 0; i < g->n; i++)
			gdk_color_alloc (cmap, &g->colors [i]);

		g->colors_allocated = 1;
	}

	tgcs = g_new (GdkGC *, g->n);
	for (i = 0; i < g->n; i++) {
		tgcs [i] = gdk_gc_new (g->da->window);

		gdk_gc_copy (tgcs [i], g->da->style->text_gc [0]);
		gdk_gc_set_foreground (tgcs [i], &g->colors [i]);
	}

	if (g->bs) {
		gdk_pixmap_unref (g->bs);
		g->bs = NULL;
	}

	th = g->da->style->font->ascent;
	fh = 1.2 * (g->da->style->font->ascent + g->da->style->font->descent) + 2;
	asc2 = (th >> 1) - (th&1);

	head = g->data_fn (GRAPH_HEAD, NULL);
	tail = g->data_fn (GRAPH_TAIL, NULL);

	/*
	 * two passes
	 *   1. compute some values
	 *   2. draw
	 *
	 */

	bonus = 0; /* keep gcc happy */

	for (draw = 0; draw < 2; draw++) {
		if (draw) {

			gint fh2 = (fh << 1);

			ht = 0;			

			ht += (head) ? fh2 : 0;
			ht += (tail) ? fh2 : 0;

			/* bonus - lines to fit to minimal height */
			bonus = g->height - (h + ht) + 1;
			bonus = (bonus > 0) ? bonus : 0;
			h += bonus;
			
			gtk_widget_set_usize (g->da, w, h + ht);
			g->bs = gdk_pixmap_new (g->da->window, w, h + ht, -1);

			gdk_draw_rectangle (g->bs,
					    g->da->style->black_gc,
					    TRUE,
					    0, 0,
					    w, h + ht);
			h -= lines;

			if (head) {

				gint x;

				x = (w - gdk_string_width (g->da->style->font, head)) >> 1;

				gdk_draw_text (g->bs, g->da->style->font,
					       g->da->style->white_gc,
					       x, th,
					       head, strlen (head));

				th += fh2;
				gh += fh2;
			}

		}

		data = g->data_fn (GRAPH_FIRST, NULL);

		while (data) {
			value = (unsigned) g->data_fn (GRAPH_VALUE, data);
			label = g->data_fn (GRAPH_LABEL, data);
			if (total == 0) total = 1; /* avoids division by 0. */
			/* printf ("label: %s\n", label); */

			data = g->data_fn (GRAPH_NEXT, data);

			if (draw) {
				double idx = (double)value / total;
				gint cb = idx * bonus;
				gint lb, ll1, ll2, le;

				cgh = h * idx;
				lb = gh + (cgh >> 1);
				ll1 = th - asc2;
				ll2 = ll1 + cb;
				le = (lb >= ll1 && lb <= ll2) ? lb : ((lb - ll2 > 0) ? ll2 : ll1);

				gdk_draw_rectangle (g->bs,
						    tgcs [c],
						    TRUE,
						    0, gh,
						    GRAPH_WIDTH, cgh);
				gdk_draw_line (g->bs,
					       tgcs [c],
					       GRAPH_WIDTH + GRAPH_PAD_WIDTH,
					       lb,
					       GRAPH_WIDTH + GRAPH_LINE_WIDTH +
					       GRAPH_PAD_WIDTH,
					       le);
				       
				gdk_draw_text (g->bs, g->da->style->font,
					       tgcs [c],
					       GRAPH_WIDTH + GRAPH_LINE_WIDTH +
					       (GRAPH_PAD_WIDTH << 1),
					       le+asc2,
					       label, strlen (label));
				       
				gh += (cgh) ? cgh + 1 : 0;
				th += fh + cb;
				c++;
				c %= g->n;
				bonus -= cb;
				h -= cgh;
				total -= value;

			} else {
				total += value;
				h+=2;
				ll = gdk_string_width (g->da->style->font, label);
				if (mll < ll)
					mll = ll;
			}

			lines ++;
		}

		if (!draw) {
			w = GRAPH_WIDTH + GRAPH_LINE_WIDTH + (GRAPH_PAD_WIDTH << 1) +
				mll;
			h = fh * lines;
		}

		if (!lines)
			break;
	}

	if (tail) {
		
		gint x;

		x = (w - gdk_string_width (g->da->style->font, tail)) >> 1;

		gdk_draw_text (g->bs, g->da->style->font,
			       g->da->style->white_gc,
			       x, th + fh,
			       tail, strlen (tail));
	}

	for (i = 0; i < g->n; i++)
		gdk_gc_unref (tgcs [i]);
	g_free (tgcs);
}

void
graph_update (Graph *g)
{
	graph_process_data (g);
}

void
graph_colors_set (Graph *g, GdkColor *cs, gint n)
{
	g->colors_allocated = 0;
	g->colors = cs;
	g->n = n;
}
