# copyright (C) 1997-98 Jean-Luc Fontaine (mailto:jfontain@mygale.org)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: tablesel.tcl,v 1.2 1998/05/24 19:24:43 jfontain Exp $}

# implements selection on table cells, identified by row and column indices

class tableSelector {

    proc tableSelector {this args} selector {$args} {}

    proc ~tableSelector {this} {}

    ### public procedures follow:

    proc extend {this cell} {
        if {[info exists selector::($this,lastSelected)]} {
            scan $selector::($this,lastSelected) %d,%d startRow startColumn
            scan $cell %d,%d lastRow lastColumn
            if {$lastRow<$startRow} {                                                                                  ;# order rows
                set last $startRow
                set startRow $lastRow
                set lastRow $last
            }
            if {$lastColumn<$startColumn} {                                                                         ;# order columns
                set last $startColumn
                set startColumn $lastColumn
                set lastColumn $last
            }
            set list {}
            for {set row $startRow} {$row<=$lastRow} {incr row} {
                for {set column $startColumn} {$column<=$lastColumn} {incr column} {
                    lappend list $row,$column
                }
            }
            selector::clear $this
            selector::set $this $list 1
        } else {
            selector::select $this $cell
        }
    }

    proc list {this} {
        return [lsort -integer [selector::_list $this]]
    }
}
