#!/usr/bin/perl

## Type _full_ path below

$CONFIGFILE="/staff/fnet/areafix/areafix/config/config";
$CONFIGFILE=$ARGV[0] if defined($ARGV[0]);

## main program :)
&areafix();

##   
#
# $CONFIGFILE -      .
# $PERLLIBRARY -    .
#
# ,   
# $SYSOP_NAME        -   
# $ROBOT_NAME        -      
# $ADDRESS           -  
# $UPLINK_ROBOT_NAME -     (    )
# $UPLINK_ADDRESS    -  
# $UPLINK_PASSWORD   -   Area Manager  
# $QUEUE	     -     
# $ECHO2NEWS         -   ifmail's areas file
# $HELPFILE          -     
# $ACTIVE            - $NEWSLIB/active
# $NEWSGROUPS        - $NEWSLIB/newsgroups
# $NEWSFEEDS         - $NEWSLIB/newsfeeds
# $PASSIVE_NEWSFEEDS - ,        %PASSIVE
# $RESTFILE          -      "" 
# $MAILCOMMAND       - ,   ( |/usr/sbin/sendmail -t )
# $OUTNEWSFEEDS      -   "  newsfeeds" -- 
#                        $NEWSFEEDS
# $DESCRMISSING      - ""  ,    $NEWSLIB/newsgroups
# $RELOADCOMMAND     -    newsfeeds
# $UPLINK_PASSWORD   -    
# $LOGFILE           -     -.
# $LOGLEVEL          -  .
# $FORWARD           -    
# $SEMAPHORE	     -  (   :)
#
##      
#
# $HELP =     p
# %passwds - p   $passwds{"hostname"}
# %feeds   -   ()  newsfeeds $feeds{"hostname"}
# %passive -     .
# %description  -  . ($description{$newsgroup})
# @restricted[$i] -  ,   .
# @sites[$i] -   (i - )
# @exclude{$sites[i]} -  exclude-
# @patterns{$sites[i]} -  p
# @distribs{$sites[i]} -  distributions
# @flags{$sites[i]} - 
# @params{$sites[i]} - pp
# @comments{$sites[i]} - p _p_  
# $lastcomment - p   
# %echo2ng - p    p $echo2ns{"newsgroup_name"}
# %ng2echo - p
# $active[$i] - newsgroup
#
##    :
#
# $USERADDR - full address (user@host)
# $USERNAME - username part
# $USERHOST - host part ( $USERADDR eq "$USERNAME@$USERHOST")
# $SUBJECT  - letter's subject
# $FROM     - From field
# $REPLYTO  - Reply-To field
#
## other:
# $NEWSFEEDSCHANGED (==1    add/delete)
# $PRECEDENCE --    log-

sub areafix
{
    local($oldpid);
    &startup();

    if ( -e $SEMAPHORE )
    {
	die do syslog(err,"Bad semaphore-like file $SEMAPHORE found") unless ( -f $SEMAPHORE );
	open(SEM,$SEMAPHORE) || die do syslog(err,"Cannot open existing semaphore $SEMAPHORE");
	$oldpid=<SEM>;
	close(SEM);
	die do syslog(err,"Bad PID in semaphore file $SEMAPHORE") unless ($oldpid>0);	
	if (!kill(0,$oldpid))
	{
	    print STDERR "?-AreaFix-Dead semaphore (PID=$oldpid) found";
	    unlink($SEMAPHORE) || die do syslog(err,"Cannot unlink dead semaphore $SEMAPHORE");
	}
	elsif (time()-(stat($SEMAPHORE))[9]>86400)	# 1 day
	{
	    die do syslog(alert,"Possibly hung areafix (PID=$oldpid)");
	}
	else
	{
	    do syslog(warning,"= Overlapping with areafix[$oldpid] - exiting =");
	    return 0;
	} 
    }
    open(SEM,">".$SEMAPHORE);
    print SEM $$;
    close(SEM);

    &process_queue();
    &finish();
    unlink($SEMAPHORE) || die do syslog(err,"Cannot unlink own semaphore $SEMAPHORE");
}

sub process_queue
{
    local(@files,$file);

    @file=<$QUEUE/*>;

    foreach $file (@file)
    {
        if ( -f $file ) 
        { 
            open(IN,$file) || die do syslog(err,"Cannot open queue file $file");
            &process_message();
            close(IN);
	    unlink($file) || die do syslog(err,"Cannot unlink queue file $file");
        }
    }
}

sub process_message
{
    return 0 unless (&parse_header());
    open(OUT,$MAILCOMMAND);
    do syslog(info,"Processing message from $USERADDR");
    print OUT "From: $ROBOT_NAME@$ADDRESS\n";
    print OUT "To: $USERADDR\n";
    print OUT "Subject: Reply from Area Manager\n\n";

    if ( &newsfeeds_check($USERHOST) )
    {
        if ( &passwd_check($USERHOST,$SUBJECT) )
        {
            $SITE=$feeds{$USERHOST};
            &process_message_body();
        }
        else
        {
            &write_password_flame();
        }
    }
    else
    {
        &write_address_flame();
    }
    close(OUT);
}

sub startup
{ 
    local($fcntl_result);
    &read_config($CONFIGFILE) || die &logline("Bad configuration file");
    &read_control_files();
    require "syslog.pl";
    do openlog('areafix', 'cons,pid', 'local0');
    do syslog(debug,'Firing up');
}

sub finish
{ ## afterall
    if($NEWSFEEDSCHANGED)
    {
        # newsfeeds writting
        if ( -e $OUTNEWSFEEDS)
        {
            if ( -e $OUTNEWSFEEDS.".bak")
            {
                unlink($OUTNEWSFEEDS.".bak") || die do syslog(err,"Can not unlink file $OUTNEWSFEEDS.bak");
            }
            rename($OUTNEWSFEEDS,$OUTNEWSFEEDS.".bak") || die do syslog(err,"Can not rename file $OUTNEWSFEEDS to $OUTNEWSFEEDS.bak");
        }
        print OUT "Cannot write outfile" unless (&write_newsfeeds($OUTNEWSFEEDS,$PASSIVE_NEWSFEEDS));
    }
    close(IN);
    if ($NEWSFEEDSCHANGED)
    {
        system("$RELOADCOMMAND");
        do syslog(info,"newsfeeds reloaded");
    }
    do syslog(debug,"========== Shutting down ==========");
    do closelog();
}

##--------- top-level functions
sub passwd_check
{
    return (defined $passwds{$_[0]}) && (&to_upper_case($_[1]) eq &to_upper_case($passwds{$_[0]}));
}

sub newsfeeds_check
{
    return (defined $feeds{$_[0]});
}

##--------- translate string to upper case
sub to_upper_case
{
    $_[0]=~tr/[a-z]/[A-Z]/;
    return $_[0];
}

sub quote_meta
{
    $_[0]=~s/\./\\\./g;
    $_[0]=~s/\+/\\\+/g;
    $_[0]=~s/\$/\\\$/g;
    $_[0]=~s/\?/\\\?/g;
    return $_[0];
}

sub wildmat_to_regexp
{
    $_[0]=~s/\*/\\S\*/g;
    $_[0]="^".&quote_meta($_[0])."$";
}

sub write_password_flame
{
    print OUT "\nDear ".&torealname($USERNAME)."!\n\n";
    print OUT "You gave incorrect password for Area Manager, so,\n";
    print OUT "your AreaFix query will be refused. Please repeat\n";
    print OUT "your request with correct password or contact\n";
    print OUT "with ".&torealname($SYSOP_NAME).", our system operator.\n\n";
    print OUT "\t\t Yours, AreaFix of $ADDRESS\n";
    do syslog(warning,"Remote $USERADDR gave incorrect password $SUBJECT");
}

sub write_restricted_flame
{
    print OUT "$_[1]$_[0] -- the echo $_[0] is restricted. You cannot change its status.\n";
    do syslog(warning,"Remote $USERADDR attempted to \'$_[1]\' restricted echo $_[0]");
}

sub write_address_flame
{
    print OUT "\nDear ".&torealname($USERNAME)."!\n\n";
    print OUT "I'm terribly sorry, but your site is not present\n";
    print OUT "in our newsfeeds file, so, you can not access\n";
    print OUT "Area Manager on this node. Please, contact with\n";
    print OUT &torealname($SYSOP_NAME).", our system operator.\n\n";
    print OUT "\t\t Yours, AreaFix of $ADDRESS\n";
    do syslog(warning,"Site $USERADDR was not found in newsfeeds");
}

sub process_message_body
{
    while (<IN>)
    {
        last if(/\s*---/);
        do syslog(info,"Executing command: $_") unless (/^\s*$/);
        &print_help(), next if(/^\s*\%HELP\s*$/i);
        &print_list(0), next if(/^\s*\%LIST\s*$/i);
        &print_list(1), next if(/^\s*\%LISTALL\s*$/i);
        &do_wide(), next if(/^\s*\%WIDE\s*$/i);
        &print_query(), next if(/^\s*\%QUERY\s*$/i);
        &make_passive(), next if(/^\s*\%PASSIVE\s*$/i);
        &make_active(), next if(/^\s*\%ACTIVE\s*$/i);
        &print_unlinked(), next if(/^\s*\%UNLINKED\s*$/i);
        &unsubscribe($1), next if (/^\s*\-(\S+)/);
        &subscribe($1), next if (/^\s*\+(\S+)/);
        &print_invalid($_), next if(/^\s*\S+/);
        }
}

## top-level commands processing

sub make_passive
{
    do syslog(notice,"Processing %PASSIVE operation");
    if ($passive{$SITE}==1)
    {
        print OUT "%PASSIVE - your newsfeeds already have passive status\n";
    }
    else
    {
        $passive{$SITE}=1;
        $NEWSFEEDSCHANGED=1;
        print OUT "%PASSIVE - your newsfeeds have passive status now\n";
    }
}

sub make_active
{
    do syslog(notice,"Processing %ACTIVE operation");
    if ($passive{$SITE}==0)
    {
        print OUT "%ACTIVE - your news feeds already have active status\n";
    }
    else
    {
        $passive{$SITE}=0;
        $NEWSFEEDSCHANGED=1;
        print OUT "%ACTIVE - your news feeds have active status now\n";
    }
}

sub subscribe
{
    local($echo,@echoes,$curecho,$curgroup,@patt,$tmp);
    $echo=$_[0];
    $echo=~tr/a-z/A-Z/;
    do syslog(notice,"Processing subscribe operation");
    &wildmat_to_regexp($echo);
    @echoes=grep(/$echo/,keys(%echo2ng));
    if (defined(@echoes))
    {
        foreach $curecho (@echoes)
        {
            $curgroup=$echo2ng{$curecho};
    
            if (&findinrestricted($curecho))
            {
                &write_restricted_flame($curecho,"+");
            }
            elsif (&findinactive($curgroup))
            {
                @patt=split(",",$patterns{$SITE});    
                $tmp=$curgroup;    
                &quote_meta($tmp);
                unless (grep(/^$tmp$/,@patt))
                {
                    push(@patt,$curgroup);
                    $patterns{$SITE}=join(",",sort(@patt));    
                    $NEWSFEEDSCHANGED=1;
                    print OUT "+$curecho -- Subscribed to $curecho\n";
                    do syslog(notice,"Remote subsribed to $curecho");
                }
                else
                {
                    print OUT "+$curecho -- Already subscribed to $curecho\n";
                    do syslog(notice,"Remote already subscribed to $curecho");
                }
            }
	    else
	    {
		print OUT "+$curecho -- Cannot translate to newsgroup. Sysop of $ADDRESS notified\n";
		print STDERR "?-AreaFix-Areas and active do not match: no active $curgroup";
	    }
        }
    }
    else
    {
        print OUT "+$_[0] -- No such echo(es) here.";
        do syslog(notice,"Can not subscribe to $_[0]");
        if ($FORWARD)
        {    
            print OUT " Your request will be forwarded to our uplink. Try later.\n";
            do syslog(warning,"This request will be forwarded to our uplink");
            &forward($_[0]);
        }
	else
	{
	    print OUT "\n";
	}
    }
    return 1;
}

sub torealname
{
    local($tmp)=$_[0];
    $tmp=~tr/[_ \.]/ /;
    return $tmp;
}

sub findinrestricted
{
    local($ftmp,$fecho,$fcurecho);
    $fecho=$_[0];
    $fecho=~tr/a-z/A-Z/;
    foreach $ftmp (@restricted)
    {
        $fcurecho=$ftmp;
        $fcurecho=~tr/a-z/A-Z/;
        &wildmat_to_regexp($fcurecho);
        return 1 if ($fecho=~/$fcurecho/);
    }
    return 0;
}

sub forward
{
    local($FILE);
    unless (open(FILE,$MAILCOMMAND))
    {
        $SYSOP_NAME=~tr/[._]/ /;
        print OUT "Fatal error: forwarding can not be processed\n";
        print OUT "Immediately report to ".$SYSOP_NAME."\n";
        print OUT "---\n";
        return 1;
    }
    $SYSOP_NAME=~tr/[_ ]/./;
    print FILE "From: $SYSOP_NAME@$ADDRESS\n";
    print FILE "To: $UPLINK_ROBOT_NAME@$UPLINK_ADDRESS\n";
    print FILE "Subject: $UPLINK_PASSWORD\n\n";
    print FILE "+$_[0]\n---\n";
    close(FILE);
}

sub unsubscribe
{
    local($echo,$curecho,$curgroup,@pattin,@pattout,$f);
    $echo=$_[0];
    $echo=~tr/a-z/A-Z/;
    do syslog(notice,"Processing unsubscribe operation");
    @pattin=split(",",$patterns{$SITE});    
    
    &wildmat_to_regexp($echo);

    foreach $curgroup (@pattin)
    {
        $curecho=$ng2echo{$curgroup};
        if ($curecho=~/$echo/)
        {
            if (&findinrestricted($curecho))
            {
                &write_restricted_flame($curecho,"-");
		push(@pattout,$curgroup);
            }
            else
            {
                print OUT "-$curecho -- Unsubscribed\n";
                do syslog(notice,"Remote unsubsribed from $curecho");
            }
	    $f=1;
        }
        else
        {
            push(@pattout,$curgroup);
        }
    }

    unless ($f)
    {
        print OUT "-$_[0] -- No match in your subscription list\n";
        do syslog(notice,"Remote is not subsribed to $_[0]");
    }
    else
    {
        $NEWSFEEDSCHANGED=1;
        $patterns{$SITE}=join(",",@pattout);
    }
    return 1;
}

# print_list(printall);
# -   ,  printall != 0 -- ,  - 
#   
sub print_list
{
    local($echo,$group,$descr,$oldfh);
    do syslog(notice,"Processing LIST".(($listall==1)?"ALL":"")." operation");
    $listall=$_[0];
    print OUT "\%LIST";
    print OUT (($listall==1)?"ALL\n":"\.\n");
    $oldfh=select(OUT);
    $~=($WIDE||$listall==1)?OUTWIDE:OUT;
    foreach $group (@active){
        $echo=defined($ng2echo{$group})?$ng2echo{$group}:"UNTRANSLATED";
        $descr=defined($description{$group})?$description{$group}:$DESCRMISSING;
        write if(defined($ng2echo{$group}) || $listall);
    }
    select($oldfh);
}

sub do_wide
{
    $WIDE=1;
    print OUT "%WIDE -- OK\n";
}

sub print_invalid
{
    print OUT "$_[0] -- invalid command\n";
}

sub print_help 
{
    print OUT "%HELP\n$HELP\n";
}

format OUTWIDE=
@<<<<<<<<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$echo,      $group,       $descr
.
;
format OUT=
@<<<<<<<<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$echo,           $descr
.

sub print_query
{
    local($echo,@groups,$group,$descr,$oldfh);
    do syslog(notice,"Processing \%QUERY operation");
    print OUT "\%QUERY\n";
    $oldfh=select(OUT);
    $~=$WIDE?OUTWIDE:OUT;
    @groups=split(",",$patterns{$SITE});
    foreach $group (@groups)
    {
        $echo=defined ($ng2echo{$group}) ? $ng2echo{$group}: "UNTRANSLATED";
        $descr=defined( $description{$group})? $description{$group}:$DESCRMISSING;
        write ;
    }
    select($oldfh);
}

sub print_unlinked
{
    local($echo,@groups,$group,$descr,$oldfh,$g);
    do syslog(notice,"Processing \%UNLINKED operation");
    print OUT "\%UNLINKED\n";
    $oldfh=select(OUT);
    $~=$WIDE?OUTWIDE:OUT;
    @groups=split(",",$patterns{$SITE});
    foreach $group (@active)
    {
	$g=$group;
	&quote_meta($g);
        if (grep(/$g/,@groups)==())
        {
            $echo=defined ($ng2echo{$group}) ? $ng2echo{$group}: "UNTRANSLATED";
            $descr=defined( $description{$group})? $description{$group}:$DESCRMISSING;
            write ;
        }
    }
    select($oldfh);
}

# ---- RFC822-header parsing
# $USERADDR - full address (user@host)
# $USERNAME - username part
# $USERHOST - host part ( $USERADDR eq "$USERNAME@$USERHOST")
# $SUBJECT  - letter's subject
# $FROM     - From field
# inputs from IN filehandle

sub parse_addr
{
    $USERADDR=$1,return if($FROM=~/^[^<]*<(\S+@\S+)>/) ;
    $USERADDR=$1,return if($FROM=~m|(\S+@\S+)\s+[\(][^\)]+[\)]|);
    $USERADDR=$FROM;
}

sub parse_header
{
    while(<IN>)
    {
        chop; ## MSDOG
        last if (/^\s*$/); ## empty string -- break
        next unless(($headline,$value)=/([^:]+):\s+(.*$)/);
        $SUBJECT=$value if($headline=~/^Subject/);
        $FROM=$value if($headline=~/^From/);
    }
    return 0 unless (defined($FROM) && defined($SUBJECT));
    &parse_addr();
    ($USERNAME,$USERHOST)=split("@",$USERADDR);
}

## -------  NEWSFEEDS MANIPULATION SUBS

sub write_newsfeeds
{
    local ($site,$groupstr,$outfile,$outhandle,$passive_outfile,$passive_outhandle);
    $outfile=$_[0];
    $passive_outfile=$_[1];
    open(outhandle,">".$outfile) || return 0;
    open(passive_outhandle,">".$passive_outfile) || return 0;
    foreach $site (@sites) #    !
    {
        if ($passive{$site}==0)
        {
            print outhandle $comments{$site}; #   
            print outhandle $site; #  
            print outhandle "/".$exclude{$site} unless($exclude{$site}eq""); #  ,  
#     ,       .
            print outhandle "\\\n"; #  \   .
            $groupstr=$patterns{$site}; #     ,
            $groupstr=~s|,|,\\\n\t|go; #       
            print outhandle "\t:$groupstr\\\n"; #     newsfeeds
            print outhandle ("\t/".$distribs{$site}."\\\n") unless($distribs{$site} eq ""); #    ,    ...
            print outhandle "\t:";
            print outhandle ($flags{$site}) unless ($flags{$site} eq ""); # ...   ...
            print outhandle ":";
            print outhandle $params{$site} unless ($params{$site}eq ""); # ...  .
            print outhandle "\n";
        }
        else
        {
            print passive_outhandle $comments{$site}; #   
            print outhandle $comments{$site}; #   
            print passive_outhandle $site; #  
            print outhandle $site; #  
            print passive_outhandle "/".$exclude{$site} unless($exclude{$site}eq""); #  ,  
            print outhandle "/".$exclude{$site} unless($exclude{$site}eq""); #  ,  
#     ,       .
            print passive_outhandle "\\\n"; #  \   .
            print outhandle "\\\n"; #  \   .
            $groupstr=$patterns{$site}; #     ,
            $groupstr=~s|,|,\\\n\t|go; #       
            print passive_outhandle "\t:$groupstr\\\n"; #     newsfeeds
            print outhandle "\t:\\\n"; #     newsfeeds
            print passive_outhandle ("\t/".$distribs{$site}."\\\n") unless($distribs{$site} eq ""); #    ,    ...
            print passive_outhandle "\t:";
            print outhandle "\t:";
            print passive_outhandle ($flags{$site}) unless ($flags{$site} eq ""); # ...   ...
            print passive_outhandle ":";
            print passive_outhandle $params{$site} unless ($params{$site}eq ""); # ...  .
            print passive_outhandle "\n";
            print outhandle ($flags{$site}) unless ($flags{$site} eq ""); # ...   ...
            print outhandle ":";
            print outhandle $params{$site} unless ($params{$site}eq ""); # ...  .
            print outhandle "\n";
        }
    }
    print outhandle $last_comment; #     .
    close(outhandle);
    close(passive_outhandle);
    return 1;
}

sub add_group
{
    local($patt);
    @patt=split(",",$patterns{$_[0]});
    return 0 if (grep(/^$_[1]$/,@patt));
    push(@patt,$_[1]);
    $patterns{$_[0]}=join(",",sort(@patt));
    return 1;
}

sub del_group
{
    local($curgroup,@pattin,@pattout);
    @pattin=split(",",$patterns{$_[0]});
    foreach $curgroup (@pattin)
    {
        push(@pattout,$curgroup) unless ($curgroup eq $_[1]);
    }
    return 0 unless defined(@pattout);
    $patterns{$_[0]}=join(",",sort(@pattout));
    return 1;
}

## ---------------- reading of config files

sub read_control_files
{
    &read_active($ACTIVE)|| die &logline("Bad active file");
    &read_areas($ECHO2NEWS) || die &logline ("Bad Areas file");
    &read_help($HELPFILE) || die &logline ("Bad help file");
    &read_newsgroups($NEWSGROUPS)|| die &logline ("Bad newsgroups file");
    &read_newsfeeds($NEWSFEEDS) || die &logline ("Bad newsfeeds file");
    &read_passive_newsfeeds($PASSIVE_NEWSFEEDS) || die &logline ("Bad passive newsfeeds file");
    &read_passwd($PASSWDFILE) || die &logline ("Bad passwords file");
    &read_restricted($RESTFILE);
    $NEWSFEEDSCHANGED=0;
    $WIDE=0;
}

## ---------------- passwd.pl --------------------
#  passwd
# %passwds - p   $passwds{"hostname"}
# %feeds -   ()  newsfeeds $feeds{"hostname"}
#

sub read_passwd {
    local($pwd_file,$pwd_handle,$host,$feed,$passwd);
    $pwd_file=$_[0];
    open(pwd_handle,$pwd_file)|| die &logline("Cannot open $pwd_file");

    while(<pwd_handle>) {
	chop;
        next if (/\s+#/);
        next unless(($host,$feed,$passwd)=/([^:]+):([^:]+):([^:]+)/);
        $passwds{$host}=$passwd;
        $feeds{$host}=$feed;
    }
    close(pwd_handle);
    return 1;
}

## ----------- newsgrou.pl -----------------
#   newsgroups  
# %description  -  . ($description{$newsgroup})

sub read_newsgroups {
    local($ng_file,$ng_handle);
    $ng_file=$_[0];
    open(ng_handle,$ng_file) || die &logline("Cannot open $ng_file");

    while(<ng_handle>){
        next if(/^\s*#/);
        next unless(($group,$descr)=/(\S+)\s+(.*$)/);
        $description{$group}=$descr;
    }
    close(ng_handle);
    return 1;
}

## ------------------ newsfeed.pl -----------------
# newsfeeds parser
#        newsfeeds,
# p    :
# @sites[$i] -   (i - )
# @exclude{$sites[i]} -  exclude-
# @patterns{$sites[i]} -  p
# @distribs{$sites[i]} -  distributions
# @flags{$sites[i]} - 
# @params{$sites[i]} - pp
# @comments{$sites[i]} - p _p_  
# $lastcomment - p   

sub read_newsfeeds
{
    local($handle,$current_line,$temp_line,$commentstr);
    local($index,$nf_file,$site,$sitetmp);
    local($excl,$pats,$patstmp,$distr,$flgs,$param);
    $nf_file=$_[0];
    $index=0;
    $commentstr="";
    open(handle,$nf_file) || die &logline("Cannot open $nf_file");
input:
    while(<handle>)
    {
        next input if /^$/; #    newsfeeds .

##     newsfeeds ...

        $current_line=$_; #   .
        if($current_line=~m/^\s*#/) #    - ,
# ..       - 
#  ( # ), 
        {
            $commentstr.=$current_line; #     
            next input; #      !
        }

##   -   ...

        chop($current_line); ##MSDOS

##  :   newsfeeds   site, -
## , ,     (   ,
##    C,  \  ""  )   ...

        while ($current_line=~/\\$/ ) # ,     ...
        {
            chop($current_line); #  \   ...
            chop($temp_line=<handle>); #  ,  \n ...
            $temp_line=~s/^\s*//; #    ...
            $current_line .= $temp_line; #     ,   .
        }
        $sitestr=$current_line;

##         site     -
## : <site>:<feeds>:<flags>:<parameters> ...

        ($sitetmp,$patstmp, $flgs, $param)=split(/:/,$sitestr); #        !
        $site=$sitetmp; # $site -  .
        $pats=$patstmp; # $pats -  .
        $excl=""; # $excl -    ,       ...

##       ,  ,   
##    ...

        if ($sitetmp=~m|([^/]+)/([^/]+)|)
        {
            $site=$1;
            $excl=$2;
        }

        $distr=""; # $distr -   newsgroup distribution

##          .

        if($patstmp=~m|([^/]+)/([^/]+)|)
        {
            $pats=$1;
            $distr=$2;
        }

##      : 

        $sites[$index]=$site; #   ->    ...
        $passive{$site}=0;
        $exclude{$site}=$excl; #  ->    ...
        $patterns{$site}=$pats; #  ...
        $distribs{$site}=$distr; #  ...
        $flags{$site}=$flgs; #  ...
        $params{$site}=$param; #  ...
        $comments{$site}=$commentstr; #  ...
        $index++; #     1 ...
        $commentstr=""; #     ...
    }
    $last_comment=$commentstr; #       .
    close(handle); #         newsfeeds !
    return 1;
}

sub read_passive_newsfeeds
{
    local($handle,$current_line,$temp_line,$commentstr);
    local($nf_file,$site,$sitetmp,$index);
    local($excl,$pats,$patstmp,$distr,$flgs,$param,$counter);
    $nf_file=$_[0];
    $commentstr="";
    open(handle,$nf_file) || die &logline("Cannot open $nf_file");
input:
    while(<handle>)
    {
        next input if /^$/;
        $current_line=$_;
        if($current_line=~m/^\s*#/)
        {
            $commentstr.=$current_line;
            next input;
        }
        chop($current_line); ##MSDOS
        while ($current_line=~/\\$/ )
        {
            chop($current_line);
            chop($temp_line=<handle>);
            $temp_line=~s/^\s*//;
            $current_line.=$temp_line;
        }
        $sitestr=$current_line;
        ($sitetmp,$patstmp, $flgs, $param)=split(/:/,$sitestr);
        $site=$sitetmp;
        $pats=$patstmp;
        $excl="";
        if ($sitetmp=~m|([^/]+)/([^/]+)|)
        {
            $site=$1;
            $excl=$2;
        }
        $distr="";
        if($patstmp=~m|([^/]+)/([^/]+)|)
        {
            $pats=$1;
            $distr=$2;
        }
        $passive{$site}=1;
        $exclude{$site}=$excl;
        $patterns{$site}=$pats;
        $distribs{$site}=$distr;
        $flags{$site}=$flgs;
        $params{$site}=$param;
        $comments{$site}=$commentstr;
        $commentstr="";
    }
    $last_comment=$commentstr;
    close(handle);
    return 1;
}

## ----------------   read help file --------------
#  HELP'
# $HELP =     p
#
sub read_help
{
    local($helpf,$hh);
    $helpf=$_[0];
    open(hh,$helpf) || die &logline("Cannot open $helpf");
    $HELP="";
    $HELP.=$_ while(<hh>);
    close(hh);
    return 1;
}

## ------------ read areas file ------------------
#  :
# %echo2ng - p    p $echo2ns{"newsgroup_name"}
# %ng2echo - p

sub read_areas
{
    local($areas_file,$areas_handle,$echo,$ngroup);
    $areas_file=$_[0];
    open(areas_handle,$areas_file) || die &logline("Cannot open $areas_file");

    while(<areas_handle>)
    {
        next if (/^\s*#/);
        next unless(( $echo,$ngroup)=/(\S+)\s+(\S+)/);
        $ngroup=~tr/A-Z/a-z/;
        $echo=~tr/a-z/A-Z/;    
        $echo2ng{$echo}=$ngroup;
        $ng2echo{$ngroup}=$echo;
    }
    close(areas_handle);
    return 1;
}

sub findinactive
{
    local($tmp)=$_[0];
    &quote_meta($tmp);
    return grep(/^$tmp$/,@active);
}

## --------- read active file -----------------------
#  :
# $active[$i]
# 
sub read_active {
    local($active_file,$active_handle,$ngroup);
    $active_file=$_[0];
    $ACTIVECOUNT=0;
    open(active_handle,$active_file) || die &logline("Cannot open $active_file");
    while(<active_handle>){
        #chop; ## MSDOS
        next if (/^\s*#/);
        next unless(($ngroup)=/(\S+)\s+.*/);
        push(@active,$ngroup);
    }
    close(active_handle);
    return 1;
}

## --------- read restricted file -----------------------
#  :
# $restricted[$i]
sub read_restricted {
    local($handle,$echo);
    open(handle,$RESTFILE) || die &logline("Cannot open $rest_file");
    while(<handle>){
        #chop; ## MSDOS
        next if (/^\s*#/);
        next unless(($echo)=/^(\S+)$/);
        push(@restricted,$echo);
    }
    close(handle);
    return 1;
}

sub read_config
{
    local($handle,$config_file);
    $config_file=$_[0];
    open(handle,$config_file) || die &logline("Cannot open $config_file");
    while(<handle>)
    {
        #chop; ## MSDOS
        next if (/^\s*#/);
        next unless(($keyword,$val)=/(\S+)\s+(\S+[^\n]*)/);
        $ROBOT_NAME=$val if($keyword=~/^Robot$/i);
        $HELPFILE=$val if($keyword=~/^HelpFile$/i);
        $NEWSFEEDS=$val if($keyword=~/^NewsFeeds$/i);
        $PASSIVE_NEWSFEEDS=$val if($keyword=~/^Passive_NewsFeeds$/i);
        $NEWSGROUPS=$val if($keyword=~/^NewsGroups$/i);
        $ECHO2NEWS=$val if($keyword=~/^Echo2News$/i);
        $ACTIVE=$val if($keyword=~/^Active$/i);
        $LOGFILE=$val if($keyword=~/^LogFileName$/i);
        $RESTFILE=$val if($keyword=~/^RestEcho$/i);
        $LOGLEVEL=$val if($keyword=~/^LogLevel$/i);
        $PASSWDFILE=$val if($keyword=~/^PasswdFile$/i);
        $OUTNEWSFEEDS=$val if($keyword=~/^OutNewsFeeds$/i);
        $MAILCOMMAND=$val if($keyword=~/^MailCommand$/i);
        $DESCRMISSING=$val if($keyword=~/^DescrMissing$/i);
        $RELOADCOMMAND=$val if ($keyword=~/^ReloadCommand$/i);
        $SYSOP_NAME=$val if ($keyword=~/^SysOp$/i);
        $ADDRESS=$val if ($keyword=~/^Address$/i);
        $UPLINK_ADDRESS=$val if ($keyword=~/^UpLink_Address$/i);
        $UPLINK_ROBOT_NAME=$val if ($keyword=~/^UpLink_Robot$/i);
        $UPLINK_PASSWORD=$val if ($keyword=~/^UpLink_Password$/i);
	$FORWARD=($val=~/^Yes$/i)?1:0 if ($keyword=~/^Forward$/i);
	$QUEUE=$val if ($keyword=~/^Queue$/i);
	$SEMAPHORE=$val if ($keyword=~/^Semaphore$/i);
    }
    $DESCRMISSING="Description missing" unless (defined($DESCRMISSING));
    return 0 unless(defined($ACTIVE)
        && defined($ECHO2NEWS)
        && defined($NEWSGROUPS)
        && defined($LOGFILE)
        && defined($LOGLEVEL)
        && defined($HELPFILE)
        && defined($PASSWDFILE)
        && defined($OUTNEWSFEEDS)
        && defined($MAILCOMMAND)
        && defined($RELOADCOMMAND)
        && defined($SYSOP_NAME)
        && defined($ADDRESS)
        && defined($UPLINK_ADDRESS)
        && defined($UPLINK_ROBOT_NAME)
        && defined($UPLINK_PASSWORD)
        && defined($PASSIVE_NEWSFEEDS)
        && defined($NEWSFEEDS)
	&& defined($SEMAPHORE)); 
    return 1;
}
##--------  end of reading of config files

