/* 
   EOAttribute.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: August 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __EOAttribute_h__
#define __EOAttribute_h__

#include <Foundation/NSString.h>
#include <Foundation/NSDictionary.h>
#include <Foundation/NSDate.h>

#include <extensions/GCObject.h>
#include <extensions/GCArray.h>

@class EOEntity;

@interface EOAttribute : GCObject
{
    NSString*	name;
    NSString*	calendarFormat;
    NSTimeZone*	clientTimeZone;
    NSTimeZone*	serverTimeZone;
    NSString*	columnName;
    NSString*	definition;
    NSString*	externalType;
    NSString*	valueClassName;
    NSString*	valueType;
    NSString*	insertFormat;
    NSString*	selectFormat;
    NSString*	updateFormat;
    NSDictionary* userDictionary;

    /* Garbage collectable objects */
    EOEntity*	entity;
    GCMutableArray* definitionArray;	// These variables are meaningful only
    EOAttribute* realAttribute;		// if the attribute is flattened

    struct {
	BOOL	isReadOnly:1;
	BOOL	isDerived:1;
	BOOL	isFlattened:1;
    } flags;
}

/* Initializing new instances */
- initWithName:(NSString*)name;

/* Accessing the entity */
- (void)setEntity:(EOEntity*)entity;
- (EOEntity*)entity;

/* Accessing the name */
- (BOOL)setName:(NSString*)name;
- (NSString*)name;
+ (BOOL)isValidName:(NSString*)name;

/* Accessing date information */
+ (NSString*)defaultCalendarFormat;
- (void)setCalendarFormat:(NSString*)format;
- (NSString*)calendarFormat;
- (void)setClientTimeZone:(NSTimeZone*)tz;
- (NSTimeZone*)clientTimeZone;
- (void)setServerTimeZone:(NSTimeZone*)tz;
- (NSTimeZone*)serverTimeZone;

/* Accessing external definitions */
- (void)setColumnName:(NSString*)columnName;
- (NSString*)columnName;
- (void)setDefinition:(NSString*)definition;
- (NSString*)definition;
- (GCMutableArray*)definitionArray;
- (void)setExternalType:(NSString*)type;
- (NSString*)externalType;

/* Accessing value type information */
- (void)setValueClassName:(NSString*)name;
- (NSString*)valueClassName;
- (void)setValueType:(NSString*)type;
- (NSString*)valueType;

/* Checking type information */
- (BOOL)referencesProperty:property;
- (BOOL)isDerived;
- (BOOL)isFlattened;
- (BOOL)setReadOnly:(BOOL)flag;
- (BOOL)isReadOnly;

/* Accessing SQL statement formats */
- (void)setInsertFormat:(NSString*)string;
- (NSString*)insertFormat;
- (void)setSelectFormat:(NSString*)string;
- (NSString*)selectFormat;
- (void)setUpdateFormat:(NSString*)string;
- (NSString*)updateFormat;

/* Accessing the user dictionary */
- (void)setUserDictionary:(NSDictionary*)dictionary;
- (NSDictionary*)userDictionary;

/* Obsolete. This method always return NO, because you should always release
   a property. */
- (BOOL)referencesProperty:property;

@end


@interface EOAttribute (EOAttributePrivate)

+ (EOAttribute*)attributeFromPropertyList:(id)propertyList;
- (void)replaceStringsWithObjects;
- (id)propertyList;

@end /* EOAttribute (EOAttributePrivate) */

@interface EOAttribute(ValuesConversion)

- convertValue:aValue toClass:(Class)aClass forType:(NSString*)aValueType;
- convertValueToModel:aValue;

@end /* EOAttribute (ValuesConversion) */

@interface NSString (EOAttributeTypeCheck)

- (BOOL)isNameOfARelationshipPath;

@end

#endif /* __EOAttribute_h__ */
